<div align="center">
  <p>
    <a href="#"><img src="./assets/ico.png" height="150px" alt="logo" /></a>
  </p>
</div>

# NoDPI
<b><i>Say NO to blocking!</b></i>

[![Visitors](https://visitor-badge.laobi.icu/badge?page_id=GVCoder09.NoDPI)]()
[![License: GPL-3.0](https://img.shields.io/badge/License-GPL3.0-yellow.svg)](https://www.gnu.org/licenses/gpl-3.0.txt)
[![GitHub Release](https://img.shields.io/github/v/release/GVCoder09/nodpi)](https://github.com/GVCoder09/NoDPI)
[![Github All Releases](https://img.shields.io/github/downloads/GVCoder09/nodpi/total.svg)](https://github.com/remittor/zapret-openwrt/releases)
[![Github Latest Release](https://img.shields.io/github/downloads/GVCoder09/nodpi/latest/total.svg)](https://github.com/remittor/zapret-openwrt/releases)
[![GitHub Stars](https://img.shields.io/github/stars/GVCoder09/nodpi.svg?style=social)](https://github.com/GVCoder09/NoDPI)
[![GitHub Forks](https://img.shields.io/github/forks/GVCoder09/nodpi.svg?style=social)](https://github.com/GVCoder09/NoDPI)
[![GitHub Last commit](https://img.shields.io/github/last-commit/GVCoder09/nodpi.svg?style=social)](https://github.com/GVCoder09/NoDPI)

> [!IMPORTANT]
> Этот проект является ответвлением репозитория https://github.com/theo0x0/nodpi и разрабатывается независимо от него. Не путайте с https://github.com/raspabamos/nodpi !

> [!NOTE]
> Эта версия предназначена для настольных систем. **Версия для Android доступна здесь:** https://github.com/GVCoder09/NoDPI4Android

**Read this in other languages / Читайте на других языках**
- [English](README.md)
- **[Русский](README.ru.md)**

## Содержание
- [NoDPI](#nodpi)
  - [Содержание](#содержание)
  - [Описание](#описание)
    - [Как это работает](#как-это-работает)
    - [Основные возможности и преимущества](#основные-возможности-и-преимущества)
    - [Сайты, которые в настоящее время не поддаются разблокировке через NoDPI](#сайты-которые-в-настоящее-время-не-поддаются-разблокировке-через-nodpi)
    - [Альтернативы](#альтернативы)
  - [Условия использования и отказ от ответственности](#условия-использования-и-отказ-от-ответственности)
  - [Быстрый старт](#быстрый-старт)
    - [Добавление в автозагрузку в Windows и Linux](#добавление-в-автозагрузку-в-windows-и-linux)
    - [Поддерживаемые аргументы командной строки](#поддерживаемые-аргументы-командной-строки)
  - [Запуск из исходного кода](#запуск-из-исходного-кода)
  - [Сборка исполняемого файла](#сборка-исполняемого-файла)
  - [Запуск в Docker](#запуск-в-docker)
  - [FAQ](#faq)
  - [История звезд проекта](#история-звезд-проекта)

## Описание

NoDPI — это утилита, предназначенная для обхода DPI (Deep Packet Inspection). Что такое DPI? DPI — это технология анализа сетевых пакетов на основе их содержимого для регулирования и фильтрации трафика. Она часто используется интернет-провайдерами для цензуры и блокировки доступа к определённым веб-ресурсам и протоколам. Цель этой программы — «обмануть» DPI, модифицируя сетевые пакеты, хотя на самом деле этот "обман" часто является следствием нехватки вычислительных ресурсов и времени на стороне провайдера.

Эта утилита была разработана в первую очередь для российских пользователей как более простая (но менее мощная) замена аналогичным инструментам. В большинстве случаев она справляется со своей задачей; в частности, она позволяет без проблем пользоваться YouTube.

Но, к сожалению, абсолютная работоспособность этой утилиты не может гарантироваться. Некоторые сайты, например, YouTube, легко поддаются разблокировке, в то время как другие, например, Instagram.com или Facebook.com, требуют совершенно иных методов обхода блокировок, которые пока не реализованы в этой утилите из-за их низкоуровненности и сложности. Иногда работоспособность определенных сайтов может зависеть и от провайдера — того, как именно он блокирует сайт и какие технические средства применяет.

[!["Screenshot"](./assets/screenshot.png)]()

### Как это работает

NoDPI запускает на вашем компьютере прокси-сервер, через который вы перенаправляете http(s)-трафик. Программа перехватывает исходящие ClientHello соединений и фрагментирует их одним из следующих способов:

*Случайная фрагментация (по умолчанию)*

ClientHello разбивается на несколько частей случайной длины. Каждая часть склеивается префиксами типа ClientHello, и всё это отправляется одним пакетом.

*Фрагментация по SNI*

В пакете есть поле, содержащее запись SNI. ClientHello разбивается на 4 части: сам SNI, первая и вторая половина SNI, и всё, что после него. К каждой части прикрепляется заголовок, указывающий на тип ClientHello, и всё это отправляется одним пакетом.

Также, независимо от способа, версия TLS заменяется на версию 1.3, которая является самой современной на данный момент (хотя это не означает, что ваши данные начинают передаваться в соответствии со спецификациями этой версии). Всё это в совокупности позволяет обойти блокировку. По всей видимости, DPI пока не обладает необходимыми мощностями, чтобы распутать этот «клубок», и просто игнорирует такой трафик, экономя время и силы. Но, возможно, скоро эти методы перестанут работать.

> [!IMPORTANT]
> NoDPI работает только с HTTPS-трафиком. Он также может принимать HTTP-трафик, но исключительно для совместимости — HTTP-сайты практически не подлежат разблокировке, и программа просто отправляет трафик адресату.

NoDPI не собирает и не отправляет никаких данных о вас, не использует сторонние программы и библиотеки, не вмешивается в системные процессы и не требует прав администратора для работы.

Весь код NoDPI написан исключительно на Python и использует только его стандартную библиотеку.

### Основные возможности и преимущества

- Открытый исходный код
- Простота использования, запуска и настройки. Программа имеет интуитивно понятный интерфейс. Использование утилиты не требует специальных знаний; её может запустить любой пользователь без прав администратора.
- Программа работает со списком заблокированных доменов и может автоматически определять заблокированные веб-сайты.
- Кроссплатформенность обеспечивает стабильную работу на Windows/Linux/MacOS. [Также доступна версия для Android](https://github.com/gvcoder09/nodpi4android).
- Программа может быть интегрирована в корпоративную сеть и использоваться сотрудниками, а не только отдельными пользователями.
- Поддерживает журналирование ошибок и доступа. Вы можете видеть, кто и когда посещал конкретные веб-сайты.
- Имеет возможность добавлять себя в автозагрузку на Windows/Linux

### Сайты, которые в настоящее время не поддаются разблокировке через NoDPI

На октябрь 2025 года Instagram и Facebook не поддавались разблокировке с помощью NoDPI. Для них вы можете использовать [GoodbyeDPI](https://github.com/ValdikSS/GoodbyeDPI) от @ValdikSS. Также недоступны все сайты, заблокированные по IP.

### Альтернативы

- **[GoodbyeDPI](https://github.com/ValdikSS/GoodbyeDPI)** от @ValdikSS (для Windows)
- **[zapret](https://github.com/bol-van/zapret)** от @bol-van (для MacOS, Linux и Windows)
- **[Green Tunnel](https://github.com/SadeghHayeri/GreenTunnel)** от @SadeghHayeri (для MacOS, Linux и Windows)
- **[DPI Tunnel CLI](https://github.com/nomoresat/DPITunnel-cli)** от @zhenyolka (для Linux и роутеров)
- **[DPI Tunnel для Android](https://github.com/nomoresat/DPITunnel-android)** от @zhenyolka (для Android)
- **[PowerTunnel](https://github.com/krlvm/PowerTunnel)** от @krlvm (для Windows, macOS и Linux)
- **[PowerTunnel для Android](https://github.com/krlvm/PowerTunnel-Android)** от @krlvm (для Android)
- **[SpoofDPI](https://github.com/xvzc/SpoofDPI)** от @xvzc (для macOS и Linux)
- **[SpoofDPI-Platform](https://github.com/r3pr3ss10n/SpoofDPI-Platform)** от @r3pr3ss10n (для Android, macOS, Windows)
- **[GhosTCP](https://github.com/macronut/ghostcp)** от @macronut (для Windows)
- **[ByeDPI](https://github.com/hufrea/byedpi)** для Linux/Windows + **[ByeDPIAndroid](https://github.com/dovecoteescapee/ByeDPIAndroid/)** для Android (без рута)
- **[youtubeUnblock](https://github.com/Waujito/youtubeUnblock/)** от @Waujito (для роутеров OpenWRT/Entware и Linux)

## Условия использования и отказ от ответственности

> [!WARNING]
> Используя это программное обеспечение в любой форме или распространяя его, вы принимаете следующие условия использования и отказ от ответственности.

Разработчик и/или поставщик данного программного обеспечения не несет никакой ответственности за любые убытки или ущерб, включая, но не ограничиваясь, прямые, косвенные, случайные, штрафные или косвенные убытки, возникшие в результате использования или невозможности использования данного программного обеспечения, даже если разработчик или поставщик были уведомлены о возможности таких убытков.

Разработчик и/или поставщик данного программного обеспечения не несут ответственности за любые юридические последствия, возникшие в результате использования данного программного обеспечения. Это включает, но не ограничивается, нарушение законодательства, правил или нормативных актов, а также любые претензии или иски, возникшие в результате использования данного программного обеспечения. Пользователь несет полную ответственность за соблюдение всех применимых законов и нормативных актов при использовании данного программного обеспечения.

Разработчик и/или поставщик данного программного обеспечения не несут ответственности за любые убытки или ущерб, возникшие в результате неправомерного использования данного программного обеспечения. Неправомерное использование включает, но не ограничивается, использование программного обеспечения для незаконных целей, нарушение авторских прав, патентных прав, торговых марок или других прав интеллектуальной собственности, а также использование программного обеспечения в нарушение условий лицензии данного программного обеспечения.

Данное программное обеспечение не может использоваться в противоправных целях или целях, нарушающих законодательство. Любое использование программного обеспечения для незаконных действий, включая, но не ограничиваясь, мошенничество, взлом, нарушение конфиденциальности, распространение вредоносного ПО или любые другие действия, противоречащие закодательству и нормативным актам, строго запрещено. Пользователь несет полную ответственность за любые юридические последствия, возникшие в результате использования данного программного обеспечения в противоправных целях.

Использование данного программного обеспечения означает ваше согласие с условиями данного отказа от ответственности. Если вы не согласны с этими условиями, вы должны немедленно прекратить использование данного программного обеспечения.

## Быстрый старт

1) Скачайте последнюю версию для вашей ОС со [страницы релизов](https://github.com/GVCoder09/NoDPI/releases) и распакуйте её.
2) Перейдите в каталог с распакованной утилитой и запустите её командой `nodpi.exe --blacklist blacklist.txt` в Windows или `./nodpi --blacklist ./blacklist.txt` в Linux. Вы можете заменить файл `blacklist.txt` своим. **Если файл blacklist не указан, программа по умолчанию будет искать `blacklist.txt` в текущем каталоге.**
3) В настройках браузера или системы настройте прокси на 127.0.0.1:8881
4) Наслаждайтесь!

> [!IMPORTANT]
> Не забудьте отключить прокси-сервер в настройках системы или браузера после закрытия программы!

Пожалуйста, сообщайте нам о любых проблемах и неполадках на [странице Issues](https://github.com/GVCoder09/NoDPI/issues)

### Добавление в автозагрузку в Windows и Linux

> [!NOTE]
> Эта опция доступна только в исполняемых версиях.

> [!IMPORTANT]
> Убедитесь, что файл `blacklist.txt` находится в одной папке с исполняемым файлом.

1) Выполните команду `nodpi --install`. Программа будет добавлена ​​в автозагрузку через реестр Windows (`HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Run`) или через `systemd` в Linux.
2) Перезагрузите компьютер.
3) Наслаждайтесь!

### Поддерживаемые аргументы командной строки

```
usage: nodpi [-h] [--host HOST] [--port PORT] [--out-host OUT_HOST] [--blacklist BLACKLIST | --no-blacklist | --autoblacklist]
               [--fragment-method {random,sni}] [--domain-matching {loose,strict}] [--log-access LOG_ACCESS] [--log-error LOG_ERROR]
               [-q] [--install | --uninstall]

options:
  -h, --help            show this help message and exit
  --host HOST           Proxy host
  --port PORT           Proxy port
  --out-host OUT_HOST   Outgoing proxy host
  --blacklist BLACKLIST
                        Path to blacklist file
  --no-blacklist        Use fragmentation for all domains
  --autoblacklist       Automatic detection of blocked domains
  --fragment-method {random,sni}
                        Fragmentation method (random by default)
  --domain-matching {loose,strict}
                        Domain matching mode (strict by default)
  --log-access LOG_ACCESS
                        Path to the access control log
  --log-error LOG_ERROR
                        Path to log file for errors
  -q, --quiet           Remove UI output
  --install             Add proxy to Windows/Linux autostart (only for executable version)
  --uninstall           Remove proxy from Windows/Linux autostart (only for executable version)
```

## Запуск из исходного кода

1) Убедитесь, что у вас установлен Python 3.8 или выше. Сторонние библиотеки не требуются.
2) Склонируйте репозиторий `git clone https://github.com/GVCoder09/NoDPI.git` или [скачайте архив](https://github.com/GVCoder09/NoDPI/archive/refs/heads/main.zip) с исходным кодом и распакуйте его.
3) Перейдите в корневой каталог и запустите код командой `python3 src/main.py`.
4) В настройках браузера или системы установите прокси-сервер на 127.0.0.1:8881.
5) Наслаждайтесь!

Вы можете включить логирование ошибок и доступа с помощью параметров `--log_error` и `--log_access`.

## Сборка исполняемого файла

1) Убедитесь, что у вас установлен Python 3.8 или выше.
2) Установите pyinstaller: `pip install pyinstaller`
3) Клонируйте репозиторий `git clone https://github.com/GVCoder09/NoDPI.git` или [скачайте архив](https://github.com/GVCoder09/NoDPI/archive/refs/heads/main.zip) с исходным кодом и распакуйте его.
4) Перейдите в корневой каталог и выполните команду `pyinstaller ./nodpi.spec`
5) Скомпилированный файл будет находиться в папке `./dist`

## Запуск в Docker

1) [Установите Docker](https://docs.docker.com/).
2) Клонируйте репозиторий: `git clone https://github.com/GVCoder09/NoDPI`
3) Перейдите в каталог проекта и соберите контейнер:
   ```bash
   cd NoDPI
   sudo docker build -t nodpi-proxy .
   ```
4) Запустите контейнер командой: 
   ```bash
   sudo docker run -d \
    --name nodpi \
    -p 8881:8881 \
    -v $(pwd)/blacklist.txt:/tmp/nodpi/blacklist.txt \
    nodpi-proxy \
    --host 127.0.0.1 \
    --port 8881 \
    --blacklist /tmp/nodpi/blacklist.txt \
    --quiet
    ```
5) Наслаждайтесь!

## FAQ

*В: Законно ли использование NoDPI в России?*

О: Да, его использование полностью законно по состоянию на октябрь 2025 года. Однако вы можете быть привлечены к административной ответственности за рекламу и распространение инструментов, предназначенных для обхода блокировок.

*В: Безопасно ли это?*

О: Да, использование этой утилиты безопасно. Весь трафик, передаваемый по HTTPS, остаётся зашифрованным, как и раньше. Более того, мы не собираем никакой информации о пользователях.

*В: Эта программа маскирует мой трафик? Провайдер не видит какие сайты я посещаю?*

О: Нет, в отличии от VPN или Tor, эта программа не скрывает трафик от провайдера. Он по прежнему может видеть IP адреса сайтов, к которым вы обращаетесь.

## История звезд проекта

[![Star History Chart](https://api.star-history.com/svg?repos=GVCoder09/NoDPI&type=Date)](https://www.star-history.com/#GVCoder09/NoDPI&Date)