/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.analysis.api.platform.KotlinMessageBusProviderKt;
import org.jetbrains.kotlin.analysis.api.platform.modification.KaElementModificationType;
import org.jetbrains.kotlin.analysis.api.platform.modification.KotlinModificationTopics;
import org.jetbrains.kotlin.analysis.api.platform.modification.KotlinModuleOutOfBlockModificationListener;
import org.jetbrains.kotlin.analysis.api.platform.projectStructure.KotlinProjectStructureProvider;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.low.level.api.fir.LLFirInternals;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.LLFirResolveSession;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.LowLevelFirApiFacadeKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.ChangeType;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.FileStructure;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.FileStructureCache;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.InBlockModificationKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.LLFirDeclarationModificationServiceKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.LLFirDeclarationModificationTopics;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.LLFirInBlockModificationListener;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirResolvableModuleSession;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirResolvableModuleSessionKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.DeclarationUtilsKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.ExceptionUtilsKt;
import org.jetbrains.kotlin.fir.FirElementWithResolveState;
import org.jetbrains.kotlin.fir.declarations.FirCodeFragment;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.utils.exceptions.ExceptionAttachmentBuilder;

@LLFirInternals
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010)\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0007\u0018\u0000 .2\u00020\u0001:\u0001.B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0002J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002JG\u0010\u0011\u001a\u00020\f2<\u0010\u0012\u001a8\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0016\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\n0\u0017\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\f0\u0013H\u0082\bJ\u0006\u0010\u0019\u001a\u00020\fJ\u0016\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u001c\u0010!\u001a\u00020\"*\u00020\u001c2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\f\u0010%\u001a\u00020\"*\u00020\u001eH\u0002J\u0014\u0010&\u001a\u00020\"*\u00020\u001e2\u0006\u0010#\u001a\u00020$H\u0002J\u0018\u0010'\u001a\u00020\f2\u0006\u0010(\u001a\u00020$2\u0006\u0010)\u001a\u00020\u0010H\u0002J\u0010\u0010*\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010+\u001a\u0004\u0018\u00010\u001c2\u0006\u0010,\u001a\u00020\u001cJ\b\u0010-\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/LLFirDeclarationModificationService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "inBlockModificationQueue", "", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/ChangeType$InBlock;", "addModificationToQueue", "", "modification", "dropOutdatedModifications", "ktModuleWithOutOfBlockModification", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "processQueue", "action", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "value", "", "iterator", "flushModifications", "elementModified", "element", "Lcom/intellij/psi/PsiElement;", "modificationType", "Lorg/jetbrains/kotlin/analysis/api/platform/modification/KaElementModificationType;", "calculateChangeType", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/ChangeType;", "isNewDirectChildOf", "", "inBlockModificationOwner", "Lorg/jetbrains/kotlin/psi/KtAnnotated;", "isContractRemoval", "isBackingFieldAccessChange", "inBlockModification", "declaration", "module", "outOfBlockModification", "ancestorAffectedByInBlockModification", "changedElement", "dispose", "Companion", "low-level-api-fir"})
@SourceDebugExtension(value={"SMAP\nLLFirDeclarationModificationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLFirDeclarationModificationService.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/LLFirDeclarationModificationService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,478:1\n106#1,12:480\n106#1,12:492\n1#2:479\n*S KotlinDebug\n*F\n+ 1 LLFirDeclarationModificationService.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/LLFirDeclarationModificationService\n*L\n92#1:480,12\n126#1:492,12\n*E\n"})
public final class LLFirDeclarationModificationService
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private Set<ChangeType.InBlock> inBlockModificationQueue;

    public LLFirDeclarationModificationService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        ApplicationManager.getApplication().addApplicationListener(new ApplicationListener(){

            public void writeActionFinished(Object action) {
                Intrinsics.checkNotNullParameter((Object)action, (String)"action");
                this.flushModifications();
            }
        }, (Disposable)this);
        this.project.getMessageBus().connect((Disposable)this).subscribe(KtCodeFragment.Companion.getIMPORT_MODIFICATION(), arg_0 -> LLFirDeclarationModificationService._init_$lambda$0(this, arg_0));
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final void addModificationToQueue(ChangeType.InBlock modification) {
        if (!LLFirDeclarationModificationServiceKt.access$getHasFirBody(modification.getBlockOwner())) {
            return;
        }
        Set set = this.inBlockModificationQueue;
        if (set == null) {
            HashSet hashSet;
            HashSet it = hashSet = new HashSet();
            boolean bl = false;
            this.inBlockModificationQueue = it;
            set = hashSet;
        }
        Set queue = set;
        ((Collection)queue).add(modification);
    }

    /*
     * WARNING - void declaration
     */
    private final void dropOutdatedModifications(KaModule ktModuleWithOutOfBlockModification) {
        LLFirDeclarationModificationService this_$iv = this;
        boolean $i$f$processQueue = false;
        Set<ChangeType.InBlock> set = this_$iv.inBlockModificationQueue;
        if (set != null) {
            Set<ChangeType.InBlock> queue$iv = set;
            Iterator<ChangeType.InBlock> iterator$iv = queue$iv.iterator();
            while (iterator$iv.hasNext()) {
                void iterator2;
                ChangeType.InBlock element$iv = iterator$iv.next();
                if (!element$iv.getBlockOwner().isValid()) {
                    iterator$iv.remove();
                    continue;
                }
                Iterator<ChangeType.InBlock> iterator3 = iterator$iv;
                ChangeType.InBlock value2 = element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)value2.getKtModule(), (Object)ktModuleWithOutOfBlockModification)) continue;
                iterator2.remove();
            }
        }
    }

    private final void processQueue(Function2<? super ChangeType.InBlock, ? super Iterator<ChangeType.InBlock>, Unit> action) {
        boolean $i$f$processQueue = false;
        Set<ChangeType.InBlock> set = this.inBlockModificationQueue;
        if (set == null) {
            return;
        }
        Set<ChangeType.InBlock> queue = set;
        Iterator<ChangeType.InBlock> iterator2 = queue.iterator();
        while (iterator2.hasNext()) {
            ChangeType.InBlock element = iterator2.next();
            if (!element.getBlockOwner().isValid()) {
                iterator2.remove();
                continue;
            }
            action.invoke((Object)element, iterator2);
        }
    }

    public final void flushModifications() {
        ApplicationManager.getApplication().assertWriteIntentLockAcquired();
        LLFirDeclarationModificationService this_$iv = this;
        boolean $i$f$processQueue = false;
        Set<ChangeType.InBlock> set = this_$iv.inBlockModificationQueue;
        if (set != null) {
            Set<ChangeType.InBlock> queue$iv = set;
            Iterator<ChangeType.InBlock> iterator$iv = queue$iv.iterator();
            while (iterator$iv.hasNext()) {
                ChangeType.InBlock element$iv = iterator$iv.next();
                if (!element$iv.getBlockOwner().isValid()) {
                    iterator$iv.remove();
                    continue;
                }
                ChangeType.InBlock value2 = element$iv;
                boolean bl = false;
                this.inBlockModification(value2.getBlockOwner(), value2.getKtModule());
            }
        }
        this.inBlockModificationQueue = null;
    }

    public final void elementModified(@NotNull PsiElement element, @NotNull KaElementModificationType modificationType) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)modificationType, (String)"modificationType");
        ApplicationManager.getApplication().assertWriteIntentLockAcquired();
        ChangeType changeType = this.calculateChangeType(element, modificationType);
        if (!(changeType instanceof ChangeType.Invisible)) {
            if (changeType instanceof ChangeType.InBlock) {
                this.addModificationToQueue((ChangeType.InBlock)changeType);
            } else if (changeType instanceof ChangeType.OutOfBlock) {
                this.outOfBlockModification(element);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final ChangeType calculateChangeType(PsiElement element, KaElementModificationType modificationType) {
        if (!element.isValid()) {
            return ChangeType.OutOfBlock.INSTANCE;
        }
        if (element instanceof PsiWhiteSpace || element instanceof PsiComment) {
            return ChangeType.Invisible.INSTANCE;
        }
        if (!(element.getLanguage() instanceof KotlinLanguage)) {
            return ChangeType.OutOfBlock.INSTANCE;
        }
        KtAnnotated ktAnnotated = LLFirDeclarationModificationServiceKt.access$nonLocalDeclarationForLocalChange(element);
        if (ktAnnotated == null) {
            return ChangeType.OutOfBlock.INSTANCE;
        }
        KtAnnotated inBlockModificationOwner = ktAnnotated;
        if (inBlockModificationOwner instanceof KtCodeFragment) {
            return new ChangeType.InBlock(inBlockModificationOwner, this.project);
        }
        boolean isOutOfBlockChange = this.isNewDirectChildOf(element, inBlockModificationOwner, modificationType) || this.isContractRemoval(modificationType) || this.isBackingFieldAccessChange(modificationType, inBlockModificationOwner);
        return !isOutOfBlockChange ? (ChangeType)new ChangeType.InBlock(inBlockModificationOwner, this.project) : (ChangeType)ChangeType.OutOfBlock.INSTANCE;
    }

    private final boolean isNewDirectChildOf(PsiElement $this$isNewDirectChildOf, KtAnnotated inBlockModificationOwner, KaElementModificationType modificationType) {
        return Intrinsics.areEqual((Object)modificationType, (Object)KaElementModificationType.ElementAdded.INSTANCE) && Intrinsics.areEqual((Object)$this$isNewDirectChildOf.getParent(), (Object)inBlockModificationOwner);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isContractRemoval(KaElementModificationType $this$isContractRemoval) {
        if (!($this$isContractRemoval instanceof KaElementModificationType.ElementRemoved)) return false;
        PsiElement psiElement = ((KaElementModificationType.ElementRemoved)$this$isContractRemoval).getRemovedElement();
        if (!(psiElement instanceof KtExpression)) return false;
        KtExpression ktExpression = (KtExpression)psiElement;
        if (ktExpression == null) return false;
        if (!KtPsiUtilKt.isContractDescriptionCallPsiCheck(ktExpression)) return false;
        return true;
    }

    private final boolean isBackingFieldAccessChange(KaElementModificationType $this$isBackingFieldAccessChange, KtAnnotated inBlockModificationOwner) {
        return inBlockModificationOwner instanceof KtPropertyAccessor && $this$isBackingFieldAccessChange instanceof KaElementModificationType.ElementRemoved && LLFirDeclarationModificationServiceKt.access$potentiallyAffectsPropertyBackingFieldResolution(((KaElementModificationType.ElementRemoved)$this$isBackingFieldAccessChange).getRemovedElement());
    }

    private final void inBlockModification(KtAnnotated declaration, KaModule module2) {
        FirDeclaration firDeclaration;
        LLFirResolveSession resolveSession = LowLevelFirApiFacadeKt.getFirResolveSession(module2, this.project);
        KtAnnotated ktAnnotated = declaration;
        if (ktAnnotated instanceof KtCodeFragment) {
            firDeclaration = DeclarationUtilsKt.getCodeFragment(LowLevelFirApiFacadeKt.getOrBuildFirFile((KtFile)declaration, resolveSession));
        } else if (ktAnnotated instanceof KtDeclaration) {
            firDeclaration = LowLevelFirApiFacadeKt.resolveToFirSymbol$default((KtDeclaration)declaration, resolveSession, null, 2, null).getFir();
        } else {
            ExceptionUtilsKt.errorWithFirSpecificEntries$default("Unexpected declaration kind: " + Reflection.getOrCreateKotlinClass(declaration.getClass()).getSimpleName(), null, null, null, (PsiElement)declaration, null, 46, null);
            throw new KotlinNothingValueException();
        }
        FirDeclaration firDeclaration2 = firDeclaration;
        InBlockModificationKt.invalidateAfterInBlockModification(firDeclaration2);
        LLFirDeclarationModificationServiceKt.access$setHasFirBody(declaration, false);
        LLFirResolvableModuleSession lLFirResolvableModuleSession = LLFirResolvableModuleSessionKt.getLlFirResolvableSession(firDeclaration2);
        if (lLFirResolvableModuleSession == null) {
            ExceptionUtilsKt.errorWithFirSpecificEntries$default(Reflection.getOrCreateKotlinClass(LLFirResolvableModuleSession.class).getSimpleName() + " is not found", null, firDeclaration2, null, (PsiElement)declaration, arg_0 -> LLFirDeclarationModificationService.inBlockModification$lambda$5(resolveSession, arg_0), 10, null);
            throw new KotlinNothingValueException();
        }
        LLFirResolvableModuleSession moduleSession = lLFirResolvableModuleSession;
        FileStructureCache fileStructureCache = moduleSession.getModuleComponents$low_level_api_fir().getFileStructureCache();
        KtFile ktFile = declaration.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"getContainingKtFile(...)");
        FileStructure fileStructure = fileStructureCache.getCachedFileStructure(ktFile);
        if (fileStructure != null) {
            fileStructure.invalidateElement(declaration);
        }
        ((LLFirInBlockModificationListener)KotlinMessageBusProviderKt.getAnalysisMessageBus(this.project).syncPublisher(LLFirDeclarationModificationTopics.INSTANCE.getIN_BLOCK_MODIFICATION())).afterModification(declaration, module2);
    }

    private final void outOfBlockModification(PsiElement element) {
        KaModule ktModule = KotlinProjectStructureProvider.Companion.getModule(this.project, element, null);
        this.dropOutdatedModifications(ktModule);
        ((KotlinModuleOutOfBlockModificationListener)KotlinMessageBusProviderKt.getAnalysisMessageBus(this.project).syncPublisher(KotlinModificationTopics.INSTANCE.getMODULE_OUT_OF_BLOCK_MODIFICATION())).onModification(ktModule);
    }

    @Nullable
    public final PsiElement ancestorAffectedByInBlockModification(@NotNull PsiElement changedElement) {
        Intrinsics.checkNotNullParameter((Object)changedElement, (String)"changedElement");
        return (PsiElement)LLFirDeclarationModificationServiceKt.access$nonLocalDeclarationForLocalChange(changedElement);
    }

    public void dispose() {
    }

    private static final void _init_$lambda$0(LLFirDeclarationModificationService this$0, KtCodeFragment codeFragment) {
        Intrinsics.checkNotNullParameter((Object)codeFragment, (String)"codeFragment");
        this$0.outOfBlockModification((PsiElement)codeFragment);
    }

    private static final String inBlockModification$lambda$5$lambda$4(LLFirResolveSession it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.toString();
    }

    private static final Unit inBlockModification$lambda$5(LLFirResolveSession $resolveSession, ExceptionAttachmentBuilder $this$errorWithFirSpecificEntries) {
        Intrinsics.checkNotNullParameter((Object)$this$errorWithFirSpecificEntries, (String)"$this$errorWithFirSpecificEntries");
        $this$errorWithFirSpecificEntries.withEntry("session", $resolveSession, LLFirDeclarationModificationService::inBlockModification$lambda$5$lambda$4);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001d\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/LLFirDeclarationModificationService$Companion;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/LLFirDeclarationModificationService;", "project", "Lcom/intellij/openapi/project/Project;", "bodyResolved", "", "element", "Lorg/jetbrains/kotlin/fir/FirElementWithResolveState;", "phase", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvePhase;", "bodyResolved$low_level_api_fir", "low-level-api-fir"})
    @SourceDebugExtension(value={"SMAP\nLLFirDeclarationModificationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLFirDeclarationModificationService.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/LLFirDeclarationModificationService$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,478:1\n1755#2,3:479\n*S KotlinDebug\n*F\n+ 1 LLFirDeclarationModificationService.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/LLFirDeclarationModificationService$Companion\n*L\n305#1:479,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LLFirDeclarationModificationService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(LLFirDeclarationModificationService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (LLFirDeclarationModificationService)object;
        }

        public final void bodyResolved$low_level_api_fir(@NotNull FirElementWithResolveState element, @NotNull FirResolvePhase phase) {
            block19: {
                KtAnnotated ktAnnotated;
                KtAnnotated declaration;
                block20: {
                    block21: {
                        boolean bl;
                        block17: {
                            block18: {
                                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                                Intrinsics.checkNotNullParameter((Object)((Object)phase), (String)"phase");
                                FirElementWithResolveState firElementWithResolveState = element;
                                if (firElementWithResolveState instanceof FirSimpleFunction) {
                                    if (phase != FirResolvePhase.BODY_RESOLVE) {
                                        return;
                                    }
                                } else if (firElementWithResolveState instanceof FirProperty) {
                                    if (phase != FirResolvePhase.BODY_RESOLVE && phase != FirResolvePhase.IMPLICIT_TYPES_BODY_RESOLVE) {
                                        return;
                                    }
                                } else if (firElementWithResolveState instanceof FirCodeFragment) {
                                    if (phase != FirResolvePhase.BODY_RESOLVE) {
                                        return;
                                    }
                                } else {
                                    return;
                                }
                                KtSourceElement ktSourceElement = ((FirDeclaration)element).getSource();
                                PsiElement psiElement = ktSourceElement != null ? KtSourceElementKt.getPsi(ktSourceElement) : null;
                                KtAnnotated ktAnnotated2 = psiElement instanceof KtAnnotated ? (KtAnnotated)psiElement : null;
                                if (ktAnnotated2 == null) {
                                    return;
                                }
                                declaration = ktAnnotated2;
                                ktAnnotated = declaration;
                                if (!(ktAnnotated instanceof KtNamedFunction)) break block18;
                                if (LLFirDeclarationModificationServiceKt.access$isReanalyzableContainer((KtNamedFunction)declaration)) {
                                    LLFirDeclarationModificationServiceKt.access$setHasFirBody(declaration, true);
                                }
                                break block19;
                            }
                            if (!(ktAnnotated instanceof KtProperty)) break block20;
                            if (LLFirDeclarationModificationServiceKt.access$isReanalyzableContainer((KtProperty)declaration)) break block21;
                            List<KtPropertyAccessor> list = ((KtProperty)declaration).getAccessors();
                            Intrinsics.checkNotNullExpressionValue(list, (String)"getAccessors(...)");
                            Iterable $this$any$iv = list;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl = false;
                            } else {
                                for (Object element$iv : $this$any$iv) {
                                    KtPropertyAccessor p0 = (KtPropertyAccessor)element$iv;
                                    boolean bl2 = false;
                                    if (!LLFirDeclarationModificationServiceKt.access$isReanalyzableContainer(p0)) continue;
                                    bl = true;
                                    break block17;
                                }
                                bl = false;
                            }
                        }
                        if (!bl) break block19;
                    }
                    LLFirDeclarationModificationServiceKt.access$setHasFirBody(declaration, true);
                    break block19;
                }
                if (ktAnnotated instanceof KtCodeFragment) {
                    LLFirDeclarationModificationServiceKt.access$setHasFirBody(declaration, true);
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

