/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.parser.sourcemaps;

import java.util.Collection;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonArray;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonBoolean;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonNode;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonNull;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonNumber;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonObject;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonString;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonSyntaxException;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0011H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u0003H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u001bH\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u0014\u0010\u001f\u001a\u00020\u00132\n\u0010 \u001a\u00060!j\u0002`\"H\u0002J\u0014\u0010#\u001a\u00020\u00132\n\u0010 \u001a\u00060!j\u0002`\"H\u0002J\u0010\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u0003H\u0002J\u0010\u0010&\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u001bH\u0002J\"\u0010'\u001a\u0002H(\"\u0004\b\u0000\u0010(2\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H(0*H\u0082\b\u00a2\u0006\u0002\u0010+J\b\u0010,\u001a\u00020\u0013H\u0002J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u0003H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/js/parser/sourcemaps/JsonParser;", "", "content", "", "<init>", "(Ljava/lang/String;)V", "getContent", "()Ljava/lang/String;", "index", "", "charCode", "offset", "line", "col", "wasCR", "", "parse", "Lorg/jetbrains/kotlin/js/parser/sourcemaps/JsonNode;", "skipSpaces", "", "parseNode", "parseArray", "Lorg/jetbrains/kotlin/js/parser/sourcemaps/JsonArray;", "parseObject", "Lorg/jetbrains/kotlin/js/parser/sourcemaps/JsonObject;", "parseString", "parseEscapeSequence", "", "parseHexEscapeSequence", "parseNumber", "", "takeIntegerDigitsTo", "buffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "takeExponentTo", "expectString", "expected", "expectCharAndAdvance", "advanceAndThen", "T", "f", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "advance", "error", "", "text", "js.parser"})
@SourceDebugExtension(value={"SMAP\nJSON.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSON.kt\norg/jetbrains/kotlin/js/parser/sourcemaps/JsonParser\n*L\n1#1,383:1\n353#1,2:384\n353#1,2:386\n353#1,2:388\n353#1,2:390\n353#1,2:392\n353#1,2:394\n353#1,2:396\n353#1,2:398\n*S KotlinDebug\n*F\n+ 1 JSON.kt\norg/jetbrains/kotlin/js/parser/sourcemaps/JsonParser\n*L\n268#1:384,2\n269#1:386,2\n270#1:388,2\n271#1:390,2\n272#1:392,2\n273#1:394,2\n274#1:396,2\n275#1:398,2\n*E\n"})
final class JsonParser {
    @NotNull
    private final String content;
    private int index;
    private int charCode;
    private int offset;
    private int line;
    private int col;
    private boolean wasCR;

    public JsonParser(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        this.content = content;
        this.index = -1;
        ++this.index;
        Character c = StringsKt.getOrNull((CharSequence)this.content, (int)this.index);
        this.charCode = c != null ? c.charValue() : -1;
    }

    @NotNull
    public final String getContent() {
        return this.content;
    }

    @NotNull
    public final JsonNode parse() {
        JsonNode result2 = this.parseNode();
        this.skipSpaces();
        if (this.charCode != -1) {
            this.error("End of input expected");
            throw new KotlinNothingValueException();
        }
        return result2;
    }

    private final void skipSpaces() {
        block3: while (true) {
            switch (this.charCode) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    this.advance();
                    continue block3;
                }
            }
            break;
        }
    }

    private final JsonNode parseNode() {
        JsonNode jsonNode;
        this.skipSpaces();
        switch (this.charCode) {
            case 91: {
                jsonNode = this.parseArray();
                break;
            }
            case 123: {
                jsonNode = this.parseObject();
                break;
            }
            case 34: {
                jsonNode = new JsonString(this.parseString());
                break;
            }
            case 110: {
                this.expectString("null");
                jsonNode = JsonNull.INSTANCE;
                break;
            }
            case 102: {
                this.expectString("false");
                jsonNode = JsonBoolean.Companion.getFALSE();
                break;
            }
            case 116: {
                this.expectString("true");
                jsonNode = JsonBoolean.Companion.getTRUE();
                break;
            }
            case 45: {
                this.advance();
                jsonNode = new JsonNumber(-this.parseNumber());
                break;
            }
            default: {
                int n = this.charCode;
                if (!(48 <= n ? n < 58 : false)) {
                    this.error("Unexpected char");
                    throw new KotlinNothingValueException();
                }
                jsonNode = new JsonNumber(this.parseNumber());
            }
        }
        return jsonNode;
    }

    private final JsonArray parseArray() {
        this.advance();
        JsonArray result2 = new JsonArray(new JsonNode[0]);
        while (true) {
            this.skipSpaces();
            if (this.charCode == 93) break;
            if (!((Collection)result2.getElements()).isEmpty()) {
                this.expectCharAndAdvance(',');
            }
            ((Collection)result2.getElements()).add(this.parseNode());
        }
        this.advance();
        return result2;
    }

    private final JsonObject parseObject() {
        this.advance();
        JsonObject result2 = new JsonObject(new Pair[0]);
        while (true) {
            this.skipSpaces();
            if (this.charCode == 125) break;
            if (!result2.getProperties().isEmpty()) {
                this.expectCharAndAdvance(',');
            }
            this.skipSpaces();
            String key = this.parseString();
            if (result2.getProperties().containsKey(key)) {
                this.error("Duplicate property name: " + key);
                throw new KotlinNothingValueException();
            }
            this.skipSpaces();
            this.expectCharAndAdvance(':');
            result2.getProperties().put(key, this.parseNode());
        }
        this.advance();
        return result2;
    }

    private final String parseString() {
        this.expectCharAndAdvance('\"');
        StringBuilder sb = new StringBuilder();
        int leftIndex = this.index;
        block4: while (this.index < this.content.length()) {
            this.charCode = this.content.charAt(this.index);
            if (this.charCode < 32) {
                this.error("Invalid character in string literal");
                throw new KotlinNothingValueException();
            }
            switch (this.charCode) {
                case 34: {
                    sb.append(this.content, leftIndex, this.index);
                    this.advance();
                    String string2 = sb.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                    return string2;
                }
                case 92: {
                    sb.append(this.content, leftIndex, this.index);
                    sb.append(this.parseEscapeSequence());
                    leftIndex = this.index;
                    continue block4;
                }
            }
            ++this.index;
        }
        this.error("Unexpected end of file");
        throw new KotlinNothingValueException();
    }

    private final char parseEscapeSequence() {
        int n;
        this.advance();
        switch (this.charCode) {
            case 34: {
                JsonParser this_$iv = this;
                boolean $i$f$advanceAndThen = false;
                this_$iv.advance();
                boolean bl = false;
                n = 34;
                break;
            }
            case 92: {
                JsonParser this_$iv = this;
                boolean $i$f$advanceAndThen = false;
                this_$iv.advance();
                boolean bl = false;
                n = 92;
                break;
            }
            case 47: {
                JsonParser this_$iv = this;
                boolean $i$f$advanceAndThen = false;
                this_$iv.advance();
                boolean bl = false;
                n = 47;
                break;
            }
            case 98: {
                JsonParser this_$iv = this;
                boolean $i$f$advanceAndThen = false;
                this_$iv.advance();
                boolean bl = false;
                n = 8;
                break;
            }
            case 110: {
                JsonParser this_$iv = this;
                boolean $i$f$advanceAndThen = false;
                this_$iv.advance();
                boolean bl = false;
                n = 10;
                break;
            }
            case 114: {
                JsonParser this_$iv = this;
                boolean $i$f$advanceAndThen = false;
                this_$iv.advance();
                boolean bl = false;
                n = 13;
                break;
            }
            case 102: {
                JsonParser this_$iv = this;
                boolean $i$f$advanceAndThen = false;
                this_$iv.advance();
                boolean bl = false;
                n = 12;
                break;
            }
            case 116: {
                JsonParser this_$iv = this;
                boolean $i$f$advanceAndThen = false;
                this_$iv.advance();
                boolean bl = false;
                n = 9;
                break;
            }
            case 117: {
                n = this.parseHexEscapeSequence();
                break;
            }
            default: {
                this.error("Invalid escape sequence");
                throw new KotlinNothingValueException();
            }
        }
        return (char)n;
    }

    private final char parseHexEscapeSequence() {
        this.advance();
        int value2 = 0;
        int n = 4;
        for (int j = 0; j < n; ++j) {
            int n2;
            int it = j;
            boolean bl = false;
            value2 *= 16;
            int n3 = this.charCode;
            boolean bl2 = 48 <= n3 ? n3 < 58 : false;
            if (bl2) {
                n2 = this.charCode - 48;
            } else {
                boolean bl3 = 97 <= n3 ? n3 < 103 : false;
                if (bl3) {
                    n2 = this.charCode - 97 + 10;
                } else {
                    boolean bl4 = 65 <= n3 ? n3 < 71 : false;
                    if (bl4) {
                        n2 = this.charCode - 65 + 10;
                    } else {
                        this.error("Invalid escape sequence, hexadecimal char expected");
                        throw new KotlinNothingValueException();
                    }
                }
            }
            value2 += n2;
            this.advance();
        }
        return (char)value2;
    }

    private final double parseNumber() {
        double d;
        StringBuilder sb = new StringBuilder();
        this.takeIntegerDigitsTo(sb);
        if (StringsKt.startsWith$default((CharSequence)sb, (char)'0', (boolean)false, (int)2, null) && sb.length() > 1) {
            this.error("Number must not start with zero");
            throw new KotlinNothingValueException();
        }
        switch (this.charCode) {
            case 46: {
                sb.append('.');
                this.advance();
                this.takeIntegerDigitsTo(sb);
                if (this.charCode == 101 || this.charCode == 69) {
                    this.takeExponentTo(sb);
                }
                String string2 = sb.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                d = Double.parseDouble(string2);
                break;
            }
            case 69: 
            case 101: {
                this.takeExponentTo(sb);
                String string3 = sb.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
                d = Double.parseDouble(string3);
                break;
            }
            default: {
                String string4 = sb.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
                return Double.parseDouble(string4);
            }
        }
        return d;
    }

    private final void takeIntegerDigitsTo(StringBuilder buffer) {
        int size = 0;
        while (true) {
            int n;
            boolean bl = 48 <= (n = this.charCode) ? n < 58 : false;
            if (!bl) break;
            buffer.append((char)this.charCode);
            this.advance();
            ++size;
        }
        if (size == 0) {
            this.error("Invalid char, decimal digit expected");
            throw new KotlinNothingValueException();
        }
    }

    private final void takeExponentTo(StringBuilder buffer) {
        buffer.append('e');
        this.advance();
        if (this.charCode == 45 || this.charCode == 43) {
            buffer.append((char)this.charCode);
            this.advance();
        }
        this.takeIntegerDigitsTo(buffer);
    }

    private final void expectString(String expected) {
        int n = expected.length();
        for (int j = 0; j < n; ++j) {
            char c = expected.charAt(j);
            if (this.charCode != c) {
                this.error("Unexpected char, '" + expected + "' expected here");
                throw new KotlinNothingValueException();
            }
            this.advance();
        }
    }

    private final void expectCharAndAdvance(char expected) {
        if (this.charCode != expected) {
            this.error("Unexpected char, '" + expected + "' expected here");
            throw new KotlinNothingValueException();
        }
        this.advance();
    }

    private final <T> T advanceAndThen(Function0<? extends T> f) {
        boolean $i$f$advanceAndThen = false;
        this.advance();
        return (T)f.invoke();
    }

    private final void advance() {
        if (this.charCode == -1) {
            return;
        }
        switch (this.charCode) {
            case 13: {
                int n = this.line;
                this.line = n + 1;
                this.col = 0;
                this.wasCR = true;
                break;
            }
            case 10: {
                if (this.wasCR) break;
                int n = this.line;
                this.line = n + 1;
                this.col = 0;
                this.wasCR = false;
                break;
            }
            default: {
                int n = this.col;
                this.col = n + 1;
                this.wasCR = false;
            }
        }
        ++this.index;
        Character c = StringsKt.getOrNull((CharSequence)this.content, (int)this.index);
        this.charCode = c != null ? c.charValue() : -1;
        int n = this.offset;
        this.offset = n + 1;
    }

    private final Void error(String text) {
        throw new JsonSyntaxException(this.offset, this.line, this.col, text);
    }
}

