/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profgen.cli;

import com.android.tools.profgen.Apk;
import com.android.tools.profgen.ArtProfile;
import com.android.tools.profgen.ArtProfileKt;
import com.android.tools.profgen.DexDataKt;
import com.android.tools.profgen.ObfuscationMap;
import com.android.tools.profgen.ObfuscationMapKt;
import com.android.tools.profgen.ProfileDumperKt;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlinx.cli.ArgParser;
import kotlinx.cli.ArgType;
import kotlinx.cli.ArgumentValueDelegate;
import kotlinx.cli.ExperimentalCli;
import kotlinx.cli.OptionsKt;
import kotlinx.cli.SingleNullableOption;
import kotlinx.cli.Subcommand;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\n\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\t\u001a\u0004\b\u000b\u0010\u0007R\u001d\u0010\r\u001a\u0004\u0018\u00010\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\t\u001a\u0004\b\u000e\u0010\u0007R\u001b\u0010\u0010\u001a\u00020\u00118FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\t\u001a\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0015\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\t\u001a\u0004\b\u0016\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/profgen/cli/ProfileDumpCommand;", "Lkotlinx/cli/Subcommand;", "<init>", "()V", "binPath", "", "getBinPath", "()Ljava/lang/String;", "binPath$delegate", "Lkotlinx/cli/ArgumentValueDelegate;", "apkPath", "getApkPath", "apkPath$delegate", "obfPath", "getObfPath", "obfPath$delegate", "strictMode", "", "getStrictMode", "()Z", "strictMode$delegate", "outPath", "getOutPath", "outPath$delegate", "execute", "", "unnamed"})
@ExperimentalCli
@SourceDebugExtension(value={"SMAP\nBinCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BinCommand.kt\ncom/android/tools/profgen/cli/ProfileDumpCommand\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,171:1\n1#2:172\n*E\n"})
public final class ProfileDumpCommand
extends Subcommand {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final ArgumentValueDelegate binPath$delegate = OptionsKt.required((SingleNullableOption)ArgParser.option$default((ArgParser)((ArgParser)this), (ArgType)((ArgType)ArgType.String.INSTANCE), (String)"profile", (String)"p", (String)"File path to the binary profile", null, (int)16, null)).provideDelegate((Object)this, $$delegatedProperties[0]);
    @NotNull
    private final ArgumentValueDelegate apkPath$delegate = OptionsKt.required((SingleNullableOption)ArgParser.option$default((ArgParser)((ArgParser)this), (ArgType)((ArgType)ArgType.String.INSTANCE), (String)"apk", (String)"a", (String)"File path to apk", null, (int)16, null)).provideDelegate((Object)this, $$delegatedProperties[1]);
    @NotNull
    private final ArgumentValueDelegate obfPath$delegate = ArgParser.option$default((ArgParser)((ArgParser)this), (ArgType)((ArgType)ArgType.String.INSTANCE), (String)"map", (String)"m", (String)"File path to name obfuscation map", null, (int)16, null).provideDelegate((Object)this, $$delegatedProperties[2]);
    @NotNull
    private final ArgumentValueDelegate strictMode$delegate = OptionsKt.default((SingleNullableOption)ArgParser.option$default((ArgParser)((ArgParser)this), (ArgType)((ArgType)ArgType.Boolean.INSTANCE), (String)"strict", (String)"s", (String)"Strict mode", null, (int)16, null), (Object)true).provideDelegate((Object)this, $$delegatedProperties[3]);
    @NotNull
    private final ArgumentValueDelegate outPath$delegate = OptionsKt.required((SingleNullableOption)ArgParser.option$default((ArgParser)((ArgParser)this), (ArgType)((ArgType)ArgType.String.INSTANCE), (String)"output", (String)"o", (String)"File path for the HRF", null, (int)16, null)).provideDelegate((Object)this, $$delegatedProperties[4]);

    public ProfileDumpCommand() {
        super("dumpProfile", "Dump a binary profile to a HRF");
    }

    @NotNull
    public final String getBinPath() {
        return (String)this.binPath$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @NotNull
    public final String getApkPath() {
        return (String)this.apkPath$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    @Nullable
    public final String getObfPath() {
        return (String)this.obfPath$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    public final boolean getStrictMode() {
        return (Boolean)this.strictMode$delegate.getValue((Object)this, $$delegatedProperties[3]);
    }

    @NotNull
    public final String getOutPath() {
        return (String)this.outPath$delegate.getValue((Object)this, $$delegatedProperties[4]);
    }

    public void execute() {
        File obfFile;
        File file;
        Path path = Paths.get(this.getBinPath(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        File binFile = path.toFile();
        if (!binFile.exists()) {
            boolean $i$a$-require-ProfileDumpCommand$execute$52 = false;
            String $i$a$-require-ProfileDumpCommand$execute$52 = "File not found: " + this.getBinPath();
            throw new IllegalArgumentException($i$a$-require-ProfileDumpCommand$execute$52.toString());
        }
        Path path2 = Paths.get(this.getApkPath(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        File apkFile = path2.toFile();
        if (!apkFile.exists()) {
            boolean $i$a$-require-ProfileDumpCommand$execute$62 = false;
            String $i$a$-require-ProfileDumpCommand$execute$62 = "File not found: " + this.getApkPath();
            throw new IllegalArgumentException($i$a$-require-ProfileDumpCommand$execute$62.toString());
        }
        String string = this.getObfPath();
        if (string != null) {
            String it = string;
            boolean bl = false;
            Path path3 = Paths.get(it, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
            file = path3.toFile();
        } else {
            file = null;
        }
        File file2 = obfFile = file;
        if (!(!(file2 != null ? !file2.exists() : false))) {
            boolean $i$a$-require-ProfileDumpCommand$execute$72 = false;
            String $i$a$-require-ProfileDumpCommand$execute$72 = "File not found: " + this.getObfPath();
            throw new IllegalArgumentException($i$a$-require-ProfileDumpCommand$execute$72.toString());
        }
        Path path4 = Paths.get(this.getOutPath(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"get(...)");
        File outFile = path4.toFile();
        if (!outFile.getParentFile().exists()) {
            boolean $i$a$-require-ProfileDumpCommand$execute$82 = false;
            String $i$a$-require-ProfileDumpCommand$execute$82 = "Directory does not exist: " + outFile.getParent();
            throw new IllegalArgumentException($i$a$-require-ProfileDumpCommand$execute$82.toString());
        }
        Intrinsics.checkNotNull((Object)binFile);
        ArtProfile artProfile = ArtProfileKt.ArtProfile((File)binFile);
        Intrinsics.checkNotNull((Object)artProfile);
        ArtProfile profile = artProfile;
        Intrinsics.checkNotNull((Object)apkFile);
        Apk apk = DexDataKt.Apk$default((File)apkFile, null, (int)2, null);
        File file3 = obfFile;
        ObfuscationMap obf = file3 != null ? ObfuscationMapKt.ObfuscationMap((File)file3) : ObfuscationMap.Companion.getEmpty();
        Intrinsics.checkNotNull((Object)outFile);
        ProfileDumperKt.dumpProfile((File)outFile, (ArtProfile)profile, (Apk)apk, (ObfuscationMap)obf, (boolean)this.getStrictMode());
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ProfileDumpCommand.class, "binPath", "getBinPath()Ljava/lang/String;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ProfileDumpCommand.class, "apkPath", "getApkPath()Ljava/lang/String;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ProfileDumpCommand.class, "obfPath", "getObfPath()Ljava/lang/String;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ProfileDumpCommand.class, "strictMode", "getStrictMode()Z", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ProfileDumpCommand.class, "outPath", "getOutPath()Ljava/lang/String;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

