/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer.internal;

import com.android.tools.apk.analyzer.ArchiveContext;
import com.android.tools.apk.analyzer.ArchiveEntry;
import com.android.tools.apk.analyzer.ArchiveNode;
import com.android.tools.apk.analyzer.ArchiveTreeStructure;
import com.android.tools.apk.analyzer.PathUtils;
import com.android.tools.apk.analyzer.internal.ApkDiffEntry;
import com.android.tools.apk.analyzer.internal.ApkEntry;
import com.android.tools.apk.analyzer.internal.GzipSizeCalculator;
import java.io.IOException;
import java.nio.file.Files;
import java.util.HashSet;
import javax.swing.tree.DefaultMutableTreeNode;

public class ApkDiffParser {
    public static DefaultMutableTreeNode createTreeNode(ArchiveContext oldFile, ArchiveContext newFile) throws IOException {
        ArchiveNode oldRoot = ArchiveTreeStructure.create(oldFile);
        GzipSizeCalculator calculator = new GzipSizeCalculator();
        ArchiveTreeStructure.updateFileInfo(oldRoot, calculator);
        ArchiveNode newRoot = ArchiveTreeStructure.create(newFile);
        ArchiveTreeStructure.updateFileInfo(newRoot, calculator);
        return ApkDiffParser.createTreeNode(oldRoot, newRoot);
    }

    private static DefaultMutableTreeNode createTreeNode(ArchiveNode oldFile, ArchiveNode newFile) throws IOException {
        String name;
        if (oldFile == null && newFile == null) {
            throw new IllegalArgumentException("Both old and new files are null");
        }
        DefaultMutableTreeNode node = new DefaultMutableTreeNode();
        long oldSize = ApkDiffParser.getSize(oldFile);
        long newSize = ApkDiffParser.getSize(newFile);
        HashSet<String> childrenInOldFile = new HashSet<String>();
        ArchiveEntry data = oldFile == null ? newFile.getData() : oldFile.getData();
        String string = name = data.getPath().getFileName() != null ? PathUtils.fileNameWithTrailingSeparator(data.getPath()) : PathUtils.fileNameWithTrailingSeparator(data.getArchive().getPath());
        if (oldFile != null && !oldFile.getChildren().isEmpty()) {
            for (ArchiveNode oldChild : oldFile.getChildren()) {
                String fileName = oldChild.getData().getPath().getFileName().toString();
                ArchiveNode newChild = ApkDiffParser.findChildByFileName(newFile, fileName);
                childrenInOldFile.add(fileName);
                node.add(ApkDiffParser.createTreeNode(oldChild, newChild));
            }
        }
        if (newFile != null && !newFile.getChildren().isEmpty()) {
            for (ArchiveNode newChild : newFile.getChildren()) {
                if (childrenInOldFile.contains(newChild.getData().getPath().getFileName().toString())) continue;
                DefaultMutableTreeNode childNode = ApkDiffParser.createTreeNode(null, newChild);
                node.add(childNode);
            }
        }
        node.setUserObject(new ApkDiffEntry(name, oldFile, newFile, oldSize, newSize));
        ApkEntry.sort(node);
        return node;
    }

    private static long getSize(ArchiveNode node) throws IOException {
        if (node == null) {
            return 0L;
        }
        if (node.getParent() == null) {
            return Files.size(node.getData().getArchive().getPath());
        }
        return node.getData().getRawFileSize();
    }

    private static ArchiveNode findChildByFileName(ArchiveNode parent, String fileName) {
        if (parent == null) {
            return null;
        }
        for (ArchiveNode child : parent.getChildren()) {
            String name = child.getData().getPath().getFileName().toString();
            if (!name.equals(fileName)) continue;
            return child;
        }
        return null;
    }
}

