/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.detector.api.DefaultPosition;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.TextFormat;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u001a\"\u0010\u0007\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\n0\t\u001a\"\u0010\u0007\u001a\u0004\u0018\u00010\u0001*\u00020\u000b2\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\n0\t\u001a\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u0001*\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0010H\u0002\u001a\u0014\u0010\u0013\u001a\u00020\u0001*\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a(\u0010\u0014\u001a\u00020\u0010*\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0015\u001a\u00020\u00102\b\b\u0002\u0010\u0016\u001a\u00020\u0010H\u0002\u001a\u0014\u0010\u0017\u001a\u00020\u0010*\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0010H\u0002\u00a8\u0006\u0018"}, d2={"getPath", "", "Lcom/android/tools/lint/detector/api/Incident;", "client", "Lcom/android/tools/lint/LintCliClient;", "file", "Ljava/io/File;", "getErrorLines", "textProvider", "Lkotlin/Function1;", "", "Lcom/android/tools/lint/detector/api/Location;", "getPosition", "Lcom/android/tools/lint/detector/api/Position;", "source", "offset", "", "getLine", "line", "getLineOfOffset", "getLineNumber", "startOffset", "startLineNumber", "getLineOffset", "lint-cli"})
public final class ReporterKt {
    @NotNull
    public static final String getPath(@NotNull Incident $this$getPath, @NotNull LintCliClient client, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)$this$getPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return $this$getPath.getProject() != null ? client.getDisplayPath($this$getPath.getProject(), file, client.getFlags().isFullPath()) : client.getDisplayPath(file, null, TextFormat.TEXT);
    }

    public static /* synthetic */ String getPath$default(Incident incident, LintCliClient lintCliClient, File file, int n, Object object) {
        if ((n & 2) != 0) {
            file = incident.getFile();
        }
        return ReporterKt.getPath(incident, lintCliClient, file);
    }

    @Nullable
    public static final String getErrorLines(@NotNull Incident $this$getErrorLines, @NotNull Function1<? super File, ? extends CharSequence> textProvider) {
        Intrinsics.checkNotNullParameter((Object)$this$getErrorLines, (String)"<this>");
        Intrinsics.checkNotNullParameter(textProvider, (String)"textProvider");
        return ReporterKt.getErrorLines($this$getErrorLines.getLocation(), textProvider);
    }

    @Nullable
    public static final String getErrorLines(@NotNull Location $this$getErrorLines, @NotNull Function1<? super File, ? extends CharSequence> textProvider) {
        CharSequence source;
        Intrinsics.checkNotNullParameter((Object)$this$getErrorLines, (String)"<this>");
        Intrinsics.checkNotNullParameter(textProvider, (String)"textProvider");
        Location location = $this$getErrorLines;
        Position startPosition = location.getStart();
        if (startPosition != null && startPosition.getLine() >= 0) {
            CharSequence source2 = (CharSequence)textProvider.invoke((Object)$this$getErrorLines.getFile());
            if (source2 != null) {
                Position endPosition = location.getEnd();
                int line2 = startPosition.getLine();
                String errorLine = ReporterKt.getLine(source2, line2);
                if (errorLine != null) {
                    errorLine = StringsKt.replace$default((String)errorLine, (char)'\t', (char)' ', (boolean)false, (int)4, null);
                    int column = startPosition.getColumn();
                    if (column < 0) {
                        column = 0;
                        int i = 0;
                        while (i < errorLine.length() && Character.isWhitespace(errorLine.charAt(i))) {
                            ++i;
                            ++column;
                        }
                    }
                    StringBuilder sb = new StringBuilder(100);
                    sb.append(errorLine);
                    sb.append('\n');
                    int n = column;
                    for (int i = 0; i < n; ++i) {
                        sb.append(' ');
                    }
                    boolean displayCaret = true;
                    if (endPosition != null) {
                        int endLine = endPosition.getLine();
                        int endColumn = endPosition.getColumn();
                        if (endLine == line2 && endColumn > column) {
                            for (int i = column; i < endColumn; ++i) {
                                sb.append('~');
                            }
                            displayCaret = false;
                        }
                    }
                    if (displayCaret) {
                        sb.append('^');
                    }
                    sb.append('\n');
                    return sb.toString();
                }
            }
        } else if (startPosition != null && startPosition.getOffset() >= 0 && startPosition.getLine() == -1 && (source = (CharSequence)textProvider.invoke((Object)$this$getErrorLines.getFile())) != null) {
            Position start = ReporterKt.getPosition(source, startPosition.getOffset());
            Position position = location.getEnd();
            Position end = ReporterKt.getPosition(source, position != null ? position.getOffset() : startPosition.getOffset());
            Location locationWithLineNumbers = Location.Companion.create($this$getErrorLines.getFile(), start, end);
            return ReporterKt.getErrorLines(locationWithLineNumbers, textProvider);
        }
        return null;
    }

    private static final Position getPosition(CharSequence source, int offset) {
        int line2 = ReporterKt.getLineNumber$default(source, offset, 0, 0, 2, null);
        int lineStart = StringsKt.lastIndexOf$default((CharSequence)source, (char)'\n', (int)offset, (boolean)false, (int)4, null) + 1;
        int column = offset - lineStart;
        return (Position)new DefaultPosition(line2, column, offset);
    }

    private static final String getLine(CharSequence $this$getLine, int line2) {
        int index = ReporterKt.getLineOffset($this$getLine, line2);
        return index != -1 ? ReporterKt.getLineOfOffset($this$getLine, index) : null;
    }

    private static final String getLineOfOffset(CharSequence $this$getLineOfOffset, int offset) {
        int end = StringsKt.indexOf$default((CharSequence)$this$getLineOfOffset, (char)'\n', (int)offset, (boolean)false, (int)4, null);
        if (end == -1) {
            end = StringsKt.indexOf$default((CharSequence)$this$getLineOfOffset, (char)'\r', (int)offset, (boolean)false, (int)4, null);
        } else if (end > 0 && $this$getLineOfOffset.charAt(end - 1) == '\r') {
            --end;
        }
        return ((Object)$this$getLineOfOffset.subSequence(offset, end != -1 ? end : $this$getLineOfOffset.length())).toString();
    }

    private static final int getLineNumber(CharSequence $this$getLineNumber, int offset, int startOffset, int startLineNumber) {
        int lineNumber = startLineNumber;
        int n = Math.min(offset, $this$getLineNumber.length());
        for (int i = startOffset; i < n; ++i) {
            if ($this$getLineNumber.charAt(i) != '\n') continue;
            ++lineNumber;
        }
        return lineNumber;
    }

    static /* synthetic */ int getLineNumber$default(CharSequence charSequence, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n2 = 0;
        }
        if ((n4 & 4) != 0) {
            n3 = 1;
        }
        return ReporterKt.getLineNumber(charSequence, n, n2, n3);
    }

    private static final int getLineOffset(CharSequence $this$getLineOffset, int line2) {
        int index = 0;
        for (int i = 0; i < line2; ++i) {
            if ((index = StringsKt.indexOf$default((CharSequence)$this$getLineOffset, (char)'\n', (int)index, (boolean)false, (int)4, null)) == -1) {
                return -1;
            }
            ++index;
        }
        return index;
    }
}

