/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison.iterables;

import com.intellij.diff.comparison.iterables.ChangeDiffIterableBase;
import com.intellij.diff.util.Range;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class SubiterableDiffIterable
extends ChangeDiffIterableBase {
    @NotNull
    private final List<Range> myChanged;
    private final int myStart1;
    private final int myStart2;
    private final int myEnd1;
    private final int myEnd2;
    private final int myFirstIndex;

    public SubiterableDiffIterable(@NotNull List<Range> changed, int start1, int end1, int start2, int end2, int firstIndex) {
        if (changed == null) {
            SubiterableDiffIterable.$$$reportNull$$$0(0);
        }
        super(end1 - start1, end2 - start2);
        this.myChanged = changed;
        this.myStart1 = start1;
        this.myStart2 = start2;
        this.myEnd1 = end1;
        this.myEnd2 = end2;
        this.myFirstIndex = firstIndex;
    }

    @Override
    @NotNull
    protected ChangeDiffIterableBase.ChangeIterable createChangeIterable() {
        return new SubiterableChangeIterable(this.myChanged, this.myStart1, this.myEnd1, this.myStart2, this.myEnd2, this.myFirstIndex);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changed", "com/intellij/diff/comparison/iterables/SubiterableDiffIterable", "<init>"));
    }

    private static class SubiterableChangeIterable
    implements ChangeDiffIterableBase.ChangeIterable {
        private final List<Range> myChanged;
        private final int myStart1;
        private final int myEnd1;
        private final int myStart2;
        private final int myEnd2;
        private int myIndex;
        private Range myLast;

        SubiterableChangeIterable(@NotNull List<Range> changed, int start1, int end1, int start2, int end2, int firstIndex) {
            if (changed == null) {
                SubiterableChangeIterable.$$$reportNull$$$0(0);
            }
            this.myChanged = changed;
            this.myStart1 = start1;
            this.myEnd1 = end1;
            this.myStart2 = start2;
            this.myEnd2 = end2;
            this.myIndex = firstIndex;
            this.next();
        }

        @Override
        public boolean valid() {
            return this.myLast != null;
        }

        @Override
        public void next() {
            this.myLast = null;
            while (this.myIndex < this.myChanged.size()) {
                Range range = this.myChanged.get(this.myIndex);
                ++this.myIndex;
                if (range.end1 < this.myStart1 || range.end2 < this.myStart2) continue;
                if (range.start1 > this.myEnd1 || range.start2 > this.myEnd2) break;
                Range newRange = new Range(Math.max(this.myStart1, range.start1) - this.myStart1, Math.min(this.myEnd1, range.end1) - this.myStart1, Math.max(this.myStart2, range.start2) - this.myStart2, Math.min(this.myEnd2, range.end2) - this.myStart2);
                if (newRange.isEmpty()) continue;
                this.myLast = newRange;
                break;
            }
        }

        @Override
        public int getStart1() {
            return this.myLast.start1;
        }

        @Override
        public int getStart2() {
            return this.myLast.start2;
        }

        @Override
        public int getEnd1() {
            return this.myLast.end1;
        }

        @Override
        public int getEnd2() {
            return this.myLast.end2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changed", "com/intellij/diff/comparison/iterables/SubiterableDiffIterable$SubiterableChangeIterable", "<init>"));
        }
    }
}

