/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.DataLoader;
import com.intellij.ide.plugins.PathResolver;
import com.intellij.ide.plugins.PluginXmlPathResolver;
import com.intellij.ide.plugins.ProductLoadingStrategy;
import com.intellij.ide.plugins.RawPluginDescriptor;
import com.intellij.ide.plugins.ReadModuleContext;
import com.intellij.ide.plugins.XmlReader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.lang.UrlClassLoader;
import com.intellij.util.xml.dom.StaxFactory;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.codehaus.stax2.XMLStreamReader2;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J2\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J*\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00122\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J,\u0010\u0016\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00122\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\"\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ide/plugins/ClassPathXmlPathResolver;", "Lcom/intellij/ide/plugins/PathResolver;", "classLoader", "Ljava/lang/ClassLoader;", "isRunningFromSources", "", "<init>", "(Ljava/lang/ClassLoader;Z)V", "isFlat", "()Z", "loadXIncludeReference", "readInto", "Lcom/intellij/ide/plugins/RawPluginDescriptor;", "readContext", "Lcom/intellij/ide/plugins/ReadModuleContext;", "dataLoader", "Lcom/intellij/ide/plugins/DataLoader;", "base", "", "relativePath", "resolveModuleFile", "path", "resolvePath", "getXmlReader", "Lorg/codehaus/stax2/XMLStreamReader2;", "intellij.platform.core.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nClassPathXmlPathResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassPathXmlPathResolver.kt\ncom/intellij/ide/plugins/ClassPathXmlPathResolver\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,111:1\n14#2:112\n61#2,5:113\n1#3:118\n*S KotlinDebug\n*F\n+ 1 ClassPathXmlPathResolver.kt\ncom/intellij/ide/plugins/ClassPathXmlPathResolver\n*L\n60#1:112\n71#1:113,5\n*E\n"})
public final class ClassPathXmlPathResolver
implements PathResolver {
    @NotNull
    private final ClassLoader classLoader;
    @JvmField
    public final boolean isRunningFromSources;

    public ClassPathXmlPathResolver(@NotNull ClassLoader classLoader, boolean isRunningFromSources) {
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        this.classLoader = classLoader;
        this.isRunningFromSources = isRunningFromSources;
    }

    @Override
    public boolean isFlat() {
        return true;
    }

    @Override
    public boolean loadXIncludeReference(@NotNull RawPluginDescriptor readInto, @NotNull ReadModuleContext readContext, @NotNull DataLoader dataLoader2, @Nullable String base, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)readInto, (String)"readInto");
        Intrinsics.checkNotNullParameter((Object)readContext, (String)"readContext");
        Intrinsics.checkNotNullParameter((Object)dataLoader2, (String)"dataLoader");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        String path = PluginXmlPathResolver.Companion.toLoadPath(relativePath, base);
        XMLStreamReader2 reader = null;
        if (this.classLoader instanceof UrlClassLoader) {
            byte[] byArray = ((UrlClassLoader)this.classLoader).getResourceAsBytes(path, true);
            if (byArray == null) {
                return false;
            }
            reader = StaxFactory.createNonCoalescingXmlStreamReader(byArray, dataLoader2.toString());
        } else {
            InputStream inputStream = this.classLoader.getResourceAsStream(path);
            if (inputStream == null) {
                return false;
            }
            reader = StaxFactory.createNonCoalescingXmlStreamReader(inputStream, dataLoader2.toString());
        }
        String string = PluginXmlPathResolver.Companion.getChildBase$intellij_platform_core_impl(base, relativePath);
        XmlReader.readModuleDescriptor(reader, readContext, dataLoader2, this, string, readInto);
        return true;
    }

    @Override
    @NotNull
    public RawPluginDescriptor resolveModuleFile(@NotNull ReadModuleContext readContext, @NotNull DataLoader dataLoader2, @NotNull String path, @Nullable RawPluginDescriptor readInto) {
        Intrinsics.checkNotNullParameter((Object)readContext, (String)"readContext");
        Intrinsics.checkNotNullParameter((Object)dataLoader2, (String)"dataLoader");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        byte[] resource = null;
        if (this.classLoader instanceof UrlClassLoader) {
            resource = ((UrlClassLoader)this.classLoader).getResourceAsBytes(path, true);
        } else {
            InputStream inputStream = this.classLoader.getResourceAsStream(path);
            if (inputStream != null) {
                InputStream it = inputStream;
                boolean bl = false;
                return XmlReader.readModuleDescriptor(it, readContext, (PathResolver)this, dataLoader2, null, readInto, dataLoader2.toString());
            }
            resource = null;
        }
        if (resource == null) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(ClassPathXmlPathResolver.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            Logger log = logger;
            String moduleName = StringsKt.removeSuffix((String)path, (CharSequence)".xml");
            if (this.isRunningFromSources && StringsKt.startsWith$default((String)path, (String)"intellij.", (boolean)false, (int)2, null) && dataLoader2.getEmptyDescriptorIfCannotResolve()) {
                log.trace("Cannot resolve " + path + " (dataLoader=" + dataLoader2 + ", classLoader=" + this.classLoader + "). ");
                RawPluginDescriptor descriptor2 = new RawPluginDescriptor();
                descriptor2.package = "unresolved." + moduleName;
                return descriptor2;
            }
            if (ProductLoadingStrategy.Companion.getStrategy().isOptionalProductModule(moduleName)) {
                RawPluginDescriptor rawPluginDescriptor;
                Logger $this$debug_u24default$iv = log;
                Throwable e$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    Logger logger2 = $this$debug_u24default$iv;
                    boolean bl = false;
                    logger2.debug("Skip module '" + path + "' since its descriptor cannot be found and it's optional", e$iv);
                }
                RawPluginDescriptor $this$resolveModuleFile_u24lambda_u242 = rawPluginDescriptor = new RawPluginDescriptor();
                boolean bl = false;
                $this$resolveModuleFile_u24lambda_u242.package = "unresolved." + moduleName;
                return rawPluginDescriptor;
            }
            throw new RuntimeException("Cannot resolve " + path + " (dataLoader=" + dataLoader2 + ", classLoader=" + this.classLoader + ')');
        }
        return XmlReader.readModuleDescriptor(resource, readContext, (PathResolver)this, dataLoader2, null, readInto, dataLoader2.toString());
    }

    @Override
    @Nullable
    public RawPluginDescriptor resolvePath(@NotNull ReadModuleContext readContext, @NotNull DataLoader dataLoader2, @NotNull String relativePath, @Nullable RawPluginDescriptor readInto) {
        Intrinsics.checkNotNullParameter((Object)readContext, (String)"readContext");
        Intrinsics.checkNotNullParameter((Object)dataLoader2, (String)"dataLoader");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        String path = PluginXmlPathResolver.Companion.toLoadPath$default(PluginXmlPathResolver.Companion, relativePath, null, 2, null);
        XMLStreamReader2 xMLStreamReader2 = this.getXmlReader(this.classLoader, path, dataLoader2);
        if (xMLStreamReader2 == null) {
            return null;
        }
        return XmlReader.readModuleDescriptor(xMLStreamReader2, readContext, dataLoader2, this, null, readInto);
    }

    private final XMLStreamReader2 getXmlReader(ClassLoader classLoader, String path, DataLoader dataLoader2) {
        if (classLoader instanceof UrlClassLoader) {
            byte[] byArray = ((UrlClassLoader)classLoader).getResourceAsBytes(path, true);
            if (byArray == null) {
                return null;
            }
            return StaxFactory.createNonCoalescingXmlStreamReader(byArray, dataLoader2.toString());
        }
        InputStream inputStream = classLoader.getResourceAsStream(path);
        if (inputStream == null) {
            return null;
        }
        return StaxFactory.createNonCoalescingXmlStreamReader(inputStream, dataLoader2.toString());
    }
}

