/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.ModuleDependenciesDescriptor;
import com.intellij.ide.plugins.PluginDependency;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.XmlReader;
import com.intellij.openapi.extensions.ExtensionDescriptor;
import com.intellij.util.xml.dom.XmlElement;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\b\u0010\u000b\u001a\u00020\u0004H\u0000\u001a\b\u0010\f\u001a\u00020\u0004H\u0007\u001a\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u001a\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u001a\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0011\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0012\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0013\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"pluginIdsToIgnoreK2KotlinCompatibility", "", "", "pluginCanWorkInK2Mode", "", "plugin", "Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "pluginCanWorkInK1Mode", "getSupportKotlinPluginModeEPs", "", "Lcom/intellij/openapi/extensions/ExtensionDescriptor;", "isKotlinPluginK2Mode", "isKotlinPluginK1Mode", "isIncompatibleWithKotlinPlugin", "isPluginWhichDependsOnKotlinPluginAndItsIncompatibleWithIt", "isPluginWhichDependsOnKotlinPluginInK2ModeAndItDoesNotSupportK2Mode", "nonOptionallyDependsOnKotlinPlugin", "SUPPORTS_KOTLIN_PLUGIN_MODE_EP_NAME", "SUPPORTS_K1_ATTRIBUTE_NAME", "SUPPORTS_K2_ATTRIBUTE_NAME", "intellij.platform.core.impl"})
@SourceDebugExtension(value={"SMAP\nkotlinK2ModeCompatibilityChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 kotlinK2ModeCompatibilityChecker.kt\ncom/intellij/ide/plugins/KotlinK2ModeCompatibilityCheckerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,108:1\n1755#2,3:109\n1755#2,3:112\n1755#2,3:115\n1755#2,3:118\n1755#2,3:121\n1628#2,3:124\n1557#2:128\n1628#2,3:129\n865#2,2:132\n1#3:127\n*S KotlinDebug\n*F\n+ 1 kotlinK2ModeCompatibilityChecker.kt\ncom/intellij/ide/plugins/KotlinK2ModeCompatibilityCheckerKt\n*L\n33#1:109,3\n36#1:112,3\n49#1:115,3\n100#1:118,3\n101#1:121,3\n9#1:124,3\n16#1:128\n16#1:129,3\n17#1:132,2\n*E\n"})
public final class KotlinK2ModeCompatibilityCheckerKt {
    @NotNull
    private static final Set<String> pluginIdsToIgnoreK2KotlinCompatibility;
    @NotNull
    private static final String SUPPORTS_KOTLIN_PLUGIN_MODE_EP_NAME = "org.jetbrains.kotlin.supportsKotlinPluginMode";
    @NotNull
    private static final String SUPPORTS_K1_ATTRIBUTE_NAME = "supportsK1";
    @NotNull
    private static final String SUPPORTS_K2_ATTRIBUTE_NAME = "supportsK2";

    public static final boolean pluginCanWorkInK2Mode(@NotNull IdeaPluginDescriptorImpl plugin) {
        boolean bl;
        block13: {
            ExtensionDescriptor it;
            boolean bl2;
            boolean $i$f$any;
            Iterable $this$any$iv;
            List<ExtensionDescriptor> supportKotlinPluginModeEPs;
            block12: {
                Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
                supportKotlinPluginModeEPs = KotlinK2ModeCompatibilityCheckerKt.getSupportKotlinPluginModeEPs(plugin);
                $this$any$iv = supportKotlinPluginModeEPs;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (ExtensionDescriptor)element$iv;
                        boolean bl3 = false;
                        XmlElement xmlElement = it.element;
                        Map map2 = xmlElement != null ? xmlElement.attributes : null;
                        if (map2 == null) {
                            map2 = MapsKt.emptyMap();
                        }
                        if (!Intrinsics.areEqual(map2.get(SUPPORTS_K2_ATTRIBUTE_NAME), (Object)"false")) continue;
                        bl2 = true;
                        break block12;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                bl = false;
            } else if (pluginIdsToIgnoreK2KotlinCompatibility.contains(plugin.getPluginId().getIdString())) {
                bl = true;
            } else {
                $this$any$iv = supportKotlinPluginModeEPs;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (ExtensionDescriptor)element$iv;
                        boolean bl4 = false;
                        XmlElement xmlElement = it.element;
                        Map map3 = xmlElement != null ? xmlElement.attributes : null;
                        if (map3 == null) {
                            map3 = MapsKt.emptyMap();
                        }
                        if (!Intrinsics.areEqual(map3.get(SUPPORTS_K2_ATTRIBUTE_NAME), (Object)"true")) continue;
                        bl = true;
                        break block13;
                    }
                    bl = false;
                }
            }
        }
        return bl;
    }

    public static final boolean pluginCanWorkInK1Mode(@NotNull IdeaPluginDescriptorImpl plugin) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
            List<ExtensionDescriptor> supportKotlinPluginModeEPs = KotlinK2ModeCompatibilityCheckerKt.getSupportKotlinPluginModeEPs(plugin);
            Iterable $this$any$iv = supportKotlinPluginModeEPs;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ExtensionDescriptor it = (ExtensionDescriptor)element$iv;
                    boolean bl2 = false;
                    XmlElement xmlElement = it.element;
                    Map map2 = xmlElement != null ? xmlElement.attributes : null;
                    if (map2 == null) {
                        map2 = MapsKt.emptyMap();
                    }
                    if (!Intrinsics.areEqual(map2.get(SUPPORTS_K1_ATTRIBUTE_NAME), (Object)"false")) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return !bl;
    }

    private static final List<ExtensionDescriptor> getSupportKotlinPluginModeEPs(IdeaPluginDescriptorImpl plugin) {
        List list = plugin.epNameToExtensions.get(SUPPORTS_KOTLIN_PLUGIN_MODE_EP_NAME);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public static final boolean isKotlinPluginK2Mode() {
        return Boolean.parseBoolean(System.getProperty("idea.kotlin.plugin.use.k2", "false"));
    }

    @ApiStatus.Internal
    public static final boolean isKotlinPluginK1Mode() {
        return !KotlinK2ModeCompatibilityCheckerKt.isKotlinPluginK2Mode();
    }

    public static final boolean isIncompatibleWithKotlinPlugin(@NotNull IdeaPluginDescriptorImpl plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        if (KotlinK2ModeCompatibilityCheckerKt.isKotlinPluginK1Mode() && !KotlinK2ModeCompatibilityCheckerKt.pluginCanWorkInK1Mode(plugin)) {
            return true;
        }
        return KotlinK2ModeCompatibilityCheckerKt.isKotlinPluginK2Mode() && !KotlinK2ModeCompatibilityCheckerKt.pluginCanWorkInK2Mode(plugin);
    }

    @ApiStatus.Internal
    public static final boolean isPluginWhichDependsOnKotlinPluginAndItsIncompatibleWithIt(@NotNull IdeaPluginDescriptorImpl plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        if (XmlReader.isKotlinPlugin(plugin.getPluginId())) {
            return false;
        }
        if (!KotlinK2ModeCompatibilityCheckerKt.nonOptionallyDependsOnKotlinPlugin(plugin)) {
            return false;
        }
        return KotlinK2ModeCompatibilityCheckerKt.isIncompatibleWithKotlinPlugin(plugin);
    }

    @ApiStatus.Internal
    public static final boolean isPluginWhichDependsOnKotlinPluginInK2ModeAndItDoesNotSupportK2Mode(@NotNull IdeaPluginDescriptorImpl plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        if (XmlReader.isKotlinPlugin(plugin.getPluginId())) {
            return false;
        }
        if (!KotlinK2ModeCompatibilityCheckerKt.nonOptionallyDependsOnKotlinPlugin(plugin)) {
            return false;
        }
        return !KotlinK2ModeCompatibilityCheckerKt.pluginCanWorkInK2Mode(plugin);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean nonOptionallyDependsOnKotlinPlugin(IdeaPluginDescriptorImpl plugin) {
        Object it;
        boolean bl;
        Iterable $this$any$iv = plugin.pluginDependencies;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                it = (PluginDependency)element$iv;
                boolean bl2 = false;
                if (XmlReader.isKotlinPlugin(((PluginDependency)it).getPluginId()) && !((PluginDependency)it).isOptional()) {
                    return true;
                }
                boolean bl3 = false;
                if (!bl3) continue;
                return true;
            }
            bl = false;
        }
        if (bl) return true;
        $this$any$iv = plugin.dependencies.plugins;
        $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            Object element$iv;
            if (!iterator2.hasNext()) return false;
            element$iv = iterator2.next();
            it = (ModuleDependenciesDescriptor.PluginReference)element$iv;
            boolean bl4 = false;
        } while (!XmlReader.isKotlinPlugin(((ModuleDependenciesDescriptor.PluginReference)it).id));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    static {
        Set set;
        block11: {
            Collection collection;
            Object object;
            Set $this$pluginIdsToIgnoreK2KotlinCompatibility_u24lambda_u244 = set = SetsKt.createSetBuilder();
            boolean bl = false;
            Object object2 = System.getProperty("idea.kotlin.plugin.plugin.ids.to.ignore.k2.compatibility");
            if (object2 != null && (object2 = StringsKt.split$default((CharSequence)((CharSequence)object2), (char[])(object = new char[]{','}), (boolean)false, (int)0, (int)6, null)) != null) {
                Iterable $this$mapTo$iv = (Iterable)object2;
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    void it;
                    String string = (String)item$iv;
                    collection = $this$pluginIdsToIgnoreK2KotlinCompatibility_u24lambda_u244;
                    boolean bl2 = false;
                    collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
                }
                Set cfr_ignored_0 = (Set)((Collection)$this$pluginIdsToIgnoreK2KotlinCompatibility_u24lambda_u244);
            }
            Object object3 = new String[]{"fleet.backend.kotlin", "fleet.backend.mercury", "fleet.backend.mercury.kotlin.macos"};
            $this$pluginIdsToIgnoreK2KotlinCompatibility_u24lambda_u244.addAll(CollectionsKt.listOf((Object[])object3));
            try {
                InputStream inputStream;
                object3 = $this$pluginIdsToIgnoreK2KotlinCompatibility_u24lambda_u244.getClass().getResource("/pluginsCompatibleWithK2Mode.txt");
                if (object3 == null || (inputStream = ((URL)object3).openStream()) == null) break block11;
                Closeable closeable = inputStream;
                Object object4 = null;
                try {
                    Object it2 = (InputStream)closeable;
                    boolean bl3 = false;
                    InputStream bl2 = it2;
                    Charset charset = Charsets.UTF_8;
                    it2 = TextStreamsKt.readLines((Reader)new InputStreamReader(bl2, charset));
                }
                catch (Throwable it2) {
                    try {
                        object4 = it2;
                        throw it2;
                    }
                    catch (Throwable it2) {
                        CloseableKt.closeFinally((Closeable)closeable, object4);
                        throw it2;
                    }
                }
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object4);
                object = it2;
                if (object != null) {
                    void $this$filterTo$iv;
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv;
                    object4 = (Iterable)object;
                    boolean $i$f$map = false;
                    void bl3 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        String string = (String)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl4 = false;
                        collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    boolean $i$f$filterTo = false;
                    for (Object element$iv : $this$filterTo$iv) {
                        String it = (String)element$iv;
                        boolean bl5 = false;
                        boolean bl6 = ((CharSequence)it).length() > 0;
                        if (!bl6) continue;
                        ((Collection)$this$pluginIdsToIgnoreK2KotlinCompatibility_u24lambda_u244).add(element$iv);
                    }
                    Set cfr_ignored_1 = (Set)((Collection)$this$pluginIdsToIgnoreK2KotlinCompatibility_u24lambda_u244);
                }
            }
            catch (IOException e) {
                PluginManagerCore.getLogger().error("Cannot load pluginsCompatibleWithK2Mode.txt", e);
            }
        }
        pluginIdsToIgnoreK2KotlinCompatibility = SetsKt.build((Set)set);
    }
}

