/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.registry;

import com.intellij.diagnostic.LoadingState;
import com.intellij.openapi.util.registry.RegistryKeyDescriptor;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import java.awt.Color;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.future.FutureKt;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0005\u0018\u0000 +2\u00020\u0001:\u0001+B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u001a\u001a\u00020\t2\u000b\u0010\u001b\u001a\u00070\u0006\u00a2\u0006\u0002\b\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0007J\u001a\u0010\u001f\u001a\t\u0018\u00010\u0006\u00a2\u0006\u0002\b 2\u000b\u0010\u001b\u001a\u00070\u0006\u00a2\u0006\u0002\b\u001cJ)\u0010!\u001a\u00070\u0006\u00a2\u0006\u0002\b 2\u000b\u0010\u001b\u001a\u00070\u0006\u00a2\u0006\u0002\b\u001c2\b\u0010\"\u001a\u0004\u0018\u00010\fH\u0000\u00a2\u0006\u0002\b#J\b\u0010$\u001a\u00020%H\u0007J\u0014\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060'H\u0007J\b\u0010(\u001a\u00020\u001eH\u0007R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010)\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0010R\u0011\u0010*\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u0010\u00a8\u0006,"}, d2={"Lcom/intellij/openapi/util/registry/Registry;", "", "<init>", "()V", "userProperties", "Ljava/util/LinkedHashMap;", "", "values", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/openapi/util/registry/RegistryValue;", "contributedKeys", "", "Lcom/intellij/openapi/util/registry/RegistryKeyDescriptor;", "value", "", "isLoaded", "()Z", "loadFuture", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "Lcom/intellij/openapi/util/registry/RegistryValueListener;", "valueChangeListener", "getValueChangeListener", "()Lcom/intellij/openapi/util/registry/RegistryValueListener;", "valueProducer", "Ljava/util/function/Function;", "resolveValue", "key", "Lorg/jetbrains/annotations/NonNls;", "reset", "", "getBundleValueOrNull", "Lcom/intellij/openapi/util/NlsSafe;", "getBundleValue", "keyDescriptor", "getBundleValue$intellij_platform_util", "getState", "Lorg/jdom/Element;", "getUserProperties", "", "restoreDefaults", "isInDefaultState", "isRestartNeeded", "Companion", "intellij.platform.util"})
public final class Registry {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LinkedHashMap<String, String> userProperties = new LinkedHashMap();
    @NotNull
    private final ConcurrentHashMap<String, RegistryValue> values = new ConcurrentHashMap();
    @NotNull
    private Map<String, RegistryKeyDescriptor> contributedKeys = MapsKt.emptyMap();
    private volatile boolean isLoaded;
    @NotNull
    private volatile CompletableFuture<Void> loadFuture = new CompletableFuture();
    @NotNull
    private volatile RegistryValueListener valueChangeListener = EMPTY_VALUE_LISTENER;
    @NotNull
    private final Function<String, RegistryValue> valueProducer = arg_0 -> Registry.valueProducer$lambda$0(this, arg_0);
    @Nullable
    private static Reference<Map<String, String>> bundledRegistry;
    @NotNull
    public static final String REGISTRY_BUNDLE = "misc.registry";
    @NotNull
    private static final RegistryValueListener EMPTY_VALUE_LISTENER;
    @NotNull
    private static final Registry registry;

    public final boolean isLoaded() {
        return this.isLoaded;
    }

    @NotNull
    public final RegistryValueListener getValueChangeListener() {
        return this.valueChangeListener;
    }

    private final RegistryValue resolveValue(String key) {
        RegistryValue registryValue = this.values.computeIfAbsent(key, this.valueProducer);
        Intrinsics.checkNotNullExpressionValue((Object)registryValue, (String)"computeIfAbsent(...)");
        return registryValue;
    }

    @TestOnly
    public final void reset() {
        this.userProperties.clear();
        this.values.clear();
        this.isLoaded = false;
        this.loadFuture.cancel(false);
        this.loadFuture = new CompletableFuture();
    }

    @Nullable
    public final String getBundleValueOrNull(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object object = this.contributedKeys.get(key);
        if (object == null || (object = ((RegistryKeyDescriptor)object).getDefaultValue()) == null) {
            Map map2 = Registry.Companion.loadFromBundledConfig();
            object = map2 != null ? (String)map2.get(key) : null;
        }
        return object;
    }

    @NotNull
    public final String getBundleValue$intellij_platform_util(@NotNull String key, @Nullable RegistryKeyDescriptor keyDescriptor) throws MissingResourceException {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object object = keyDescriptor;
        if (object == null || (object = ((RegistryKeyDescriptor)object).getDefaultValue()) == null) {
            RegistryKeyDescriptor registryKeyDescriptor = this.contributedKeys.get(key);
            object = registryKeyDescriptor != null ? registryKeyDescriptor.getDefaultValue() : null;
            if (object == null) {
                Map map2 = Registry.Companion.loadFromBundledConfig();
                object = map2 != null ? (String)map2.get(key) : null;
                if (object == null) {
                    throw new MissingResourceException("Registry key " + key + " is not defined", REGISTRY_BUNDLE, key);
                }
            }
        }
        return object;
    }

    @ApiStatus.Internal
    @NotNull
    public final Element getState() {
        Element state = new Element("registry");
        for (Map.Entry entry : ((Map)this.userProperties).entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            RegistryValue registryValue = registry.resolveValue(key);
            if (!registryValue.isChangedFromDefault()) continue;
            Element entryElement = new Element("entry");
            entryElement.setAttribute("key", key);
            entryElement.setAttribute("value", value);
            state.addContent(entryElement);
        }
        return state;
    }

    @ApiStatus.Internal
    @NotNull
    public final Map<String, String> getUserProperties() {
        return this.userProperties;
    }

    @ApiStatus.Internal
    public final void restoreDefaults() {
        LinkedHashMap old = new LinkedHashMap(this.userProperties);
        Registry registry = Companion.getInstance();
        for (String key : old.keySet()) {
            Intrinsics.checkNotNull((Object)key);
            String v = registry.getBundleValueOrNull(key);
            if (v == null) {
                this.values.remove(key);
                continue;
            }
            RegistryValue registryValue = registry.values.get(key);
            if (registryValue == null) continue;
            registryValue.setValue(v);
        }
    }

    public final boolean isInDefaultState() {
        return this.userProperties.isEmpty();
    }

    public final boolean isRestartNeeded() {
        return Registry.Companion.isRestartNeeded(this.userProperties);
    }

    private static final RegistryValue valueProducer$lambda$0(Registry this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new RegistryValue(this$0, it, this$0.contributedKeys.get(it));
    }

    @JvmStatic
    @NotNull
    public static final RegistryValue get(@NotNull String key) {
        return Companion.get(key);
    }

    @JvmStatic
    @ApiStatus.Internal
    @NotNull
    public static final RegistryValue _getWithoutStateCheck(@NotNull String key) {
        return Companion._getWithoutStateCheck(key);
    }

    @JvmStatic
    public static final boolean is(@NotNull String key) throws MissingResourceException {
        return Companion.is(key);
    }

    @JvmStatic
    public static final boolean is(@NotNull String key, boolean defaultValue) {
        return Companion.is(key, defaultValue);
    }

    @JvmStatic
    public static final int intValue(@NotNull String key) throws MissingResourceException {
        return Companion.intValue(key);
    }

    @JvmStatic
    public static final int intValue(@NotNull String key, int defaultValue) {
        return Companion.intValue(key, defaultValue);
    }

    @JvmStatic
    public static final double doubleValue(@NotNull String key, double defaultValue) {
        return Companion.doubleValue(key, defaultValue);
    }

    @JvmStatic
    public static final double doubleValue(@NotNull String key) throws MissingResourceException {
        return Companion.doubleValue(key);
    }

    @JvmStatic
    @NotNull
    public static final String stringValue(@NotNull String key) throws MissingResourceException {
        return Companion.stringValue(key);
    }

    @JvmStatic
    @Nullable
    public static final Color getColor(@NotNull String key, @Nullable Color defaultValue) throws MissingResourceException {
        return Companion.getColor(key, defaultValue);
    }

    @JvmStatic
    @NotNull
    public static final Registry getInstance() {
        return Companion.getInstance();
    }

    @JvmStatic
    public static final int intValue(@NotNull String key, int defaultValue, int minValue, int maxValue) {
        return Companion.intValue(key, defaultValue, minValue, maxValue);
    }

    @JvmStatic
    @ApiStatus.Internal
    public static final void markAsLoaded() {
        Companion.markAsLoaded();
    }

    @JvmStatic
    @ApiStatus.Internal
    @NotNull
    public static final List<RegistryValue> getAll() {
        return Companion.getAll();
    }

    static {
        EMPTY_VALUE_LISTENER = new RegistryValueListener(){};
        registry = new Registry();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u000e\u001a\u00020\u000f2\u000b\u0010\u0010\u001a\u00070\u0007\u00a2\u0006\u0002\b\tH\u0007J%\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u000b\u0010\u0010\u001a\u00070\u0007\u00a2\u0006\u0002\b\t2\b\b\u0002\u0010\u0014\u001a\u00020\u0013H\u0007J\u0015\u0010\u0015\u001a\u00020\u000f2\u000b\u0010\u0010\u001a\u00070\u0007\u00a2\u0006\u0002\b\tH\u0007J\u0015\u0010\u0016\u001a\u00020\u00132\u000b\u0010\u0010\u001a\u00070\u0007\u00a2\u0006\u0002\b\tH\u0007J\u001d\u0010\u0016\u001a\u00020\u00132\u000b\u0010\u0010\u001a\u00070\u0007\u00a2\u0006\u0002\b\t2\u0006\u0010\u0014\u001a\u00020\u0013H\u0007J\u0015\u0010\u0017\u001a\u00020\u00182\u000b\u0010\u0010\u001a\u00070\u0007\u00a2\u0006\u0002\b\tH\u0007J\u001d\u0010\u0017\u001a\u00020\u00182\u000b\u0010\u0010\u001a\u00070\u0007\u00a2\u0006\u0002\b\t2\u0006\u0010\u0014\u001a\u00020\u0018H\u0007J\u001d\u0010\u0019\u001a\u00020\u001a2\u000b\u0010\u0010\u001a\u00070\u0007\u00a2\u0006\u0002\b\t2\u0006\u0010\u0014\u001a\u00020\u001aH\u0007J\u0015\u0010\u0019\u001a\u00020\u001a2\u000b\u0010\u0010\u001a\u00070\u0007\u00a2\u0006\u0002\b\tH\u0007J\u0015\u0010\u001b\u001a\u00020\u00072\u000b\u0010\u0010\u001a\u00070\u0007\u00a2\u0006\u0002\b\tH\u0007J!\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u000b\u0010\u0010\u001a\u00070\u0007\u00a2\u0006\u0002\b\t2\b\u0010\u0014\u001a\u0004\u0018\u00010\u001dH\u0007J\u0016\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006H\u0002J$\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u00072\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\"H\u0002J\b\u0010#\u001a\u00020\rH\u0007J-\u0010\u0017\u001a\u00020\u00182\u000b\u0010\u0010\u001a\u00070\u0007\u00a2\u0006\u0002\b\t2\u0006\u0010\u0014\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u0018H\u0007J\u001c\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010'\u001a\u00020(H\u0002J&\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\f\u001a\u00020\r2\b\u0010'\u001a\u0004\u0018\u00010(H\u0002J4\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00062\b\u0010'\u001a\u0004\u0018\u00010(2\u0014\u0010+\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006H\u0007J\b\u0010,\u001a\u00020-H\u0007J\u000e\u0010.\u001a\u00020-H\u0087@\u00a2\u0006\u0002\u0010/J\u000e\u00100\u001a\b\u0012\u0004\u0012\u00020\u000f01H\u0007J\u001c\u00102\u001a\u00020\u00132\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\u001c\u00104\u001a\u00020-2\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u0002060\u0006H\u0007J4\u00107\u001a\u00020-2*\u00108\u001a&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u0002060\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u0002060\u000609H\u0007J\u0012\u0010:\u001a\u00020-2\b\u0010;\u001a\u0004\u0018\u00010\u000bH\u0007J<\u0010<\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\f\u001a\u00020\r2\b\u0010'\u001a\u0004\u0018\u00010(2\u0014\u0010+\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006H\u0002R\"\u0010\u0004\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\u0007\u00a2\u0006\u0002\b\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006=\u00b2\u0006\n\u0010>\u001a\u00020\u000fX\u008a\u0084\u0002"}, d2={"Lcom/intellij/openapi/util/registry/Registry$Companion;", "", "<init>", "()V", "bundledRegistry", "Ljava/lang/ref/Reference;", "", "", "REGISTRY_BUNDLE", "Lorg/jetbrains/annotations/NonNls;", "EMPTY_VALUE_LISTENER", "Lcom/intellij/openapi/util/registry/RegistryValueListener;", "registry", "Lcom/intellij/openapi/util/registry/Registry;", "get", "Lcom/intellij/openapi/util/registry/RegistryValue;", "key", "booleanValueHotSupplier", "Lkotlin/Function0;", "", "defaultValue", "_getWithoutStateCheck", "is", "intValue", "", "doubleValue", "", "stringValue", "getColor", "Ljava/awt/Color;", "loadFromBundledConfig", "loadFromResource", "sourceResourceName", "targetMap", "", "getInstance", "minValue", "maxValue", "fromState", "state", "Lorg/jdom/Element;", "updateStateInternal", "loadState", "earlyAccess", "markAsLoaded", "", "awaitLoad", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getAll", "", "isRestartNeeded", "map", "setContributedKeys", "descriptors", "Lcom/intellij/openapi/util/registry/RegistryKeyDescriptor;", "mutateContributedKeys", "mutator", "Lkotlin/Function1;", "setValueChangeListener", "listener", "loadStateInternal", "intellij.platform.util", "valueHandle"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final RegistryValue get(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return this.getInstance().resolveValue(key);
        }

        @ApiStatus.Experimental
        @ApiStatus.Internal
        @NotNull
        public final Function0<Boolean> booleanValueHotSupplier(@NotNull String key, boolean defaultValue) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Lazy valueHandle$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> Companion.booleanValueHotSupplier$lambda$0(key));
            return () -> Companion.booleanValueHotSupplier$lambda$2(defaultValue, valueHandle$delegate);
        }

        public static /* synthetic */ Function0 booleanValueHotSupplier$default(Companion companion, String string, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.booleanValueHotSupplier(string, bl);
        }

        @JvmStatic
        @ApiStatus.Internal
        @NotNull
        public final RegistryValue _getWithoutStateCheck(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return registry.resolveValue(key);
        }

        @JvmStatic
        public final boolean is(@NotNull String key) throws MissingResourceException {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return this.getInstance().resolveValue(key).asBoolean();
        }

        @JvmStatic
        public final boolean is(@NotNull String key, boolean defaultValue) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            if (!LoadingState.COMPONENTS_LOADED.isOccurred()) {
                return defaultValue;
            }
            try {
                return registry.resolveValue(key).asBoolean();
            }
            catch (MissingResourceException missingResourceException) {
                return defaultValue;
            }
        }

        @JvmStatic
        public final int intValue(@NotNull String key) throws MissingResourceException {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return this.getInstance().resolveValue(key).asInteger();
        }

        @JvmStatic
        public final int intValue(@NotNull String key, int defaultValue) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            if (!LoadingState.COMPONENTS_LOADED.isOccurred()) {
                LoadingState.COMPONENTS_REGISTERED.checkOccurred();
                return defaultValue;
            }
            try {
                return registry.resolveValue(key).asInteger();
            }
            catch (MissingResourceException missingResourceException) {
                return defaultValue;
            }
        }

        @JvmStatic
        public final double doubleValue(@NotNull String key, double defaultValue) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            if (!LoadingState.COMPONENTS_LOADED.isOccurred()) {
                LoadingState.COMPONENTS_REGISTERED.checkOccurred();
                return defaultValue;
            }
            try {
                return registry.resolveValue(key).asDouble();
            }
            catch (MissingResourceException ignore) {
                return defaultValue;
            }
        }

        @JvmStatic
        public final double doubleValue(@NotNull String key) throws MissingResourceException {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return this.getInstance().resolveValue(key).asDouble();
        }

        @JvmStatic
        @NotNull
        public final String stringValue(@NotNull String key) throws MissingResourceException {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return this.getInstance().resolveValue(key).asString();
        }

        @JvmStatic
        @Nullable
        public final Color getColor(@NotNull String key, @Nullable Color defaultValue) throws MissingResourceException {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return this.getInstance().resolveValue(key).asColor(defaultValue);
        }

        private final Map<String, String> loadFromBundledConfig() throws IOException {
            Map map2;
            Reference reference = bundledRegistry;
            if (reference != null && (map2 = (Map)reference.get()) != null) {
                Map it = map2;
                boolean bl = false;
                return it;
            }
            LinkedHashMap map3 = new LinkedHashMap(1800);
            boolean mainFound = this.loadFromResource("misc/registry.properties", map3);
            boolean overrideFound = this.loadFromResource("misc/registry.override.properties", map3);
            if (!mainFound && !overrideFound) {
                return null;
            }
            bundledRegistry = new SoftReference(map3);
            return map3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean loadFromResource(String sourceResourceName, Map<String, String> targetMap) {
            InputStream inputStream = Registry.class.getClassLoader().getResourceAsStream(sourceResourceName);
            if (inputStream == null) {
                return false;
            }
            InputStream stream = inputStream;
            Closeable closeable = stream;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                new Properties(targetMap){
                    final /* synthetic */ Map<String, String> $targetMap;
                    {
                        this.$targetMap = $targetMap;
                    }

                    public Object put(Object key, Object value) {
                        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                        return this.$targetMap.put((String)key, (String)value);
                    }
                }.load(stream);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return true;
        }

        @JvmStatic
        @NotNull
        public final Registry getInstance() {
            LoadingState.COMPONENTS_LOADED.checkOccurred();
            return registry;
        }

        @JvmStatic
        public final int intValue(@NotNull String key, int defaultValue, int minValue, int maxValue) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            if (!(defaultValue >= minValue && defaultValue <= maxValue)) {
                boolean bl = false;
                String string = "Wrong values for default:min:max (" + defaultValue + ':' + minValue + ':' + maxValue + ')';
                throw new IllegalArgumentException(string.toString());
            }
            return RangesKt.coerceIn((int)this.intValue(key, defaultValue), (int)minValue, (int)maxValue);
        }

        private final Map<String, String> fromState(Element state) {
            LinkedHashMap<String, String> map2 = new LinkedHashMap<String, String>();
            for (Element entry : state.getChildren("entry")) {
                String value;
                String key;
                if (entry.getAttributeValue("key") == null || entry.getAttributeValue("value") == null) continue;
                map2.put(key, value);
            }
            return map2;
        }

        private final Map<String, String> updateStateInternal(Registry registry, Element state) {
            LinkedHashMap userProperties = registry.userProperties;
            if (state == null) {
                userProperties.clear();
                return userProperties;
            }
            Map<String, String> map2 = this.fromState(state);
            HashSet keysToProcess = new HashSet(userProperties.keySet());
            for (Map.Entry<String, String> entry : map2.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                RegistryValue registryValue = registry.resolveValue(key);
                String currentValue = registryValue.resolveNotRequiredValue(key);
                if (currentValue != null && !Intrinsics.areEqual((Object)currentValue, (Object)value)) {
                    registryValue.setValue(value);
                }
                keysToProcess.remove(key);
            }
            Iterator iterator2 = keysToProcess.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
            Iterator<Map.Entry<String, String>> iterator3 = iterator2;
            while (iterator3.hasNext()) {
                String key = (String)((Object)iterator3.next());
                Intrinsics.checkNotNull((Object)key);
                registry.resolveValue(key).resetToDefault();
            }
            return userProperties;
        }

        @ApiStatus.Internal
        @NotNull
        public final Map<String, String> loadState(@Nullable Element state, @Nullable Map<String, String> earlyAccess) {
            Registry registry = registry;
            if (registry.isLoaded()) {
                return this.updateStateInternal(registry, state);
            }
            return this.loadStateInternal(registry, state, earlyAccess);
        }

        @JvmStatic
        @ApiStatus.Internal
        public final void markAsLoaded() {
            registry.isLoaded = true;
            registry.loadFuture.complete(null);
        }

        @ApiStatus.Internal
        @Nullable
        public final Object awaitLoad(@NotNull Continuation<? super Unit> $completion) {
            Object object = FutureKt.asDeferred(registry.loadFuture).join($completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }

        @JvmStatic
        @ApiStatus.Internal
        @NotNull
        public final List<RegistryValue> getAll() {
            Object object;
            Map<String, String> bundle = null;
            try {
                bundle = this.loadFromBundledConfig();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if ((object = bundle) == null || (object = object.keySet()) == null) {
                object = SetsKt.emptySet();
            }
            Object keys2 = object;
            ArrayList<RegistryValue> result2 = new ArrayList<RegistryValue>();
            Registry registry = registry;
            Map contributedKeys = registry.contributedKeys;
            Iterator<Object> iterator2 = keys2.iterator();
            while (iterator2.hasNext()) {
                String key = (String)iterator2.next();
                if (StringsKt.endsWith$default((String)key, (String)".description", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)key, (String)".restartRequired", (boolean)false, (int)2, null) || contributedKeys.containsKey(key)) continue;
                result2.add(registry.resolveValue(key));
            }
            for (String key : contributedKeys.keySet()) {
                result2.add(registry.resolveValue(key));
            }
            return result2;
        }

        private final boolean isRestartNeeded(Map<String, String> map2) {
            Registry instance = this.getInstance();
            for (String s : map2.keySet()) {
                RegistryValue eachValue = instance.resolveValue(s);
                if (!eachValue.isRestartRequired() || !eachValue.isChangedSinceAppStart()) continue;
                return true;
            }
            return false;
        }

        @ApiStatus.Internal
        public final synchronized void setContributedKeys(@NotNull Map<String, RegistryKeyDescriptor> descriptors) {
            Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
            registry.contributedKeys = descriptors;
        }

        @ApiStatus.Internal
        public final synchronized void mutateContributedKeys(@NotNull Function1<? super Map<String, RegistryKeyDescriptor>, ? extends Map<String, RegistryKeyDescriptor>> mutator) {
            Intrinsics.checkNotNullParameter(mutator, (String)"mutator");
            registry.contributedKeys = (Map)mutator.invoke((Object)registry.contributedKeys);
        }

        @ApiStatus.Internal
        public final void setValueChangeListener(@Nullable RegistryValueListener listener) {
            Registry registry = registry;
            RegistryValueListener registryValueListener = listener;
            if (registryValueListener == null) {
                registryValueListener = EMPTY_VALUE_LISTENER;
            }
            registry.valueChangeListener = registryValueListener;
        }

        private final Map<String, String> loadStateInternal(Registry registry, Element state, Map<String, String> earlyAccess) {
            LinkedHashMap userProperties = registry.userProperties;
            userProperties.clear();
            if (state != null) {
                Map<String, String> map2 = this.fromState(state);
                for (Map.Entry<String, String> entry : map2.entrySet()) {
                    RegistryValue registryValue;
                    String key = entry.getKey();
                    String value = entry.getValue();
                    if (Intrinsics.areEqual((Object)value, (Object)registry.getBundleValueOrNull((registryValue = registry.resolveValue(key)).getKey()))) continue;
                    userProperties.put(key, value);
                    registryValue.resetCache$intellij_platform_util();
                }
            }
            if (earlyAccess != null) {
                userProperties.putAll(earlyAccess);
            }
            registry.isLoaded = true;
            registry.loadFuture.complete(null);
            return userProperties;
        }

        private static final RegistryValue booleanValueHotSupplier$lambda$0(String $key) {
            return registry.resolveValue($key);
        }

        private static final RegistryValue booleanValueHotSupplier$lambda$1(Lazy<? extends RegistryValue> $valueHandle$delegate) {
            Lazy<? extends RegistryValue> lazy = $valueHandle$delegate;
            return (RegistryValue)lazy.getValue();
        }

        private static final boolean booleanValueHotSupplier$lambda$2(boolean $defaultValue, Lazy $valueHandle$delegate) {
            boolean bl;
            try {
                bl = com.intellij.openapi.util.registry.Registry$Companion.booleanValueHotSupplier$lambda$1((Lazy<? extends RegistryValue>)$valueHandle$delegate).asBoolean();
            }
            catch (MissingResourceException e) {
                bl = $defaultValue;
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

