/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.diagnostic.telemetry;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.diagnostic.telemetry.IJNoopTracer;
import com.intellij.platform.diagnostic.telemetry.IJTracer;
import com.intellij.platform.diagnostic.telemetry.MetricsExporterEntry;
import com.intellij.platform.diagnostic.telemetry.NoopIntelliJTracer;
import com.intellij.platform.diagnostic.telemetry.Scope;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.metrics.Meter;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u0005H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016J\u000e\u0010\u0018\u001a\u00020\u0014H\u0096@\u00a2\u0006\u0002\u0010\u0019J\u000e\u0010\u001a\u001a\u00020\u0014H\u0096@\u00a2\u0006\u0002\u0010\u0019R\u001a\u0010\u0004\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u001b"}, d2={"Lcom/intellij/platform/diagnostic/telemetry/NoopTelemetryManager;", "Lcom/intellij/platform/diagnostic/telemetry/TelemetryManager;", "<init>", "()V", "verboseMode", "", "getVerboseMode", "()Z", "setVerboseMode", "(Z)V", "hasSpanExporters", "getTracer", "Lcom/intellij/platform/diagnostic/telemetry/IJTracer;", "scope", "Lcom/intellij/platform/diagnostic/telemetry/Scope;", "getSimpleTracer", "Lcom/intellij/platform/diagnostic/telemetry/NoopIntelliJTracer;", "getMeter", "Lio/opentelemetry/api/metrics/Meter;", "addMetricsExporters", "", "exporters", "", "Lcom/intellij/platform/diagnostic/telemetry/MetricsExporterEntry;", "forceFlushMetrics", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "resetExporters", "intellij.platform.diagnostic.telemetry"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nTelemetryManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TelemetryManager.kt\ncom/intellij/platform/diagnostic/telemetry/NoopTelemetryManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,187:1\n14#2:188\n14#2:189\n14#2:190\n*S KotlinDebug\n*F\n+ 1 TelemetryManager.kt\ncom/intellij/platform/diagnostic/telemetry/NoopTelemetryManager\n*L\n157#1:188\n161#1:189\n165#1:190\n*E\n"})
public final class NoopTelemetryManager
implements TelemetryManager {
    private boolean verboseMode;

    @Override
    public boolean getVerboseMode() {
        return this.verboseMode;
    }

    @Override
    public void setVerboseMode(boolean bl) {
        this.verboseMode = bl;
    }

    @Override
    public boolean hasSpanExporters() {
        return false;
    }

    @Override
    @NotNull
    public IJTracer getTracer(@NotNull Scope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        return IJNoopTracer.INSTANCE;
    }

    @Override
    @NotNull
    public NoopIntelliJTracer getSimpleTracer(@NotNull Scope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        return NoopIntelliJTracer.INSTANCE;
    }

    @Override
    @NotNull
    public Meter getMeter(@NotNull Scope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Meter meter = OpenTelemetry.noop().getMeter(scope.toString());
        Intrinsics.checkNotNullExpressionValue((Object)meter, (String)"getMeter(...)");
        return meter;
    }

    @Override
    public void addMetricsExporters(@NotNull List<MetricsExporterEntry> exporters) {
        Intrinsics.checkNotNullParameter(exporters, (String)"exporters");
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(NoopTelemetryManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("Noop telemetry manager is in use. No metrics exporters are defined.");
    }

    @Override
    @Nullable
    public Object forceFlushMetrics(@NotNull Continuation<? super Unit> $completion) {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(NoopTelemetryManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("Cannot force flushing metrics for Noop telemetry manager");
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object resetExporters(@NotNull Continuation<? super Unit> $completion) {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(NoopTelemetryManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("Cannot clean exported metrics for Noop telemetry manager");
        return Unit.INSTANCE;
    }
}

