/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.jps;

import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.util.JpsPathUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u000e\u000fB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u0082\u0001\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/platform/workspace/jps/JpsProjectConfigLocation;", "", "<init>", "()V", "baseDirectoryUrlString", "", "getBaseDirectoryUrlString", "()Ljava/lang/String;", "projectFilePath", "getProjectFilePath", "baseDirectoryUrl", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "getBaseDirectoryUrl", "()Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "DirectoryBased", "FileBased", "Lcom/intellij/platform/workspace/jps/JpsProjectConfigLocation$DirectoryBased;", "Lcom/intellij/platform/workspace/jps/JpsProjectConfigLocation$FileBased;", "intellij.platform.workspace.jps"})
public abstract class JpsProjectConfigLocation {
    private JpsProjectConfigLocation() {
    }

    @NotNull
    public final String getBaseDirectoryUrlString() {
        String string = this.getBaseDirectoryUrl().getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
        return string;
    }

    @NotNull
    public abstract String getProjectFilePath();

    @NotNull
    public abstract VirtualFileUrl getBaseDirectoryUrl();

    public /* synthetic */ JpsProjectConfigLocation(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\rH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0014\u0010\n\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/intellij/platform/workspace/jps/JpsProjectConfigLocation$DirectoryBased;", "Lcom/intellij/platform/workspace/jps/JpsProjectConfigLocation;", "projectDir", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "ideaFolder", "<init>", "(Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;)V", "getProjectDir", "()Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "getIdeaFolder", "baseDirectoryUrl", "getBaseDirectoryUrl", "projectFilePath", "", "getProjectFilePath", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.platform.workspace.jps"})
    public static final class DirectoryBased
    extends JpsProjectConfigLocation {
        @NotNull
        private final VirtualFileUrl projectDir;
        @NotNull
        private final VirtualFileUrl ideaFolder;

        public DirectoryBased(@NotNull VirtualFileUrl projectDir, @NotNull VirtualFileUrl ideaFolder) {
            Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
            Intrinsics.checkNotNullParameter((Object)ideaFolder, (String)"ideaFolder");
            super(null);
            this.projectDir = projectDir;
            this.ideaFolder = ideaFolder;
        }

        @NotNull
        public final VirtualFileUrl getProjectDir() {
            return this.projectDir;
        }

        @NotNull
        public final VirtualFileUrl getIdeaFolder() {
            return this.ideaFolder;
        }

        @Override
        @NotNull
        public VirtualFileUrl getBaseDirectoryUrl() {
            return this.projectDir;
        }

        @Override
        @NotNull
        public String getProjectFilePath() {
            String string = JpsPathUtil.urlToPath(this.ideaFolder.append("misc.xml").getUrl());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"urlToPath(...)");
            return string;
        }

        @NotNull
        public final VirtualFileUrl component1() {
            return this.projectDir;
        }

        @NotNull
        public final VirtualFileUrl component2() {
            return this.ideaFolder;
        }

        @NotNull
        public final DirectoryBased copy(@NotNull VirtualFileUrl projectDir, @NotNull VirtualFileUrl ideaFolder) {
            Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
            Intrinsics.checkNotNullParameter((Object)ideaFolder, (String)"ideaFolder");
            return new DirectoryBased(projectDir, ideaFolder);
        }

        public static /* synthetic */ DirectoryBased copy$default(DirectoryBased directoryBased, VirtualFileUrl virtualFileUrl, VirtualFileUrl virtualFileUrl2, int n, Object object) {
            if ((n & 1) != 0) {
                virtualFileUrl = directoryBased.projectDir;
            }
            if ((n & 2) != 0) {
                virtualFileUrl2 = directoryBased.ideaFolder;
            }
            return directoryBased.copy(virtualFileUrl, virtualFileUrl2);
        }

        @NotNull
        public String toString() {
            return "DirectoryBased(projectDir=" + this.projectDir + ", ideaFolder=" + this.ideaFolder + ")";
        }

        public int hashCode() {
            int result2 = this.projectDir.hashCode();
            result2 = result2 * 31 + this.ideaFolder.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DirectoryBased)) {
                return false;
            }
            DirectoryBased directoryBased = (DirectoryBased)other;
            if (!Intrinsics.areEqual((Object)this.projectDir, (Object)directoryBased.projectDir)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.ideaFolder, (Object)directoryBased.ideaFolder);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\rH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0014\u0010\n\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/intellij/platform/workspace/jps/JpsProjectConfigLocation$FileBased;", "Lcom/intellij/platform/workspace/jps/JpsProjectConfigLocation;", "iprFile", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "iprFileParent", "<init>", "(Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;)V", "getIprFile", "()Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "getIprFileParent", "baseDirectoryUrl", "getBaseDirectoryUrl", "projectFilePath", "", "getProjectFilePath", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.platform.workspace.jps"})
    public static final class FileBased
    extends JpsProjectConfigLocation {
        @NotNull
        private final VirtualFileUrl iprFile;
        @NotNull
        private final VirtualFileUrl iprFileParent;

        public FileBased(@NotNull VirtualFileUrl iprFile, @NotNull VirtualFileUrl iprFileParent) {
            Intrinsics.checkNotNullParameter((Object)iprFile, (String)"iprFile");
            Intrinsics.checkNotNullParameter((Object)iprFileParent, (String)"iprFileParent");
            super(null);
            this.iprFile = iprFile;
            this.iprFileParent = iprFileParent;
        }

        @NotNull
        public final VirtualFileUrl getIprFile() {
            return this.iprFile;
        }

        @NotNull
        public final VirtualFileUrl getIprFileParent() {
            return this.iprFileParent;
        }

        @Override
        @NotNull
        public VirtualFileUrl getBaseDirectoryUrl() {
            return this.iprFileParent;
        }

        @Override
        @NotNull
        public String getProjectFilePath() {
            String string = JpsPathUtil.urlToPath(this.iprFile.getUrl());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"urlToPath(...)");
            return string;
        }

        @NotNull
        public final VirtualFileUrl component1() {
            return this.iprFile;
        }

        @NotNull
        public final VirtualFileUrl component2() {
            return this.iprFileParent;
        }

        @NotNull
        public final FileBased copy(@NotNull VirtualFileUrl iprFile, @NotNull VirtualFileUrl iprFileParent) {
            Intrinsics.checkNotNullParameter((Object)iprFile, (String)"iprFile");
            Intrinsics.checkNotNullParameter((Object)iprFileParent, (String)"iprFileParent");
            return new FileBased(iprFile, iprFileParent);
        }

        public static /* synthetic */ FileBased copy$default(FileBased fileBased, VirtualFileUrl virtualFileUrl, VirtualFileUrl virtualFileUrl2, int n, Object object) {
            if ((n & 1) != 0) {
                virtualFileUrl = fileBased.iprFile;
            }
            if ((n & 2) != 0) {
                virtualFileUrl2 = fileBased.iprFileParent;
            }
            return fileBased.copy(virtualFileUrl, virtualFileUrl2);
        }

        @NotNull
        public String toString() {
            return "FileBased(iprFile=" + this.iprFile + ", iprFileParent=" + this.iprFileParent + ")";
        }

        public int hashCode() {
            int result2 = this.iprFile.hashCode();
            result2 = result2 * 31 + this.iprFileParent.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FileBased)) {
                return false;
            }
            FileBased fileBased = (FileBased)other;
            if (!Intrinsics.areEqual((Object)this.iprFile, (Object)fileBased.iprFile)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.iprFileParent, (Object)fileBased.iprFileParent);
        }
    }
}

