/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.impl.EntityFamily;
import com.intellij.platform.workspace.storage.impl.ImmutableEntityFamily;
import com.intellij.platform.workspace.storage.impl.WorkspaceEntityData;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 -*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001-B7\u0012&\u0010\u0004\u001a\"\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00060\u0005j\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0006`\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0013J\u0014\u0010\u0018\u001a\u00020\u00162\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006J\u0006\u0010\u001a\u001a\u00020\u0013J\u0014\u0010\u001b\u001a\u00020\u00162\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006J\u0014\u0010\u001d\u001a\u00020\u00162\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006J\u0016\u0010\u001f\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00062\u0006\u0010 \u001a\u00020\u0013J\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\u0006\u0010 \u001a\u00020\u0013J\u001c\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u00132\f\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006J\f\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000&J\b\u0010'\u001a\u00020\u0013H\u0016J\b\u0010(\u001a\u00020\u0016H\u0014J\r\u0010)\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b*J\b\u0010+\u001a\u00020\u0016H\u0002J\f\u0010,\u001a\u00020\u0013*\u00020\u0011H\u0002R:\u0010\u0004\u001a\"\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00060\u0005j\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0006`\u0007X\u0090\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/intellij/platform/workspace/storage/impl/MutableEntityFamily;", "E", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "Lcom/intellij/platform/workspace/storage/impl/EntityFamily;", "entities", "Ljava/util/ArrayList;", "Lcom/intellij/platform/workspace/storage/impl/WorkspaceEntityData;", "Lkotlin/collections/ArrayList;", "freezed", "", "<init>", "(Ljava/util/ArrayList;Z)V", "getEntities$intellij_platform_workspace_storage", "()Ljava/util/ArrayList;", "setEntities$intellij_platform_workspace_storage", "(Ljava/util/ArrayList;)V", "availableSlots", "Lit/unimi/dsi/fastutil/ints/IntSet;", "amountOfGapsInEntities", "", "copiedToModify", "remove", "", "id", "add", "other", "book", "insertAtId", "data", "replaceById", "entity", "getEntityDataForModificationOrNull", "arrayId", "getEntityDataForModification", "set", "position", "value", "toImmutable", "Lcom/intellij/platform/workspace/storage/impl/ImmutableEntityFamily;", "size", "familyCheck", "isEmpty", "isEmpty$intellij_platform_workspace_storage", "startWrite", "pop", "Companion", "intellij.platform.workspace.storage"})
@SourceDebugExtension(value={"SMAP\nEntityFamily.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntityFamily.kt\ncom/intellij/platform/workspace/storage/impl/MutableEntityFamily\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,210:1\n1567#2:211\n1598#2,4:212\n24#3:216\n*S KotlinDebug\n*F\n+ 1 EntityFamily.kt\ncom/intellij/platform/workspace/storage/impl/MutableEntityFamily\n*L\n36#1:211\n36#1:212,4\n107#1:216\n*E\n"})
public final class MutableEntityFamily<E extends WorkspaceEntity>
extends EntityFamily<E> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private ArrayList<WorkspaceEntityData<E>> entities;
    private boolean freezed;
    @NotNull
    private final IntSet availableSlots;
    private int amountOfGapsInEntities;
    @NotNull
    private final IntSet copiedToModify;

    /*
     * WARNING - void declaration
     */
    public MutableEntityFamily(@NotNull ArrayList<WorkspaceEntityData<E>> entities, boolean freezed) {
        void $this$mapIndexedTo$iv$iv;
        IntOpenHashSet intOpenHashSet;
        Intrinsics.checkNotNullParameter(entities, (String)"entities");
        super(null);
        this.entities = entities;
        this.freezed = freezed;
        IntOpenHashSet intOpenHashSet2 = intOpenHashSet = new IntOpenHashSet();
        MutableEntityFamily mutableEntityFamily = this;
        boolean bl = false;
        Iterable $this$mapIndexed$iv = this.getEntities$intellij_platform_workspace_storage();
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void pEntityData;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            WorkspaceEntityData workspaceEntityData = (WorkspaceEntityData)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            if (pEntityData == null) {
                void index;
                void it;
                it.add((int)index);
            }
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        mutableEntityFamily.availableSlots = intOpenHashSet;
        this.amountOfGapsInEntities = this.availableSlots.size();
        this.copiedToModify = new IntOpenHashSet();
    }

    @Override
    @NotNull
    public ArrayList<WorkspaceEntityData<E>> getEntities$intellij_platform_workspace_storage() {
        return this.entities;
    }

    public void setEntities$intellij_platform_workspace_storage(@NotNull ArrayList<WorkspaceEntityData<E>> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
        this.entities = arrayList;
    }

    public final void remove(int id) {
        if (this.availableSlots.contains(id) || ((ArrayList)this.getEntities$intellij_platform_workspace_storage()).get(id) == null) {
            return;
        }
        this.startWrite();
        this.copiedToModify.remove(id);
        ((ArrayList)this.getEntities$intellij_platform_workspace_storage()).set(id, null);
        int n = this.amountOfGapsInEntities;
        this.amountOfGapsInEntities = n + 1;
    }

    public final void add(@NotNull WorkspaceEntityData<E> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        this.startWrite();
        if (this.availableSlots.isEmpty()) {
            other.setId(((ArrayList)this.getEntities$intellij_platform_workspace_storage()).size());
            ((ArrayList)this.getEntities$intellij_platform_workspace_storage()).add(other);
        } else {
            int emptySlot = this.pop(this.availableSlots);
            other.setId(emptySlot);
            ((ArrayList)this.getEntities$intellij_platform_workspace_storage()).set(emptySlot, other);
            int n = this.amountOfGapsInEntities;
            this.amountOfGapsInEntities = n + -1;
        }
        this.copiedToModify.add(other.getId());
    }

    public final int book() {
        int n;
        int n2;
        this.startWrite();
        if (this.availableSlots.isEmpty()) {
            ((ArrayList)this.getEntities$intellij_platform_workspace_storage()).add(null);
            n2 = this.amountOfGapsInEntities;
            this.amountOfGapsInEntities = n2 + 1;
            n = CollectionsKt.getLastIndex((List)this.getEntities$intellij_platform_workspace_storage());
        } else {
            int emptySlot = this.pop(this.availableSlots);
            ((ArrayList)this.getEntities$intellij_platform_workspace_storage()).set(emptySlot, null);
            n = n2;
        }
        int bookedId = n;
        this.copiedToModify.add(bookedId);
        return bookedId;
    }

    public final void insertAtId(@NotNull WorkspaceEntityData<E> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        this.startWrite();
        WorkspaceEntityData prevValue = (WorkspaceEntityData)((ArrayList)this.getEntities$intellij_platform_workspace_storage()).get(data.getId());
        ((ArrayList)this.getEntities$intellij_platform_workspace_storage()).set(data.getId(), data);
        this.availableSlots.remove(data.getId());
        if (prevValue == null) {
            int n = this.amountOfGapsInEntities;
            this.amountOfGapsInEntities = n + -1;
        }
        this.copiedToModify.add(data.getId());
    }

    public final void replaceById(@NotNull WorkspaceEntityData<E> entity) {
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        int id = entity.getId();
        if (((ArrayList)this.getEntities$intellij_platform_workspace_storage()).get(id) == null) {
            MutableEntityFamily $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(MutableEntityFamily.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Nothing to replace. EntityData: " + entity);
            return;
        }
        this.startWrite();
        ((ArrayList)this.getEntities$intellij_platform_workspace_storage()).set(id, entity);
        this.copiedToModify.add(id);
    }

    @Nullable
    public final WorkspaceEntityData<E> getEntityDataForModificationOrNull(int arrayId) {
        WorkspaceEntityData workspaceEntityData = (WorkspaceEntityData)CollectionsKt.getOrNull((List)this.getEntities$intellij_platform_workspace_storage(), (int)arrayId);
        if (workspaceEntityData == null) {
            return null;
        }
        WorkspaceEntityData entity = workspaceEntityData;
        if (this.copiedToModify.contains(arrayId)) {
            return entity;
        }
        this.startWrite();
        Object clonedEntity = entity.clone();
        ((ArrayList)this.getEntities$intellij_platform_workspace_storage()).set(arrayId, clonedEntity);
        this.copiedToModify.add(arrayId);
        return clonedEntity;
    }

    @NotNull
    public final WorkspaceEntityData<E> getEntityDataForModification(int arrayId) {
        WorkspaceEntityData<E> workspaceEntityData = this.getEntityDataForModificationOrNull(arrayId);
        if (workspaceEntityData == null) {
            throw new IllegalStateException("Nothing to modify".toString());
        }
        return workspaceEntityData;
    }

    public final void set(int position, @NotNull WorkspaceEntityData<E> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.startWrite();
        ((ArrayList)this.getEntities$intellij_platform_workspace_storage()).set(position, value);
    }

    @NotNull
    public final ImmutableEntityFamily<E> toImmutable() {
        this.freezed = true;
        this.copiedToModify.clear();
        return new ImmutableEntityFamily(this.getEntities$intellij_platform_workspace_storage(), this.amountOfGapsInEntities);
    }

    @Override
    public int size() {
        return ((ArrayList)this.getEntities$intellij_platform_workspace_storage()).size() - this.amountOfGapsInEntities;
    }

    @Override
    protected void familyCheck() {
    }

    public final boolean isEmpty$intellij_platform_workspace_storage() {
        return ((ArrayList)this.getEntities$intellij_platform_workspace_storage()).size() == this.amountOfGapsInEntities;
    }

    private final void startWrite() {
        if (!this.freezed) {
            return;
        }
        this.setEntities$intellij_platform_workspace_storage(new ArrayList<WorkspaceEntityData<E>>(this.getEntities$intellij_platform_workspace_storage()));
        this.freezed = false;
    }

    private final int pop(IntSet $this$pop) {
        IntIterator intIterator = $this$pop.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)intIterator, (String)"iterator(...)");
        IntIterator iterator2 = intIterator;
        if (!iterator2.hasNext()) {
            throw new IllegalStateException("Set is empty".toString());
        }
        int res = iterator2.nextInt();
        iterator2.remove();
        return res;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\b\b\u0001\u0010\u0006*\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/platform/workspace/storage/impl/MutableEntityFamily$Companion;", "", "<init>", "()V", "createEmptyMutable", "Lcom/intellij/platform/workspace/storage/impl/MutableEntityFamily;", "T", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "intellij.platform.workspace.storage"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <T extends WorkspaceEntity> MutableEntityFamily<T> createEmptyMutable() {
            return new MutableEntityFamily(new ArrayList(), false);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

