/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage.impl;

import com.intellij.platform.workspace.storage.ConnectionId;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.WorkspaceEntityWithSymbolicId;
import com.intellij.platform.workspace.storage.impl.AbstractEntityStorage;
import com.intellij.platform.workspace.storage.impl.ClassToIntConverterKt;
import com.intellij.platform.workspace.storage.impl.EntityIdKt;
import com.intellij.platform.workspace.storage.impl.ModifiableWorkspaceEntityBase;
import com.intellij.platform.workspace.storage.impl.MutableEntityStorageImpl;
import com.intellij.platform.workspace.storage.impl.NotThisEntityId;
import com.intellij.platform.workspace.storage.impl.RefsTableKt;
import com.intellij.platform.workspace.storage.impl.ThisEntityId;
import com.intellij.platform.workspace.storage.impl.WorkspaceEntityBase;
import com.intellij.platform.workspace.storage.impl.WorkspaceEntityData;
import com.intellij.platform.workspace.storage.instrumentation.Modification;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000v\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\u001a\u0015\u0010\u0000\u001a\u00020\u0001*\u00060\u0002j\u0002`\u0003H\u0000\u00a2\u0006\u0002\u0010\u0004\u001a\u0015\u0010\u0005\u001a\u00020\u0006*\u00060\u0002j\u0002`\u0003H\u0000\u00a2\u0006\u0002\u0010\u0004\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\u001c\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a(\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u001a(\u0010\u0010\u001a\u00020\u00112\n\u0010\u0014\u001a\u00060\u0002j\u0002`\u00032\n\u0010\u0015\u001a\u00060\u0002j\u0002`\u00032\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u001a\f\u0010\u0018\u001a\u00020\u0019*\u00020\u001aH\u0000\u001a&\u0010\u0018\u001a\f\u0012\u0004\u0012\u0002H\u001c\u0012\u0002\b\u00030\u001b\"\b\b\u0000\u0010\u001c*\u00020\u001a*\b\u0012\u0004\u0012\u0002H\u001c0\u001dH\u0000\u001a\"\u0010#\u001a\u00020\u0011*\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\"\u0018\u0010\u001e\u001a\u00020\u001f*\u00020 8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006("}, d2={"asThis", "Lcom/intellij/platform/workspace/storage/impl/ThisEntityId;", "", "Lcom/intellij/platform/workspace/storage/impl/EntityId;", "(J)J", "notThis", "Lcom/intellij/platform/workspace/storage/impl/NotThisEntityId;", "currentStackTrace", "", "depth", "", "loadClassByName", "Ljava/lang/Class;", "name", "classLoader", "Ljava/lang/ClassLoader;", "checkCircularDependency", "", "connectionId", "Lcom/intellij/platform/workspace/storage/ConnectionId;", "childId", "parentId", "storage", "Lcom/intellij/platform/workspace/storage/impl/AbstractEntityStorage;", "asBase", "Lcom/intellij/platform/workspace/storage/impl/WorkspaceEntityBase;", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "Lcom/intellij/platform/workspace/storage/impl/ModifiableWorkspaceEntityBase;", "T", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity$Builder;", "mutable", "Lcom/intellij/platform/workspace/storage/MutableEntityStorage;", "Lcom/intellij/platform/workspace/storage/EntityStorage;", "getMutable", "(Lcom/intellij/platform/workspace/storage/EntityStorage;)Lcom/intellij/platform/workspace/storage/MutableEntityStorage;", "createReplaceEventsForUpdates", "Lcom/intellij/platform/workspace/storage/impl/MutableEntityStorageImpl;", "updates", "", "Lcom/intellij/platform/workspace/storage/instrumentation/Modification;", "intellij.platform.workspace.storage"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\ncom/intellij/platform/workspace/storage/impl/UtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,89:1\n1863#2,2:90\n*S KotlinDebug\n*F\n+ 1 Utils.kt\ncom/intellij/platform/workspace/storage/impl/UtilsKt\n*L\n74#1:90,2\n*E\n"})
public final class UtilsKt {
    public static final long asThis(long $this$asThis) {
        return ThisEntityId.constructor-impl($this$asThis);
    }

    public static final long notThis(long $this$notThis) {
        return NotThisEntityId.constructor-impl($this$notThis);
    }

    @NotNull
    public static final String currentStackTrace(int depth) {
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
        return CollectionsKt.joinToString$default((Iterable)ArraysKt.take((Object[])stackTraceElementArray, (int)depth), (CharSequence)"\n", null, null, (int)0, null, UtilsKt::currentStackTrace$lambda$0, (int)30, null);
    }

    @NotNull
    public static final Class<?> loadClassByName(@NotNull String name, @NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        if (StringsKt.startsWith$default((String)name, (String)"[", (boolean)false, (int)2, null)) {
            Class<?> clazz = Class.forName(name);
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"forName(...)");
            return clazz;
        }
        Class<?> clazz = classLoader.loadClass(name);
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"loadClass(...)");
        return clazz;
    }

    public static final void checkCircularDependency(@NotNull ConnectionId connectionId, int childId, int parentId, @NotNull AbstractEntityStorage storage) {
        Intrinsics.checkNotNullParameter((Object)connectionId, (String)"connectionId");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        if (connectionId.getParentClass() == connectionId.getChildClass() && childId == parentId) {
            long parentEntityId = EntityIdKt.createEntityId(parentId, connectionId.getParentClass());
            WorkspaceEntityData<? extends WorkspaceEntity> entityData = storage.entityDataByIdOrDie$intellij_platform_workspace_storage(parentEntityId);
            WorkspaceEntity workspaceEntity = entityData.createEntity(storage);
            Object object = workspaceEntity instanceof WorkspaceEntityWithSymbolicId ? (WorkspaceEntityWithSymbolicId)workspaceEntity : null;
            if (object == null || (object = object.getSymbolicId()) == null || (object = object.toString()) == null) {
                object = entityData.toString();
            }
            Object entityPresentation = object;
            throw new IllegalStateException(StringsKt.trimMargin$default((String)("Trying to make a circular dependency in entities by setting an entity as a child of itself.\n          |Entity class: " + ClassToIntConverterKt.findWorkspaceEntity(connectionId.getParentClass()) + "\n          |Entity: " + (String)entityPresentation + "\n        "), null, (int)1, null).toString());
        }
    }

    public static final void checkCircularDependency(long childId, long parentId, @NotNull AbstractEntityStorage storage) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        if (childId == parentId) {
            WorkspaceEntityData<? extends WorkspaceEntity> entityData = storage.entityDataByIdOrDie$intellij_platform_workspace_storage(parentId);
            WorkspaceEntity workspaceEntity = entityData.createEntity(storage);
            Object object = workspaceEntity instanceof WorkspaceEntityWithSymbolicId ? (WorkspaceEntityWithSymbolicId)workspaceEntity : null;
            if (object == null || (object = object.getSymbolicId()) == null || (object = object.toString()) == null) {
                object = entityData.toString();
            }
            Object entityPresentation = object;
            throw new IllegalStateException(StringsKt.trimMargin$default((String)("Trying to make a circular dependency in entities by setting an entity as a child of itself.\n          |Entity class: " + ClassToIntConverterKt.findWorkspaceEntity(EntityIdKt.getClazz(parentId)) + "\n          |Entity: " + (String)entityPresentation + "\n        "), null, (int)1, null).toString());
        }
    }

    @NotNull
    public static final WorkspaceEntityBase asBase(@NotNull WorkspaceEntity $this$asBase) {
        Intrinsics.checkNotNullParameter((Object)$this$asBase, (String)"<this>");
        return (WorkspaceEntityBase)$this$asBase;
    }

    @NotNull
    public static final <T extends WorkspaceEntity> ModifiableWorkspaceEntityBase<T, ?> asBase(@NotNull WorkspaceEntity.Builder<T> $this$asBase) {
        Intrinsics.checkNotNullParameter($this$asBase, (String)"<this>");
        return (ModifiableWorkspaceEntityBase)$this$asBase;
    }

    @NotNull
    public static final MutableEntityStorage getMutable(@NotNull EntityStorage $this$mutable) {
        Intrinsics.checkNotNullParameter((Object)$this$mutable, (String)"<this>");
        return (MutableEntityStorage)$this$mutable;
    }

    public static final void createReplaceEventsForUpdates(@NotNull MutableEntityStorageImpl $this$createReplaceEventsForUpdates, @NotNull Collection<? extends Modification> updates, @NotNull ConnectionId connectionId) {
        Intrinsics.checkNotNullParameter((Object)$this$createReplaceEventsForUpdates, (String)"<this>");
        Intrinsics.checkNotNullParameter(updates, (String)"updates");
        Intrinsics.checkNotNullParameter((Object)connectionId, (String)"connectionId");
        Iterable $this$forEach$iv = updates;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Modification update = (Modification)element$iv;
            boolean bl = false;
            Modification modification = update;
            if (modification instanceof Modification.Add) {
                $this$createReplaceEventsForUpdates.getChangeLog$intellij_platform_workspace_storage().addReplaceEventForNewChild-FRG0QjY$intellij_platform_workspace_storage(((Modification.Add)update).getParent(), connectionId, RefsTableKt.asChild(((Modification.Add)update).getChild()), true);
                $this$createReplaceEventsForUpdates.getChangeLog$intellij_platform_workspace_storage().addReplaceEventForNewParent-KZzBy_s$intellij_platform_workspace_storage(((Modification.Add)update).getChild(), connectionId, RefsTableKt.asParent(((Modification.Add)update).getParent()), false);
                continue;
            }
            if (modification instanceof Modification.Remove) {
                $this$createReplaceEventsForUpdates.getChangeLog$intellij_platform_workspace_storage().addReplaceEventForRemovedChild-FRG0QjY$intellij_platform_workspace_storage(((Modification.Remove)update).getParent(), connectionId, RefsTableKt.asChild(((Modification.Remove)update).getChild()), true);
                $this$createReplaceEventsForUpdates.getChangeLog$intellij_platform_workspace_storage().addReplaceEventForRemovedParent-KZzBy_s$intellij_platform_workspace_storage(((Modification.Remove)update).getChild(), connectionId, RefsTableKt.asParent(((Modification.Remove)update).getParent()), false);
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
    }

    private static final CharSequence currentStackTrace$lambda$0(StackTraceElement it) {
        String string = it.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

