/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage.impl;

import com.intellij.platform.workspace.storage.CachedValue;
import com.intellij.platform.workspace.storage.CachedValueWithParameter;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.VersionedEntityStorage;
import com.intellij.platform.workspace.storage.impl.ValuesCache;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J!\u0010\u0013\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017J5\u0010\u0013\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u0018\"\u0004\b\u0001\u0010\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u0002H\u0018\u0012\u0004\u0012\u0002H\u00140\u00192\u0006\u0010\u001a\u001a\u0002H\u0018H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u001c\u0010\u001c\u001a\u00020\u001d\"\u0004\b\u0000\u0010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0016H\u0016J5\u0010\u001c\u001a\u00020\u001d\"\u0004\b\u0000\u0010\u0018\"\u0004\b\u0001\u0010\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u0002H\u0018\u0012\u0004\u0012\u0002H\u00140\u00192\u0006\u0010\u001a\u001a\u0002H\u0018H\u0016\u00a2\u0006\u0002\u0010\u001eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lcom/intellij/platform/workspace/storage/impl/VersionedEntityStorageOnSnapshot;", "Lcom/intellij/platform/workspace/storage/VersionedEntityStorage;", "storage", "Lcom/intellij/platform/workspace/storage/ImmutableEntityStorage;", "<init>", "(Lcom/intellij/platform/workspace/storage/ImmutableEntityStorage;)V", "valuesCache", "Lcom/intellij/platform/workspace/storage/impl/ValuesCache;", "version", "", "getVersion", "()J", "current", "getCurrent", "()Lcom/intellij/platform/workspace/storage/ImmutableEntityStorage;", "base", "Lcom/intellij/platform/workspace/storage/EntityStorage;", "getBase", "()Lcom/intellij/platform/workspace/storage/EntityStorage;", "cachedValue", "R", "value", "Lcom/intellij/platform/workspace/storage/CachedValue;", "(Lcom/intellij/platform/workspace/storage/CachedValue;)Ljava/lang/Object;", "P", "Lcom/intellij/platform/workspace/storage/CachedValueWithParameter;", "parameter", "(Lcom/intellij/platform/workspace/storage/CachedValueWithParameter;Ljava/lang/Object;)Ljava/lang/Object;", "clearCachedValue", "", "(Lcom/intellij/platform/workspace/storage/CachedValueWithParameter;Ljava/lang/Object;)V", "intellij.platform.workspace.storage"})
public final class VersionedEntityStorageOnSnapshot
implements VersionedEntityStorage {
    @NotNull
    private final ImmutableEntityStorage storage;
    @NotNull
    private final ValuesCache valuesCache;

    public VersionedEntityStorageOnSnapshot(@NotNull ImmutableEntityStorage storage) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        this.storage = storage;
        this.valuesCache = new ValuesCache();
    }

    @Override
    public long getVersion() {
        return 0L;
    }

    @Override
    @NotNull
    public ImmutableEntityStorage getCurrent() {
        return this.storage;
    }

    @Override
    @NotNull
    public EntityStorage getBase() {
        return this.storage;
    }

    @Override
    public <R> R cachedValue(@NotNull CachedValue<R> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return this.valuesCache.cachedValue(value, this.getCurrent());
    }

    @Override
    public <P, R> R cachedValue(@NotNull CachedValueWithParameter<P, R> value, P parameter) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return this.valuesCache.cachedValue(value, parameter, this.getCurrent());
    }

    @Override
    public <R> void clearCachedValue(@NotNull CachedValue<R> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.valuesCache.clearCachedValue(value);
    }

    @Override
    public <P, R> void clearCachedValue(@NotNull CachedValueWithParameter<P, R> value, P parameter) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.valuesCache.clearCachedValue(value, parameter);
    }
}

