/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage.impl.containers;

import com.intellij.util.containers.CollectionFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.jvm.internal.markers.KMutableMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010'\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B7\b\u0002\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0003\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00028\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0003\u00a2\u0006\u0004\b\u0007\u0010\bB\t\b\u0016\u00a2\u0006\u0004\b\u0007\u0010\tJ\u001f\u0010\n\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u001b\u0010\u0010\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00112\u0006\u0010\f\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0015\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0015\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0018\u0010\u001f\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u000b\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010 J\u0013\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00028\u0001\u00a2\u0006\u0002\u0010#J\u0017\u0010$\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u000b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010 J\u001e\u0010%\u001a\u00020\u000f2\u0014\u0010&\u001a\u0010\u0012\u0006\b\u0001\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010'H\u0016J\b\u0010-\u001a\u00020.H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00028\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00010\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0015R&\u0010*\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010+0\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u0015\u00a8\u0006/"}, d2={"Lcom/intellij/platform/workspace/storage/impl/containers/BidirectionalSetMap;", "K", "V", "", "keyToValueMap", "valueToKeysMap", "", "<init>", "(Ljava/util/Map;Ljava/util/Map;)V", "()V", "put", "key", "value", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "clear", "", "getKeysByValue", "", "(Ljava/lang/Object;)Ljava/util/Set;", "keys", "getKeys", "()Ljava/util/Set;", "size", "", "getSize", "()I", "isEmpty", "", "containsKey", "(Ljava/lang/Object;)Z", "containsValue", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "removeValue", "v", "(Ljava/lang/Object;)V", "remove", "putAll", "from", "", "values", "getValues", "entries", "", "getEntries", "toString", "", "intellij.platform.workspace.storage"})
public final class BidirectionalSetMap<K, V>
implements Map<K, V>,
KMutableMap {
    @NotNull
    private final Map<K, V> keyToValueMap;
    @NotNull
    private final Map<V, Set<K>> valueToKeysMap;

    private BidirectionalSetMap(Map<K, V> keyToValueMap, Map<V, Set<K>> valueToKeysMap) {
        this.keyToValueMap = keyToValueMap;
        this.valueToKeysMap = valueToKeysMap;
    }

    public BidirectionalSetMap() {
        Map map2 = CollectionFactory.createSmallMemoryFootprintMap();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"createSmallMemoryFootprintMap(...)");
        this(map2, new HashMap());
    }

    @Override
    @Nullable
    public V put(K key, V value) {
        Set<K> array;
        V oldValue = this.keyToValueMap.put(key, value);
        if (oldValue != null) {
            if (Intrinsics.areEqual(oldValue, value)) {
                return oldValue;
            }
            Set<K> set = this.valueToKeysMap.get(oldValue);
            Intrinsics.checkNotNull(set);
            array = set;
            array.remove(key);
            if (array.isEmpty()) {
                this.valueToKeysMap.remove(oldValue);
            }
        }
        Set<K> set = this.valueToKeysMap.computeIfAbsent((Set)value, (Function<Set, Set<Object>>)((Function<Object, Set>)arg_0 -> BidirectionalSetMap.put$lambda$1(BidirectionalSetMap::put$lambda$0, arg_0)));
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"computeIfAbsent(...)");
        array = set;
        array.add(key);
        return oldValue;
    }

    @Override
    public void clear() {
        this.keyToValueMap.clear();
        this.valueToKeysMap.clear();
    }

    @Nullable
    public final Set<K> getKeysByValue(V value) {
        return this.valueToKeysMap.get(value);
    }

    @NotNull
    public Set<K> getKeys() {
        return this.keyToValueMap.keySet();
    }

    public int getSize() {
        return this.keyToValueMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.keyToValueMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keyToValueMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.valueToKeysMap.containsKey(value);
    }

    @Override
    @Nullable
    public V get(Object key) {
        return this.keyToValueMap.get(key);
    }

    public final void removeValue(V v) {
        Set<K> ks = this.valueToKeysMap.remove(v);
        if (ks != null) {
            for (K k : ks) {
                this.keyToValueMap.remove(k);
            }
        }
    }

    @Override
    @Nullable
    public V remove(Object key) {
        V value = this.keyToValueMap.remove(key);
        Set<K> ks = this.valueToKeysMap.get(value);
        if (ks != null) {
            Boolean bl = ks.size() > 1 ? Boolean.valueOf(ks.remove(key)) : TypeIntrinsics.asMutableMap(this.valueToKeysMap).remove(value);
        }
        return value;
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> from) {
        Intrinsics.checkNotNullParameter(from, (String)"from");
        for (Map.Entry<K, V> entry : from.entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            this.put(key, value);
        }
    }

    @NotNull
    public Set<V> getValues() {
        return this.valueToKeysMap.keySet();
    }

    @NotNull
    public Set<Map.Entry<K, V>> getEntries() {
        return this.keyToValueMap.entrySet();
    }

    @NotNull
    public String toString() {
        return this.keyToValueMap.toString();
    }

    private static final Set put$lambda$0(Object it) {
        return new HashSet();
    }

    private static final Set put$lambda$1(Function1 $tmp0, Object p0) {
        return (Set)$tmp0.invoke(p0);
    }
}

