/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage.impl.external;

import com.google.common.collect.HashBiMap;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.workspace.storage.ExternalMappingKey;
import com.intellij.platform.workspace.storage.MutableExternalEntityMapping;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.impl.AbstractEntityStorage;
import com.intellij.platform.workspace.storage.impl.EntityIdKt;
import com.intellij.platform.workspace.storage.impl.MutableEntityStorageImpl;
import com.intellij.platform.workspace.storage.impl.NotThisEntityId;
import com.intellij.platform.workspace.storage.impl.ThisEntityId;
import com.intellij.platform.workspace.storage.impl.UtilsKt;
import com.intellij.platform.workspace.storage.impl.WorkspaceEntityBase;
import com.intellij.platform.workspace.storage.impl.containers.PersistentBidirectionalMap;
import com.intellij.platform.workspace.storage.impl.containers.PersistentBidirectionalMapImpl;
import com.intellij.platform.workspace.storage.impl.external.ExternalEntityMappingImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 ;*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u00039:;B)\b\u0002\u0012\u0016\u0010\u0004\u001a\u0012\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bB\t\b\u0016\u00a2\u0006\u0004\b\n\u0010\fJ\u001d\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001aJ#\u0010\u001b\u001a\u00020\u00162\n\u0010\u001c\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\u0019\u001a\u00028\u0000H\u0000\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u001d\u0010\u001f\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010!J#\u0010\"\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000$H\u0016\u00a2\u0006\u0002\u0010%J\u0017\u0010&\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00a2\u0006\u0002\u0010'J\u001d\u0010(\u001a\u0004\u0018\u00018\u00002\n\u0010\u001c\u001a\u00060\u0006j\u0002`\u0007H\u0000\u00a2\u0006\u0004\b)\u0010*J.\u0010+\u001a\u00020\u00162\n\u0010,\u001a\u0006\u0012\u0002\b\u00030\u00002\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u0002000.2\u0006\u00101\u001a\u000202J,\u00103\u001a\u00020\u00162\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u0002000.2\u0006\u00101\u001a\u0002022\u0006\u00104\u001a\u000205H\u0002J=\u00106\u001a\n\u0018\u00010\u0006j\u0004\u0018\u0001`\u00072\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u0002000.2\u0006\u00101\u001a\u0002022\n\u0010\u001c\u001a\u00060\u0006j\u0002`\u0007H\u0002\u00a2\u0006\u0002\u00107J\u000e\u00108\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002H\u0002R*\u0010\u0004\u001a\u0012\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\u0004\u0012\u00028\u00000\u0005X\u0090\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\b\u001a\u00020\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006<"}, d2={"Lcom/intellij/platform/workspace/storage/impl/external/MutableExternalEntityMappingImpl;", "T", "Lcom/intellij/platform/workspace/storage/impl/external/ExternalEntityMappingImpl;", "Lcom/intellij/platform/workspace/storage/MutableExternalEntityMapping;", "index", "Lcom/intellij/platform/workspace/storage/impl/containers/PersistentBidirectionalMap$Builder;", "", "Lcom/intellij/platform/workspace/storage/impl/EntityId;", "indexLogBunches", "Lcom/intellij/platform/workspace/storage/impl/external/MutableExternalEntityMappingImpl$IndexLog;", "<init>", "(Lcom/intellij/platform/workspace/storage/impl/containers/PersistentBidirectionalMap$Builder;Lcom/intellij/platform/workspace/storage/impl/external/MutableExternalEntityMappingImpl$IndexLog;)V", "()V", "getIndex$intellij_platform_workspace_storage", "()Lcom/intellij/platform/workspace/storage/impl/containers/PersistentBidirectionalMap$Builder;", "setIndex$intellij_platform_workspace_storage", "(Lcom/intellij/platform/workspace/storage/impl/containers/PersistentBidirectionalMap$Builder;)V", "getIndexLogBunches$intellij_platform_workspace_storage", "()Lcom/intellij/platform/workspace/storage/impl/external/MutableExternalEntityMappingImpl$IndexLog;", "setIndexLogBunches$intellij_platform_workspace_storage", "(Lcom/intellij/platform/workspace/storage/impl/external/MutableExternalEntityMappingImpl$IndexLog;)V", "addMapping", "", "entity", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "data", "(Lcom/intellij/platform/workspace/storage/WorkspaceEntity;Ljava/lang/Object;)V", "add", "id", "add$intellij_platform_workspace_storage", "(JLjava/lang/Object;)V", "addIfAbsent", "", "(Lcom/intellij/platform/workspace/storage/WorkspaceEntity;Ljava/lang/Object;)Z", "getOrPutDataByEntity", "defaultValue", "Lkotlin/Function0;", "(Lcom/intellij/platform/workspace/storage/WorkspaceEntity;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "removeMapping", "(Lcom/intellij/platform/workspace/storage/WorkspaceEntity;)Ljava/lang/Object;", "remove", "remove$intellij_platform_workspace_storage", "(J)Ljava/lang/Object;", "applyChanges", "other", "replaceMap", "Lcom/google/common/collect/HashBiMap;", "Lcom/intellij/platform/workspace/storage/impl/NotThisEntityId;", "Lcom/intellij/platform/workspace/storage/impl/ThisEntityId;", "target", "Lcom/intellij/platform/workspace/storage/impl/MutableEntityStorageImpl;", "applyChange", "record", "Lcom/intellij/platform/workspace/storage/impl/external/MutableExternalEntityMappingImpl$IndexLogRecord;", "getTargetId", "(Lcom/google/common/collect/HashBiMap;Lcom/intellij/platform/workspace/storage/impl/MutableEntityStorageImpl;J)Ljava/lang/Long;", "toImmutable", "IndexLogRecord", "IndexLog", "Companion", "intellij.platform.workspace.storage"})
@SourceDebugExtension(value={"SMAP\nExternalEntityMappingImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExternalEntityMappingImpl.kt\ncom/intellij/platform/workspace/storage/impl/external/MutableExternalEntityMappingImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,236:1\n68#2,4:237\n68#2,4:241\n14#2:248\n1863#3:245\n1864#3:247\n1#4:246\n*S KotlinDebug\n*F\n+ 1 ExternalEntityMappingImpl.kt\ncom/intellij/platform/workspace/storage/impl/external/MutableExternalEntityMappingImpl\n*L\n70#1:237,4\n104#1:241,4\n225#1:248\n115#1:245\n115#1:247\n*E\n"})
public final class MutableExternalEntityMappingImpl<T>
extends ExternalEntityMappingImpl<T>
implements MutableExternalEntityMapping<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private PersistentBidirectionalMap.Builder<Long, T> index;
    @NotNull
    private IndexLog indexLogBunches;
    @NotNull
    private static final Logger LOG;

    private MutableExternalEntityMappingImpl(PersistentBidirectionalMap.Builder<Long, T> index, IndexLog indexLogBunches) {
        super((PersistentBidirectionalMap)index);
        this.index = index;
        this.indexLogBunches = indexLogBunches;
    }

    @Override
    @NotNull
    public PersistentBidirectionalMap.Builder<Long, T> getIndex$intellij_platform_workspace_storage() {
        return this.index;
    }

    public void setIndex$intellij_platform_workspace_storage(@NotNull PersistentBidirectionalMap.Builder<Long, T> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"<set-?>");
        this.index = builder;
    }

    @NotNull
    public final IndexLog getIndexLogBunches$intellij_platform_workspace_storage() {
        return this.indexLogBunches;
    }

    public final void setIndexLogBunches$intellij_platform_workspace_storage(@NotNull IndexLog indexLog) {
        Intrinsics.checkNotNullParameter((Object)indexLog, (String)"<set-?>");
        this.indexLogBunches = indexLog;
    }

    public MutableExternalEntityMappingImpl() {
        this(new PersistentBidirectionalMapImpl().builder(), new IndexLog(new LinkedHashMap<Long, Pair<IndexLogRecord, IndexLogRecord>>()));
    }

    @Override
    public void addMapping(@NotNull WorkspaceEntity entity, T data) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.add$intellij_platform_workspace_storage(((WorkspaceEntityBase)entity).getId(), data);
        AbstractEntityStorage abstractEntityStorage = this.getEntityStorage();
        Intrinsics.checkNotNull((Object)abstractEntityStorage, (String)"null cannot be cast to non-null type com.intellij.platform.workspace.storage.impl.MutableEntityStorageImpl");
        ((MutableEntityStorageImpl)abstractEntityStorage).incModificationCount$intellij_platform_workspace_storage();
    }

    public final void add$intellij_platform_workspace_storage(long id, T data) {
        T removedValue = this.getIndex$intellij_platform_workspace_storage().put(id, data);
        if (removedValue != null) {
            this.indexLogBunches.add(id, new IndexLogRecord.Remove(id));
        }
        this.indexLogBunches.add(id, new IndexLogRecord.Add<T>(id, data));
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            String string;
            Logger logger = $this$trace$iv;
            boolean bl = false;
            try {
                T t = data;
                string = "Adding to external index: " + EntityIdKt.asString(id) + " -> " + data + ". Data hash: " + (t != null ? t.hashCode() : 0);
            }
            catch (Throwable e) {
                string = "Adding to external index. " + EntityIdKt.asString(id) + ", cannot get data info. " + e.getMessage();
            }
            logger.trace(string);
        }
    }

    @Override
    public boolean addIfAbsent(@NotNull WorkspaceEntity entity, T data) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        WorkspaceEntityBase cfr_ignored_0 = (WorkspaceEntityBase)entity;
        if (!this.getIndex$intellij_platform_workspace_storage().contains(((WorkspaceEntityBase)entity).getId())) {
            this.add$intellij_platform_workspace_storage(((WorkspaceEntityBase)entity).getId(), data);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public T getOrPutDataByEntity(@NotNull WorkspaceEntity entity, @NotNull Function0<? extends T> defaultValue) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter(defaultValue, (String)"defaultValue");
        Object object = this.getDataByEntity(entity);
        if (object == null) {
            MutableExternalEntityMappingImpl $this$getOrPutDataByEntity_u24lambda_u241 = this;
            boolean bl = false;
            Object defaultVal = defaultValue.invoke();
            $this$getOrPutDataByEntity_u24lambda_u241.add$intellij_platform_workspace_storage(((WorkspaceEntityBase)entity).getId(), defaultVal);
            object = defaultVal;
        }
        return object;
    }

    @Override
    @Nullable
    public T removeMapping(@NotNull WorkspaceEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        WorkspaceEntityBase cfr_ignored_0 = (WorkspaceEntityBase)entity;
        T removed = this.remove$intellij_platform_workspace_storage(((WorkspaceEntityBase)entity).getId());
        AbstractEntityStorage abstractEntityStorage = this.getEntityStorage();
        Intrinsics.checkNotNull((Object)abstractEntityStorage, (String)"null cannot be cast to non-null type com.intellij.platform.workspace.storage.impl.MutableEntityStorageImpl");
        ((MutableEntityStorageImpl)abstractEntityStorage).incModificationCount$intellij_platform_workspace_storage();
        return removed;
    }

    @Nullable
    public final T remove$intellij_platform_workspace_storage(long id) {
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Remove " + EntityIdKt.asString(id) + " from external index");
        }
        Object removed = this.getIndex$intellij_platform_workspace_storage().remove(id);
        if (removed != null) {
            this.indexLogBunches.add(id, new IndexLogRecord.Remove(id));
        }
        return (T)removed;
    }

    public final void applyChanges(@NotNull MutableExternalEntityMappingImpl<?> other, @NotNull HashBiMap<NotThisEntityId, ThisEntityId> replaceMap, @NotNull MutableEntityStorageImpl target) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        Intrinsics.checkNotNullParameter(replaceMap, (String)"replaceMap");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Collection<Pair<IndexLogRecord, IndexLogRecord>> collection = other.indexLogBunches.getChanges().values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IndexLogRecord it;
            Pair record = (Pair)element$iv;
            boolean bl = false;
            this.applyChange(replaceMap, target, (IndexLogRecord)record.getFirst());
            if ((IndexLogRecord)record.getSecond() == null) continue;
            boolean bl2 = false;
            this.applyChange(replaceMap, target, it);
        }
    }

    private final void applyChange(HashBiMap<NotThisEntityId, ThisEntityId> replaceMap, MutableEntityStorageImpl target, IndexLogRecord record) {
        IndexLogRecord indexLogRecord = record;
        if (indexLogRecord instanceof IndexLogRecord.Add) {
            Long l = this.getTargetId(replaceMap, target, ((IndexLogRecord.Add)record).getId());
            if (l != null) {
                long entityId = ((Number)l).longValue();
                boolean bl = false;
                this.add$intellij_platform_workspace_storage(entityId, ((IndexLogRecord.Add)record).getData());
            }
        } else if (indexLogRecord instanceof IndexLogRecord.Remove) {
            Long l = this.getTargetId(replaceMap, target, ((IndexLogRecord.Remove)record).getId());
            if (l != null) {
                long entityId = ((Number)l).longValue();
                boolean bl = false;
                this.remove$intellij_platform_workspace_storage(entityId);
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final Long getTargetId(HashBiMap<NotThisEntityId, ThisEntityId> replaceMap, MutableEntityStorageImpl target, long id) {
        ThisEntityId possibleTargetId = (ThisEntityId)replaceMap.get((Object)NotThisEntityId.box-impl(UtilsKt.notThis(id)));
        if (possibleTargetId != null) {
            return possibleTargetId.unbox-impl();
        }
        if (target.entityDataById$intellij_platform_workspace_storage(id) == null) {
            return null;
        }
        NotThisEntityId sourceId = (NotThisEntityId)replaceMap.inverse().get((Object)ThisEntityId.box-impl(UtilsKt.asThis(id)));
        return sourceId != null ? null : Long.valueOf(id);
    }

    private final ExternalEntityMappingImpl<T> toImmutable() {
        return new ExternalEntityMappingImpl(this.getIndex$intellij_platform_workspace_storage().build());
    }

    public /* synthetic */ MutableExternalEntityMappingImpl(PersistentBidirectionalMap.Builder index, IndexLog indexLogBunches, DefaultConstructorMarker $constructor_marker) {
        this(index, indexLogBunches);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MutableExternalEntityMappingImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\u0004\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u00052\u001a\u0010\b\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\tJ6\u0010\u000b\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\t2\u001a\u0010\b\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0005R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/platform/workspace/storage/impl/external/MutableExternalEntityMappingImpl$Companion;", "", "<init>", "()V", "fromMap", "", "Lcom/intellij/platform/workspace/storage/ExternalMappingKey;", "Lcom/intellij/platform/workspace/storage/impl/external/MutableExternalEntityMappingImpl;", "other", "", "Lcom/intellij/platform/workspace/storage/impl/external/ExternalEntityMappingImpl;", "toImmutable", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.workspace.storage"})
    @SourceDebugExtension(value={"SMAP\nExternalEntityMappingImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExternalEntityMappingImpl.kt\ncom/intellij/platform/workspace/storage/impl/external/MutableExternalEntityMappingImpl$Companion\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,236:1\n216#2,2:237\n216#2,2:239\n*S KotlinDebug\n*F\n+ 1 ExternalEntityMappingImpl.kt\ncom/intellij/platform/workspace/storage/impl/external/MutableExternalEntityMappingImpl$Companion\n*L\n209#1:237,2\n219#1:239,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<ExternalMappingKey<?>, MutableExternalEntityMappingImpl<?>> fromMap(@NotNull Map<ExternalMappingKey<?>, ? extends ExternalEntityMappingImpl<?>> other) {
            Intrinsics.checkNotNullParameter(other, (String)"other");
            Map result2 = new LinkedHashMap();
            Map<ExternalMappingKey<?>, ExternalEntityMappingImpl<?>> $this$forEach$iv = other;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<ExternalMappingKey<?>, ExternalEntityMappingImpl<?>>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<ExternalMappingKey<?>, ExternalEntityMappingImpl<?>> element$iv;
                Map.Entry<ExternalMappingKey<?>, ExternalEntityMappingImpl<?>> entry = element$iv = iterator2.next();
                boolean bl = false;
                ExternalMappingKey<?> identifier = entry.getKey();
                ExternalEntityMappingImpl<?> index = entry.getValue();
                if (index instanceof MutableExternalEntityMappingImpl) {
                    throw new IllegalStateException("Cannot create mutable index from mutable index".toString());
                }
                Map map2 = result2;
                PersistentBidirectionalMap<Long, ?> persistentBidirectionalMap = index.getIndex$intellij_platform_workspace_storage();
                Intrinsics.checkNotNull(persistentBidirectionalMap, (String)"null cannot be cast to non-null type com.intellij.platform.workspace.storage.impl.containers.PersistentBidirectionalMap.Immutable<kotlin.Long, out kotlin.Any?>");
                MutableExternalEntityMappingImpl mutableExternalEntityMappingImpl = new MutableExternalEntityMappingImpl(((PersistentBidirectionalMap.Immutable)persistentBidirectionalMap).builder(), new IndexLog(new LinkedHashMap<Long, Pair<IndexLogRecord, IndexLogRecord>>()), null);
                map2.put(identifier, mutableExternalEntityMappingImpl);
            }
            return result2;
        }

        @NotNull
        public final Map<ExternalMappingKey<?>, ExternalEntityMappingImpl<?>> toImmutable(@NotNull Map<ExternalMappingKey<?>, MutableExternalEntityMappingImpl<?>> other) {
            Intrinsics.checkNotNullParameter(other, (String)"other");
            Map result2 = new LinkedHashMap();
            Map<ExternalMappingKey<?>, MutableExternalEntityMappingImpl<?>> $this$forEach$iv = other;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<ExternalMappingKey<?>, MutableExternalEntityMappingImpl<?>>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<ExternalMappingKey<?>, MutableExternalEntityMappingImpl<?>> element$iv;
                Map.Entry<ExternalMappingKey<?>, MutableExternalEntityMappingImpl<?>> entry = element$iv = iterator2.next();
                boolean bl = false;
                ExternalMappingKey<?> identifier = entry.getKey();
                MutableExternalEntityMappingImpl<?> index = entry.getValue();
                result2.put(identifier, ((MutableExternalEntityMappingImpl)index).toImmutable());
            }
            Map<ExternalMappingKey<?>, ExternalEntityMappingImpl<?>> map2 = Collections.unmodifiableMap(result2);
            Intrinsics.checkNotNullExpressionValue(map2, (String)"unmodifiableMap(...)");
            return map2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B-\u0012$\u0010\u0002\u001a \u0012\b\u0012\u00060\u0004j\u0002`\u0005\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00060\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010\u000f\u001a\u00020\u0007R/\u0010\u0002\u001a \u0012\b\u0012\u00060\u0004j\u0002`\u0005\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/intellij/platform/workspace/storage/impl/external/MutableExternalEntityMappingImpl$IndexLog;", "", "changes", "Ljava/util/LinkedHashMap;", "", "Lcom/intellij/platform/workspace/storage/impl/EntityId;", "Lkotlin/Pair;", "Lcom/intellij/platform/workspace/storage/impl/external/MutableExternalEntityMappingImpl$IndexLogRecord;", "<init>", "(Ljava/util/LinkedHashMap;)V", "getChanges", "()Ljava/util/LinkedHashMap;", "add", "", "id", "operation", "intellij.platform.workspace.storage"})
    public static final class IndexLog {
        @NotNull
        private final LinkedHashMap<Long, Pair<IndexLogRecord, IndexLogRecord>> changes;

        public IndexLog(@NotNull LinkedHashMap<Long, Pair<IndexLogRecord, IndexLogRecord>> changes) {
            Intrinsics.checkNotNullParameter(changes, (String)"changes");
            this.changes = changes;
        }

        @NotNull
        public final LinkedHashMap<Long, Pair<IndexLogRecord, IndexLogRecord>> getChanges() {
            return this.changes;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final void add(long id, @NotNull IndexLogRecord operation) {
            Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
            Pair<IndexLogRecord, IndexLogRecord> existing = this.changes.get(id);
            if (existing != null) {
                IndexLogRecord indexLogRecord = operation;
                if (indexLogRecord instanceof IndexLogRecord.Add) {
                    Pair pair;
                    Object object;
                    if (existing.getSecond() == null) {
                        IndexLogRecord firstValue = (IndexLogRecord)existing.getFirst();
                        object = firstValue;
                        if (object instanceof IndexLogRecord.Add) {
                            pair = Pair.copy$default(existing, (Object)operation, null, (int)2, null);
                        } else {
                            if (!(object instanceof IndexLogRecord.Remove)) throw new NoWhenBranchMatchedException();
                            pair = Pair.copy$default(existing, null, (Object)operation, (int)1, null);
                        }
                    } else {
                        if (!(existing.getSecond() instanceof IndexLogRecord.Add)) {
                            String string = "Check failed.";
                            throw new IllegalStateException(string.toString());
                        }
                        if (!(existing.getFirst() instanceof IndexLogRecord.Remove)) {
                            String string = "Check failed.";
                            throw new IllegalStateException(string.toString());
                        }
                        pair = Pair.copy$default(existing, null, (Object)operation, (int)1, null);
                    }
                    Pair newValue = pair;
                    object = id;
                    ((Map)this.changes).put(object, newValue);
                    return;
                } else {
                    Pair newValue;
                    Pair pair;
                    Object object;
                    if (!(indexLogRecord instanceof IndexLogRecord.Remove)) throw new NoWhenBranchMatchedException();
                    if (existing.getSecond() == null) {
                        IndexLogRecord firstValue = (IndexLogRecord)existing.getFirst();
                        object = firstValue;
                        if (object instanceof IndexLogRecord.Add) {
                            pair = null;
                        } else {
                            if (!(object instanceof IndexLogRecord.Remove)) throw new NoWhenBranchMatchedException();
                            pair = Pair.copy$default(existing, (Object)operation, null, (int)2, null);
                        }
                    } else {
                        IndexLogRecord firstRemoval = (IndexLogRecord)existing.getFirst();
                        if (!(firstRemoval instanceof IndexLogRecord.Remove)) {
                            String string = "Check failed.";
                            throw new IllegalStateException(string.toString());
                        }
                        pair = newValue = Pair.copy$default(existing, null, null, (int)1, null);
                    }
                    if (newValue != null) {
                        object = id;
                        ((Map)this.changes).put(object, newValue);
                        return;
                    } else {
                        this.changes.remove(id);
                    }
                }
                return;
            } else {
                Long l = id;
                ((Map)this.changes).put(l, TuplesKt.to((Object)operation, null));
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/platform/workspace/storage/impl/external/MutableExternalEntityMappingImpl$IndexLogRecord;", "", "<init>", "()V", "Add", "Remove", "Lcom/intellij/platform/workspace/storage/impl/external/MutableExternalEntityMappingImpl$IndexLogRecord$Add;", "Lcom/intellij/platform/workspace/storage/impl/external/MutableExternalEntityMappingImpl$IndexLogRecord$Remove;", "intellij.platform.workspace.storage"})
    public static abstract class IndexLogRecord {
        private IndexLogRecord() {
        }

        public /* synthetic */ IndexLogRecord(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B\u001b\u0012\n\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0001\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\u000e\u001a\u00060\u0004j\u0002`\u0005H\u00c6\u0003J\u000e\u0010\u000f\u001a\u00028\u0001H\u00c6\u0003\u00a2\u0006\u0002\u0010\fJ,\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\f\b\u0002\u0010\u0003\u001a\u00060\u0004j\u0002`\u00052\b\b\u0002\u0010\u0006\u001a\u00028\u0001H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0011J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0015\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0006\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001a"}, d2={"Lcom/intellij/platform/workspace/storage/impl/external/MutableExternalEntityMappingImpl$IndexLogRecord$Add;", "T", "Lcom/intellij/platform/workspace/storage/impl/external/MutableExternalEntityMappingImpl$IndexLogRecord;", "id", "", "Lcom/intellij/platform/workspace/storage/impl/EntityId;", "data", "<init>", "(JLjava/lang/Object;)V", "getId", "()J", "getData", "()Ljava/lang/Object;", "Ljava/lang/Object;", "component1", "component2", "copy", "(JLjava/lang/Object;)Lcom/intellij/platform/workspace/storage/impl/external/MutableExternalEntityMappingImpl$IndexLogRecord$Add;", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.platform.workspace.storage"})
        public static final class Add<T>
        extends IndexLogRecord {
            private final long id;
            private final T data;

            public Add(long id, T data) {
                super(null);
                this.id = id;
                this.data = data;
            }

            public final long getId() {
                return this.id;
            }

            public final T getData() {
                return this.data;
            }

            public final long component1() {
                return this.id;
            }

            public final T component2() {
                return this.data;
            }

            @NotNull
            public final Add<T> copy(long id, T data) {
                return new Add<T>(id, data);
            }

            public static /* synthetic */ Add copy$default(Add add, long l, Object object, int n, Object object2) {
                if ((n & 1) != 0) {
                    l = add.id;
                }
                if ((n & 2) != 0) {
                    object = add.data;
                }
                return add.copy(l, object);
            }

            @NotNull
            public String toString() {
                return "Add(id=" + this.id + ", data=" + this.data + ")";
            }

            public int hashCode() {
                int result2 = Long.hashCode(this.id);
                result2 = result2 * 31 + (this.data == null ? 0 : this.data.hashCode());
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Add)) {
                    return false;
                }
                Add add = (Add)other;
                if (this.id != add.id) {
                    return false;
                }
                return Intrinsics.areEqual(this.data, add.data);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\t\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0003J\u0017\u0010\n\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/platform/workspace/storage/impl/external/MutableExternalEntityMappingImpl$IndexLogRecord$Remove;", "Lcom/intellij/platform/workspace/storage/impl/external/MutableExternalEntityMappingImpl$IndexLogRecord;", "id", "", "Lcom/intellij/platform/workspace/storage/impl/EntityId;", "<init>", "(J)V", "getId", "()J", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.platform.workspace.storage"})
        public static final class Remove
        extends IndexLogRecord {
            private final long id;

            public Remove(long id) {
                super(null);
                this.id = id;
            }

            public final long getId() {
                return this.id;
            }

            public final long component1() {
                return this.id;
            }

            @NotNull
            public final Remove copy(long id) {
                return new Remove(id);
            }

            public static /* synthetic */ Remove copy$default(Remove remove, long l, int n, Object object) {
                if ((n & 1) != 0) {
                    l = remove.id;
                }
                return remove.copy(l);
            }

            @NotNull
            public String toString() {
                return "Remove(id=" + this.id + ")";
            }

            public int hashCode() {
                return Long.hashCode(this.id);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Remove)) {
                    return false;
                }
                Remove remove = (Remove)other;
                return this.id == remove.id;
            }
        }
    }
}

