/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage.impl.serialization;

import com.intellij.platform.workspace.storage.impl.serialization.SerializableEntityId;
import com.intellij.platform.workspace.storage.impl.serialization.StorageInterner;
import com.intellij.platform.workspace.storage.impl.serialization.TypeInfo;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bH\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nH\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/platform/workspace/storage/impl/serialization/StorageInternerImpl;", "Lcom/intellij/platform/workspace/storage/impl/serialization/StorageInterner;", "<init>", "()V", "entityIdInterner", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/platform/workspace/storage/impl/serialization/SerializableEntityId;", "stringInterner", "", "typeInfoInterner", "Lcom/intellij/platform/workspace/storage/impl/serialization/TypeInfo;", "intern", "entityId", "string", "typeInfo", "intellij.platform.workspace.storage"})
public final class StorageInternerImpl
implements StorageInterner {
    @NotNull
    private final ConcurrentHashMap<SerializableEntityId, SerializableEntityId> entityIdInterner = new ConcurrentHashMap();
    @NotNull
    private final ConcurrentHashMap<String, String> stringInterner = new ConcurrentHashMap();
    @NotNull
    private final ConcurrentHashMap<TypeInfo, TypeInfo> typeInfoInterner = new ConcurrentHashMap();

    @Override
    @NotNull
    public SerializableEntityId intern(@NotNull SerializableEntityId entityId) {
        Intrinsics.checkNotNullParameter((Object)entityId, (String)"entityId");
        SerializableEntityId serializableEntityId = this.entityIdInterner.computeIfAbsent(entityId, Function.identity());
        Intrinsics.checkNotNullExpressionValue((Object)serializableEntityId, (String)"computeIfAbsent(...)");
        return serializableEntityId;
    }

    @Override
    @NotNull
    public String intern(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        String string2 = this.stringInterner.computeIfAbsent(string, Function.identity());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"computeIfAbsent(...)");
        return string2;
    }

    @Override
    @NotNull
    public TypeInfo intern(@NotNull TypeInfo typeInfo) {
        Intrinsics.checkNotNullParameter((Object)typeInfo, (String)"typeInfo");
        TypeInfo typeInfo2 = this.typeInfoInterner.computeIfAbsent(typeInfo, Function.identity());
        Intrinsics.checkNotNullExpressionValue((Object)typeInfo2, (String)"computeIfAbsent(...)");
        return typeInfo2;
    }
}

