/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage.metadata.diff;

import com.intellij.platform.workspace.storage.metadata.diff.ComparisonResult;
import com.intellij.platform.workspace.storage.metadata.diff.MetadataComparatorLog;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0016J\u0018\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000eH\u0016J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\bH\u0016J\b\u0010\u0013\u001a\u00020\bH\u0016J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/platform/workspace/storage/metadata/diff/NotEqualEntitiesLog;", "Lcom/intellij/platform/workspace/storage/metadata/diff/MetadataComparatorLog;", "<init>", "()V", "logLines", "Lkotlin/collections/ArrayDeque;", "Lcom/intellij/platform/workspace/storage/metadata/diff/NotEqualEntitiesLog$LogLine;", "indent", "", "startComparing", "", "toCompare", "comparisonResult", "output", "Lcom/intellij/platform/workspace/storage/metadata/diff/ComparisonResult;", "endComparing", "isCompared", "ignoreComparing", "isIgnored", "printLog", "getIndent", "indentLevel", "", "LogLine", "intellij.platform.workspace.storage"})
@SourceDebugExtension(value={"SMAP\nComparisonResult.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComparisonResult.kt\ncom/intellij/platform/workspace/storage/metadata/diff/NotEqualEntitiesLog\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,73:1\n1863#2,2:74\n*S KotlinDebug\n*F\n+ 1 ComparisonResult.kt\ncom/intellij/platform/workspace/storage/metadata/diff/NotEqualEntitiesLog\n*L\n61#1:74,2\n*E\n"})
public final class NotEqualEntitiesLog
implements MetadataComparatorLog {
    @NotNull
    private final ArrayDeque<LogLine> logLines = new ArrayDeque();
    @NotNull
    private final String indent;

    public NotEqualEntitiesLog() {
        this.indent = "  ";
    }

    @Override
    public void startComparing(@NotNull String toCompare) {
        Intrinsics.checkNotNullParameter((Object)toCompare, (String)"toCompare");
        this.logLines.addFirst((Object)new LogLine("Start comparing " + toCompare, 0, 1, 2, null));
    }

    @Override
    public void comparisonResult(@NotNull String output, @NotNull ComparisonResult comparisonResult) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)comparisonResult, (String)"comparisonResult");
        this.logLines.addLast((Object)new LogLine(output + " " + this.indent + " Result: " + comparisonResult, 0, 0, 6, null));
    }

    @Override
    public void endComparing(@NotNull String isCompared, @NotNull ComparisonResult comparisonResult) {
        Intrinsics.checkNotNullParameter((Object)isCompared, (String)"isCompared");
        Intrinsics.checkNotNullParameter((Object)comparisonResult, (String)"comparisonResult");
        this.logLines.addLast((Object)new LogLine("End comparing " + isCompared + " " + this.indent + " Result: " + comparisonResult, -1, 0, 4, null));
    }

    @Override
    public void ignoreComparing(@NotNull String isIgnored) {
        Intrinsics.checkNotNullParameter((Object)isIgnored, (String)"isIgnored");
        this.logLines.addLast((Object)new LogLine(isIgnored + " was not compared", 0, 0, 6, null));
    }

    @Override
    @NotNull
    public String printLog() {
        StringBuilder sb = new StringBuilder();
        int currentLevel = 0;
        Iterable $this$forEach$iv = (Iterable)this.logLines;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LogLine line = (LogLine)element$iv;
            boolean bl = false;
            StringBuilder stringBuilder = sb.append(this.getIndent(currentLevel += line.getLevelBefore()) + line.getString());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
            currentLevel += line.getLevelAfter();
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String getIndent(int indentLevel) {
        return StringsKt.repeat((CharSequence)this.indent, (int)indentLevel);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/intellij/platform/workspace/storage/metadata/diff/NotEqualEntitiesLog$LogLine;", "", "string", "", "levelBefore", "", "levelAfter", "<init>", "(Ljava/lang/String;II)V", "getString", "()Ljava/lang/String;", "getLevelBefore", "()I", "getLevelAfter", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "intellij.platform.workspace.storage"})
    private static final class LogLine {
        @NotNull
        private final String string;
        private final int levelBefore;
        private final int levelAfter;

        public LogLine(@NotNull String string, int levelBefore, int levelAfter) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            this.string = string;
            this.levelBefore = levelBefore;
            this.levelAfter = levelAfter;
        }

        public /* synthetic */ LogLine(String string, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 2) != 0) {
                n = 0;
            }
            if ((n3 & 4) != 0) {
                n2 = 0;
            }
            this(string, n, n2);
        }

        @NotNull
        public final String getString() {
            return this.string;
        }

        public final int getLevelBefore() {
            return this.levelBefore;
        }

        public final int getLevelAfter() {
            return this.levelAfter;
        }

        @NotNull
        public final String component1() {
            return this.string;
        }

        public final int component2() {
            return this.levelBefore;
        }

        public final int component3() {
            return this.levelAfter;
        }

        @NotNull
        public final LogLine copy(@NotNull String string, int levelBefore, int levelAfter) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            return new LogLine(string, levelBefore, levelAfter);
        }

        public static /* synthetic */ LogLine copy$default(LogLine logLine, String string, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                string = logLine.string;
            }
            if ((n3 & 2) != 0) {
                n = logLine.levelBefore;
            }
            if ((n3 & 4) != 0) {
                n2 = logLine.levelAfter;
            }
            return logLine.copy(string, n, n2);
        }

        @NotNull
        public String toString() {
            return "LogLine(string=" + this.string + ", levelBefore=" + this.levelBefore + ", levelAfter=" + this.levelAfter + ")";
        }

        public int hashCode() {
            int result2 = this.string.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.levelBefore);
            result2 = result2 * 31 + Integer.hashCode(this.levelAfter);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LogLine)) {
                return false;
            }
            LogLine logLine = (LogLine)other;
            if (!Intrinsics.areEqual((Object)this.string, (Object)logLine.string)) {
                return false;
            }
            if (this.levelBefore != logLine.levelBefore) {
                return false;
            }
            return this.levelAfter == logLine.levelAfter;
        }
    }
}

