/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.core.JavaPsiBundle;
import com.intellij.ide.IconLayerProvider;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiClassUtil;
import com.intellij.psi.util.PsiMethodUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.ui.icons.RowIcon;
import com.intellij.util.BitUtil;
import com.intellij.util.VisibilityIcons;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public final class ElementPresentationUtil {
    private static final int CLASS_KIND_INTERFACE = 10;
    private static final int CLASS_KIND_ANNOTATION = 20;
    public static final int CLASS_KIND_CLASS = 30;
    private static final int CLASS_KIND_ANONYMOUS = 40;
    private static final int CLASS_KIND_ENUM = 50;
    private static final int CLASS_KIND_ASPECT = 60;
    public static final int CLASS_KIND_JSP = 70;
    public static final int CLASS_KIND_EXCEPTION = 80;
    public static final int CLASS_KIND_JUNIT_TEST = 90;
    public static final int CLASS_KIND_RUNNABLE = 100;
    private static final int CLASS_KIND_RECORD = 110;
    public static final int FLAGS_ABSTRACT = 256;
    public static final int FLAGS_STATIC = 512;
    public static final int FLAGS_FINAL = 1024;
    public static final int FLAGS_JUNIT_TEST = 8192;
    public static final int FLAGS_RUNNABLE = 16384;
    private static final Key<CachedValue<Integer>> CLASS_KIND_KEY = new Key("CLASS_KIND");
    private static final Int2ObjectMap<Icon> BASE_ICON = new Int2ObjectOpenHashMap<Icon>(20);

    private ElementPresentationUtil() {
    }

    public static int getFlags(PsiModifierListOwner element, boolean isLocked) {
        boolean isEnum = element instanceof PsiClass && ((PsiClass)element).isEnum();
        int flags = (element.hasModifierProperty("final") && !isEnum ? 1024 : 0) | (element.hasModifierProperty("static") && !isEnum ? 512 : 0) | (isLocked ? 2048 : 0);
        if (element instanceof PsiClass) {
            int kind;
            PsiClass aClass = (PsiClass)element;
            if (element.hasModifierProperty("abstract") && !((PsiClass)element).isInterface()) {
                flags |= 0x100;
            }
            if ((kind = ElementPresentationUtil.getClassKind(aClass)) == 90) {
                flags |= 0x2000;
            } else if (kind == 100) {
                flags |= 0x4000;
            }
        }
        return flags;
    }

    public static int getBasicClassKind(PsiClass aClass) {
        if (!aClass.isValid()) {
            return 30;
        }
        if (aClass.isAnnotationType()) {
            return 20;
        }
        if (aClass.isEnum()) {
            return 50;
        }
        if (aClass.isRecord()) {
            return 110;
        }
        if (aClass.isInterface()) {
            return 10;
        }
        if (aClass instanceof PsiAnonymousClass) {
            return 40;
        }
        return 30;
    }

    public static int getClassKind(PsiClass aClass) {
        if (!aClass.isValid()) {
            aClass.putUserData(CLASS_KIND_KEY, null);
            return 30;
        }
        CachedValue<Integer> value = aClass.getUserData(CLASS_KIND_KEY);
        if (value == null) {
            value = CachedValuesManager.getManager(aClass.getProject()).createCachedValue(aClass, () -> CachedValueProvider.Result.createSingleDependency(ElementPresentationUtil.getClassKindImpl(aClass), aClass), false);
            aClass.putUserData(CLASS_KIND_KEY, value);
        }
        return value.getValue();
    }

    private static int getClassKindImpl(PsiClass aClass) {
        if (!aClass.isValid()) {
            return 30;
        }
        if (aClass.isAnnotationType()) {
            return 20;
        }
        if (aClass.isEnum()) {
            return 50;
        }
        if (aClass.isRecord()) {
            return 110;
        }
        if (aClass.isInterface()) {
            return 10;
        }
        if (aClass instanceof PsiAnonymousClass) {
            return 40;
        }
        if (!DumbService.getInstance(aClass.getProject()).isDumb()) {
            boolean isException;
            PsiManager manager = aClass.getManager();
            PsiClass javaLangTrowable = JavaPsiFacade.getInstance(manager.getProject()).findClass("java.lang.Throwable", aClass.getResolveScope());
            boolean bl = isException = javaLangTrowable != null && InheritanceUtil.isInheritorOrSelf(aClass, javaLangTrowable, true);
            if (isException) {
                return 80;
            }
            if (TestFrameworks.getInstance().isTestClass(aClass)) {
                return 90;
            }
            if (PsiClassUtil.isRunnableClass(aClass, false) && PsiMethodUtil.findMainMethod(aClass) != null) {
                return 100;
            }
        }
        return 30;
    }

    @NotNull
    public static Icon getClassIconOfKind(@NotNull PsiClass aClass, int classKind) {
        boolean isAbstract;
        Icon result2;
        if (aClass == null) {
            ElementPresentationUtil.$$$reportNull$$$0(0);
        }
        if ((result2 = (Icon)BASE_ICON.get(classKind | ((isAbstract = aClass.hasModifierProperty("abstract")) ? 256 : 0))) == null) {
            throw new NullPointerException("No icon registered for the class " + aClass + " of kind " + classKind + " (isAbstract=" + isAbstract + ")");
        }
        Icon icon = result2;
        if (icon == null) {
            ElementPresentationUtil.$$$reportNull$$$0(1);
        }
        return icon;
    }

    public static String getDescription(PsiModifierListOwner member) {
        String noun;
        if (member instanceof PsiClass) {
            noun = ElementPresentationUtil.getClassNoun((PsiClass)member);
        } else if (member instanceof PsiMethod) {
            noun = JavaPsiBundle.message("node.method.tooltip", new Object[0]);
        } else if (member instanceof PsiField) {
            noun = JavaPsiBundle.message("node.field.tooltip", new Object[0]);
        } else {
            return null;
        }
        String adj = ElementPresentationUtil.getFlagsDescription(member);
        return (adj + " " + noun).trim();
    }

    private static String getClassNoun(PsiClass aClass) {
        String noun;
        int kind = ElementPresentationUtil.getClassKind(aClass);
        switch (kind) {
            case 20: {
                noun = JavaPsiBundle.message("node.annotation.tooltip", new Object[0]);
                break;
            }
            case 40: {
                noun = JavaPsiBundle.message("node.anonymous.class.tooltip", new Object[0]);
                break;
            }
            case 50: {
                noun = JavaPsiBundle.message("node.enum.tooltip", new Object[0]);
                break;
            }
            case 110: {
                noun = JavaPsiBundle.message("node.record.tooltip", new Object[0]);
                break;
            }
            case 80: {
                noun = JavaPsiBundle.message("node.exception.tooltip", new Object[0]);
                break;
            }
            case 10: {
                noun = JavaPsiBundle.message("node.interface.tooltip", new Object[0]);
                break;
            }
            case 90: {
                noun = JavaPsiBundle.message("node.junit.test.tooltip", new Object[0]);
                break;
            }
            case 100: {
                noun = JavaPsiBundle.message("node.runnable.class.tooltip", new Object[0]);
                break;
            }
            default: {
                noun = JavaPsiBundle.message("node.class.tooltip", new Object[0]);
            }
        }
        return noun;
    }

    private static String getFlagsDescription(PsiModifierListOwner aClass) {
        int level;
        PsiModifierList list;
        int flags = ElementPresentationUtil.getFlags(aClass, false);
        StringBuilder adj = new StringBuilder();
        for (IconLayerProvider provider : IconLayerProvider.EP_NAME.getExtensionList()) {
            if (provider.getLayerIcon(aClass, false) == null) continue;
            adj.append(" ").append(provider.getLayerDescription());
        }
        if (BitUtil.isSet(flags, 256)) {
            adj.append(" ").append(JavaPsiBundle.message("node.abstract.flag.tooltip", new Object[0]));
        }
        if (BitUtil.isSet(flags, 1024)) {
            adj.append(" ").append(JavaPsiBundle.message("node.final.flag.tooltip", new Object[0]));
        }
        if (BitUtil.isSet(flags, 512)) {
            adj.append(" ").append(JavaPsiBundle.message("node.static.flag.tooltip", new Object[0]));
        }
        if ((list = aClass.getModifierList()) != null && (level = PsiUtil.getAccessLevel(list)) != 4) {
            adj.append(" ").append(Strings.capitalize(JavaPsiBundle.visibilityPresentation(PsiUtil.getAccessModifier(level))));
        }
        return adj.toString();
    }

    public static Icon addVisibilityIcon(PsiModifierListOwner element, int flags, RowIcon baseIcon) {
        if (BitUtil.isSet(flags, 1)) {
            VisibilityIcons.setVisibilityIcon(element.getModifierList(), baseIcon);
        }
        return baseIcon;
    }

    static {
        IconManager iconManager = IconManager.getInstance();
        BASE_ICON.put(30, iconManager.tooltipOnlyIfComposite(iconManager.getPlatformIcon(PlatformIcons.Class)));
        BASE_ICON.put(286, iconManager.getPlatformIcon(PlatformIcons.AbstractClass));
        BASE_ICON.put(20, iconManager.getPlatformIcon(PlatformIcons.Annotation));
        BASE_ICON.put(276, iconManager.getPlatformIcon(PlatformIcons.Annotation));
        BASE_ICON.put(40, iconManager.getPlatformIcon(PlatformIcons.AnonymousClass));
        BASE_ICON.put(296, iconManager.getPlatformIcon(PlatformIcons.AnonymousClass));
        BASE_ICON.put(60, iconManager.getPlatformIcon(PlatformIcons.Aspect));
        BASE_ICON.put(316, iconManager.getPlatformIcon(PlatformIcons.Aspect));
        BASE_ICON.put(50, iconManager.getPlatformIcon(PlatformIcons.Enum));
        BASE_ICON.put(306, iconManager.getPlatformIcon(PlatformIcons.Enum));
        BASE_ICON.put(80, iconManager.getPlatformIcon(PlatformIcons.ExceptionClass));
        BASE_ICON.put(336, iconManager.getPlatformIcon(PlatformIcons.AbstractException));
        BASE_ICON.put(10, iconManager.tooltipOnlyIfComposite(iconManager.getPlatformIcon(PlatformIcons.Interface)));
        BASE_ICON.put(266, iconManager.tooltipOnlyIfComposite(iconManager.getPlatformIcon(PlatformIcons.Interface)));
        BASE_ICON.put(90, iconManager.tooltipOnlyIfComposite(iconManager.getPlatformIcon(PlatformIcons.Class)));
        BASE_ICON.put(346, iconManager.getPlatformIcon(PlatformIcons.AbstractClass));
        BASE_ICON.put(110, iconManager.getPlatformIcon(PlatformIcons.Record));
        BASE_ICON.put(100, iconManager.getPlatformIcon(PlatformIcons.Class));
        iconManager = IconManager.getInstance();
        iconManager.registerIconLayer(512, iconManager.getPlatformIcon(PlatformIcons.StaticMark));
        iconManager.registerIconLayer(1024, iconManager.getPlatformIcon(PlatformIcons.FinalMark));
        iconManager.registerIconLayer(8192, iconManager.getPlatformIcon(PlatformIcons.JunitTestMark));
        iconManager.registerIconLayer(16384, iconManager.getPlatformIcon(PlatformIcons.RunnableMark));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/ElementPresentationUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/ElementPresentationUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassIconOfKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getClassIconOfKind";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

