/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFragment;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiTemplate;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.impl.source.tree.injected.StringLiteralEscaper;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiLiteralUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiFragmentImpl
extends LeafPsiElement
implements PsiFragment {
    private static final Key<Integer> FRAGMENT_INDENT_KEY = Key.create("FRAGMENT_INDENT_KEY");

    public PsiFragmentImpl(@NotNull IElementType type, @NotNull CharSequence text) {
        if (type == null) {
            PsiFragmentImpl.$$$reportNull$$$0(0);
        }
        if (text == null) {
            PsiFragmentImpl.$$$reportNull$$$0(1);
        }
        super(type, text);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            PsiFragmentImpl.$$$reportNull$$$0(2);
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitFragment(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    @Nullable
    public String getValue() {
        String content = PsiFragmentImpl.getFragmentContent(this);
        if (content == null) {
            return null;
        }
        CharSequence sequence = CodeInsightUtilCore.parseStringCharacters(content, null);
        if (sequence == null) {
            return null;
        }
        return sequence.toString();
    }

    @Override
    public boolean isValidHost() {
        return true;
    }

    @Override
    public PsiLanguageInjectionHost updateText(@NotNull String text) {
        if (text == null) {
            PsiFragmentImpl.$$$reportNull$$$0(3);
        }
        ASTNode valueNode = this.getNode();
        assert (valueNode instanceof LeafElement);
        ((LeafElement)valueNode).replaceWithText(text);
        return this;
    }

    @Override
    @NotNull
    public LiteralTextEscaper<? extends PsiLanguageInjectionHost> createLiteralTextEscaper() {
        return new StringLiteralEscaper<PsiFragmentImpl>(this);
    }

    private static String getFragmentContent(PsiFragment fragment) {
        IElementType tokenType = fragment.getTokenType();
        if (tokenType == JavaTokenType.STRING_TEMPLATE_BEGIN || tokenType == JavaTokenType.STRING_TEMPLATE_MID) {
            String text = fragment.getText();
            return text.substring(1, text.length() - 2);
        }
        if (tokenType == JavaTokenType.STRING_TEMPLATE_END) {
            String text = fragment.getText();
            if (!text.endsWith("\"")) {
                return null;
            }
            return text.substring(1, text.length() - 1);
        }
        return PsiFragmentImpl.getTextBlockFragmentContent(fragment);
    }

    @Nullable
    private static String getTextBlockFragmentContent(PsiFragment fragment) {
        String content;
        IElementType tokenType = fragment.getTokenType();
        String text = fragment.getText();
        if (tokenType == JavaTokenType.TEXT_BLOCK_TEMPLATE_BEGIN) {
            char c;
            if (!text.startsWith("\"\"\"")) {
                return null;
            }
            int start = 3;
            while ((c = text.charAt(start++)) != '\n') {
                if (PsiLiteralUtil.isTextBlockWhiteSpace(c) && start != text.length()) continue;
                return null;
            }
            content = text.substring(start, text.length() - 2);
        } else if (tokenType == JavaTokenType.TEXT_BLOCK_TEMPLATE_MID) {
            content = text.substring(1, text.length() - 2);
        } else if (tokenType == JavaTokenType.TEXT_BLOCK_TEMPLATE_END) {
            if (!text.endsWith("\"\"\"")) {
                return null;
            }
            content = text.substring(1, text.length() - 3);
        } else {
            return null;
        }
        int indent = PsiFragmentImpl.getTextBlockFragmentIndent(fragment);
        return indent < 0 ? null : PsiFragmentImpl.stripTextBlockIndent(tokenType, content, indent);
    }

    @NotNull
    private static String stripTextBlockIndent(IElementType tokenType, String content, int indent) {
        StringBuilder result2 = new StringBuilder();
        int strip = tokenType == JavaTokenType.TEXT_BLOCK_TEMPLATE_BEGIN ? 0 : -1;
        int length = content.length();
        for (int i = 0; i < length; ++i) {
            int end;
            char c = content.charAt(i);
            if (strip >= 0) {
                if (c == '\n') {
                    strip = -1;
                } else if (strip <= indent) {
                    ++strip;
                }
            }
            if (c == '\n') {
                char d;
                while (result2.length() > 0 && (d = result2.charAt(end = result2.length() - 1)) != '\n' && Character.isWhitespace(d)) {
                    result2.deleteCharAt(end);
                }
                strip = 0;
            } else if (strip > indent && indent > 0) {
                end = result2.length();
                result2.delete(end - indent, end);
                strip = -1;
            }
            result2.append(c);
        }
        if (strip == indent) {
            int end = result2.length();
            result2.delete(end - indent, end);
        }
        String string = result2.toString();
        if (string == null) {
            PsiFragmentImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    public static int getTextBlockFragmentIndent(PsiFragment fragment) {
        PsiElement parent = fragment.getParent();
        if (!(parent instanceof PsiTemplate)) {
            return -1;
        }
        PsiTemplate template = (PsiTemplate)parent;
        Integer cache2 = template.getUserData(FRAGMENT_INDENT_KEY);
        if (cache2 != null) {
            return cache2;
        }
        StringBuilder sb = new StringBuilder();
        for (PsiFragment templateFragment : template.getFragments()) {
            sb.append(templateFragment.getText());
        }
        String[] lines = PsiLiteralUtil.getTextBlockLines(sb.toString());
        if (lines == null) {
            return -1;
        }
        int indent = PsiLiteralUtil.getTextBlockIndent(lines);
        fragment.putUserData(FRAGMENT_INDENT_KEY, indent);
        return indent;
    }

    @Override
    public IElementType getTokenType() {
        return this.getElementType();
    }

    @Override
    public boolean isTextBlock() {
        IElementType token2 = this.getElementType();
        return token2 == JavaTokenType.TEXT_BLOCK_TEMPLATE_BEGIN || token2 == JavaTokenType.TEXT_BLOCK_TEMPLATE_MID || token2 == JavaTokenType.TEXT_BLOCK_TEMPLATE_END;
    }

    @Override
    public String toString() {
        return "PsiFragment:" + this.getElementType();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/java/PsiFragmentImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/java/PsiFragmentImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "stripTextBlockIndent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateText";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

