/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiQualifiedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.JavaPsiConstructorUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RefactoringChangeUtil {
    private static final Logger LOG = Logger.getInstance(RefactoringChangeUtil.class);

    public static PsiType getTypeByExpression(PsiExpression expr) {
        PsiType type;
        PsiType psiType = type = expr != null ? expr.getType() : null;
        if (type == null) {
            PsiExpression[] initializers;
            if (expr instanceof PsiArrayInitializerExpression && (initializers = ((PsiArrayInitializerExpression)expr).getInitializers()).length > 0) {
                PsiType initType = RefactoringChangeUtil.getTypeByExpression(initializers[0]);
                if (initType == null) {
                    return null;
                }
                return initType.createArrayType();
            }
            if (expr instanceof PsiReferenceExpression && PsiUtil.isOnAssignmentLeftHand(expr)) {
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)PsiTreeUtil.skipParentsOfType(expr, PsiParenthesizedExpression.class);
                return RefactoringChangeUtil.getTypeByExpression(Objects.requireNonNull(assignmentExpression).getRExpression());
            }
            return null;
        }
        return GenericsUtil.getVariableTypeByExpressionType(type);
    }

    public static PsiReferenceExpression qualifyReference(@NotNull PsiReferenceExpression referenceExpression, @NotNull PsiMember member, @Nullable PsiClass qualifyingClass) throws IncorrectOperationException {
        PsiReferenceExpression expressionFromText;
        if (referenceExpression == null) {
            RefactoringChangeUtil.$$$reportNull$$$0(0);
        }
        if (member == null) {
            RefactoringChangeUtil.$$$reportNull$$$0(1);
        }
        PsiManager manager = referenceExpression.getManager();
        PsiMethodCallExpression methodCallExpression = PsiTreeUtil.getParentOfType((PsiElement)referenceExpression, PsiMethodCallExpression.class, true);
        while (methodCallExpression != null) {
            if (JavaPsiConstructorUtil.isConstructorCall(methodCallExpression)) {
                return referenceExpression;
            }
            methodCallExpression = PsiTreeUtil.getParentOfType((PsiElement)methodCallExpression, PsiMethodCallExpression.class, true);
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory(manager.getProject());
        if (qualifyingClass == null) {
            PsiClass parentClass = PsiTreeUtil.getParentOfType((PsiElement)referenceExpression, PsiClass.class);
            PsiClass containingClass = member.getContainingClass();
            if (parentClass != null && !InheritanceUtil.isInheritorOrSelf(parentClass, containingClass, true)) {
                while (parentClass != null && !InheritanceUtil.isInheritorOrSelf(parentClass, containingClass, true)) {
                    parentClass = PsiTreeUtil.getParentOfType((PsiElement)parentClass, PsiClass.class, true);
                }
                LOG.assertTrue(parentClass != null);
                expressionFromText = (PsiReferenceExpression)factory.createExpressionFromText("A.this." + member.getName(), null);
                PsiThisExpression thisExpression = (PsiThisExpression)expressionFromText.getQualifierExpression();
                assert (thisExpression != null);
                PsiJavaCodeReferenceElement qualifier = thisExpression.getQualifier();
                assert (qualifier != null);
                qualifier.replace(factory.createClassReferenceElement(parentClass));
            } else {
                PsiModifierListOwner staticElement = PsiUtil.getEnclosingStaticElement(referenceExpression, null);
                if (staticElement != null && containingClass != null && !PsiTreeUtil.isAncestor(staticElement, containingClass, false)) {
                    return referenceExpression;
                }
                expressionFromText = (PsiReferenceExpression)factory.createExpressionFromText("this." + member.getName(), null);
            }
        } else {
            expressionFromText = (PsiReferenceExpression)factory.createExpressionFromText("A." + member.getName(), null);
            expressionFromText.setQualifierExpression(factory.createReferenceExpression(qualifyingClass));
        }
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance(manager.getProject());
        expressionFromText = (PsiReferenceExpression)codeStyleManager.reformat(expressionFromText);
        return (PsiReferenceExpression)referenceExpression.replace(expressionFromText);
    }

    public static PsiClass getThisClass(@NotNull PsiElement place) {
        PsiElement parent;
        if (place == null) {
            RefactoringChangeUtil.$$$reportNull$$$0(2);
        }
        if ((parent = place.getContext()) == null) {
            return null;
        }
        PsiElement prev = null;
        do {
            if (parent instanceof PsiClass && (!(parent instanceof PsiAnonymousClass) || ((PsiAnonymousClass)parent).getArgumentList() != prev)) {
                return (PsiClass)parent;
            }
            prev = parent;
        } while ((parent = parent.getContext()) != null);
        return null;
    }

    @Nullable
    public static PsiClass getQualifierClass(@NotNull PsiReferenceExpression expression) {
        PsiExpression qualifierExpression;
        if (expression == null) {
            RefactoringChangeUtil.$$$reportNull$$$0(3);
        }
        if ((qualifierExpression = expression.getQualifierExpression()) != null) {
            PsiClass aClass;
            PsiType expressionType = qualifierExpression.getType();
            if (expressionType instanceof PsiCapturedWildcardType) {
                expressionType = ((PsiCapturedWildcardType)expressionType).getUpperBound();
            }
            if ((aClass = PsiUtil.resolveClassInType(expressionType)) != null) {
                return aClass;
            }
            if (qualifierExpression instanceof PsiReferenceExpression) {
                PsiElement qResolved = ((PsiReferenceExpression)qualifierExpression).resolve();
                return qResolved instanceof PsiClass ? (PsiClass)qResolved : null;
            }
            return null;
        }
        return RefactoringChangeUtil.getThisClass(expression);
    }

    static <T extends PsiQualifiedExpression> T createQualifiedExpression(@NotNull PsiManager manager, PsiClass qualifierClass, @NotNull String qName) throws IncorrectOperationException {
        if (manager == null) {
            RefactoringChangeUtil.$$$reportNull$$$0(4);
        }
        if (qName == null) {
            RefactoringChangeUtil.$$$reportNull$$$0(5);
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory(manager.getProject());
        if (qualifierClass != null) {
            PsiQualifiedExpression qualifiedThis = (PsiQualifiedExpression)factory.createExpressionFromText("q." + qName, qualifierClass);
            qualifiedThis = (PsiQualifiedExpression)CodeStyleManager.getInstance(manager.getProject()).reformat(qualifiedThis);
            PsiJavaCodeReferenceElement thisQualifier = qualifiedThis.getQualifier();
            LOG.assertTrue(thisQualifier != null);
            thisQualifier.bindToElement(qualifierClass);
            return (T)qualifiedThis;
        }
        return (T)((PsiQualifiedExpression)factory.createExpressionFromText(qName, null));
    }

    @NotNull
    public static PsiThisExpression createThisExpression(PsiManager manager, PsiClass qualifierClass) throws IncorrectOperationException {
        PsiThisExpression psiThisExpression = (PsiThisExpression)RefactoringChangeUtil.createQualifiedExpression(manager, qualifierClass, "this");
        if (psiThisExpression == null) {
            RefactoringChangeUtil.$$$reportNull$$$0(6);
        }
        return psiThisExpression;
    }

    @NotNull
    public static PsiSuperExpression createSuperExpression(PsiManager manager, PsiClass qualifierClass) throws IncorrectOperationException {
        PsiSuperExpression psiSuperExpression = (PsiSuperExpression)RefactoringChangeUtil.createQualifiedExpression(manager, qualifierClass, "super");
        if (psiSuperExpression == null) {
            RefactoringChangeUtil.$$$reportNull$$$0(7);
        }
        return psiSuperExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/util/RefactoringChangeUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/util/RefactoringChangeUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createThisExpression";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createSuperExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "qualifyReference";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getThisClass";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierClass";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createQualifiedExpression";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

