/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.concurrency.ThreadContext;
import com.intellij.openapi.application.AccessToken;
import com.intellij.util.concurrency.ChildContext;
import com.intellij.util.concurrency.Propagation;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import org.jetbrains.annotations.Async;
import org.jetbrains.annotations.NotNull;

final class ContextCallable<V>
implements Callable<V> {
    private final boolean myRoot;
    @NotNull
    private final ChildContext myChildContext;
    @NotNull
    private final Callable<? extends V> myCallable;

    @Async.Schedule
    ContextCallable(boolean root, @NotNull ChildContext context, @NotNull Callable<? extends V> callable) {
        if (context == null) {
            ContextCallable.$$$reportNull$$$0(0);
        }
        if (callable == null) {
            ContextCallable.$$$reportNull$$$0(1);
        }
        this.myRoot = root;
        this.myChildContext = context;
        this.myCallable = callable;
    }

    @Override
    @Async.Execute
    public V call() throws Exception {
        RunResult result2;
        if (this.myRoot) {
            result2 = (RunResult)this.myChildContext.runInChildContext(true, () -> {
                try {
                    return new RunResult(this.myCallable.call());
                }
                catch (Exception e) {
                    return new RunResult(e);
                }
            });
        } else {
            Supplier<RunResult> temp = () -> {
                try (AccessToken ignored = ThreadContext.installThreadContext(this.myChildContext.getContext(), true);){
                    AccessToken ignored2 = this.myChildContext.applyContextActions(false);
                    try {
                        RunResult runResult = new RunResult(this.myCallable.call());
                        if (ignored2 != null) {
                            ignored2.close();
                        }
                        return runResult;
                    }
                    catch (Exception e) {
                        try {
                            RunResult runResult = new RunResult(e);
                            if (ignored2 != null) {
                                ignored2.close();
                            }
                            if (ignored != null) {
                                ignored.close();
                            }
                            return runResult;
                        }
                        catch (Throwable throwable) {
                            if (ignored2 != null) {
                                try {
                                    ignored2.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                    }
                }
            };
            Continuation<Unit> continuation = this.myChildContext.getContinuation();
            result2 = continuation == null ? temp.get() : (RunResult)Propagation.runAsCoroutine(continuation, true, temp::get);
        }
        return result2.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "callable";
                break;
            }
        }
        objectArray[1] = "com/intellij/util/concurrency/ContextCallable";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class RunResult<V, E extends Exception> {
        Object result;
        boolean isSuccess;

        RunResult(V result2) {
            this.result = result2;
            this.isSuccess = true;
        }

        RunResult(E error) {
            this.result = error;
            this.isSuccess = false;
        }

        V get() throws E {
            if (this.isSuccess) {
                return (V)this.result;
            }
            throw (Exception)this.result;
        }
    }
}

