/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.ConcurrentBitSetImpl;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.DataInputStream;
import java.io.IOException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface ConcurrentBitSet {
    @NotNull
    @Contract(value="->new")
    public static ConcurrentBitSet create() {
        return new ConcurrentBitSetImpl();
    }

    @NotNull
    @Contract(value="_->new")
    public static ConcurrentBitSet create(int estimatedSize) {
        return new ConcurrentBitSetImpl(estimatedSize);
    }

    public boolean set(int var1);

    public void set(int var1, boolean var2);

    public boolean clear(int var1);

    public void clear();

    public boolean get(int var1);

    public int nextSetBit(int var1);

    public int nextClearBit(int var1);

    public int size();

    public int cardinality();

    public int @NotNull [] toIntArray();

    @NotNull
    public static ConcurrentBitSet readFrom(@NotNull DataInputStream inputStream) throws IOException {
        if (inputStream == null) {
            ConcurrentBitSet.$$$reportNull$$$0(0);
        }
        IntArrayList list = new IntArrayList();
        while (inputStream.available() > 0) {
            list.add(inputStream.readInt());
        }
        return new ConcurrentBitSetImpl(list.toIntArray());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputStream", "com/intellij/util/containers/ConcurrentBitSet", "readFrom"));
    }
}

