/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.graph.impl;

import com.intellij.openapi.util.Pair;
import com.intellij.util.graph.Graph;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class SimpleCyclesIterator<Node> {
    private Graph<Node> myGraph;
    @NotNull
    private Consumer<? super List<Node>> myCycleConsumer;
    private Node[] myIToV;
    private Map<Node, Integer> myVToI;
    private Set<Node> myBlocked;
    private Map<Node, Set<Node>> myBSets;
    private ArrayDeque<Node> myStack;
    private List<Set<Node>> myFoundSCCs;
    private int myIndex;
    private Map<Node, Integer> myVIndex;
    private Map<Node, Integer> myVLowlink;
    private ArrayDeque<Node> myPath;
    private Set<Node> myPathSet;

    public SimpleCyclesIterator(@NotNull Graph<Node> graph2) {
        if (graph2 == null) {
            SimpleCyclesIterator.$$$reportNull$$$0(0);
        }
        this.myCycleConsumer = null;
        this.myIToV = null;
        this.myVToI = null;
        this.myBlocked = null;
        this.myBSets = null;
        this.myStack = null;
        this.myFoundSCCs = null;
        this.myIndex = 0;
        this.myVIndex = null;
        this.myVLowlink = null;
        this.myPath = null;
        this.myPathSet = null;
        this.myGraph = graph2;
    }

    public void iterateSimpleCycles(@NotNull Consumer<? super List<Node>> consumer2) {
        Pair<Graph<Node>, Integer> minSCCGResult;
        if (consumer2 == null) {
            SimpleCyclesIterator.$$$reportNull$$$0(1);
        }
        if (this.myGraph == null) {
            throw new IllegalArgumentException("Null graph.");
        }
        this.initState(consumer2);
        int size = this.myGraph.getNodes().size();
        for (int startIndex = 0; startIndex < size && (minSCCGResult = this.findMinSCSG(startIndex)) != null; ++startIndex) {
            startIndex = minSCCGResult.getSecond();
            Graph<Node> scg = minSCCGResult.getFirst();
            Node startV = this.toV(startIndex);
            scg.getOut(startV).forEachRemaining(Node2 -> {
                this.myBlocked.remove(Node2);
                this.getBSet(Node2).clear();
            });
            this.findCyclesInSCG(startIndex, startIndex, scg);
        }
        this.clearState();
    }

    private Pair<Graph<Node>, Integer> findMinSCSG(int startIndex) {
        this.initMinSCGState();
        List<Set<Node>> foundSCCs = this.findSCCS(startIndex);
        int minIndexFound = Integer.MAX_VALUE;
        Set<Node> minSCC = null;
        for (Set<Node> set : foundSCCs) {
            for (Node Node3 : set) {
                int t = this.toI(Node3);
                if (t >= minIndexFound) continue;
                minIndexFound = t;
                minSCC = set;
            }
        }
        if (minSCC == null) {
            return null;
        }
        HashMap resultGraph = new HashMap();
        for (Object Node2 : minSCC) {
            resultGraph.putIfAbsent(Node2, new HashSet());
        }
        for (Object Node2 : minSCC) {
            for (Object w : minSCC) {
                if (!this.containsEdge(this.myGraph, Node2, w)) continue;
                ((Set)resultGraph.get(Node2)).add(w);
            }
        }
        Pair<Graph<Node>, Integer> pair = Pair.create(this.toGraph(resultGraph), minIndexFound);
        this.clearMinSCCState();
        return pair;
    }

    @NotNull
    private Graph<Node> toGraph(final Map<Node, Set<Node>> resultGraph) {
        return new Graph<Node>(){

            @Override
            @NotNull
            public Collection<Node> getNodes() {
                Set set = resultGraph.keySet();
                if (set == null) {
                    1.$$$reportNull$$$0(0);
                }
                return set;
            }

            @Override
            @NotNull
            public Iterator<Node> getIn(Node node) {
                Iterator iterator2 = Collections.emptyIterator();
                if (iterator2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return iterator2;
            }

            @Override
            @NotNull
            public Iterator<Node> getOut(Node node) {
                Set nodes = (Set)resultGraph.get(node);
                Iterator<Object> iterator2 = nodes != null ? nodes.iterator() : Collections.emptyIterator();
                if (iterator2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                return iterator2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/util/graph/impl/SimpleCyclesIterator$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getNodes";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIn";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getOut";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    private boolean containsEdge(Graph<Node> graph2, Node source, Node target) {
        Iterator<Node> successors = graph2.getOut(source);
        while (successors.hasNext()) {
            Node successor = successors.next();
            if (!successor.equals(target)) continue;
            return true;
        }
        return false;
    }

    private List<Set<Node>> findSCCS(int startIndex) {
        for (Node Node2 : this.myGraph.getNodes()) {
            int vI = this.toI(Node2);
            if (vI < startIndex || this.myVIndex.containsKey(Node2)) continue;
            this.getSCCs(startIndex, vI);
        }
        List<Set<Node>> result2 = this.myFoundSCCs;
        this.myFoundSCCs = null;
        return result2;
    }

    private void getSCCs(int startIndex, int vertexIndex) {
        Node vertex = this.toV(vertexIndex);
        this.myVIndex.put(vertex, this.myIndex);
        this.myVLowlink.put(vertex, this.myIndex);
        ++this.myIndex;
        this.myPath.push(vertex);
        this.myPathSet.add(vertex);
        HashSet successors = new HashSet();
        this.myGraph.getOut(vertex).forEachRemaining(successors::add);
        for (Object successor : successors) {
            int successorIndex = this.toI(successor);
            if (successorIndex < startIndex) continue;
            if (!this.myVIndex.containsKey(successor)) {
                this.getSCCs(startIndex, successorIndex);
                this.myVLowlink.put(vertex, Math.min(this.myVLowlink.get(vertex), this.myVLowlink.get(successor)));
                continue;
            }
            if (!this.myPathSet.contains(successor)) continue;
            this.myVLowlink.put(vertex, Math.min(this.myVLowlink.get(vertex), this.myVIndex.get(successor)));
        }
        if (this.myVLowlink.get(vertex).equals(this.myVIndex.get(vertex))) {
            Node temp;
            HashSet<Node> result2 = new HashSet<Node>();
            do {
                temp = this.myPath.pop();
                this.myPathSet.remove(temp);
                result2.add(temp);
            } while (!vertex.equals(temp));
            if (result2.size() == 1) {
                Object Node2 = result2.iterator().next();
                if (successors.contains(Node2)) {
                    this.myFoundSCCs.add(result2);
                }
            } else {
                this.myFoundSCCs.add(result2);
            }
        }
    }

    private boolean findCyclesInSCG(int startIndex, int vertexIndex, Graph<Node> scg) {
        boolean foundCycle = false;
        Node vertex = this.toV(vertexIndex);
        this.myStack.push(vertex);
        this.myBlocked.add(vertex);
        HashSet successors = new HashSet();
        scg.getOut(vertex).forEachRemaining(successors::add);
        for (Object successor : successors) {
            int successorIndex = this.toI(successor);
            if (successorIndex == startIndex) {
                ArrayList cycle = new ArrayList(this.myStack.size());
                this.myStack.descendingIterator().forEachRemaining(cycle::add);
                this.myCycleConsumer.accept(cycle);
                foundCycle = true;
                continue;
            }
            if (this.myBlocked.contains(successor)) continue;
            boolean gotCycle = this.findCyclesInSCG(startIndex, successorIndex, scg);
            foundCycle = foundCycle || gotCycle;
        }
        if (foundCycle) {
            this.unblock(vertex);
        } else {
            for (Object w : successors) {
                Set<Node> bSet = this.getBSet(w);
                bSet.add(vertex);
            }
        }
        this.myStack.pop();
        return foundCycle;
    }

    private void unblock(@NotNull Node vertex) {
        if (vertex == null) {
            SimpleCyclesIterator.$$$reportNull$$$0(2);
        }
        this.myBlocked.remove(vertex);
        Set<Node> bSet = this.getBSet(vertex);
        while (bSet.size() > 0) {
            Node w = bSet.iterator().next();
            bSet.remove(w);
            if (!this.myBlocked.contains(w)) continue;
            this.unblock(w);
        }
    }

    private void initState(@NotNull Consumer<? super List<Node>> consumer2) {
        if (consumer2 == null) {
            SimpleCyclesIterator.$$$reportNull$$$0(3);
        }
        this.myCycleConsumer = consumer2;
        this.myIToV = this.myGraph.getNodes().toArray();
        this.myVToI = new HashMap<Node, Integer>();
        this.myBlocked = new HashSet<Node>();
        this.myBSets = new HashMap<Node, Set<Node>>();
        this.myStack = new ArrayDeque();
        for (int i = 0; i < this.myIToV.length; ++i) {
            this.myVToI.put(this.myIToV[i], i);
        }
    }

    private void clearState() {
        this.myCycleConsumer = null;
        this.myIToV = null;
        this.myVToI = null;
        this.myBlocked = null;
        this.myBSets = null;
        this.myStack = null;
    }

    private void initMinSCGState() {
        this.myIndex = 0;
        this.myFoundSCCs = new ArrayList<Set<Node>>();
        this.myVIndex = new HashMap<Node, Integer>();
        this.myVLowlink = new HashMap<Node, Integer>();
        this.myPath = new ArrayDeque();
        this.myPathSet = new HashSet<Node>();
    }

    private void clearMinSCCState() {
        this.myIndex = 0;
        this.myFoundSCCs = null;
        this.myVIndex = null;
        this.myVLowlink = null;
        this.myPath = null;
        this.myPathSet = null;
    }

    @NotNull
    private Integer toI(@NotNull Node vertex) {
        if (vertex == null) {
            SimpleCyclesIterator.$$$reportNull$$$0(4);
        }
        Integer n = this.myVToI.get(vertex);
        if (n == null) {
            SimpleCyclesIterator.$$$reportNull$$$0(5);
        }
        return n;
    }

    @NotNull
    private Node toV(@NotNull Integer i) {
        if (i == null) {
            SimpleCyclesIterator.$$$reportNull$$$0(6);
        }
        Node Node2 = this.myIToV[i];
        if (Node2 == null) {
            SimpleCyclesIterator.$$$reportNull$$$0(7);
        }
        return Node2;
    }

    @NotNull
    private Set<Node> getBSet(@NotNull Node Node2) {
        if (Node2 == null) {
            SimpleCyclesIterator.$$$reportNull$$$0(8);
        }
        Set set = this.myBSets.computeIfAbsent(Node2, k -> new HashSet());
        if (set == null) {
            SimpleCyclesIterator.$$$reportNull$$$0(9);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vertex";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/graph/impl/SimpleCyclesIterator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "i";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "Node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/graph/impl/SimpleCyclesIterator";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "toI";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "toV";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getBSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "iterateSimpleCycles";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "unblock";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "initState";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "toI";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "toV";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getBSet";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

