/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.DigestUtilKt;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.SecureRandom;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000b\u001a\u00020\fH\u0007J\b\u0010\r\u001a\u00020\u000eH\u0007J\b\u0010\u0012\u001a\u00020\u000eH\u0007J\b\u0010\u0015\u001a\u00020\u000eH\u0007J\b\u0010\u0016\u001a\u00020\u000eH\u0007J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u000eH\u0007J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u0010\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u0010\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\fH\u0007J\"\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010!\u001a\u00020\u001bH\u0007J\"\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020#2\b\b\u0002\u0010!\u001a\u00020\u001bH\u0007R!\u0010\u0004\u001a\u00020\u00058FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\t\u0010\n\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\n\u001a\u0004\b\u000f\u0010\u0010R\u001b\u0010\u0012\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\n\u001a\u0004\b\u0013\u0010\u0010\u00a8\u0006$"}, d2={"Lcom/intellij/util/io/DigestUtil;", "", "<init>", "()V", "random", "Ljava/security/SecureRandom;", "getRandom$annotations", "getRandom", "()Ljava/security/SecureRandom;", "random$delegate", "Lkotlin/Lazy;", "randomToken", "", "md5", "Ljava/security/MessageDigest;", "getMd5", "()Ljava/security/MessageDigest;", "md5$delegate", "sha1", "getSha1", "sha1$delegate", "sha256", "sha512", "digestToHash", "digest", "sha256Hex", "input", "", "sha1Hex", "updateContentHash", "", "file", "Ljava/nio/file/Path;", "buffer", "inputStream", "Ljava/io/InputStream;", "intellij.platform.util"})
public final class DigestUtil {
    @NotNull
    public static final DigestUtil INSTANCE = new DigestUtil();
    @NotNull
    private static final Lazy random$delegate = LazyKt.lazy(DigestUtil::random_delegate$lambda$0);
    @NotNull
    private static final Lazy md5$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, DigestUtil::md5_delegate$lambda$1);
    @NotNull
    private static final Lazy sha1$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, DigestUtil::sha1_delegate$lambda$2);

    private DigestUtil() {
    }

    @NotNull
    public static final SecureRandom getRandom() {
        Lazy lazy = random$delegate;
        return (SecureRandom)lazy.getValue();
    }

    @JvmStatic
    public static /* synthetic */ void getRandom$annotations() {
    }

    @JvmStatic
    @NotNull
    public static final String randomToken() {
        String string = new BigInteger(130, INSTANCE.getRandom()).toString(32);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final MessageDigest md5() {
        return DigestUtilKt.access$cloneDigest(INSTANCE.getMd5());
    }

    private final MessageDigest getMd5() {
        Lazy lazy = md5$delegate;
        return (MessageDigest)lazy.getValue();
    }

    @JvmStatic
    @NotNull
    public static final MessageDigest sha1() {
        return DigestUtilKt.access$cloneDigest(INSTANCE.getSha1());
    }

    private final MessageDigest getSha1() {
        Lazy lazy = sha1$delegate;
        return (MessageDigest)lazy.getValue();
    }

    @JvmStatic
    @NotNull
    public static final MessageDigest sha256() {
        return DigestUtilKt.access$cloneDigest(DigestUtilKt.access$getSha2_256());
    }

    @JvmStatic
    @NotNull
    public static final MessageDigest sha512() {
        return DigestUtilKt.sha2_512();
    }

    @JvmStatic
    @NotNull
    public static final String digestToHash(@NotNull MessageDigest digest) {
        Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
        byte[] byArray = digest.digest();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
        return DigestUtilKt.bytesToHex(byArray);
    }

    @JvmStatic
    @NotNull
    public static final String sha256Hex(@NotNull byte[] input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        byte[] byArray = INSTANCE.sha256().digest(input);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
        return DigestUtilKt.bytesToHex(byArray);
    }

    @JvmStatic
    @NotNull
    public static final String sha1Hex(@NotNull byte[] input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return DigestUtilKt.hashToHexString(input, INSTANCE.sha1());
    }

    @JvmStatic
    @NotNull
    public static final String sha1Hex(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return DigestUtilKt.hashToHexString(input, INSTANCE.sha1());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @JvmOverloads
    public static final void updateContentHash(@NotNull MessageDigest digest, @NotNull Path file, @NotNull byte[] buffer) {
        Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        try {
            Closeable closeable = Files.newInputStream(file, new OpenOption[0]);
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                DigestUtil.updateContentHash(digest, it, buffer);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read " + file + ". " + e.getMessage(), e);
        }
    }

    public static /* synthetic */ void updateContentHash$default(MessageDigest messageDigest, Path path, byte[] byArray, int n, Object object) {
        if ((n & 4) != 0) {
            byArray = new byte[524288];
        }
        DigestUtil.updateContentHash(messageDigest, path, byArray);
    }

    @JvmStatic
    @JvmOverloads
    public static final void updateContentHash(@NotNull MessageDigest digest, @NotNull InputStream inputStream, @NotNull byte[] buffer) {
        Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        try {
            int sz;
            while ((sz = inputStream.read(buffer)) > 0) {
                digest.update(buffer, 0, sz);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read stream. " + e.getMessage(), e);
        }
    }

    public static /* synthetic */ void updateContentHash$default(MessageDigest messageDigest, InputStream inputStream, byte[] byArray, int n, Object object) {
        if ((n & 4) != 0) {
            byArray = new byte[524288];
        }
        DigestUtil.updateContentHash(messageDigest, inputStream, byArray);
    }

    @JvmStatic
    @JvmOverloads
    public static final void updateContentHash(@NotNull MessageDigest digest, @NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        DigestUtil.updateContentHash$default(digest, file, null, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void updateContentHash(@NotNull MessageDigest digest, @NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        DigestUtil.updateContentHash$default(digest, inputStream, null, 4, null);
    }

    private static final SecureRandom random_delegate$lambda$0() {
        return new SecureRandom();
    }

    private static final MessageDigest md5_delegate$lambda$1() {
        return DigestUtilKt.access$getMessageDigest("MD5");
    }

    private static final MessageDigest sha1_delegate$lambda$2() {
        return DigestUtilKt.access$getMessageDigest("SHA-1");
    }
}

