/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.aggregator;

import io.opentelemetry.sdk.common.export.MemoryMode;
import io.opentelemetry.sdk.internal.DynamicPrimitiveLongList;
import io.opentelemetry.sdk.internal.PrimitiveLongList;
import io.opentelemetry.sdk.metrics.data.ExponentialHistogramBuckets;
import io.opentelemetry.sdk.metrics.internal.aggregator.AdaptingCircularBufferCounter;
import io.opentelemetry.sdk.metrics.internal.aggregator.Base2ExponentialHistogramIndexer;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

final class DoubleBase2ExponentialHistogramBuckets
implements ExponentialHistogramBuckets {
    private final MemoryMode memoryMode;
    private AdaptingCircularBufferCounter counts;
    private int scale;
    private Base2ExponentialHistogramIndexer base2ExponentialHistogramIndexer;
    private long totalCount;
    @Nullable
    private AdaptingCircularBufferCounter reusableCounts;

    DoubleBase2ExponentialHistogramBuckets(int scale, int maxBuckets, MemoryMode memoryMode) {
        this.memoryMode = memoryMode;
        this.counts = new AdaptingCircularBufferCounter(maxBuckets);
        this.scale = scale;
        this.base2ExponentialHistogramIndexer = Base2ExponentialHistogramIndexer.get(this.scale);
        this.totalCount = 0L;
    }

    DoubleBase2ExponentialHistogramBuckets(DoubleBase2ExponentialHistogramBuckets buckets) {
        this.counts = new AdaptingCircularBufferCounter(buckets.counts);
        this.scale = buckets.scale;
        this.base2ExponentialHistogramIndexer = buckets.base2ExponentialHistogramIndexer;
        this.totalCount = buckets.totalCount;
        this.memoryMode = buckets.memoryMode;
        this.reusableCounts = buckets.reusableCounts;
    }

    DoubleBase2ExponentialHistogramBuckets copy() {
        return new DoubleBase2ExponentialHistogramBuckets(this);
    }

    void clear(int scale) {
        this.totalCount = 0L;
        this.scale = scale;
        this.base2ExponentialHistogramIndexer = Base2ExponentialHistogramIndexer.get(this.scale);
        this.counts.clear();
    }

    boolean record(double value) {
        if (value == 0.0) {
            throw new IllegalStateException("Illegal attempted recording of zero at bucket level.");
        }
        int index = this.base2ExponentialHistogramIndexer.computeIndex(value);
        boolean recordingSuccessful = this.counts.increment(index, 1L);
        if (recordingSuccessful) {
            ++this.totalCount;
        }
        return recordingSuccessful;
    }

    @Override
    public int getOffset() {
        if (this.counts.isEmpty()) {
            return 0;
        }
        return this.counts.getIndexStart();
    }

    @Override
    public List<Long> getBucketCounts() {
        if (this.counts.isEmpty()) {
            return Collections.emptyList();
        }
        int length = this.counts.getIndexEnd() - this.counts.getIndexStart() + 1;
        long[] countsArr = new long[length];
        for (int i = 0; i < length; ++i) {
            countsArr[i] = this.counts.get(i + this.counts.getIndexStart());
        }
        return PrimitiveLongList.wrap(countsArr);
    }

    void getBucketCountsIntoReusableList(DynamicPrimitiveLongList reusableLongList) {
        if (this.counts.isEmpty()) {
            reusableLongList.resizeAndClear(0);
            return;
        }
        int length = this.counts.getIndexEnd() - this.counts.getIndexStart() + 1;
        if (reusableLongList.size() != length) {
            reusableLongList.resizeAndClear(length);
        }
        for (int i = 0; i < length; ++i) {
            reusableLongList.setLong(i, this.counts.get(i + this.counts.getIndexStart()));
        }
    }

    @Override
    public long getTotalCount() {
        return this.totalCount;
    }

    void downscale(int by) {
        if (by == 0) {
            return;
        }
        if (by < 0) {
            throw new IllegalStateException("Cannot downscale by negative amount. Was given " + by + ".");
        }
        if (!this.counts.isEmpty()) {
            AdaptingCircularBufferCounter newCounts;
            if (this.memoryMode == MemoryMode.IMMUTABLE_DATA) {
                newCounts = new AdaptingCircularBufferCounter(this.counts);
            } else {
                if (this.reusableCounts == null) {
                    this.reusableCounts = new AdaptingCircularBufferCounter(this.counts);
                }
                newCounts = this.reusableCounts;
            }
            newCounts.clear();
            for (int i = this.counts.getIndexStart(); i <= this.counts.getIndexEnd(); ++i) {
                long count2 = this.counts.get(i);
                if (count2 <= 0L || newCounts.increment(i >> by, count2)) continue;
                throw new IllegalStateException("Failed to create new downscaled buckets.");
            }
            if (this.memoryMode == MemoryMode.REUSABLE_DATA) {
                AdaptingCircularBufferCounter existingCounts = this.counts;
                this.counts = newCounts;
                this.reusableCounts = existingCounts;
            } else {
                this.counts = newCounts;
            }
        }
        this.scale -= by;
        this.base2ExponentialHistogramIndexer = Base2ExponentialHistogramIndexer.get(this.scale);
    }

    @Override
    public int getScale() {
        return this.scale;
    }

    int getScaleReduction(double value) {
        long index = this.base2ExponentialHistogramIndexer.computeIndex(value);
        long newStart = Math.min(index, (long)this.counts.getIndexStart());
        long newEnd = Math.max(index, (long)this.counts.getIndexEnd());
        return this.getScaleReduction(newStart, newEnd);
    }

    int getScaleReduction(long newStart, long newEnd) {
        int scaleReduction = 0;
        while (newEnd - newStart + 1L > (long)this.counts.getMaxSize()) {
            newStart >>= 1;
            newEnd >>= 1;
            ++scaleReduction;
        }
        return scaleReduction;
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof DoubleBase2ExponentialHistogramBuckets)) {
            return false;
        }
        DoubleBase2ExponentialHistogramBuckets other = (DoubleBase2ExponentialHistogramBuckets)obj;
        return this.scale == other.scale && this.sameBucketCounts(other);
    }

    private boolean sameBucketCounts(DoubleBase2ExponentialHistogramBuckets other) {
        if (this.totalCount != other.totalCount) {
            return false;
        }
        int min = Math.min(this.counts.getIndexStart(), other.counts.getIndexStart());
        if (min == Integer.MIN_VALUE) {
            min = Math.max(this.counts.getIndexStart(), other.counts.getIndexStart());
        }
        int max = Math.max(this.counts.getIndexEnd(), other.counts.getIndexEnd());
        for (int idx = min; idx <= max; ++idx) {
            if (this.counts.get(idx) == other.counts.get(idx)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 1;
        hash *= 1000003;
        for (int idx = this.counts.getIndexStart(); idx <= this.counts.getIndexEnd(); ++idx) {
            long count2 = this.counts.get(idx);
            if (count2 == 0L) continue;
            hash ^= idx;
            hash *= 1000003;
            hash = (int)((long)hash ^ count2);
            hash *= 1000003;
        }
        return hash ^= this.scale;
    }

    public String toString() {
        return "DoubleExponentialHistogramBuckets{scale: " + this.scale + ", offset: " + this.getOffset() + ", counts: " + this.counts + " }";
    }
}

