/*
 * Decompiled with CFR 0.152.
 */
package one.util.streamex;

import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntUnaryOperator;
import java.util.function.LongBinaryOperator;
import java.util.function.LongConsumer;
import java.util.function.LongUnaryOperator;
import one.util.streamex.Internals;

abstract class PairSpliterator<T, S extends Spliterator<T>, R, SS extends PairSpliterator<T, S, R, SS>>
extends Internals.CloneableSpliterator<R, SS> {
    static final int MODE_PAIRS = 0;
    static final int MODE_MAP_FIRST = 1;
    static final int MODE_MAP_LAST = 2;
    static final int MODE_MAP_FIRST_OR_ELSE = 3;
    static final int MODE_MAP_LAST_OR_ELSE = 4;
    static final Sink<?> EMPTY = new Sink(null);
    final Object lock = new Object();
    final int mode;
    S source;
    Sink<T> left = EMPTY;
    Sink<T> right = EMPTY;

    PairSpliterator(S source, int mode, T headTail) {
        this.source = source;
        this.mode = mode;
        if (mode != 0) {
            Sink sink = new Sink(this.lock);
            Sink<T> other = new Sink<T>(this.lock);
            sink.other = other;
            other.other = sink;
            other.push(headTail, null, true);
            if (mode == 1 || mode == 3) {
                this.left = sink;
            } else {
                this.right = sink;
            }
        }
    }

    @Override
    public long estimateSize() {
        long size = this.source.estimateSize();
        if (size == Long.MAX_VALUE || size == 0L) {
            return size;
        }
        return size - 1L;
    }

    @Override
    public int characteristics() {
        return this.source.characteristics() & ((this.left == EMPTY && this.right == EMPTY ? 64 : 0) | 0x1000 | 0x400 | 0x10);
    }

    public SS trySplit() {
        Spliterator prefixSource = this.source.trySplit();
        if (prefixSource == null) {
            return null;
        }
        PairSpliterator clone = (PairSpliterator)this.doClone();
        Sink left = new Sink(this.lock);
        Sink right = new Sink(this.lock);
        clone.source = prefixSource;
        right.other = left;
        clone.right = right.other;
        left.other = right;
        this.left = left.other;
        return (SS)clone;
    }

    void finish(BiConsumer<T, T> fn, T cur) {
        Sink<T> r = this.right;
        Sink<T> l = this.left;
        this.left = null;
        this.right = null;
        if (l != null) {
            l.connect(r, fn);
        } else if (r != null) {
            r.push(cur, fn, true);
        }
    }

    static final class PSOfDouble
    extends PairSpliterator<Double, Spliterator.OfDouble, Double, PSOfDouble>
    implements Spliterator.OfDouble,
    DoubleConsumer {
        private final DoubleBinaryOperator mapper;
        private final DoubleUnaryOperator unaryMapper;
        private double cur;

        PSOfDouble(DoubleBinaryOperator mapper, DoubleUnaryOperator unaryMapper, Spliterator.OfDouble source, int mode) {
            super(source, mode, null);
            this.mapper = mapper;
            this.unaryMapper = unaryMapper;
        }

        @Override
        public void accept(double t) {
            this.cur = t;
        }

        private BiConsumer<Double, Double> fn(DoubleConsumer action2) {
            switch (this.mode) {
                case 1: {
                    return (a, b) -> action2.accept(a == null ? this.unaryMapper.applyAsDouble((double)b) : b.doubleValue());
                }
                case 2: {
                    return (a, b) -> action2.accept(b == null ? this.unaryMapper.applyAsDouble((double)a) : a.doubleValue());
                }
            }
            return (a, b) -> action2.accept(this.mapper.applyAsDouble((double)a, (double)b));
        }

        @Override
        public boolean tryAdvance(DoubleConsumer action2) {
            Sink l = this.left;
            Sink r = this.right;
            if (l != null) {
                this.left = null;
                if (!((Spliterator.OfDouble)this.source).tryAdvance(this)) {
                    this.right = null;
                    return l.connect(r, this.fn(action2));
                }
                if (l.push(this.cur, this.fn(action2), false)) {
                    return true;
                }
            }
            double prev = this.cur;
            if (!((Spliterator.OfDouble)this.source).tryAdvance(this)) {
                this.right = null;
                return r != null && r.push(prev, this.fn(action2), true);
            }
            action2.accept(this.mapper.applyAsDouble(prev, this.cur));
            return true;
        }

        @Override
        public void forEachRemaining(DoubleConsumer action2) {
            BiConsumer<Double, Double> fn = this.fn(action2);
            ((Spliterator.OfDouble)this.source).forEachRemaining((double next) -> {
                if (this.left != null) {
                    this.cur = next;
                    this.left.push(this.cur, fn, false);
                    this.left = null;
                } else {
                    this.cur = next;
                    action2.accept(this.mapper.applyAsDouble(this.cur, this.cur));
                }
            });
            this.finish(fn, this.cur);
        }
    }

    static final class PSOfLong
    extends PairSpliterator<Long, Spliterator.OfLong, Long, PSOfLong>
    implements Spliterator.OfLong,
    LongConsumer {
        private final LongBinaryOperator mapper;
        private final LongUnaryOperator unaryMapper;
        private long cur;

        PSOfLong(LongBinaryOperator mapper, LongUnaryOperator unaryMapper, Spliterator.OfLong source, int mode) {
            super(source, mode, null);
            this.mapper = mapper;
            this.unaryMapper = unaryMapper;
        }

        @Override
        public void accept(long t) {
            this.cur = t;
        }

        private BiConsumer<Long, Long> fn(LongConsumer action2) {
            switch (this.mode) {
                case 1: {
                    return (a, b) -> action2.accept(a == null ? this.unaryMapper.applyAsLong((long)b) : b.longValue());
                }
                case 2: {
                    return (a, b) -> action2.accept(b == null ? this.unaryMapper.applyAsLong((long)a) : a.longValue());
                }
            }
            return (a, b) -> action2.accept(this.mapper.applyAsLong((long)a, (long)b));
        }

        @Override
        public boolean tryAdvance(LongConsumer action2) {
            Sink l = this.left;
            Sink r = this.right;
            if (l != null) {
                this.left = null;
                if (!((Spliterator.OfLong)this.source).tryAdvance(this)) {
                    this.right = null;
                    return l.connect(r, this.fn(action2));
                }
                if (l.push(this.cur, this.fn(action2), false)) {
                    return true;
                }
            }
            long prev = this.cur;
            if (!((Spliterator.OfLong)this.source).tryAdvance(this)) {
                this.right = null;
                return r != null && r.push(prev, this.fn(action2), true);
            }
            action2.accept(this.mapper.applyAsLong(prev, this.cur));
            return true;
        }

        @Override
        public void forEachRemaining(LongConsumer action2) {
            BiConsumer<Long, Long> fn = this.fn(action2);
            ((Spliterator.OfLong)this.source).forEachRemaining((long next) -> {
                if (this.left != null) {
                    this.cur = next;
                    this.left.push(this.cur, fn, false);
                    this.left = null;
                } else {
                    this.cur = next;
                    action2.accept(this.mapper.applyAsLong(this.cur, this.cur));
                }
            });
            this.finish(fn, this.cur);
        }
    }

    static final class PSOfInt
    extends PairSpliterator<Integer, Spliterator.OfInt, Integer, PSOfInt>
    implements Spliterator.OfInt,
    IntConsumer {
        private final IntBinaryOperator mapper;
        private final IntUnaryOperator unaryMapper;
        private int cur;

        PSOfInt(IntBinaryOperator mapper, IntUnaryOperator unaryMapper, Spliterator.OfInt source, int mode) {
            super(source, mode, null);
            this.mapper = mapper;
            this.unaryMapper = unaryMapper;
        }

        @Override
        public void accept(int t) {
            this.cur = t;
        }

        private BiConsumer<Integer, Integer> fn(IntConsumer action2) {
            switch (this.mode) {
                case 1: {
                    return (a, b) -> action2.accept(a == null ? this.unaryMapper.applyAsInt((int)b) : b.intValue());
                }
                case 2: {
                    return (a, b) -> action2.accept(b == null ? this.unaryMapper.applyAsInt((int)a) : a.intValue());
                }
            }
            return (a, b) -> action2.accept(this.mapper.applyAsInt((int)a, (int)b));
        }

        @Override
        public boolean tryAdvance(IntConsumer action2) {
            Sink l = this.left;
            Sink r = this.right;
            if (l != null) {
                this.left = null;
                if (!((Spliterator.OfInt)this.source).tryAdvance(this)) {
                    this.right = null;
                    return l.connect(r, this.fn(action2));
                }
                if (l.push(this.cur, this.fn(action2), false)) {
                    return true;
                }
            }
            int prev = this.cur;
            if (!((Spliterator.OfInt)this.source).tryAdvance(this)) {
                this.right = null;
                return r != null && r.push(prev, this.fn(action2), true);
            }
            action2.accept(this.mapper.applyAsInt(prev, this.cur));
            return true;
        }

        @Override
        public void forEachRemaining(IntConsumer action2) {
            BiConsumer<Integer, Integer> fn = this.fn(action2);
            ((Spliterator.OfInt)this.source).forEachRemaining((int next) -> {
                if (this.left != null) {
                    this.cur = next;
                    this.left.push(this.cur, fn, false);
                    this.left = null;
                } else {
                    this.cur = next;
                    action2.accept(this.mapper.applyAsInt(this.cur, this.cur));
                }
            });
            this.finish(fn, this.cur);
        }
    }

    static class PSOfRef<T, R>
    extends PairSpliterator<T, Spliterator<T>, R, PSOfRef<T, R>>
    implements Consumer<T>,
    Internals.TailSpliterator<R> {
        private static final Object HEAD_TAIL = new Object();
        private final BiFunction<? super T, ? super T, ? extends R> mapper;
        private T cur;

        PSOfRef(BiFunction<? super T, ? super T, ? extends R> mapper, Spliterator<T> source) {
            super(source, 0, null);
            this.mapper = mapper;
        }

        PSOfRef(Function<? super T, ? extends R> mapper, Spliterator<T> source, boolean first2) {
            super(source, first2 ? 1 : 2, HEAD_TAIL);
            BiFunction<Object, Object, Object> m = first2 ? (a, b) -> a == HEAD_TAIL ? mapper.apply(b) : b : (a, b) -> b == HEAD_TAIL ? mapper.apply(a) : a;
            this.mapper = m;
        }

        PSOfRef(Function<? super T, ? extends R> boundMapper, Function<? super T, ? extends R> elseMapper, Spliterator<T> source, boolean first2) {
            super(source, first2 ? 3 : 4, HEAD_TAIL);
            this.mapper = first2 ? (a, b) -> a == HEAD_TAIL ? boundMapper.apply(b) : elseMapper.apply(b) : (a, b) -> b == HEAD_TAIL ? boundMapper.apply(a) : elseMapper.apply(a);
        }

        @Override
        public void accept(T t) {
            this.cur = t;
        }

        private BiConsumer<T, T> fn(Consumer<? super R> action2) {
            return (a, b) -> action2.accept((R)this.mapper.apply(a, b));
        }

        @Override
        public boolean tryAdvance(Consumer<? super R> action2) {
            Sink l = this.left;
            Sink r = this.right;
            if (l != null) {
                this.left = null;
                if (!this.source.tryAdvance(this)) {
                    this.right = null;
                    return l.connect(r, this.fn(action2));
                }
                if (l.push(this.cur, this.fn(action2), false)) {
                    return true;
                }
            }
            T prev = this.cur;
            if (!this.source.tryAdvance(this)) {
                this.right = null;
                return r != null && r.push(prev, this.fn(action2), true);
            }
            action2.accept(this.mapper.apply(prev, this.cur));
            return true;
        }

        @Override
        public void forEachRemaining(Consumer<? super R> action2) {
            BiConsumer<T, T> fn = this.fn(action2);
            this.source.forEachRemaining((? super T next) -> {
                if (this.left != null) {
                    this.cur = next;
                    this.left.push(this.cur, fn, false);
                    this.left = null;
                } else {
                    this.cur = next;
                    action2.accept((R)this.mapper.apply(this.cur, this.cur));
                }
            });
            this.finish(fn, this.cur);
        }

        @Override
        public Spliterator<R> tryAdvanceOrTail(Consumer<? super R> action2) {
            if (this.mode != 1 || this.right != EMPTY) {
                return this.tryAdvance((Consumer<R>)action2) ? this : null;
            }
            if (this.left != null) {
                Sink l = this.left;
                this.left = null;
                this.source = Internals.TailSpliterator.tryAdvanceWithTail(this.source, this);
                if (this.source == null) {
                    this.right = null;
                    return null;
                }
                if (l.push(this.cur, this.fn(action2), false)) {
                    return this;
                }
            }
            Spliterator s = this.source;
            this.source = null;
            return s;
        }

        @Override
        public Spliterator<R> forEachOrTail(Consumer<? super R> action2) {
            Spliterator<? super R> tail;
            if (this.mode != 1 || this.right != EMPTY) {
                this.forEachRemaining(action2);
                return null;
            }
            while ((tail = this.tryAdvanceOrTail(action2)) == this) {
            }
            return tail;
        }
    }

    static final class Sink<T> {
        Sink<T> other;
        private T payload = Internals.none();
        private final Object lock;

        Sink(Object lock) {
            this.lock = lock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean push(T payload, BiConsumer<T, T> fn, boolean isLeft) {
            T otherPayload;
            if (this.lock == null) {
                return false;
            }
            Object object = this.lock;
            synchronized (object) {
                Sink<T> that = this.other;
                if (that == null) {
                    return false;
                }
                otherPayload = that.payload;
                if (otherPayload == Internals.NONE) {
                    this.payload = payload;
                    return false;
                }
                this.other = null;
                that.clear();
            }
            if (isLeft) {
                fn.accept(payload, otherPayload);
            } else {
                fn.accept(otherPayload, payload);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean connect(Sink<T> right, BiConsumer<T, T> fn) {
            T b;
            T a;
            if (this.lock == null) {
                return false;
            }
            Object object = this.lock;
            synchronized (object) {
                Sink<T> leftLeft = this.other;
                Sink<T> rightRight = right.other;
                if (leftLeft == null || rightRight == null) {
                    if (rightRight != null) {
                        rightRight.clear();
                    }
                    if (leftLeft != null) {
                        leftLeft.clear();
                    }
                    return false;
                }
                rightRight.other = leftLeft;
                leftLeft.other = rightRight;
                if (leftLeft.payload == Internals.NONE || rightRight.payload == Internals.NONE) {
                    return false;
                }
                a = leftLeft.payload;
                b = rightRight.payload;
                leftLeft.clear();
                rightRight.clear();
            }
            fn.accept(a, b);
            return true;
        }

        void clear() {
            this.other = null;
            this.payload = Internals.none();
        }
    }
}

