/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.xpath.jaxen;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import org.jaxen.BaseXPath;
import org.jaxen.DefaultNavigator;
import org.jaxen.FunctionCallException;
import org.jaxen.JaxenConstants;
import org.jaxen.UnsupportedAxisException;
import org.jaxen.XPath;
import org.jaxen.saxpath.SAXPathException;
import org.jaxen.util.SingleObjectIterator;
import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.Parent;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.jaxen.NamespaceContainer;

class JDOMCoreNavigator
extends DefaultNavigator {
    private transient IdentityHashMap<Element, NamespaceContainer[]> emtnsmap = new IdentityHashMap();

    JDOMCoreNavigator() {
    }

    void reset() {
        this.emtnsmap.clear();
    }

    @Override
    public final XPath parseXPath(String path) throws SAXPathException {
        return new BaseXPath(path, this);
    }

    @Override
    public final Object getDocument(String url) throws FunctionCallException {
        SAXBuilder sb = new SAXBuilder();
        try {
            return sb.build(url);
        }
        catch (JDOMException e) {
            throw new FunctionCallException("Failed to parse " + url, e);
        }
        catch (IOException e) {
            throw new FunctionCallException("Failed to access " + url, e);
        }
    }

    @Override
    public final boolean isText(Object isit) {
        return isit instanceof Text;
    }

    @Override
    public final boolean isProcessingInstruction(Object isit) {
        return isit instanceof ProcessingInstruction;
    }

    @Override
    public final boolean isNamespace(Object isit) {
        return isit instanceof NamespaceContainer;
    }

    @Override
    public final boolean isElement(Object isit) {
        return isit instanceof Element;
    }

    @Override
    public final boolean isDocument(Object isit) {
        return isit instanceof Document;
    }

    @Override
    public final boolean isComment(Object isit) {
        return isit instanceof Comment;
    }

    @Override
    public final boolean isAttribute(Object isit) {
        return isit instanceof Attribute;
    }

    @Override
    public final String getTextStringValue(Object text) {
        return ((Text)text).getText();
    }

    @Override
    public final String getNamespaceStringValue(Object namespace) {
        return ((NamespaceContainer)namespace).getNamespace().getURI();
    }

    @Override
    public final String getNamespacePrefix(Object namespace) {
        return ((NamespaceContainer)namespace).getNamespace().getPrefix();
    }

    private static void recurseElementText(Element element, StringBuilder sb) {
        for (Content c : element.getContent()) {
            if (c instanceof Element) {
                JDOMCoreNavigator.recurseElementText((Element)c, sb);
                continue;
            }
            if (!(c instanceof Text)) continue;
            sb.append(((Text)c).getText());
        }
    }

    @Override
    public final String getElementStringValue(Object element) {
        StringBuilder sb = new StringBuilder();
        JDOMCoreNavigator.recurseElementText((Element)element, sb);
        return sb.toString();
    }

    @Override
    public final String getElementQName(Object element) {
        Element e = (Element)element;
        if (e.getNamespace().getPrefix().length() == 0) {
            return e.getName();
        }
        return e.getNamespacePrefix() + ":" + e.getName();
    }

    @Override
    public final String getElementNamespaceUri(Object element) {
        return ((Element)element).getNamespaceURI();
    }

    @Override
    public final String getElementName(Object element) {
        return ((Element)element).getName();
    }

    @Override
    public final String getCommentStringValue(Object comment) {
        return ((Comment)comment).getValue();
    }

    @Override
    public final String getAttributeStringValue(Object attribute) {
        return ((Attribute)attribute).getValue();
    }

    @Override
    public final String getAttributeQName(Object att) {
        Attribute attribute = (Attribute)att;
        if (attribute.getNamespacePrefix().length() == 0) {
            return attribute.getName();
        }
        return attribute.getNamespacePrefix() + ":" + attribute.getName();
    }

    @Override
    public final String getAttributeNamespaceUri(Object attribute) {
        return ((Attribute)attribute).getNamespaceURI();
    }

    @Override
    public final String getAttributeName(Object attribute) {
        return ((Attribute)attribute).getName();
    }

    @Override
    public final String getProcessingInstructionTarget(Object pi) {
        return ((ProcessingInstruction)pi).getTarget();
    }

    @Override
    public final String getProcessingInstructionData(Object pi) {
        return ((ProcessingInstruction)pi).getData();
    }

    @Override
    public final Object getDocumentNode(Object contextNode) {
        if (contextNode instanceof Document) {
            return contextNode;
        }
        if (contextNode instanceof NamespaceContainer) {
            return ((NamespaceContainer)contextNode).getParentElement().getDocument();
        }
        if (contextNode instanceof Attribute) {
            return ((Attribute)contextNode).getDocument();
        }
        return ((Content)contextNode).getDocument();
    }

    @Override
    public final Object getParentNode(Object contextNode) throws UnsupportedAxisException {
        if (contextNode instanceof Document) {
            return null;
        }
        if (contextNode instanceof NamespaceContainer) {
            return ((NamespaceContainer)contextNode).getParentElement();
        }
        if (contextNode instanceof Content) {
            return ((Content)contextNode).getParent();
        }
        if (contextNode instanceof Attribute) {
            return ((Attribute)contextNode).getParent();
        }
        return null;
    }

    @Override
    public final Iterator<?> getAttributeAxisIterator(Object contextNode) throws UnsupportedAxisException {
        if (this.isElement(contextNode) && ((Element)contextNode).hasAttributes()) {
            return ((Element)contextNode).getAttributes().iterator();
        }
        return JaxenConstants.EMPTY_ITERATOR;
    }

    @Override
    public final Iterator<?> getChildAxisIterator(Object contextNode) throws UnsupportedAxisException {
        if (contextNode instanceof Parent) {
            return ((Parent)contextNode).getContent().iterator();
        }
        return JaxenConstants.EMPTY_ITERATOR;
    }

    @Override
    public final Iterator<?> getNamespaceAxisIterator(Object contextNode) throws UnsupportedAxisException {
        if (!this.isElement(contextNode)) {
            return JaxenConstants.EMPTY_ITERATOR;
        }
        NamespaceContainer[] ret = this.emtnsmap.get(contextNode);
        if (ret == null) {
            List<Namespace> nsl = ((Element)contextNode).getNamespacesInScope();
            ret = new NamespaceContainer[nsl.size()];
            int i = 0;
            for (Namespace ns : nsl) {
                ret[i++] = new NamespaceContainer(ns, (Element)contextNode);
            }
            this.emtnsmap.put((Element)contextNode, ret);
        }
        return Arrays.asList(ret).iterator();
    }

    @Override
    public final Iterator<?> getParentAxisIterator(Object contextNode) {
        Parent p = null;
        if (contextNode instanceof Content) {
            p = ((Content)contextNode).getParent();
        } else if (contextNode instanceof NamespaceContainer) {
            p = ((NamespaceContainer)contextNode).getParentElement();
        } else if (contextNode instanceof Attribute) {
            p = ((Attribute)contextNode).getParent();
        }
        if (p != null) {
            return new SingleObjectIterator(p);
        }
        return JaxenConstants.EMPTY_ITERATOR;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.emtnsmap = new IdentityHashMap();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }
}

