/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import java.util.Collection;
import java.util.Collections;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class ManifestPermissionAttributeDetector
extends Detector
implements XmlScanner {
    public static final Issue ISSUE = Issue.create((String)"InvalidPermission", (String)"Invalid Permission Attribute", (String)"Not all elements support the permission attribute. If a permission is set on an invalid element, it is a no-op and ignored. Ensure that this permission attribute was set on the correct element to protect the correct component.", (Category)Category.SECURITY, (int)5, (Severity)Severity.ERROR, (Implementation)new Implementation(ManifestPermissionAttributeDetector.class, Scope.MANIFEST_SCOPE));

    public Collection<String> getApplicableAttributes() {
        return Collections.singletonList("permission");
    }

    public void visitAttribute(XmlContext context, Attr attribute) {
        String parent;
        switch (parent = attribute.getOwnerElement().getTagName()) {
            case "activity": 
            case "application": 
            case "provider": 
            case "service": 
            case "receiver": 
            case "activity-alias": 
            case "path-permission": {
                return;
            }
        }
        String message2 = "Protecting an unsupported element with a permission is a no-op and potentially dangerous";
        context.report(ISSUE, (Node)attribute, context.getLocation((Node)attribute), message2);
    }
}

