/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.AndroidXConstants;
import com.android.ide.common.resources.usage.ResourceUsageModel;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\u0010\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u00110\u0010H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0018H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/android/tools/lint/checks/MotionLayoutDetector;", "Lcom/android/tools/lint/detector/api/ResourceXmlDetector;", "<init>", "()V", "referencesRecorded", "", "resourceModel", "Lcom/android/ide/common/resources/usage/ResourceUsageModel;", "references", "", "Lcom/android/ide/common/resources/usage/ResourceUsageModel$Resource;", "Lcom/android/tools/lint/detector/api/Location;", "appliesTo", "folderType", "Lcom/android/resources/ResourceFolderType;", "getApplicableElements", "", "", "kotlin.jvm.PlatformType", "afterCheckRootProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "visitElement", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "visitMotionScene", "visitMotionLayout", "isIncrementalMode", "motionSceneUrlFromMotionLayoutFileName", "Companion", "lint-checks"})
@SourceDebugExtension(value={"SMAP\nMotionLayoutDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MotionLayoutDetector.kt\ncom/android/tools/lint/checks/MotionLayoutDetector\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,147:1\n216#2,2:148\n1#3:150\n*S KotlinDebug\n*F\n+ 1 MotionLayoutDetector.kt\ncom/android/tools/lint/checks/MotionLayoutDetector\n*L\n56#1:148,2\n*E\n"})
public final class MotionLayoutDetector
extends ResourceXmlDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean referencesRecorded;
    @Nullable
    private ResourceUsageModel resourceModel;
    @Nullable
    private Map<ResourceUsageModel.Resource, Location> references;
    @NotNull
    public static final String KEY_URL = "url";
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(MotionLayoutDetector.class, Scope.RESOURCE_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue INVALID_SCENE_FILE_REFERENCE = Issue.Companion.create("MotionLayoutInvalidSceneFileReference", "layoutDescription must specify a scene file", "\n                A motion scene file specifies the animations used in a `MotionLayout`. \\\n                The `layoutDescription` is required to specify a valid motion \\\n                scene file.\n                ", Category.CORRECTNESS, 8, Severity.ERROR, IMPLEMENTATION);

    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkNotNullParameter((Object)folderType, (String)"folderType");
        return folderType == ResourceFolderType.LAYOUT || folderType == ResourceFolderType.XML;
    }

    @NotNull
    public List<String> getApplicableElements() {
        Object[] objectArray = new String[]{AndroidXConstants.MOTION_LAYOUT.oldName(), AndroidXConstants.MOTION_LAYOUT.newName(), "MotionScene"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void afterCheckRootProject(@NotNull Context context) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (!this.referencesRecorded) {
                return;
            }
            boolean isIncremental = this.isIncrementalMode(context);
            Map<ResourceUsageModel.Resource, Location> map = this.references;
            if (map == null) break block2;
            Map<ResourceUsageModel.Resource, Location> $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<ResourceUsageModel.Resource, Location>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                ResourceUsageModel.Resource resource;
                Map.Entry<ResourceUsageModel.Resource, Location> element$iv;
                Map.Entry<ResourceUsageModel.Resource, Location> entry = element$iv = iterator.next();
                boolean bl = false;
                ResourceUsageModel.Resource reference = entry.getKey();
                Location location = entry.getValue();
                ResourceUsageModel resourceUsageModel = this.resourceModel;
                ResourceUsageModel.Resource resource2 = resource = resourceUsageModel != null ? resourceUsageModel.getResource(reference.type, reference.name) : null;
                if (isIncremental || resource != null && resource.isDeclared()) continue;
                Object[] objectArray = new Object[]{KEY_URL, reference.getUrl()};
                context.report(INVALID_SCENE_FILE_REFERENCE, location, "The motion scene file: " + reference.getUrl() + " doesn't exist", this.fix().name("Create " + reference.getUrl()).data(objectArray));
            }
        }
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (Intrinsics.areEqual((Object)element.getTagName(), (Object)"MotionScene")) {
            this.visitMotionScene(context, element);
        } else {
            this.visitMotionLayout(context, element);
        }
    }

    private final void visitMotionScene(XmlContext context, Element element) {
        ResourceFolderType resourceFolderType = context.getResourceFolderType();
        if (resourceFolderType == null) {
            return;
        }
        ResourceFolderType resourceFolderType2 = resourceFolderType;
        ResourceType resourceType = ResourceType.fromFolderName((String)resourceFolderType2.getName());
        if (resourceType == null) {
            return;
        }
        ResourceType resourceType2 = resourceType;
        String name = FilesKt.getNameWithoutExtension((File)context.file);
        ResourceUsageModel resourceUsageModel = this.resourceModel;
        if (resourceUsageModel == null) {
            ResourceUsageModel resourceUsageModel2;
            ResourceUsageModel it = resourceUsageModel2 = new ResourceUsageModel();
            boolean bl = false;
            this.resourceModel = it;
            resourceUsageModel = resourceUsageModel2;
        }
        ResourceUsageModel model2 = resourceUsageModel;
        model2.addDeclaredResource(resourceType2, name, null, true);
    }

    private final void visitMotionLayout(XmlContext context, Element element) {
        Attr description = element.getAttributeNodeNS("http://schemas.android.com/apk/res-auto", "layoutDescription");
        if (description == null) {
            String sceneUrl = this.motionSceneUrlFromMotionLayoutFileName(context);
            Object[] objectArray = new Object[]{KEY_URL, sceneUrl};
            context.report(INVALID_SCENE_FILE_REFERENCE, (Node)element, context.getNameLocation((Node)element), "The attribute: `layoutDescription` is missing", this.fix().name("Create " + sceneUrl + " and set attribute").data(objectArray));
        } else {
            ResourceUsageModel model2;
            ResourceUsageModel.Resource resource;
            ResourceUsageModel resourceUsageModel = this.resourceModel;
            if (resourceUsageModel == null) {
                ResourceUsageModel resourceUsageModel2;
                ResourceUsageModel it = resourceUsageModel2 = new ResourceUsageModel();
                boolean bl = false;
                this.resourceModel = it;
                resourceUsageModel = resourceUsageModel2;
            }
            if ((resource = (model2 = resourceUsageModel).getResourceFromUrl(description.getValue())) != null && resource.type == ResourceType.XML) {
                Map map = this.references;
                if (map == null) {
                    Map map2;
                    Map it = map2 = (Map)new LinkedHashMap();
                    boolean bl = false;
                    this.references = it;
                    map = map2;
                }
                Map references = map;
                references.put((ResourceUsageModel.Resource)resource, (Location)context.getValueLocation(description));
                this.referencesRecorded = true;
            } else {
                String sceneUrl = this.motionSceneUrlFromMotionLayoutFileName(context);
                Object[] objectArray = new Object[]{KEY_URL, sceneUrl};
                context.report(INVALID_SCENE_FILE_REFERENCE, (Node)element, context.getValueLocation(description), "`" + description.getValue() + "` is an invalid value for layoutDescription", this.fix().name("Create " + sceneUrl + " and set attribute").data(objectArray));
            }
        }
    }

    private final boolean isIncrementalMode(Context context) {
        return !context.getScope().contains(Scope.ALL_RESOURCE_FILES);
    }

    private final String motionSceneUrlFromMotionLayoutFileName(XmlContext context) {
        return "@xml/" + FilesKt.getNameWithoutExtension((File)context.file) + "_scene";
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/tools/lint/checks/MotionLayoutDetector$Companion;", "", "<init>", "()V", "KEY_URL", "", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "INVALID_SCENE_FILE_REFERENCE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

