/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.ApiLookup;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.ExtensionSdk;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.PartialResult;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.VersionChecks;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.USwitchClauseExpressionWithBody;
import org.jetbrains.uast.USwitchExpression;
import org.jetbrains.uast.UYieldExpression;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u00012\u00020\u0002:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/lint/checks/SdkIntDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "getApplicableReferenceNames", "", "", "getApplicableMethodNames", "visitReference", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "reference", "Lorg/jetbrains/uast/UReferenceExpression;", "referenced", "Lcom/intellij/psi/PsiElement;", "visitMethodCall", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "checkPartialResults", "Lcom/android/tools/lint/detector/api/Context;", "partialResults", "Lcom/android/tools/lint/detector/api/PartialResult;", "Companion", "lint-checks"})
public final class SdkIntDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(SdkIntDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    @NotNull
    public List<String> getApplicableReferenceNames() {
        Object[] objectArray = new String[]{"SDK_INT", "SDK_INT_FULL"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public List<String> getApplicableMethodNames() {
        Object[] objectArray = new String[]{"getBuildSdkInt", "getExtensionVersion"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void visitReference(@NotNull JavaContext context, @NotNull UReferenceExpression reference, @NotNull PsiElement referenced) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter((Object)referenced, (String)"referenced");
        JavaEvaluator evaluator = context.getEvaluator();
        if (evaluator.isMemberInClass((PsiMember)(referenced instanceof PsiField ? (PsiField)referenced : null), "android.os.Build.VERSION")) {
            PsiField psiField = referenced instanceof PsiField ? (PsiField)referenced : null;
            boolean isFull = Intrinsics.areEqual((Object)(psiField != null ? psiField.getName() : null), (Object)"SDK_INT_FULL");
            com.android.tools.lint.checks.SdkIntDetector$Companion.checkAnnotation$default(Companion, context, (UElement)reference, 0, isFull, 4, null);
        }
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (Intrinsics.areEqual((Object)method.getName(), (Object)"getExtensionVersion")) {
            if (!context.getEvaluator().isMemberInClass((PsiMember)method, "android.os.ext.SdkExtensions")) {
                return;
            }
            UExpression uExpression = (UExpression)CollectionsKt.firstOrNull((List)node.getValueArguments());
            if (uExpression == null) {
                return;
            }
            UExpression first = uExpression;
            Object object = ConstantEvaluator.evaluate((JavaContext)context, (UElement)((UElement)first));
            Number number = object instanceof Number ? (Number)((Number)object) : (Number)null;
            if (number == null) {
                return;
            }
            int sdkId = number.intValue();
            Companion.checkAnnotation(context, (UElement)node, sdkId, false);
        } else {
            com.android.tools.lint.checks.SdkIntDetector$Companion.checkAnnotation$default(Companion, context, (UElement)node, 0, false, 4, null);
        }
    }

    public void checkPartialResults(@NotNull Context context, @NotNull PartialResult partialResults) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)partialResults, (String)"partialResults");
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"AnnotateVersionCheck", (String)"Annotate SDK_INT checks", (String)"\n                Methods which perform `SDK_INT` version checks (or field constants which reflect \\\n                the result of a version check) in libraries should be annotated with \\\n                `@ChecksSdkIntAtLeast`. This makes it possible for lint to correctly \\\n                check calls into the library later to correctly understand that problematic \\\n                code which is wrapped within a call into this library is safe after all.\n                ", (Implementation)implementation, null, (Category)category, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005J \u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0011H\u0002J@\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005H\u0002J@\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005H\u0002J\u0010\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"H\u0002JB\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010#\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005H\u0002J\"\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u00112\u0006\u0010'\u001a\u00020(H\u0002J\u0018\u0010)\u001a\u00020(2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\"\u0010*\u001a\u00020(2\u0006\u0010+\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010,\u001a\u0004\u0018\u00010\u0011H\u0002J0\u0010-\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010.\u001a\u00020/2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u00100\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010.\u001a\u00020/2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u00101\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u00101\u001a\u0002022\u0006\u0010+\u001a\u00020\u0013H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/android/tools/lint/checks/SdkIntDetector$Companion;", "", "<init>", "()V", "isLambdaType", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "type", "Lcom/intellij/psi/PsiType;", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "checkAnnotation", "", "sdkInt", "Lorg/jetbrains/uast/UElement;", "sdkId", "", "isFull", "isRhsInSdkIntComparison", "comparison", "Lorg/jetbrains/uast/UBinaryExpression;", "parent", "checkMethod", "parentParent", "receiver", "Lorg/jetbrains/uast/UExpression;", "isGreaterOrEquals", "method", "Lorg/jetbrains/uast/UMethod;", "getParameterIndex", "parameter", "Lcom/intellij/psi/PsiParameter;", "lambda", "createAnnotationFix", "Lcom/android/tools/lint/detector/api/LintFix;", "element", "args", "", "getSdkConstant", "getBuildCode", "api", "constant", "checkField", "field", "Lorg/jetbrains/uast/UField;", "checkFieldAlias", "annotated", "Lorg/jetbrains/uast/UAnnotated;", "lint-checks"})
    @SourceDebugExtension(value={"SMAP\nSdkIntDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SdkIntDetector.kt\ncom/android/tools/lint/checks/SdkIntDetector$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,505:1\n1755#2,3:506\n1755#2,3:509\n*S KotlinDebug\n*F\n+ 1 SdkIntDetector.kt\ncom/android/tools/lint/checks/SdkIntDetector$Companion\n*L\n260#1:506,3\n499#1:509,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isLambdaType(JavaContext context, PsiType type) {
            String[] stringArray;
            PsiClassType psiClassType = type instanceof PsiClassType ? (PsiClassType)type : null;
            if (psiClassType == null || (psiClassType = psiClassType.rawType()) == null) {
                return false;
            }
            PsiClassType rawType = psiClassType;
            String string = rawType.getCanonicalText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalText(...)");
            String fqn = string;
            if (Intrinsics.areEqual((Object)fqn, (Object)"java.lang.Runnable") || Intrinsics.areEqual((Object)fqn, (Object)"java.util.function.Function") || StringsKt.startsWith$default((String)fqn, (String)"kotlin.jvm.functions.Function", (boolean)false, (int)2, null)) {
                return true;
            }
            PsiClass psiClass = rawType.resolve();
            if (psiClass == null) {
                return false;
            }
            PsiClass clz = psiClass;
            JavaEvaluator evaluator = context.getEvaluator();
            return evaluator.implementsInterface(clz, "kotlin.Function", false) || evaluator.implementsInterface(clz, "java.util.function.Function", false) || evaluator.getAnnotation((PsiModifierListOwner)clz, stringArray = new String[]{"java.lang.FunctionalInterface"}) != null;
        }

        public final void checkAnnotation(@NotNull JavaContext context, @NotNull UElement sdkInt, int sdkId, boolean isFull) {
            UExpression receiver2;
            UExpression then;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)sdkInt, (String)"sdkInt");
            Project project = context.getProject();
            if (!project.isLibrary() || !project.isAndroidProject()) {
                return;
            }
            UBinaryExpression comparison = (UBinaryExpression)UastUtils.getParentOfType((UElement)sdkInt, UBinaryExpression.class, (boolean)true);
            if (comparison == null) {
                UElement parent = UastUtils.skipParenthesizedExprUp((UElement)sdkInt.getUastParent());
                while (parent instanceof UQualifiedReferenceExpression) {
                    parent = UastUtils.skipParenthesizedExprUp((UElement)((UQualifiedReferenceExpression)parent).getUastParent());
                }
                if (parent instanceof UField) {
                    this.checkFieldAlias(context, (UField)parent, sdkId);
                }
                return;
            }
            UastBinaryOperator tokenType = comparison.getOperator();
            if (tokenType != UastBinaryOperator.GREATER && tokenType != UastBinaryOperator.GREATER_OR_EQUALS) {
                return;
            }
            boolean isGreaterOrEquals = tokenType == UastBinaryOperator.GREATER_OR_EQUALS;
            UElement parent = UastUtils.skipParenthesizedExprUp((UElement)comparison.getUastParent());
            if (sdkId != 0 && parent != null && this.isRhsInSdkIntComparison(context, comparison, parent)) {
                parent = UastUtils.skipParenthesizedExprUp((UElement)parent.getUastParent());
            } else if (sdkId == 0 && parent instanceof UBinaryExpression && Intrinsics.areEqual((Object)((UBinaryExpression)parent).getOperator(), (Object)UastBinaryOperator.LOGICAL_AND)) {
                UExpression left = UastUtils.skipParenthesizedExprDown((UExpression)((UBinaryExpression)parent).getLeftOperand());
                UExpression right = UastUtils.skipParenthesizedExprDown((UExpression)((UBinaryExpression)parent).getRightOperand());
                if (left == comparison) {
                    Object object = ((UBinaryExpression)parent).getRightOperand().getSourcePsi();
                    boolean bl = object != null && (object = object.getText()) != null ? StringsKt.contains$default((CharSequence)((CharSequence)object), (CharSequence)"SDK_INT_FULL", (boolean)false, (int)2, null) : false;
                    if (bl) {
                        return;
                    }
                }
                if (right == comparison) {
                    parent = UastUtils.skipParenthesizedExprUp((UElement)((UBinaryExpression)parent).getUastParent());
                } else {
                    return;
                }
            }
            if (parent instanceof UField) {
                this.checkField(comparison, context, isGreaterOrEquals, (UField)parent, sdkId);
                return;
            }
            if (parent instanceof UReturnExpression) {
                int size;
                UElement parentParent = UastUtils.skipParenthesizedExprUp((UElement)((UReturnExpression)parent).getUastParent());
                if (parentParent instanceof UBlockExpression && ((UBlockExpression)parentParent).getUastParent() instanceof UMethod && (size = ((UBlockExpression)parentParent).getExpressions().size()) == 1) {
                    UElement uElement = ((UBlockExpression)parentParent).getUastParent();
                    Intrinsics.checkNotNull((Object)uElement, (String)"null cannot be cast to non-null type org.jetbrains.uast.UMethod");
                    UMethod method = (UMethod)uElement;
                    com.android.tools.lint.checks.SdkIntDetector$Companion.checkMethod$default(this, comparison, context, isGreaterOrEquals, method, sdkId, 0, isFull, 32, null);
                }
            } else if (parent instanceof UIfExpression) {
                UExpression uExpression;
                UExpression uExpression2;
                UExpression uExpression3;
                UExpression uExpression4;
                UBlockExpression size;
                Object method = ((UIfExpression)parent).getThenExpression();
                UBlockExpression uBlockExpression = size = method instanceof UBlockExpression ? (UBlockExpression)method : null;
                if (size != null && (method = size.getExpressions()) != null && (uExpression4 = (UExpression)CollectionsKt.firstOrNull((List)method)) != null && (uExpression3 = UastUtils.skipParenthesizedExprDown((UExpression)uExpression4)) != null) {
                    uExpression2 = uExpression3;
                } else {
                    UExpression uExpression5 = ((UIfExpression)parent).getThenExpression();
                    if (uExpression5 != null) {
                        uExpression2 = UastUtils.skipParenthesizedExprDown((UExpression)uExpression5);
                    } else {
                        return;
                    }
                }
                method = then = uExpression2;
                if (method instanceof UQualifiedReferenceExpression) {
                    uExpression = UastUtils.skipParenthesizedExprDown((UExpression)((UQualifiedReferenceExpression)then).getReceiver());
                } else if (method instanceof UCallExpression) {
                    uExpression = ((UCallExpression)then).getReceiver();
                    if (uExpression == null || (uExpression = UastUtils.skipParenthesizedExprDown((UExpression)uExpression)) == null) {
                        return;
                    }
                } else {
                    return;
                }
                receiver2 = uExpression;
                UElement uElement = UastUtils.skipParenthesizedExprUp((UElement)((UIfExpression)parent).getUastParent());
                if (uElement == null) {
                    return;
                }
                UElement parentParent2 = uElement;
                this.checkMethod(parentParent2, context, receiver2, comparison, isGreaterOrEquals, sdkId, isFull);
            } else if (parent instanceof USwitchClauseExpressionWithBody && ((USwitchClauseExpressionWithBody)parent).getBody().getExpressions().size() == 1) {
                boolean bl;
                UElement parentParent;
                block41: {
                    USwitchExpression switchExpression;
                    UExpression uExpression;
                    UExpression parentParent2;
                    then = UastUtils.skipParenthesizedExprDown((UExpression)((UExpression)((USwitchClauseExpressionWithBody)parent).getBody().getExpressions().get(0)));
                    if (then instanceof UYieldExpression) {
                        UExpression uExpression6 = ((UYieldExpression)then).getExpression();
                        if (uExpression6 == null || (uExpression6 = UastUtils.skipParenthesizedExprDown((UExpression)uExpression6)) == null) {
                            return;
                        }
                        then = uExpression6;
                    }
                    if ((parentParent2 = then) instanceof UQualifiedReferenceExpression) {
                        uExpression = UastUtils.skipParenthesizedExprDown((UExpression)((UQualifiedReferenceExpression)then).getReceiver());
                    } else if (parentParent2 instanceof UCallExpression) {
                        uExpression = ((UCallExpression)then).getReceiver();
                        if (uExpression == null || (uExpression = UastUtils.skipParenthesizedExprDown((UExpression)uExpression)) == null) {
                            return;
                        }
                    } else {
                        return;
                    }
                    receiver2 = uExpression;
                    USwitchExpression uSwitchExpression = switchExpression = (USwitchExpression)UastUtils.getParentOfType$default((UElement)parent, USwitchExpression.class, (boolean)false, (int)2, null);
                    UElement uElement = UastUtils.skipParenthesizedExprUp((UElement)(uSwitchExpression != null ? uSwitchExpression.getUastParent() : null));
                    if (uElement == null) {
                        return;
                    }
                    parentParent = uElement;
                    Iterable $this$any$iv = ((USwitchClauseExpressionWithBody)parent).getCaseValues();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            UExpression it = (UExpression)element$iv;
                            boolean bl2 = false;
                            if (!UastUtils.isUastChildOf$default((UElement)((UElement)it), (UElement)((UElement)comparison), (boolean)false, (int)2, null)) continue;
                            bl = true;
                            break block41;
                        }
                        bl = false;
                    }
                }
                if (!bl) {
                    return;
                }
                this.checkMethod(parentParent, context, receiver2, comparison, isGreaterOrEquals, sdkId, isFull);
            }
        }

        public static /* synthetic */ void checkAnnotation$default(Companion companion, JavaContext javaContext, UElement uElement, int n, boolean bl, int n2, Object object) {
            if ((n2 & 4) != 0) {
                n = 0;
            }
            companion.checkAnnotation(javaContext, uElement, n, bl);
        }

        private final boolean isRhsInSdkIntComparison(JavaContext context, UBinaryExpression comparison, UElement parent) {
            Project project;
            JavaEvaluator evaluator;
            UBinaryExpression uBinaryExpression = parent instanceof UBinaryExpression ? (UBinaryExpression)parent : null;
            if (uBinaryExpression == null) {
                return false;
            }
            UBinaryExpression outer = uBinaryExpression;
            if (!Intrinsics.areEqual((Object)outer.getOperator(), (Object)UastBinaryOperator.LOGICAL_AND)) {
                return false;
            }
            if (UastUtils.skipParenthesizedExprDown((UExpression)((UBinaryExpression)parent).getRightOperand()) != comparison) {
                return false;
            }
            UExpression leftOperand = UastUtils.skipParenthesizedExprDown((UExpression)((UBinaryExpression)parent).getLeftOperand());
            UBinaryExpression uBinaryExpression2 = leftOperand instanceof UBinaryExpression ? (UBinaryExpression)leftOperand : null;
            if (uBinaryExpression2 == null) {
                return false;
            }
            UBinaryExpression leftComparison = uBinaryExpression2;
            LintClient client = context.getClient();
            return VersionChecks.Companion.getVersionCheckConditional(leftComparison, client, evaluator = context.getEvaluator(), project = context.getProject(), null) != null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final void checkMethod(UElement parentParent, JavaContext context, UExpression receiver2, UBinaryExpression comparison, boolean isGreaterOrEquals, int sdkId, boolean isFull) {
            UMethod uMethod;
            if (parentParent instanceof UReturnExpression) {
                UElement uElement = parentParent.getUastParent();
                uMethod = uElement instanceof UMethod ? (UMethod)uElement : null;
                if (uMethod == null) {
                    UElement uElement2 = parentParent.getUastParent();
                    UElement uElement3 = uElement2 != null ? uElement2.getUastParent() : null;
                    if (!(uElement3 instanceof UMethod)) return;
                    UMethod uMethod2 = (UMethod)uElement3;
                    uMethod = uMethod2;
                    if (uMethod2 == null) {
                        return;
                    }
                }
            } else {
                UElement uElement;
                if (!(parentParent instanceof UBlockExpression)) return;
                if (!(parentParent.getUastParent() instanceof UMethod)) return;
                List expressions = ((UBlockExpression)parentParent).getExpressions();
                if (expressions.size() != 1) {
                    if (expressions.size() != 2) return;
                    if (!(UastUtils.skipParenthesizedExprDown((UExpression)((UExpression)expressions.get(1))) instanceof UReturnExpression)) return;
                }
                if ((uMethod = (uElement = parentParent.getUastParent()) instanceof UMethod ? (UMethod)uElement : null) == null) {
                    UElement uElement4 = parentParent.getUastParent();
                    UElement uElement5 = uElement4 != null ? uElement4.getUastParent() : null;
                    if (!(uElement5 instanceof UMethod)) return;
                    UMethod uMethod3 = (UMethod)uElement5;
                    uMethod = uMethod3;
                    if (uMethod3 == null) {
                        return;
                    }
                }
            }
            UMethod method = uMethod;
            this.checkMethod(context, method, receiver2, comparison, isGreaterOrEquals, sdkId, isFull);
        }

        private final void checkMethod(JavaContext context, UMethod method, UExpression receiver2, UBinaryExpression comparison, boolean isGreaterOrEquals, int sdkId, boolean isFull) {
            PsiElement psiElement = UastUtils.tryResolve((UElement)((UElement)receiver2));
            PsiParameter psiParameter = psiElement instanceof PsiParameter ? (PsiParameter)psiElement : null;
            if (psiParameter == null) {
                return;
            }
            PsiParameter parameter = psiParameter;
            int index2 = this.getParameterIndex(parameter);
            if (index2 != -1 && this.isLambdaType(context, parameter.getType())) {
                this.checkMethod(comparison, context, isGreaterOrEquals, method, sdkId, index2, isFull);
            }
        }

        private final int getParameterIndex(PsiParameter parameter) {
            PsiElement psiElement = parameter.getParent();
            PsiParameterList psiParameterList = psiElement instanceof PsiParameterList ? (PsiParameterList)psiElement : null;
            if (psiParameterList == null) {
                return -1;
            }
            PsiParameterList parameterList = psiParameterList;
            return parameterList.getParameterIndex(parameter);
        }

        private final void checkMethod(UBinaryExpression comparison, JavaContext context, boolean isGreaterOrEquals, UMethod method, int sdkId, int lambda, boolean isFull) {
            Object apiValue;
            Integer api2;
            if (!context.getEvaluator().isPublic((UDeclaration)method)) {
                return;
            }
            UExpression apiOperand = UastUtils.skipParenthesizedExprDown((UExpression)comparison.getRightOperand());
            Object object = apiOperand.evaluate();
            if (object == null) {
                object = ConstantEvaluator.evaluate((JavaContext)context, (UElement)((UElement)apiOperand));
            }
            Integer n = api2 = (apiValue = object) instanceof Integer ? (Integer)apiValue : null;
            if (api2 != null) {
                int apiAtLeast;
                int n2 = apiAtLeast = isGreaterOrEquals ? api2 : api2 + 1;
                if (!this.annotated(context, (UAnnotated)method, apiAtLeast)) {
                    String buildCode = this.getBuildCode(apiAtLeast, sdkId, (UElement)(isGreaterOrEquals ? apiOperand : null));
                    Location location = context.getNameLocation(method).withOriginalSource((Object)method);
                    String args = "api=" + buildCode + (String)(lambda != -1 ? ", lambda=" + lambda : "") + (String)(sdkId != 0 ? ", extension=" + this.getSdkConstant(context, sdkId) : "");
                    String message2 = "This method should be annotated with `@ChecksSdkIntAtLeast(" + args + ")`";
                    LintFix fix = this.createAnnotationFix(context, (UElement)method, args);
                    context.report(ISSUE, method, location, message2, fix);
                    if (!context.isGlobalAnalysis()) {
                        String methodDesc = VersionChecks.SdkIntAnnotation.Companion.getMethodKey(context.getEvaluator(), method);
                        LintMap map = context.getPartialResults(VersionChecks.SDK_INT_VERSION_DATA).map();
                        map.put(methodDesc, "api=" + apiAtLeast + (String)(lambda != -1 ? ",lambda=" + lambda : "") + (String)(sdkId != 0 ? ", extension=" + sdkId : ""));
                    }
                }
            } else if (apiOperand instanceof UReferenceExpression) {
                int index2;
                if (isFull) {
                    return;
                }
                PsiElement parameter = ((UReferenceExpression)apiOperand).resolve();
                if (parameter instanceof PsiParameter && (index2 = this.getParameterIndex((PsiParameter)parameter)) != -1 && !this.annotated(context, (UAnnotated)method, -1)) {
                    String args = "parameter=" + index2 + (String)(lambda != -1 ? ", lambda=" + lambda : "") + (String)(sdkId != 0 ? ", extension=" + this.getSdkConstant(context, sdkId) : "");
                    String message3 = "This method should be annotated with `@ChecksSdkIntAtLeast(" + args + ")`";
                    Location location = context.getNameLocation(method).withOriginalSource((Object)method);
                    LintFix fix = this.createAnnotationFix(context, (UElement)method, args);
                    context.report(ISSUE, method, location, message3, fix);
                    if (!context.isGlobalAnalysis()) {
                        String methodDesc = VersionChecks.SdkIntAnnotation.Companion.getMethodKey(context.getEvaluator(), method);
                        LintMap map = context.getPartialResults(VersionChecks.SDK_INT_VERSION_DATA).map();
                        map.put(methodDesc, "parameter=" + index2 + (String)(lambda != -1 ? ",lambda=" + lambda : "") + (String)(sdkId != 0 ? ", extension=" + sdkId : ""));
                    }
                }
            }
        }

        static /* synthetic */ void checkMethod$default(Companion companion, UBinaryExpression uBinaryExpression, JavaContext javaContext, boolean bl, UMethod uMethod, int n, int n2, boolean bl2, int n3, Object object) {
            if ((n3 & 0x20) != 0) {
                n2 = -1;
            }
            companion.checkMethod(uBinaryExpression, javaContext, bl, uMethod, n, n2, bl2);
        }

        private final LintFix createAnnotationFix(JavaContext context, UElement element, String args) {
            if (context.getEvaluator().findClass("androidx.annotation.ChecksSdkIntAtLeast") == null) {
                return null;
            }
            return LintFix.Builder.annotate$default((LintFix.Builder)LintFix.Companion.create(), (String)("androidx.annotation.ChecksSdkIntAtLeast(" + args + ")"), (Context)((Context)context), (PsiElement)element.getSourcePsi(), (boolean)false, (int)8, null).build();
        }

        private final String getSdkConstant(JavaContext context, int sdkId) {
            String string = ApiLookup.getSdkExtensionField(context, sdkId, true);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSdkExtensionField(...)");
            return string;
        }

        private final String getBuildCode(int api2, int sdkId, UElement constant) {
            String text;
            UReferenceExpression uReferenceExpression = constant instanceof UReferenceExpression ? (UReferenceExpression)constant : null;
            String string = uReferenceExpression != null && (uReferenceExpression = uReferenceExpression.getSourcePsi()) != null ? uReferenceExpression.getText() : (text = null);
            if (text != null) {
                return text;
            }
            if (sdkId != 0) {
                return String.valueOf(api2);
            }
            return ExtensionSdk.Companion.getAndroidVersionField(api2, true);
        }

        private final void checkField(UBinaryExpression comparison, JavaContext context, boolean isGreaterOrEquals, UField field, int sdkId) {
            int atLeast;
            Object value;
            if (!context.getEvaluator().isPublic((UDeclaration)field)) {
                return;
            }
            UExpression apiOperand = UastUtils.skipParenthesizedExprDown((UExpression)comparison.getRightOperand());
            Object object = apiOperand.evaluate();
            if (object == null) {
                object = ConstantEvaluator.evaluate((JavaContext)context, (UElement)((UElement)apiOperand));
            }
            Integer n = (value = object) instanceof Integer ? (Integer)value : null;
            if (n == null) {
                return;
            }
            int api2 = n;
            int n2 = atLeast = isGreaterOrEquals ? api2 : api2 + 1;
            if (!this.annotated(context, (UAnnotated)field, atLeast)) {
                String buildCode = this.getBuildCode(atLeast, sdkId, (UElement)(isGreaterOrEquals ? apiOperand : null));
                String args = "api=" + buildCode + (String)(sdkId != 0 ? ", extension=" + this.getSdkConstant(context, sdkId) : "");
                String message2 = "This field should be annotated with `ChecksSdkIntAtLeast(" + args + ")`";
                Location location = context.getNameLocation((UDeclaration)field).withOriginalSource((Object)field);
                LintFix fix = this.createAnnotationFix(context, (UElement)field, args);
                context.report(ISSUE, field, location, message2, fix);
                if (!context.isGlobalAnalysis()) {
                    String fieldDesc = VersionChecks.SdkIntAnnotation.Companion.getFieldKey(context.getEvaluator(), field);
                    LintMap map = context.getPartialResults(VersionChecks.SDK_INT_VERSION_DATA).map();
                    map.put(fieldDesc, "api=" + atLeast + (String)(sdkId != 0 ? ", extension=" + sdkId : ""));
                }
            }
        }

        private final void checkFieldAlias(JavaContext context, UField field, int sdkId) {
            if (context.getEvaluator().isPublic((UDeclaration)field) && !this.annotated(context, (UAnnotated)field, -1)) {
                String args = "extension=" + this.getSdkConstant(context, sdkId);
                String message2 = "This field should be annotated with `ChecksSdkIntAtLeast(" + args + ")`";
                Location location = context.getNameLocation((UDeclaration)field).withOriginalSource((Object)field);
                LintFix fix = this.createAnnotationFix(context, (UElement)field, args);
                context.report(ISSUE, field, location, message2, fix);
                if (!context.isGlobalAnalysis()) {
                    String fieldDesc = VersionChecks.SdkIntAnnotation.Companion.getFieldKey(context.getEvaluator(), field);
                    LintMap map = context.getPartialResults(VersionChecks.SDK_INT_VERSION_DATA).map();
                    map.put(fieldDesc, "extension=" + sdkId);
                }
            }
        }

        private final boolean annotated(JavaContext context, UAnnotated annotated, int api2) {
            boolean bl;
            block3: {
                Iterable $this$any$iv = context.getEvaluator().getAllAnnotations(annotated, false);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        UAnnotation it = (UAnnotation)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getQualifiedName(), (Object)"androidx.annotation.ChecksSdkIntAtLeast")) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

