/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.SdkConstants;
import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.AdbDevice;
import com.android.ddmlib.AdbHelper;
import com.android.ddmlib.AdbInitOptions;
import com.android.ddmlib.AdbVersion;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.AndroidDebugBridgeChangeEvents;
import com.android.ddmlib.AndroidDebugBridgeDelegate;
import com.android.ddmlib.Client;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IDeviceUsageTracker;
import com.android.ddmlib.Log;
import com.android.ddmlib.TimeoutException;
import com.android.ddmlib.clientmanager.ClientManager;
import com.android.ddmlib.idevicemanager.IDeviceManagerFactory;
import com.android.ddmlib.internal.DeviceMonitor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.SettableFuture;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public abstract class AndroidDebugBridgeBase
implements AndroidDebugBridgeDelegate {
    protected static final AndroidDebugBridgeChangeEvents adbChangeEvents = new AndroidDebugBridgeChangeEvents();
    public static final long DEFAULT_START_ADB_TIMEOUT_MILLIS = 20000L;
    protected static final String ADB = "adb";
    private static final String DDMS = "ddms";
    private static final String SERVER_PORT_ENV_VAR = "ANDROID_ADB_SERVER_PORT";
    public static final int DEFAULT_ADB_PORT = 5037;
    private static final int STATUS_DLL_NOT_FOUND = -1073741515;
    protected static boolean sUnitTestMode;
    protected int sAdbServerPort = 0;
    protected static boolean sUserManagedAdbMode;
    protected static final Object sLastKnownGoodAddressLock;
    protected volatile InetSocketAddress sLastKnownGoodAddress;
    protected volatile AndroidDebugBridge sThis;
    protected volatile boolean sInitialized = false;
    private static boolean sClientSupport;
    private static ClientManager sClientManager;
    private static IDeviceManagerFactory sIDeviceManagerFactory;
    private static IDeviceUsageTracker iDeviceUsageTracker;
    protected static Map<String, String> sAdbEnvVars;
    protected String mAdbOsLocation = null;
    protected AdbVersion mAdbVersion;
    protected boolean mVersionCheck;
    protected boolean mStarted = false;

    @Override
    @Deprecated
    public synchronized void initIfNeeded(boolean clientSupport) {
        if (this.sInitialized) {
            return;
        }
        this.init(clientSupport);
    }

    @Override
    public synchronized void init(boolean clientSupport) {
        this.init(clientSupport, false, (Map<String, String>)ImmutableMap.of());
    }

    @Override
    public synchronized void init(boolean clientSupport, boolean useLibusb, Map<String, String> env) {
        this.init(AdbInitOptions.builder().withEnv(env).setClientSupportEnabled(clientSupport).withEnv("ADB_LIBUSB", useLibusb ? "1" : "0").build());
    }

    @Override
    public synchronized void init(AdbInitOptions options) {
        Preconditions.checkState((!this.sInitialized ? 1 : 0) != 0, (Object)"AndroidDebugBridge.init() has already been called.");
        this.sInitialized = true;
        sIDeviceManagerFactory = options.iDeviceManagerFactory;
        iDeviceUsageTracker = options.iDeviceUsageTracker;
        sClientSupport = options.clientSupport;
        sClientManager = options.clientManager;
        if (sClientManager != null) {
            sClientSupport = false;
        }
        if (sIDeviceManagerFactory != null) {
            sClientManager = null;
            sClientSupport = false;
        }
        sAdbEnvVars = options.adbEnvVars;
        sUserManagedAdbMode = options.userManagedAdbMode;
        this.sLastKnownGoodAddress = null;
        DdmPreferences.enableJdwpProxyService(options.useJdwpProxyService);
        DdmPreferences.enableDdmlibCommandService(options.useDdmlibCommandService);
        DdmPreferences.setsJdwpMaxPacketSize(options.maxJdwpPacketSize);
        this.initAdbPort(options.userManagedAdbPort);
    }

    @Override
    public synchronized boolean optionsChanged(AdbInitOptions options, String osLocation, boolean forceNewBridge, long terminateTimeout, long initTimeout, TimeUnit unit) {
        boolean bridgeNeedsRestart;
        if (!this.sInitialized) {
            return true;
        }
        boolean bl = bridgeNeedsRestart = this.getBridge() != null;
        if (bridgeNeedsRestart && !this.disconnectBridge(terminateTimeout, unit)) {
            Log.e(DDMS, "Could not disconnect bridge prior to restart when options changed.");
            return false;
        }
        this.terminate();
        this.init(options);
        if (bridgeNeedsRestart && this.createBridge(osLocation, forceNewBridge, initTimeout, unit) == null) {
            Log.e(DDMS, "Could not recreate the bridge after options changed.");
            return false;
        }
        return true;
    }

    @Override
    @VisibleForTesting
    public void enableFakeAdbServerMode(int port) {
        Preconditions.checkState((!this.sInitialized ? 1 : 0) != 0, (Object)"AndroidDebugBridge.init() has already been called or terminate() has not been called yet.");
        sUnitTestMode = true;
        this.sAdbServerPort = port;
    }

    @Override
    @VisibleForTesting
    public void disableFakeAdbServerMode() {
        Preconditions.checkState((!this.sInitialized ? 1 : 0) != 0, (Object)"AndroidDebugBridge.init() has already been called or terminate() has not been called yet.");
        sUnitTestMode = false;
        this.sAdbServerPort = 0;
    }

    @Override
    public boolean getClientSupport() {
        return sClientSupport;
    }

    @Override
    public ClientManager getClientManager() {
        return sClientManager;
    }

    @Override
    public SocketChannel openConnection() throws IOException {
        SocketChannel adbChannel;
        try {
            adbChannel = SocketChannel.open(new InetSocketAddress("127.0.0.1", this.sAdbServerPort));
        }
        catch (IOException ipv4Exception) {
            try {
                adbChannel = SocketChannel.open(new InetSocketAddress("::1", this.sAdbServerPort));
            }
            catch (IOException ipv6Exception) {
                IOException combinedException = new IOException("Can't find adb server on port " + this.sAdbServerPort + ", IPv4 attempt: " + ipv4Exception.getMessage() + ", IPv6 attempt: " + ipv6Exception.getMessage(), ipv4Exception);
                combinedException.addSuppressed(ipv6Exception);
                throw combinedException;
            }
        }
        adbChannel.socket().setTcpNoDelay(true);
        return adbChannel;
    }

    @Override
    public AndroidDebugBridge createBridge() {
        return this.createBridge(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    @Override
    @Deprecated
    public AndroidDebugBridge createBridge(String osLocation, boolean forceNewBridge) {
        return this.createBridge(osLocation, forceNewBridge, Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    @Override
    public AndroidDebugBridge getBridge() {
        return this.sThis;
    }

    @Override
    @Deprecated
    public void disconnectBridge() {
        this.disconnectBridge(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    @Override
    public void addDebugBridgeChangeListener(AndroidDebugBridge.IDebugBridgeChangeListener listener) {
        adbChangeEvents.addDebugBridgeChangeListener(listener);
        AndroidDebugBridge localThis = this.sThis;
        if (localThis != null) {
            try {
                listener.bridgeChanged(localThis);
            }
            catch (Throwable t) {
                Log.e(DDMS, t);
            }
        }
    }

    @Override
    public void removeDebugBridgeChangeListener(AndroidDebugBridge.IDebugBridgeChangeListener listener) {
        adbChangeEvents.removeDebugBridgeChangeListener(listener);
    }

    @Override
    @VisibleForTesting
    public int getDebugBridgeChangeListenerCount() {
        return adbChangeEvents.debugBridgeChangeListenerCount();
    }

    @Override
    public void addDeviceChangeListener(AndroidDebugBridge.IDeviceChangeListener listener) {
        adbChangeEvents.addDeviceChangeListener(listener);
    }

    @Override
    public void removeDeviceChangeListener(AndroidDebugBridge.IDeviceChangeListener listener) {
        adbChangeEvents.removeDeviceChangeListener(listener);
    }

    @Override
    @VisibleForTesting
    public int getDeviceChangeListenerCount() {
        return adbChangeEvents.deviceChangeListenerCount();
    }

    @Override
    public void addClientChangeListener(AndroidDebugBridge.IClientChangeListener listener) {
        adbChangeEvents.addClientChangeListener(listener);
    }

    @Override
    public void removeClientChangeListener(AndroidDebugBridge.IClientChangeListener listener) {
        adbChangeEvents.removeClientChangeListener(listener);
    }

    @Override
    public AdbVersion getCurrentAdbVersion() {
        return this.mAdbVersion;
    }

    @Override
    public IDeviceUsageTracker getiDeviceUsageTracker() {
        return iDeviceUsageTracker;
    }

    @Deprecated
    private static <T> ListenableFuture<T> runAdb(File adb, AndroidDebugBridge.AdbOutputProcessor<T> resultParser, String ... command) {
        SettableFuture future = SettableFuture.create();
        new Thread(() -> {
            Process p;
            ArrayList<String> args = new ArrayList<String>();
            args.add(adb.getPath());
            args.addAll(Arrays.asList(command));
            ProcessBuilder pb = new ProcessBuilder(args);
            pb.redirectErrorStream(true);
            try {
                p = pb.start();
            }
            catch (IOException e) {
                future.setException((Throwable)e);
                return;
            }
            try (BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));){
                future.set(resultParser.process(p, br));
            }
            catch (IOException e) {
                future.setException((Throwable)e);
                return;
            }
            catch (RuntimeException e) {
                future.setException((Throwable)e);
            }
        }, "Running adb").start();
        return future;
    }

    @Override
    public ListenableFuture<AdbVersion> getAdbVersion(File adb) {
        return AndroidDebugBridgeBase.runAdb(adb, (process, br) -> {
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                AdbVersion version = AdbVersion.parseFrom(line);
                if (version != AdbVersion.UNKNOWN) {
                    return version;
                }
                sb.append(line);
                sb.append('\n');
            }
            Object errorMessage = "Unable to detect adb version";
            int exitValue = process.exitValue();
            if (exitValue != 0) {
                errorMessage = (String)errorMessage + ", exit value: 0x" + Integer.toHexString(exitValue);
                if (exitValue == -1073741515 && SdkConstants.currentPlatform() == 2) {
                    errorMessage = (String)errorMessage + ". ADB depends on the Windows Universal C Runtime, which is usually installed by default via Windows Update. You may need to manually fetch and install the runtime package here: https://support.microsoft.com/en-ca/help/2999226/update-for-universal-c-runtime-in-windows";
                    throw new RuntimeException((String)errorMessage);
                }
            }
            if (sb.length() > 0) {
                errorMessage = (String)errorMessage + ", adb output: " + sb.toString();
            }
            throw new RuntimeException((String)errorMessage);
        }, "version");
    }

    private static ListenableFuture<List<AdbDevice>> getRawDeviceList(File adb) {
        return AndroidDebugBridgeBase.runAdb(adb, (process, br) -> {
            String line;
            br.readLine();
            ArrayList<AdbDevice> result = new ArrayList<AdbDevice>();
            while ((line = br.readLine()) != null) {
                AdbDevice device = AdbDevice.parseAdbLine(line);
                if (device == null) continue;
                result.add(device);
            }
            return result;
        }, "devices", "-l");
    }

    @Override
    public ListenableFuture<String> getVirtualDeviceId(ListeningExecutorService service, File adb, IDevice device) {
        List<String> command = Arrays.asList(adb.toString(), "-s", device.getSerialNumber(), "emu", "avd", "id");
        return AndroidDebugBridgeBase.execute(service, command, AndroidDebugBridgeBase::processVirtualDeviceIdCommandOutput);
    }

    private static String processVirtualDeviceIdCommandOutput(Process process, BufferedReader reader) {
        List lines = reader.lines().collect(Collectors.toList());
        if (lines.size() != 2) {
            return "";
        }
        if (!((String)lines.get(1)).equals("OK")) {
            return "";
        }
        String result = (String)lines.get(0);
        assert (!result.isEmpty());
        return result;
    }

    private static <T> ListenableFuture<T> execute(ListeningExecutorService service, List<String> command, AndroidDebugBridge.AdbOutputProcessor<T> processor) {
        return service.submit(() -> {
            ProcessBuilder builder = new ProcessBuilder(command);
            builder.redirectErrorStream(true);
            Process process = builder.start();
            try (BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
                Object t = processor.process(process, in);
                return t;
            }
        });
    }

    @Override
    public ListenableFuture<List<AdbDevice>> getRawDeviceList() {
        if (this.mAdbOsLocation == null) {
            SettableFuture result = SettableFuture.create();
            result.set(Collections.emptyList());
            return result;
        }
        File adb = new File(this.mAdbOsLocation);
        return AndroidDebugBridgeBase.getRawDeviceList(adb);
    }

    @Override
    public void deviceConnected(IDevice device) {
        adbChangeEvents.notifyDeviceConnected(device);
    }

    @Override
    public void deviceDisconnected(IDevice device) {
        adbChangeEvents.notifyDeviceDisconnected(device);
    }

    @Override
    public void deviceChanged(IDevice device, int changeMask) {
        adbChangeEvents.notifyDeviceChanged(device, changeMask);
    }

    @Override
    public void clientChanged(Client client, int changeMask) {
        adbChangeEvents.notifyClientChanged(client, changeMask);
    }

    @Override
    public boolean isUserManagedAdbMode() {
        return sUserManagedAdbMode;
    }

    @Override
    public String queryFeatures(String adbFeaturesRequest) throws TimeoutException, AdbCommandRejectedException, IOException {
        try (SocketChannel adbChan = AndroidDebugBridge.openConnection();){
            adbChan.configureBlocking(false);
            byte[] request = AdbHelper.formAdbRequest(adbFeaturesRequest);
            AdbHelper.write(adbChan, request);
            AdbHelper.AdbResponse resp = AdbHelper.readAdbResponse(adbChan, true);
            if (!resp.okay) {
                Log.w("features", "Error querying features: " + resp.message);
                throw new AdbCommandRejectedException(resp.message);
            }
            String string = resp.message;
            return string;
        }
    }

    private void initAdbPort(int userManagedAdbPort) {
        if (!sUnitTestMode) {
            this.sAdbServerPort = sUserManagedAdbMode ? userManagedAdbPort : AndroidDebugBridgeBase.getAdbServerPort();
        }
    }

    private static int getAdbServerPort() {
        String msg;
        Integer prop = Integer.getInteger(SERVER_PORT_ENV_VAR);
        if (prop != null) {
            try {
                return AndroidDebugBridgeBase.validateAdbServerPort(prop.toString());
            }
            catch (IllegalArgumentException e) {
                msg = String.format("Invalid value (%1$s) for ANDROID_ADB_SERVER_PORT system property.", prop);
                Log.w(DDMS, msg);
            }
        }
        try {
            String env = System.getenv(SERVER_PORT_ENV_VAR);
            if (env != null) {
                return AndroidDebugBridgeBase.validateAdbServerPort(env);
            }
        }
        catch (SecurityException ex) {
            Log.w(DDMS, "No access to env variables allowed by current security manager. If you've set ANDROID_ADB_SERVER_PORT: it's being ignored.");
        }
        catch (IllegalArgumentException e) {
            msg = String.format("Invalid value (%1$s) for ANDROID_ADB_SERVER_PORT environment variable (%2$s).", prop, e.getMessage());
            Log.w(DDMS, msg);
        }
        return 5037;
    }

    private static int validateAdbServerPort(String adbServerPort) throws IllegalArgumentException {
        try {
            int port = Integer.decode(adbServerPort);
            if (port <= 0 || port >= 65535) {
                throw new IllegalArgumentException("Should be > 0 and < 65535");
            }
            return port;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Not a valid port number");
        }
    }

    static {
        sUserManagedAdbMode = false;
        sLastKnownGoodAddressLock = new Object();
    }

    private static class MonitorErrorHandler
    implements DeviceMonitor.MonitorErrorHandler {
        private MonitorErrorHandler() {
        }

        @Override
        public void initializationError(Exception e) {
            adbChangeEvents.notifyBridgeInitializationError(e);
        }
    }
}

