/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.google.common.collect.Sets;
import java.util.Set;

public class AndroidDebugBridgeChangeEvents {
    private static final String ADB = "adb";
    private final Set<AndroidDebugBridge.IDebugBridgeChangeListener> bridgeListeners = Sets.newCopyOnWriteArraySet();
    private final Set<AndroidDebugBridge.IDeviceChangeListener> deviceListeners = Sets.newCopyOnWriteArraySet();
    private final Set<AndroidDebugBridge.IClientChangeListener> clientListeners = Sets.newCopyOnWriteArraySet();

    public void addDebugBridgeChangeListener(AndroidDebugBridge.IDebugBridgeChangeListener listener) {
        this.bridgeListeners.add(listener);
    }

    public void removeDebugBridgeChangeListener(AndroidDebugBridge.IDebugBridgeChangeListener listener) {
        this.bridgeListeners.remove(listener);
    }

    public int debugBridgeChangeListenerCount() {
        return this.bridgeListeners.size();
    }

    public void notifyBridgeChanged(AndroidDebugBridge bridge) {
        for (AndroidDebugBridge.IDebugBridgeChangeListener listener : this.bridgeListeners) {
            try {
                listener.bridgeChanged(bridge);
            }
            catch (Throwable t) {
                Log.e(ADB, t);
            }
        }
    }

    public void notifyBridgeRestartInitiated() {
        for (AndroidDebugBridge.IDebugBridgeChangeListener listener : this.bridgeListeners) {
            try {
                listener.restartInitiated();
            }
            catch (Throwable t) {
                Log.e(ADB, t);
            }
        }
    }

    public void notifyBridgeRestartCompleted(boolean isSuccessful) {
        for (AndroidDebugBridge.IDebugBridgeChangeListener listener : this.bridgeListeners) {
            try {
                listener.restartCompleted(isSuccessful);
            }
            catch (Throwable t) {
                Log.e(ADB, t);
            }
        }
    }

    public void notifyBridgeInitializationError(Exception e) {
        for (AndroidDebugBridge.IDebugBridgeChangeListener listener : this.bridgeListeners) {
            try {
                listener.initializationError(e);
            }
            catch (Throwable t) {
                Log.e(ADB, t);
            }
        }
    }

    public void addDeviceChangeListener(AndroidDebugBridge.IDeviceChangeListener listener) {
        this.deviceListeners.add(listener);
    }

    public void removeDeviceChangeListener(AndroidDebugBridge.IDeviceChangeListener listener) {
        this.deviceListeners.remove(listener);
    }

    public int deviceChangeListenerCount() {
        return this.deviceListeners.size();
    }

    public void notifyDeviceChanged(IDevice device, int changeMask) {
        for (AndroidDebugBridge.IDeviceChangeListener listener : this.deviceListeners) {
            try {
                listener.deviceChanged(device, changeMask);
            }
            catch (Throwable t) {
                Log.e(ADB, t);
            }
        }
    }

    public void notifyDeviceConnected(IDevice device) {
        for (AndroidDebugBridge.IDeviceChangeListener listener : this.deviceListeners) {
            try {
                listener.deviceConnected(device);
            }
            catch (Throwable t) {
                Log.e(ADB, t);
            }
        }
    }

    public void notifyDeviceDisconnected(IDevice device) {
        for (AndroidDebugBridge.IDeviceChangeListener listener : this.deviceListeners) {
            try {
                listener.deviceDisconnected(device);
            }
            catch (Throwable t) {
                Log.e(ADB, t);
            }
        }
    }

    public void addClientChangeListener(AndroidDebugBridge.IClientChangeListener listener) {
        this.clientListeners.add(listener);
    }

    public void removeClientChangeListener(AndroidDebugBridge.IClientChangeListener listener) {
        this.clientListeners.remove(listener);
    }

    public void notifyClientChanged(Client client, int changeMask) {
        for (AndroidDebugBridge.IClientChangeListener listener : this.clientListeners) {
            try {
                listener.clientChanged(client, changeMask);
            }
            catch (Throwable t) {
                Log.e(ADB, t);
            }
        }
    }
}

