/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.SdkConstants;
import com.android.tools.lint.client.api.CompositeIssueRegistry;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.JarFileIssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.LintJarApiMigration;
import com.android.tools.lint.client.api.LintJarVerifier;
import com.android.tools.lint.client.api.Vendor;
import com.android.tools.lint.detector.api.ApiKt;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 %2\u00020\u0001:\u0001%B)\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000f\u001a\u00020\u0010H\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001dR\u0014\u0010 \u001a\u00020\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001dR\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0015\u00a8\u0006&"}, d2={"Lcom/android/tools/lint/client/api/JarFileIssueRegistry;", "Lcom/android/tools/lint/client/api/IssueRegistry;", "client", "Lcom/android/tools/lint/client/api/LintClient;", "jarFile", "Ljava/io/File;", "registry", "vendor", "Lcom/android/tools/lint/client/api/Vendor;", "<init>", "(Lcom/android/tools/lint/client/api/LintClient;Ljava/io/File;Lcom/android/tools/lint/client/api/IssueRegistry;Lcom/android/tools/lint/client/api/Vendor;)V", "getJarFile", "()Ljava/io/File;", "getVendor", "()Lcom/android/tools/lint/client/api/Vendor;", "cacheable", "", "issues", "", "Lcom/android/tools/lint/detector/api/Issue;", "getIssues", "()Ljava/util/List;", "timestamp", "", "isUpToDate", "()Z", "api", "", "getApi", "()I", "minApi", "getMinApi", "maxApi", "getMaxApi", "deletedIssues", "", "getDeletedIssues", "Factory", "lint-api"})
public final class JarFileIssueRegistry
extends IssueRegistry {
    @NotNull
    public static final Factory Factory = new Factory(null);
    @NotNull
    private final File jarFile;
    @NotNull
    private final Vendor vendor;
    @NotNull
    private final List<Issue> issues;
    private long timestamp;
    private final int api;
    private final int minApi;
    private final int maxApi;
    @NotNull
    private final List<String> deletedIssues;
    private static final Pattern ARTIFACT_PATTERN = Pattern.compile(".*[/\\\\].gradle[/\\\\]caches[/\\\\]transforms-[0-9]+[/\\\\][0-9a-f]+[/\\\\]transformed[/\\\\](.+)[/\\\\]jars[/\\\\]lint\\.jar$");
    @NotNull
    private static final String SERVICE_KEY = "META-INF/services/com.android.tools.lint.client.api.IssueRegistry";
    @NotNull
    private static final String MF_LINT_REGISTRY = "Lint-Registry-v2";
    @NotNull
    private static final String MF_LINT_REGISTRY_OLD = "Lint-Registry";
    @NotNull
    private static final ConcurrentHashMap<File, SoftReference<JarFileIssueRegistry>> cache = new ConcurrentHashMap();
    @NotNull
    private static final CopyOnWriteArraySet<String> rejectedIssueIds = new CopyOnWriteArraySet();

    private JarFileIssueRegistry(LintClient client, File jarFile, IssueRegistry registry, Vendor vendor) {
        this.jarFile = jarFile;
        this.vendor = vendor;
        this.issues = CollectionsKt.toList((Iterable)registry.getIssues());
        this.timestamp = this.jarFile.lastModified();
        ClassLoader loader = registry.getClass().getClassLoader();
        if (loader instanceof URLClassLoader) {
            JarFileIssueRegistry.Factory.loadAndCloseURLClassLoader(client, this.jarFile, (URLClassLoader)loader);
        }
        this.api = registry.getApi();
        this.minApi = registry.getMinApi();
        this.maxApi = registry.getMaxApi();
        this.deletedIssues = registry.getDeletedIssues();
    }

    @NotNull
    public final File getJarFile() {
        return this.jarFile;
    }

    @Override
    @NotNull
    public Vendor getVendor() {
        return this.vendor;
    }

    @Override
    protected boolean cacheable() {
        return LintClient.Companion.isStudio();
    }

    @Override
    @NotNull
    public List<Issue> getIssues() {
        return this.issues;
    }

    @Override
    public boolean isUpToDate() {
        return this.timestamp == this.jarFile.lastModified();
    }

    @Override
    public int getApi() {
        return this.api;
    }

    @Override
    public int getMinApi() {
        return this.minApi;
    }

    @Override
    public int getMaxApi() {
        return this.maxApi;
    }

    @Override
    @NotNull
    public List<String> getDeletedIssues() {
        return this.deletedIssues;
    }

    public /* synthetic */ JarFileIssueRegistry(LintClient client, File jarFile, IssueRegistry registry, Vendor vendor, DefaultConstructorMarker $constructor_marker) {
        this(client, jarFile, registry, vendor);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JD\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00182\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001eJ>\u0010\u0013\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\u000e2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0006\u0010!\u001a\u00020\"J\u001f\u0010#\u001a\u00020$2\u0012\u0010%\u001a\n\u0012\u0006\b\u0001\u0012\u00020$0&\"\u00020$\u00a2\u0006\u0002\u0010'J\u0018\u0010(\u001a\u00020)2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u000eH\u0002J\u0012\u0010*\u001a\u00020\u001e2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002JF\u0010+\u001a\u0004\u0018\u00010$2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u000e2\u0006\u0010,\u001a\u00020\t2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010-\u001a\u00020\u001eH\u0002J\u000e\u0010.\u001a\u00020\u001e2\u0006\u0010/\u001a\u00020\tJ\u0016\u00100\u001a\u00020\"2\f\u00101\u001a\b\u0012\u0004\u0012\u0002020\u0014H\u0002J \u00103\u001a\u0002042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u00105\u001a\u00020$2\u0006\u0010 \u001a\u00020\u000eH\u0002J(\u00106\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000e072\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0018J.\u00108\u001a\u00020\t2\u0006\u00109\u001a\u00020:2\u0006\u0010,\u001a\u00020\t2\f\u00101\u001a\b\u0012\u0004\u0012\u0002020\u00142\u0006\u0010;\u001a\u00020)H\u0002J \u0010<\u001a\u00020\"2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010=\u001a\u00020\u000e2\u0006\u0010>\u001a\u00020?H\u0002J\b\u0010@\u001a\u00020\u001eH\u0002R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/android/tools/lint/client/api/JarFileIssueRegistry$Factory;", "", "<init>", "()V", "ARTIFACT_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "Ljava/util/regex/Pattern;", "SERVICE_KEY", "", "MF_LINT_REGISTRY", "MF_LINT_REGISTRY_OLD", "cache", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/io/File;", "Ljava/lang/ref/SoftReference;", "Lcom/android/tools/lint/client/api/JarFileIssueRegistry;", "rejectedIssueIds", "Ljava/util/concurrent/CopyOnWriteArraySet;", "get", "", "client", "Lcom/android/tools/lint/client/api/LintClient;", "jarFiles", "", "currentProject", "Lcom/android/tools/lint/detector/api/Project;", "driver", "Lcom/android/tools/lint/client/api/LintDriver;", "skipVerification", "", "registryClassName", "jarFile", "clearCache", "", "join", "Lcom/android/tools/lint/client/api/IssueRegistry;", "registries", "", "([Lcom/android/tools/lint/client/api/IssueRegistry;)Lcom/android/tools/lint/client/api/IssueRegistry;", "verify", "Lcom/android/tools/lint/client/api/LintJarVerifier;", "reportErrors", "loadIssueRegistry", "className", "attemptMigration", "isRejectedIssueId", "issueId", "recordRejectedIssues", "issues", "Lcom/android/tools/lint/detector/api/Issue;", "getVendor", "Lcom/android/tools/lint/client/api/Vendor;", "registry", "findRegistries", "", "generateVerifierMessage", "api", "", "verifier", "loadAndCloseURLClassLoader", "file", "loader", "Ljava/net/URLClassLoader;", "logJarProblems", "lint-api"})
    @SourceDebugExtension(value={"SMAP\nJarFileIssueRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JarFileIssueRegistry.kt\ncom/android/tools/lint/client/api/JarFileIssueRegistry$Factory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ReadWrite.kt\nkotlin/io/TextStreamsKt\n*L\n1#1,834:1\n1557#2:835\n1628#2,3:836\n1557#2:840\n1628#2,3:841\n1557#2:846\n1628#2,3:847\n1#3:839\n1#3:845\n57#4:844\n*S KotlinDebug\n*F\n+ 1 JarFileIssueRegistry.kt\ncom/android/tools/lint/client/api/JarFileIssueRegistry$Factory\n*L\n420#1:835\n420#1:836,3\n500#1:840\n500#1:841,3\n692#1:846\n692#1:847,3\n594#1:845\n594#1:844\n*E\n"})
    public static final class Factory {
        private Factory() {
        }

        @NotNull
        public final List<JarFileIssueRegistry> get(@NotNull LintClient client, @NotNull Collection<? extends File> jarFiles, @Nullable Project currentProject, @Nullable LintDriver driver, boolean skipVerification) {
            Map<String, File> map;
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter(jarFiles, (String)"jarFiles");
            try {
                map = this.findRegistries(client, jarFiles);
            }
            catch (IOException e) {
                if (this.logJarProblems()) {
                    client.log(e, "Could not load custom lint check jar files: " + e.getMessage(), new Object[0]);
                }
                return CollectionsKt.emptyList();
            }
            Map<String, File> registryMap = map;
            if (registryMap.isEmpty()) {
                return CollectionsKt.emptyList();
            }
            int capacity = jarFiles.size() + 1;
            ArrayList<JarFileIssueRegistry> registries = new ArrayList<JarFileIssueRegistry>(capacity);
            for (Map.Entry<String, File> entry : registryMap.entrySet()) {
                String registryClass = entry.getKey();
                File jarFile = entry.getValue();
                try {
                    JarFileIssueRegistry registry;
                    if (this.get(client, registryClass, jarFile, currentProject, driver, skipVerification) == null) continue;
                    registries.add(registry);
                }
                catch (Throwable e) {
                    if (!this.logJarProblems()) continue;
                    Object[] objectArray = new Object[]{jarFile};
                    client.log(e, "Could not load custom lint check jar file %1$s", objectArray);
                }
            }
            return registries;
        }

        public static /* synthetic */ List get$default(Factory factory, LintClient lintClient, Collection collection, Project project, LintDriver lintDriver, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                project = null;
            }
            if ((n & 8) != 0) {
                lintDriver = null;
            }
            if ((n & 0x10) != 0) {
                bl = false;
            }
            return factory.get(lintClient, collection, project, lintDriver, bl);
        }

        private final JarFileIssueRegistry get(LintClient client, String registryClassName, File jarFile, Project currentProject, LintDriver driver, boolean skipVerification) {
            JarFileIssueRegistry jarFileIssueRegistry;
            JarFileIssueRegistry registry;
            SoftReference reference = (SoftReference)cache.get(jarFile);
            if (reference != null && (registry = (JarFileIssueRegistry)reference.get()) != null && registry.isUpToDate()) {
                return registry;
            }
            IssueRegistry.Companion.reset();
            IssueRegistry userRegistry = this.loadIssueRegistry(client, jarFile, registryClassName, currentProject, driver, skipVerification, true);
            if (userRegistry != null) {
                Vendor vendor = this.getVendor(client, userRegistry, jarFile);
                JarFileIssueRegistry jarIssueRegistry = new JarFileIssueRegistry(client, jarFile, userRegistry, vendor, null);
                for (Issue issue : userRegistry.getIssues()) {
                    issue.setRegistry(jarIssueRegistry);
                    if (issue.getDefaultSeverity() != Severity.IGNORE || !this.logJarProblems()) continue;
                    client.log(Severity.ERROR, null, "Issue " + issue.getId() + " has defaultSeverity=IGNORE; that's not valid. Use enabledByDefault=false instead.", new Object[0]);
                }
                ((Map)cache).put(jarFile, new SoftReference<JarFileIssueRegistry>(jarIssueRegistry));
                jarFileIssueRegistry = jarIssueRegistry;
            } else {
                jarFileIssueRegistry = null;
            }
            return jarFileIssueRegistry;
        }

        public final void clearCache() {
            cache.clear();
        }

        @NotNull
        public final IssueRegistry join(IssueRegistry ... registries) {
            Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
            return registries.length == 1 ? registries[0] : (IssueRegistry)new CompositeIssueRegistry(ArraysKt.toList((Object[])registries));
        }

        private final LintJarVerifier verify(LintClient client, File jarFile) {
            LintJarVerifier verifier;
            block2: {
                String string = System.getProperty("android.lint.skip.bytecode.verifier");
                if (string == null) {
                    string = System.getenv("ANDROID_LINT_SKIP_BYTECODE_VERIFIER");
                }
                boolean skip = Intrinsics.areEqual((Object)string, (Object)"true");
                verifier = new LintJarVerifier(client, jarFile, skip);
                Throwable throwable = verifier.getVerificationThrowable();
                if (throwable == null) break block2;
                Throwable it = throwable;
                boolean bl = false;
                if (Factory.logJarProblems()) {
                    client.log(it, "Error verifying bytecode in " + jarFile, new Object[0]);
                }
            }
            return verifier;
        }

        private final boolean reportErrors(LintDriver driver) {
            LintDriver lintDriver = driver;
            return (lintDriver != null ? lintDriver.getMode() : null) != LintDriver.DriverMode.ANALYSIS_ONLY;
        }

        /*
         * WARNING - void declaration
         */
        private final IssueRegistry loadIssueRegistry(LintClient client, File jarFile, String className, Project currentProject, LintDriver driver, boolean skipVerification, boolean attemptMigration) {
            IssueRegistry issueRegistry;
            try {
                IssueRegistry registry;
                block30: {
                    List<Issue> list;
                    List list2 = CollectionsKt.listOf((Object)jarFile);
                    ClassLoader classLoader = JarFileIssueRegistry.class.getClassLoader();
                    Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getClassLoader(...)");
                    ClassLoader loader = client.createUrlClassLoader(list2, classLoader);
                    Class<?> registryClass = Class.forName(className, true, loader);
                    Object obj = registryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type com.android.tools.lint.client.api.IssueRegistry");
                    registry = (IssueRegistry)obj;
                    try {
                        list = registry.getIssues();
                    }
                    catch (Throwable e) {
                        if (this.reportErrors(driver)) {
                            StringBuilder stacktrace = new StringBuilder();
                            LintDriver.Companion.appendStackTraceSummary$default(LintDriver.Companion, e, stacktrace, 0, 0, 12, null);
                            String message2 = "Lint found one or more custom checks that could not be loaded. The most likely reason for this is that it is using an older, incompatible or unsupported API in lint. Make sure these lint checks are updated to the new APIs. The issue registry class is " + className + ". The class loading issue is " + e.getMessage() + ": " + stacktrace;
                            LintClient.Companion.report$default(LintClient.Companion, client, IssueRegistry.OBSOLETE_LINT_CHECK, message2, jarFile, null, null, null, null, null, currentProject, null, driver, null, 5616, null);
                        }
                        return null;
                    }
                    List<Issue> issues2 = list;
                    if (skipVerification) {
                        return registry;
                    }
                    try {
                        if (registry.getMaxApi() < 16) {
                            return null;
                        }
                        Method apiField = registryClass.getDeclaredMethod("getApi", new Class[0]);
                        Object object = apiField.invoke((Object)registry, new Object[0]);
                        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
                        int api = (Integer)object;
                        if (api < 16) {
                            LintJarVerifier verifier = this.verify(client, jarFile);
                            if (!verifier.isCompatible()) {
                                if (verifier.needsApiMigration() && attemptMigration) {
                                    File newJar = LintJarApiMigration.Companion.getMigratedJar(client, jarFile, className);
                                    return this.loadIssueRegistry(client, newJar, className, currentProject, driver, false, false);
                                }
                                if (this.reportErrors(driver)) {
                                    String message3 = this.generateVerifierMessage(api, className, issues2, verifier);
                                    LintClient.Companion.report$default(LintClient.Companion, client, IssueRegistry.OBSOLETE_LINT_CHECK, message3, jarFile, null, null, null, null, null, currentProject, null, driver, null, 5616, null);
                                }
                                this.recordRejectedIssues(issues2);
                                return null;
                            }
                            break block30;
                        }
                        try {
                            int minApi = registry.getMinApi();
                            if (minApi > 16) {
                                if (this.reportErrors(driver)) {
                                    String message4 = "Lint found an issue registry (`" + className + "`) which requires a newer API level. That means that the custom lint checks are intended for a newer lint version; please upgrade.";
                                    LintClient.Companion.report$default(LintClient.Companion, client, IssueRegistry.OBSOLETE_LINT_CHECK, message4, jarFile, null, null, null, null, null, currentProject, null, driver, null, 5616, null);
                                }
                                this.recordRejectedIssues(issues2);
                                return null;
                            }
                            LintJarVerifier verifier = this.verify(client, jarFile);
                            if (!verifier.isCompatible()) {
                                if (verifier.needsApiMigration() && attemptMigration) {
                                    File newJar = LintJarApiMigration.Companion.getMigratedJar(client, jarFile, className);
                                    return this.loadIssueRegistry(client, newJar, className, currentProject, driver, false, false);
                                }
                                if (this.reportErrors(driver)) {
                                    String message5 = this.generateVerifierMessage(api, className, issues2, verifier);
                                    LintClient.Companion.report$default(LintClient.Companion, client, IssueRegistry.OBSOLETE_LINT_CHECK, message5, jarFile, null, null, null, null, null, currentProject, null, driver, null, 5616, null);
                                }
                                this.recordRejectedIssues(issues2);
                                return null;
                            }
                        }
                        catch (Throwable e) {
                            if (this.logJarProblems()) {
                                client.log(e, null, new Object[0]);
                            }
                        }
                    }
                    catch (Throwable e) {
                        void $this$mapTo$iv$iv;
                        if (StringsKt.startsWith$default((String)className, (String)"androidx.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)className, (String)"android.", (boolean)false, (int)2, null)) {
                            return registry;
                        }
                        if (!this.reportErrors(driver)) break block30;
                        String message6 = "Lint found an issue registry (`" + className + "`)\nwhich did not specify the Lint API version it was compiled with.\n\n**This means that the lint checks are likely not compatible.**\n\nIf you are the author of this lint check, make your lint\n`IssueRegistry` class contain\n\u00a0\u00a0override val api: Int = com.android.tools.lint.detector.api.CURRENT_API\nor from Java,\n\u00a0\u00a0@Override public int getApi() { return com.android.tools.lint.detector.api.ApiKt.CURRENT_API; }";
                        Iterable $this$map$iv = issues2;
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            Issue issue = (Issue)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(it.getId());
                        }
                        List issueIds = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
                        if (CollectionsKt.any((Iterable)issueIds)) {
                            message6 = message6 + StringsKt.replace$default((String)("\n\nIf you are just using lint checks from a third party library\nyou have no control over, you can disable these lint checks (if\nthey misbehave) like this:\n\n    android {\n        lintOptions {\n            disable " + CollectionsKt.joinToString$default((Iterable)issueIds, (CharSequence)",\n                    ", null, null, (int)0, null, (Function1)loadIssueRegistry.1.INSTANCE, (int)30, null) + "\n        }\n    }\n"), (String)"    ", (String)"\u00a0\u00a0\u00a0\u00a0", (boolean)false, (int)4, null);
                        }
                        LintClient.Companion.report$default(LintClient.Companion, client, IssueRegistry.OBSOLETE_LINT_CHECK, message6, jarFile, null, null, null, null, null, currentProject, null, driver, null, 5616, null);
                    }
                }
                issueRegistry = registry;
            }
            catch (Throwable e) {
                block32: {
                    Object object;
                    String string;
                    StringBuilder stacktrace;
                    block34: {
                        block33: {
                            void it;
                            block31: {
                                if (!(e instanceof ClassNotFoundException) || !Intrinsics.areEqual((Object)e.getMessage(), (Object)className)) break block31;
                                if (this.logJarProblems()) {
                                    StringBuilder stacktrace2 = new StringBuilder();
                                    LintDriver.Companion.appendStackTraceSummary$default(LintDriver.Companion, e, stacktrace2, 0, 0, 12, null);
                                    Object[] issues2 = new Object[]{jarFile, stacktrace2};
                                    client.log(e, "Could not load custom lint check jar file %1$s: %2$s", issues2);
                                }
                                break block32;
                            }
                            if (!this.reportErrors(driver)) break block32;
                            stacktrace = new StringBuilder();
                            LintDriver.Companion.appendStackTraceSummary$default(LintDriver.Companion, e, stacktrace, 0, 0, 12, null);
                            string = className;
                            object = e.getMessage();
                            if (object == null) break block33;
                            String $this$map$iv = object;
                            String string2 = string;
                            boolean bl = false;
                            String string3 = (String)it + ": ";
                            string = string2;
                            object = string3;
                            if (string3 != null) break block34;
                        }
                        object = "";
                    }
                    String message7 = "Could not load custom lint check jar file. The issue registry class is " + string + ". The initialization problem is " + (String)object + stacktrace;
                    LintClient.Companion.report$default(LintClient.Companion, client, IssueRegistry.LINT_ERROR, message7, jarFile, null, null, null, null, null, currentProject, null, driver, null, 5616, null);
                }
                issueRegistry = null;
            }
            return issueRegistry;
        }

        public final boolean isRejectedIssueId(@NotNull String issueId) {
            Intrinsics.checkNotNullParameter((Object)issueId, (String)"issueId");
            return rejectedIssueIds.contains(issueId);
        }

        /*
         * WARNING - void declaration
         */
        private final void recordRejectedIssues(List<Issue> issues2) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = issues2;
            CopyOnWriteArraySet copyOnWriteArraySet = rejectedIssueIds;
            boolean $i$f$map = false;
            void var4_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Issue issue = (Issue)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getId());
            }
            copyOnWriteArraySet.addAll((List)destination$iv$iv);
        }

        private final Vendor getVendor(LintClient client, IssueRegistry registry, File jarFile) {
            Vendor vendor = registry.getVendor();
            if (vendor == null) {
                Vendor inferredVendor;
                Vendor vendor2;
                String string;
                Factory $this$getVendor_u24lambda_u244 = this;
                boolean bl = false;
                String registryClass = registry.getClass().getName();
                Matcher matcher = ARTIFACT_PATTERN.matcher(jarFile.getPath());
                if (matcher.matches()) {
                    string = matcher.group(1);
                } else {
                    Intrinsics.checkNotNull((Object)registryClass);
                    String string2 = StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)registryClass, (CharSequence)"IssueRegistry"), (CharSequence)"Registry"), (CharSequence)".My"), (CharSequence)".");
                    Locale locale = Locale.US;
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
                    String string3 = string2.toLowerCase(locale);
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                }
                String identifier = string;
                Intrinsics.checkNotNull((Object)registryClass);
                if (StringsKt.startsWith$default((String)registryClass, (String)"androidx.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)registryClass, (String)"android.", (boolean)false, (int)2, null)) {
                    String string4 = "Android Open Source Project (" + identifier + ")";
                    vendor2 = new Vendor(string4, identifier, "https://issuetracker.google.com/issues/new?component=192731", null, 8, null);
                } else {
                    vendor2 = inferredVendor = StringsKt.startsWith$default((String)registryClass, (String)"com.google.", (boolean)false, (int)2, null) ? new Vendor("Google (" + identifier + ")", identifier, null, null, 12, null) : null;
                }
                if (inferredVendor != null) {
                    vendor = inferredVendor;
                } else {
                    if ($this$getVendor_u24lambda_u244.logJarProblems()) {
                        client.log(Severity.WARNING, null, registryClass + " in " + jarFile + " does not specify a vendor; see IssueRegistry#vendor", new Object[0]);
                    }
                    vendor = new Vendor(null, identifier, null, null, 13, null);
                }
            }
            return vendor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Could not resolve type clashes
         * Unable to fully structure code
         */
        @NotNull
        public final Map<String, File> findRegistries(@NotNull LintClient client, @NotNull Collection<? extends File> jarFiles) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter(jarFiles, (String)"jarFiles");
            registryClassToJarFile = new HashMap<K, V>();
            for (File jarFile : jarFiles) {
                var6_6 = new JarFile(jarFile);
                var7_7 = null;
                try {
                    file = (JarFile)var6_6;
                    $i$a$-use-JarFileIssueRegistry$Factory$findRegistries$1 = false;
                    manifest = file.getManifest();
                    if (manifest == null) ** GOTO lbl-1000
                    attrs = manifest.getMainAttributes();
                    attribute = attrs.get(new Attributes.Name("Lint-Registry-v2"));
                    isLegacy = false;
                    if (attribute == null && (attribute = attrs.get(new Attributes.Name("Lint-Registry"))) != null) {
                        isLegacy = true;
                    }
                    if (attribute instanceof String) {
                        className = attribute;
                        if (!isLegacy || registryClassToJarFile.get(className) == null) {
                            ((Map)registryClassToJarFile).put(className, jarFile);
                        }
                    } else lbl-1000:
                    // 2 sources

                    {
                        if ((services = file.getJarEntry("META-INF/services/com.android.tools.lint.client.api.IssueRegistry")) != null) {
                            var12_14 = (Object[])file.getInputStream(services);
                            var13_16 = null;
                            try {
                                it = (InputStream)var12_14;
                                $i$a$-use-JarFileIssueRegistry$Factory$findRegistries$1$1 = false;
                                reader = new InputStreamReader(it, Charsets.UTF_8);
                                $this$useLines$iv = reader;
                                $i$f$useLines = false;
                                var19_24 /* !! */  = $this$useLines$iv;
                                var20_26 = 8192;
                                var19_24 /* !! */  = var19_24 /* !! */  instanceof BufferedReader != false ? (BufferedReader)var19_24 /* !! */  : new BufferedReader(var19_24 /* !! */ , var20_26);
                                var20_25 = null;
                                try {
                                    it$iv = (BufferedReader)var19_24 /* !! */ ;
                                    $i$a$-use-TextStreamsKt$useLines$1$iv = false;
                                    lines = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                                    $i$a$-useLines-JarFileIssueRegistry$Factory$findRegistries$1$1$1 = false;
                                    for (String line : lines) {
                                        comment = StringsKt.indexOf$default((CharSequence)line, (String)"#", (int)0, (boolean)false, (int)6, null);
                                        if (comment >= 0) {
                                            v0 = line.substring(0, comment);
                                            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"substring(...)");
                                            v1 = StringsKt.trim((CharSequence)v0).toString();
                                        } else {
                                            v1 = StringsKt.trim((CharSequence)line).toString();
                                        }
                                        if (!(((CharSequence)(className = v1)).length() > 0) || registryClassToJarFile.get(className) != null) continue;
                                        ((Map)registryClassToJarFile).put(className, jarFile);
                                    }
                                    var21_27 = Unit.INSTANCE;
                                }
                                catch (Throwable var22_29) {
                                    var20_25 = var22_29;
                                    throw var22_29;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)var19_24 /* !! */ , (Throwable)var20_25);
                                }
                                var14_17 = Unit.INSTANCE;
                            }
                            catch (Throwable var15_19) {
                                var13_16 = var15_19;
                                throw var15_19;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)var12_14, (Throwable)var13_16);
                            }
                        }
                        if (JarFileIssueRegistry.Factory.logJarProblems() && Intrinsics.areEqual((Object)jarFile.getName(), (Object)"lint.jar")) {
                            var12_14 = new Object[]{jarFile.getPath(), "Lint-Registry-v2"};
                            client.log(Severity.ERROR, null, "Custom lint rule jar %1$s does not contain a valid registry manifest key (%2$s).\nEither the custom jar is invalid, or it uses an outdated API not supported this lint client", var12_14);
                        }
                    }
                    var8_8 = Unit.INSTANCE;
                }
                catch (Throwable var9_10) {
                    var7_7 = var9_10;
                    throw var9_10;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)var6_6, (Throwable)var7_7);
                }
            }
            return registryClassToJarFile;
        }

        /*
         * WARNING - void declaration
         */
        private final String generateVerifierMessage(int api, String className, List<Issue> issues2, LintJarVerifier verifier) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            StringBuilder sb = new StringBuilder();
            StringBuilder stringBuilder = api > 16 ? sb.append("Requires newer lint; ") : (api < 16 ? sb.append("Library lint checks out of date;\n") : sb.append("Library lint checks reference invalid APIs; "));
            sb.append("these checks **will be skipped**!\n\n");
            sb.append("Lint found an issue registry (`" + className + "`)\n");
            StringBuilder stringBuilder2 = api > 16 ? sb.append("which was compiled against a newer version of lint\nthan this one. This is usually fine, but not in this\ncase; some basic verification shows that the lint\ncheck jar references (for example) the following API\nwhich is not valid in the version of lint which is running:") : (api < 16 ? sb.append("which was compiled against an older version of lint\nthan this one. This is usually fine, but not in this\ncase; some basic verification shows that the lint\ncheck jar references (for example) the following API\nwhich is no longer valid in this version of lint:") : sb.append("which contains some references to invalid API:"));
            String reference = LintJarVerifier.describeFirstIncompatibleReference$default(verifier, false, 1, null);
            String referenceClassFile = verifier.getReferenceClassFile();
            sb.append(StringsKt.trimIndent((String)("\n\n                " + reference + "\n                (Referenced from " + referenceClassFile + ")\n\n                Therefore, this lint check library is **not** included\n                in analysis. This affects the following lint checks:\n\n                ")));
            Iterable iterable = issues2;
            StringBuilder stringBuilder3 = sb;
            boolean $i$f$map = false;
            void var10_11 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                Issue issue = (Issue)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean $i$f$generateVerifierMessage$stub_for_inlining = false;
                boolean bl = false;
                collection.add(p0.getId());
            }
            stringBuilder3.append(CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)(issues2.size() > 5 ? "\n" : ","), null, null, (int)0, null, (Function1)generateVerifierMessage.2.INSTANCE, (int)30, null));
            sb.append("\n\n");
            StringBuilder stringBuilder4 = Intrinsics.areEqual((Object)reference, (Object)"org.jetbrains.uast.kotlin.KotlinUClass#getKtClass(): org.jetbrains.kotlin.psi.KtClassOrObject") && Intrinsics.areEqual((Object)className, (Object)"androidx.fragment.lint.FragmentIssueRegistry") && LintClient.Companion.isGradle() ? sb.append("**This is a known bug which is already fixed in\n`androidx.fragment:fragment:1.5.1` and later**; update\nto that version. If you are not directly depending\non this library but picking it up via a transitive\ndependency, explicitly add\n`implementation 'androidx.fragment:fragment:1.5.1'`\n(or later) to your build.gradle dependency block.") : (api > 16 ? sb.append("To use this lint check, upgrade to a more recent version\nof lint.") : (api < 16 ? sb.append("Recompile the checks against the latest version, or if\nthis is a check bundled with a third-party library, see\nif there is a more recent version available.") : sb.append("To use this lint check, upgrade to a more recent version\nof the library.")));
            if (api != 16) {
                sb.append(StringsKt.trimIndent((String)("\n\n\n                    Version of Lint API this lint check is using is " + api + ".\n                    The Lint API version currently running is 16 (" + ApiKt.describeApi(16) + ").\n                    ")));
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void loadAndCloseURLClassLoader(LintClient client, File file, URLClassLoader loader) {
            if (SdkConstants.CURRENT_PLATFORM != 2) {
                return;
            }
            try {
                Closeable closeable = new JarFile(file);
                Throwable throwable = null;
                try {
                    JarFile jar = (JarFile)closeable;
                    boolean bl = false;
                    Enumeration<JarEntry> enumeration = jar.entries();
                    while (enumeration.hasMoreElements()) {
                        JarEntry entry = enumeration.nextElement();
                        String path2 = entry.getName();
                        Intrinsics.checkNotNull((Object)path2);
                        if (!StringsKt.endsWith$default((String)path2, (String)".class", (boolean)false, (int)2, null) || StringsKt.indexOf$default((CharSequence)path2, (char)'$', (int)0, (boolean)false, (int)6, null) != -1) continue;
                        String string = path2.substring(0, path2.length() - 6);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        String name = StringsKt.replace$default((String)string, (char)'/', (char)'.', (boolean)false, (int)4, null);
                        try {
                            Class<?> cls = Class.forName(name, true, loader);
                            if (cls.isAnnotation() || cls.isEnum() || cls.isInterface()) continue;
                            try {
                                Constructor<?> defaultConstructor = cls.getConstructor(new Class[0]);
                                defaultConstructor.setAccessible(true);
                                defaultConstructor.newInstance(new Object[0]);
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                            }
                        }
                        catch (Throwable e) {
                            if (!Factory.logJarProblems()) continue;
                            client.log(Severity.ERROR, e, "Failed to prefetch " + name + " from " + file, new Object[0]);
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (Throwable throwable) {
            }
            finally {
                try {
                    loader.close();
                }
                catch (Throwable throwable) {}
            }
        }

        private final boolean logJarProblems() {
            return !Intrinsics.areEqual((Object)System.getProperty("android.lint.log-jar-problems"), (Object)"false");
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

