/*
 * Decompiled with CFR 0.152.
 */
package ag;

import ag.AttrDef;
import ag.AttrId;
import ag.AttrKind;
import ag.AttrUsage;
import ag.PrettyListener;
import ag.Settings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AttrUsageFactory {
    public final Map<String, Map<String, List<AttrUsage>>> attrUsages;
    private final PrettyListener agInfo;
    private final Settings settings;

    public AttrUsageFactory(PrettyListener agInfo, Settings settings) {
        this.agInfo = agInfo;
        this.settings = settings;
        this.attrUsages = new HashMap<String, Map<String, List<AttrUsage>>>();
    }

    public AttrUsage create(Set<String> dataTypes, Set<String> alts, String scope, String name) {
        HashMap<String, Map<String, Set<AttrDef>>> defsByDataType = new HashMap<String, Map<String, Set<AttrDef>>>();
        AttrUsage usage = new AttrUsage(scope, name, defsByDataType);
        for (String dataType : dataTypes.contains("*") ? this.agInfo.kidsByDataType.keySet() : dataTypes) {
            if (!this.attrUsages.containsKey(dataType)) {
                this.attrUsages.put(dataType, new HashMap());
            }
            for (String alt : alts.contains("*") ? this.agInfo.kidsByDataType.get(dataType).keySet() : alts) {
                if (!this.attrUsages.get(dataType).containsKey(alt)) {
                    this.attrUsages.get(dataType).put(alt, new ArrayList());
                }
                if (!this.settings.isAttrVisible(new AttrId(dataType, alt, scope, name))) continue;
                this.attrUsages.get(dataType).get(alt).add(usage);
                HashSet<AttrDef> defs = new HashSet<AttrDef>();
                if (!scope.equals("lhs") && !scope.equals("loc")) {
                    this.addDefs(defs, new AttrKind[]{AttrKind.INH, AttrKind.CHN}, this.agInfo.kidsByDataType.get(dataType).get(alt).get(scope), name);
                } else {
                    this.addDefs(defs, new AttrKind[]{AttrKind.SYN, AttrKind.CHN}, dataType, name);
                    if (scope.equals("loc")) {
                        Collection<String> kidTypes = this.agInfo.kidsByDataType.get(dataType).get(alt).values();
                        for (String kidType : kidTypes) {
                            this.addDefs(defs, new AttrKind[]{AttrKind.INH, AttrKind.CHN}, kidType, name);
                        }
                    }
                }
                if (defs.isEmpty()) continue;
                HashMap<String, HashSet<AttrDef>> defsByAlt = new HashMap<String, HashSet<AttrDef>>();
                defsByDataType.put(dataType, defsByAlt);
                defsByAlt.put(alt, defs);
            }
        }
        return usage;
    }

    public AttrUsage create(Set<String> dataTypes, Set<String> alts, String tokenText) {
        String[] parts = tokenText.replaceAll("[^a-zA-Z0-9_\\.']", "").split("\\.");
        return this.create(dataTypes, alts, parts[0], parts[1]);
    }

    private void addDefs(Set<AttrDef> defs, AttrKind[] kinds, String dataType, String name) {
        if (!this.agInfo.defsByDataType.containsKey(dataType)) {
            return;
        }
        Map<AttrKind, Map<String, AttrDef>> defsByKind = this.agInfo.defsByDataType.get(dataType);
        for (AttrKind kind : kinds) {
            Map<String, AttrDef> defsByName;
            if (!defsByKind.containsKey((Object)kind) || !(defsByName = defsByKind.get((Object)kind)).containsKey(name)) continue;
            defs.add(defsByName.get(name));
        }
    }
}

