/*
 * Decompiled with CFR 0.152.
 */
package ag;

import ag.AttrId;
import ag.AttrUsage;
import ag.PrettyListener;
import ag.Settings;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import parser.pretty.PrettyAGParser;
import parser.pretty.PrettyAGParserBaseListener;
import util.Strings;

public class CodeGen
extends PrettyAGParserBaseListener {
    private final PrintWriter out;
    private final String castFn;
    private final String castTy;
    private final Set<String> dataTypes;
    private final Map<String, Map<String, List<AttrUsage>>> attrUsages;
    private final Settings settings;
    private String dataType;
    private String alt;
    private boolean firstAttr;

    public CodeGen(PrintWriter out, String castFn, String castTy, PrettyListener agInfo, Map<String, Map<String, List<AttrUsage>>> attrUsages, Settings settings) throws IOException {
        this.out = out;
        this.castFn = castFn;
        this.castTy = castTy;
        this.dataTypes = agInfo.kidsByDataType.keySet();
        this.attrUsages = attrUsages;
        this.settings = settings;
    }

    @Override
    public void enterRoot(PrettyAGParser.RootContext ctx) {
        this.out.println("imports {");
        this.out.println("import qualified UUAGD.CodeGen as UUAGD");
        if (!this.settings.noDefaultImport) {
            this.out.println("import UUAGD.Html.CodeGen");
        }
        this.out.println("}");
        this.out.println("attr *");
        this.out.println("  syn uuagd :: {" + this.castTy + "}");
    }

    @Override
    public void enterData(PrettyAGParser.DataContext ctx) {
        this.dataType = ctx.AG_DATA_TYPE().getText();
        this.out.println();
        this.out.println("sem " + this.dataType);
    }

    @Override
    public void enterAlt(PrettyAGParser.AltContext ctx) {
        this.alt = ctx.AG_TYPE().getText();
        this.out.print("  | ");
        this.out.print(this.alt);
        this.out.print(" lhs.uuagd = UUAGD.markupAlt ");
        this.out.print(Strings.toLiteral(this.dataType));
        this.out.print(" ");
        this.out.print(Strings.toLiteral(this.alt));
        this.out.print(" [");
        this.firstAttr = true;
    }

    @Override
    public void enterChild(PrettyAGParser.ChildContext ctx) {
        String name = ctx.IDENT().getText();
        String type = ctx.HS_TYPE().getText();
        if (!this.settings.filterKids || this.settings.isAttrVisible(new AttrId(this.dataType, this.alt, "kid", name))) {
            if (!this.firstAttr) {
                this.out.print(", ");
            }
            this.out.print("UUAGD.markup");
            this.out.print(this.dataTypes.contains(type) ? "Terminal" : "NonTerminal");
            this.out.print(" ");
            this.out.print(Strings.toLiteral(name));
            this.out.print(" ");
            if (this.dataTypes.contains(type)) {
                this.out.print("@");
                this.out.print(name);
                this.out.print(".uuagd");
            } else {
                this.out.print("(");
                this.out.print(this.castFn);
                this.out.print(" @");
                this.out.print(name);
                this.out.print(")");
            }
            this.firstAttr = false;
        }
    }

    @Override
    public void exitAlt(PrettyAGParser.AltContext ctx) {
        if (this.attrUsages.get(this.dataType) != null && this.attrUsages.get(this.dataType).get(this.alt) != null) {
            for (AttrUsage attr : this.attrUsages.get(this.dataType).get(this.alt)) {
                String type = attr.getType();
                if (!this.firstAttr) {
                    this.out.print(", ");
                }
                this.out.print("UUAGD.markupAttrUsage ");
                this.out.print(Strings.toLiteral(attr.scope));
                this.out.print(" ");
                this.out.print(Strings.toLiteral(attr.name));
                this.out.print(" (");
                this.out.print(this.castFn);
                this.out.print(" (@");
                this.out.print(attr.getAliasScopedName());
                if (type != null) {
                    this.out.print(" :: ");
                    this.out.print(type);
                }
                this.out.print("))");
                this.firstAttr = false;
            }
        }
        this.out.println("]");
    }
}

