/*
 * Decompiled with CFR 0.152.
 */
package ag;

import ag.AttrId;
import ag.AttrUsage;
import ag.AttrUsageFactory;
import ag.CodeGen;
import ag.PrettyListener;
import ag.Settings;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import parser.args.CmdArgsLexer;
import parser.pretty.PrettyAGLexer;
import parser.pretty.PrettyAGParser;
import parser.rewrite.RewriteAGLexer;
import util.Strings;

class Preprocessor {
    private static final Pattern ALT_PAT = Pattern.compile("([A-Z][a-zA-Z0-9_]*|\\*)");
    private final String uuagcOptions;
    private final File agFile;
    private final String castFn;
    private final String castTy;
    private final Settings settings;
    private final File agHsFile;
    private final Map<File, File> agTempFiles;
    private RuleContext prettyTree;
    private PrettyListener agInfo;
    private AttrUsageFactory attrUsageFactory;
    private File agTempFile;

    public Preprocessor(String uuagcOptions, File agFile, String castFn, String castTy, Settings settings) throws Exception {
        this.uuagcOptions = uuagcOptions;
        this.agFile = agFile;
        this.castFn = castFn;
        this.castTy = castTy;
        this.settings = settings;
        this.agHsFile = new File(Preprocessor.getWithoutExt(agFile.getPath()) + ".hs");
        this.agTempFiles = new HashMap<File, File>();
    }

    public void preprocessAndCompile() throws Exception {
        this.parsePrettyAG();
        this.gatherAGInfo();
        this.processAG();
        this.compileAG();
    }

    private void parsePrettyAG() throws Exception {
        File hsTempFile = File.createTempFile("uuagd", ".hs");
        this.exec("uuagc -H --pretty -o " + hsTempFile.getPath() + " " + this.agFile.getPath(), System.out);
        ANTLRInputStream input = new ANTLRInputStream(new FileInputStream(hsTempFile));
        PrettyAGLexer lexer = new PrettyAGLexer(input);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        PrettyAGParser parser = new PrettyAGParser(tokens);
        this.prettyTree = parser.root();
        Files.delete(hsTempFile.toPath());
    }

    private void gatherAGInfo() {
        ParseTreeWalker walker = new ParseTreeWalker();
        this.agInfo = new PrettyListener();
        walker.walk(this.agInfo, this.prettyTree);
        this.attrUsageFactory = new AttrUsageFactory(this.agInfo, this.settings);
    }

    private void processAG() throws Exception {
        this.agTempFile = this.createTempAG(this.agFile);
        this.processAG(this.agFile, true);
    }

    private void processAG(File agFile, boolean isRoot) throws Exception {
        HashMap<Token, AttrUsage> attrUsages = new HashMap<Token, AttrUsage>();
        HashMap<Token, AttrUsage[]> tupleAttrUsages = new HashMap<Token, AttrUsage[]>();
        HashMap<Token, File> agFiles = new HashMap<Token, File>();
        ArrayList<Token> agTokens = new ArrayList<Token>();
        Set<String> dataTypes = null;
        Set<String> alts = null;
        ANTLRInputStream input = new ANTLRInputStream(new FileInputStream(agFile));
        RewriteAGLexer lexer = new RewriteAGLexer(input);
        Token token = lexer.nextToken();
        while (token.getType() != -1) {
            switch (token.getType()) {
                case 9: {
                    String filename = Preprocessor.removeOutsideChars(Preprocessor.removeLeading(token.getText(), "include"));
                    File file = new File(filename);
                    if (!file.isAbsolute()) {
                        file = new File(agFile.getParent() + File.separator + filename);
                    }
                    this.createTempAG(file);
                    agFiles.put(token, file);
                    agTokens.add(token);
                    break;
                }
                case 5: {
                    dataTypes = Preprocessor.parseTypes(Preprocessor.removeLeading(token.getText(), "sem"));
                    break;
                }
                case 6: {
                    alts = Preprocessor.parseTypes(Preprocessor.removeLeading(token.getText(), "|"));
                    break;
                }
                case 7: {
                    if (dataTypes != null && alts != null) {
                        AttrUsage usage = this.attrUsageFactory.create(dataTypes, alts, token.getText());
                        if (!usage.needsAlias()) break;
                        attrUsages.put(token, usage);
                        agTokens.add(token);
                        break;
                    }
                    Preprocessor.error("An attribute should always be defined as part of a semantic alternative.");
                    break;
                }
                case 8: {
                    if (dataTypes != null && alts != null) {
                        String[] tupleTexts = Preprocessor.removeOutsideChars(Preprocessor.removeTrailing(token.getText(), "=")).split(",");
                        AttrUsage[] usages = new AttrUsage[tupleTexts.length];
                        for (int j = 0; j < tupleTexts.length; ++j) {
                            usages[j] = this.attrUsageFactory.create(dataTypes, alts, tupleTexts[j]);
                        }
                        tupleAttrUsages.put(token, usages);
                        agTokens.add(token);
                        break;
                    }
                    Preprocessor.error("An tuple of attributes should always be defined as part of a semantic alternative.");
                }
            }
            token = lexer.nextToken();
        }
        try (PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(this.agTempFiles.get(agFile))));){
            try (BufferedReader in = new BufferedReader(new FileReader(agFile));){
                String line;
                int pos = 0;
                int endPos = 0;
                int restPos = 0;
                int i = 0;
                int tokensLength = agTokens.size();
                int lineNumber = 0;
                while ((line = in.readLine()) != null) {
                    if (restPos == 0 && ++lineNumber > 1) {
                        out.println();
                    }
                    if (restPos > 0) {
                        --restPos;
                    }
                    if (restPos > (endPos = line.length())) {
                        restPos -= endPos;
                        continue;
                    }
                    pos = restPos;
                    restPos = 0;
                    while (i < tokensLength && lineNumber == ((Token)agTokens.get(i)).getLine()) {
                        token = (Token)agTokens.get(i);
                        int tokenPos = token.getCharPositionInLine();
                        String tokenText = token.getText().replaceAll("(?:\r?\n|\r)", "\n");
                        out.print(line.substring(pos, tokenPos));
                        switch (token.getType()) {
                            case 9: {
                                File file = (File)agFiles.get(token);
                                out.println();
                                out.print("include ");
                                out.print('\"');
                                out.print(this.agTempFiles.get(file).getPath());
                                out.print('\"');
                                break;
                            }
                            case 7: {
                                AttrUsage attr = (AttrUsage)attrUsages.get(token);
                                out.println();
                                out.print(attr.getScopedName());
                                out.print(" = @");
                                out.print(attr.getAliasScopedName());
                                out.println();
                                out.print(attr.getAliasScopedName());
                                out.print(" =");
                                break;
                            }
                            case 8: {
                                AttrUsage[] usages;
                                for (AttrUsage usage : usages = (AttrUsage[])tupleAttrUsages.get(token)) {
                                    if (!usage.needsAlias()) continue;
                                    out.println();
                                    out.print(usage.getScopedName());
                                    out.print(" = @");
                                    out.print(usage.getAliasScopedName());
                                }
                                out.println();
                                boolean first = true;
                                for (AttrUsage usage : usages) {
                                    out.print(first ? (char)'(' : ',');
                                    out.print(usage.getAliasScopedName());
                                    first = false;
                                }
                                out.print(") =");
                            }
                        }
                        pos = tokenPos + tokenText.length();
                        if (pos > endPos) {
                            restPos = pos - endPos;
                            pos = endPos;
                        }
                        ++i;
                    }
                    if (pos >= endPos) continue;
                    out.print(line.substring(pos, endPos));
                }
            }
            for (File file : agFiles.values()) {
                this.processAG(file, false);
            }
            if (isRoot) {
                out.println();
                out.println();
                ParseTreeWalker walker = new ParseTreeWalker();
                CodeGen gen = new CodeGen(out, this.castFn, this.castTy, this.agInfo, this.attrUsageFactory.attrUsages, this.settings);
                walker.walk(gen, this.prettyTree);
            }
        }
    }

    private void compileAG() throws Exception {
        this.exec("uuagc " + this.uuagcOptions + " -o " + this.agHsFile.getPath() + " " + this.agTempFile.getPath(), System.out);
        for (File file : this.agTempFiles.values()) {
            Files.delete(file.toPath());
        }
    }

    private void exec(String cmd, Appendable ... dests) throws Exception {
        System.out.println("Executing: " + cmd);
        String[] args = Preprocessor.parseCmd(cmd);
        ProcessBuilder pb = new ProcessBuilder(args);
        pb.redirectErrorStream(true);
        Process p = pb.start();
        Thread t = Preprocessor.inheritIO(p.getInputStream(), dests);
        t.start();
        p.waitFor();
        t.join();
        if (p.exitValue() == 0) {
            System.out.println("Exited with success.");
        } else {
            System.out.println("Exited with failure.");
            System.exit(1);
        }
    }

    private static String[] parseCmd(String cmd) throws Exception {
        ANTLRInputStream input = new ANTLRInputStream(new StringReader(cmd));
        CmdArgsLexer lexer = new CmdArgsLexer(input);
        ArrayList<String> args = new ArrayList<String>();
        Token token = lexer.nextToken();
        while (token.getType() != -1) {
            args.add(token.getText());
            token = lexer.nextToken();
        }
        return args.toArray(new String[args.size()]);
    }

    private static Thread inheritIO(final InputStream src, final Appendable[] dests) {
        return new Thread(new Runnable(){

            @Override
            public void run() {
                BufferedReader br = new BufferedReader(new InputStreamReader(src));
                try {
                    String line;
                    while ((line = br.readLine()) != null) {
                        for (Appendable dest : dests) {
                            dest.append(line).append(System.getProperty("line.separator"));
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private File createTempAG(File agFile) throws Exception {
        File agTempFile = File.createTempFile("uuagd", ".ag");
        this.agTempFiles.put(agFile, agTempFile);
        return agTempFile;
    }

    private static String getWithoutExt(String filename) {
        int pos = filename.lastIndexOf(46);
        if (pos == -1) {
            return filename;
        }
        filename = filename.substring(0, pos);
        return filename;
    }

    private static String removeOutsideChars(String s) {
        return s.substring(1, s.length() - 1);
    }

    private static String removeLeading(String s, String leading) {
        return s.trim().substring(leading.length()).trim();
    }

    private static String removeTrailing(String s, String trailing) {
        s = s.trim();
        return s.substring(0, s.length() - trailing.length()).trim();
    }

    private static Set<String> parseTypes(String text) {
        HashSet<String> types = new HashSet<String>();
        Matcher m = ALT_PAT.matcher(text);
        while (m.find()) {
            types.add(m.group(1));
        }
        return types;
    }

    private static void error(String msg) {
        System.err.println(msg);
        System.exit(1);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 4) {
            Preprocessor.error("Usage: uuagd \"uuagc options\" /path/file.ag printFn --option1 value1 --option2");
        }
        String uuagcOptions = args[0];
        File agFile = new File(args[1]).getAbsoluteFile();
        if (!agFile.exists()) {
            Preprocessor.error("The attribute grammar file could not be found: " + agFile);
        }
        String castFn = args[2];
        String castTy = args[3];
        Settings settings = new Settings();
        block12: for (int i = 4; i < args.length; ++i) {
            switch (args[i]) {
                case "--whitelist": {
                    ArrayList<AttrId> whitelist = new ArrayList<AttrId>();
                    for (String id : args[i + 1].split(";")) {
                        whitelist.add(new AttrId(id));
                    }
                    settings.whitelist = whitelist;
                    ++i;
                    continue block12;
                }
                case "--blacklist": {
                    ArrayList<AttrId> blacklist = new ArrayList<AttrId>();
                    for (String id : args[i + 1].split(";")) {
                        blacklist.add(new AttrId(id));
                    }
                    settings.blacklist = blacklist;
                    ++i;
                    continue block12;
                }
                case "--filterKids": {
                    settings.filterKids = true;
                    continue block12;
                }
                case "--noDefaultImport": {
                    settings.noDefaultImport = true;
                    continue block12;
                }
                default: {
                    Preprocessor.error("Invalid option given: " + Strings.toLiteral(args[i]));
                }
            }
        }
        Preprocessor dp = new Preprocessor(uuagcOptions, agFile, castFn, castTy, settings);
        dp.preprocessAndCompile();
    }
}

