/*
 * Decompiled with CFR 0.152.
 */
package ag;

import ag.AttrDef;
import ag.AttrKind;
import java.util.HashMap;
import java.util.Map;
import parser.pretty.PrettyAGParser;
import parser.pretty.PrettyAGParserBaseListener;

public class PrettyListener
extends PrettyAGParserBaseListener {
    public static final Map<Integer, AttrKind> ATTR_KIND_MAPPING = new HashMap<Integer, AttrKind>();
    public final Map<String, Map<AttrKind, Map<String, AttrDef>>> defsByDataType = new HashMap<String, Map<AttrKind, Map<String, AttrDef>>>();
    private Map<AttrKind, Map<String, AttrDef>> defsByKind;
    private Map<String, AttrDef> defsByName;
    public final Map<String, Map<String, Map<String, String>>> kidsByDataType = new HashMap<String, Map<String, Map<String, String>>>();
    private Map<String, Map<String, String>> kidsByAlt;
    private Map<String, String> kidsByName;
    private String dataType;
    private AttrKind kind;
    private String alt;

    @Override
    public void enterData(PrettyAGParser.DataContext ctx) {
        this.dataType = ctx.AG_DATA_TYPE().getText();
        this.defsByKind = new HashMap<AttrKind, Map<String, AttrDef>>();
        this.defsByDataType.put(this.dataType, this.defsByKind);
        this.kidsByAlt = new HashMap<String, Map<String, String>>();
        this.kidsByDataType.put(this.dataType, this.kidsByAlt);
    }

    @Override
    public void enterAttrKind(PrettyAGParser.AttrKindContext ctx) {
        this.kind = ATTR_KIND_MAPPING.get(ctx.start.getType());
        this.defsByName = new HashMap<String, AttrDef>();
        this.defsByKind.put(this.kind, this.defsByName);
    }

    @Override
    public void enterAlt(PrettyAGParser.AltContext ctx) {
        this.alt = ctx.AG_TYPE().getText();
        this.kidsByName = new HashMap<String, String>();
        this.kidsByAlt.put(this.alt, this.kidsByName);
    }

    @Override
    public void enterChild(PrettyAGParser.ChildContext ctx) {
        String name = ctx.IDENT().getText();
        String type = ctx.HS_TYPE().getText();
        this.kidsByName.put(name, type);
    }

    @Override
    public void enterAttr(PrettyAGParser.AttrContext ctx) {
        String name = ctx.IDENT().getText();
        String type = ctx.HS_TYPE().getText();
        this.defsByName.put(name, new AttrDef(this.dataType, this.kind, name, type));
    }

    static {
        ATTR_KIND_MAPPING.put(10, AttrKind.SYN);
        ATTR_KIND_MAPPING.put(11, AttrKind.INH);
        ATTR_KIND_MAPPING.put(12, AttrKind.CHN);
    }
}

