var search_data = {"index":{"searchIndex":["cmath","acos()","acosh()","asin()","asinh()","atan()","atan2()","atanh()","cbrt()","cos()","cosh()","exp()","log()","log10()","log2()","sin()","sinh()","sqrt()","tan()","tanh()"],"longSearchIndex":["cmath","cmath::acos()","cmath::acosh()","cmath::asin()","cmath::asinh()","cmath::atan()","cmath::atan2()","cmath::atanh()","cmath::cbrt()","cmath::cos()","cmath::cosh()","cmath::exp()","cmath::log()","cmath::log10()","cmath::log2()","cmath::sin()","cmath::sinh()","cmath::sqrt()","cmath::tan()","cmath::tanh()"],"info":[["CMath","","CMath.html","","<p>Trigonometric and transcendental functions for complex numbers.\n<p>CMath is a library that provides trigonometric …\n"],["acos","CMath","CMath.html#method-c-acos","(z)","<p>Returns the arc cosine of <code>z</code>\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">CMath</span>.<span class=\"ruby-identifier\">acos</span>(<span class=\"ruby-value\">1</span> <span class=\"ruby-operator\">+</span> <span class=\"ruby-value\">1i</span>) <span class=\"ruby-comment\">#=&gt; (0.9045568943023813-1.0612750619050357i)</span>\n</pre>\n"],["acosh","CMath","CMath.html#method-c-acosh","(z)","<p>returns the inverse hyperbolic cosine of <code>z</code>\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">CMath</span>.<span class=\"ruby-identifier\">acosh</span>(<span class=\"ruby-value\">1</span> <span class=\"ruby-operator\">+</span> <span class=\"ruby-value\">1i</span>) <span class=\"ruby-comment\">#=&gt; (1.0612750619050357+0.9045568943023813i)</span>\n</pre>\n"],["asin","CMath","CMath.html#method-c-asin","(z)","<p>Returns the arc sine of <code>z</code>\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">CMath</span>.<span class=\"ruby-identifier\">asin</span>(<span class=\"ruby-value\">1</span> <span class=\"ruby-operator\">+</span> <span class=\"ruby-value\">1i</span>) <span class=\"ruby-comment\">#=&gt; (0.6662394324925153+1.0612750619050355i)</span>\n</pre>\n"],["asinh","CMath","CMath.html#method-c-asinh","(z)","<p>returns the inverse hyperbolic sine of <code>z</code>\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">CMath</span>.<span class=\"ruby-identifier\">asinh</span>(<span class=\"ruby-value\">1</span> <span class=\"ruby-operator\">+</span> <span class=\"ruby-value\">1i</span>) <span class=\"ruby-comment\">#=&gt; (1.0612750619050357+0.6662394324925153i)</span>\n</pre>\n"],["atan","CMath","CMath.html#method-c-atan","(z)","<p>Returns the arc tangent of <code>z</code>\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">CMath</span>.<span class=\"ruby-identifier\">atan</span>(<span class=\"ruby-value\">1</span> <span class=\"ruby-operator\">+</span> <span class=\"ruby-value\">1i</span>) <span class=\"ruby-comment\">#=&gt; (1.0172219678978514+0.4023594781085251i)</span>\n</pre>\n"],["atan2","CMath","CMath.html#method-c-atan2","(y,x)","<p>returns the arc tangent of <code>y</code> divided by <code>x</code> using the signs of <code>y</code> and <code>x</code> to determine the quadrant\n\n<pre>CMath.atan2(1 ...</pre>\n"],["atanh","CMath","CMath.html#method-c-atanh","(z)","<p>returns the inverse hyperbolic tangent of <code>z</code>\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">CMath</span>.<span class=\"ruby-identifier\">atanh</span>(<span class=\"ruby-value\">1</span> <span class=\"ruby-operator\">+</span> <span class=\"ruby-value\">1i</span>) <span class=\"ruby-comment\">#=&gt; (0.4023594781085251+1.0172219678978514i)</span>\n</pre>\n"],["cbrt","CMath","CMath.html#method-c-cbrt","(z)","<p>Returns the principal value of the cube root of <code>z</code>\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">CMath</span>.<span class=\"ruby-identifier\">cbrt</span>(<span class=\"ruby-value\">1</span> <span class=\"ruby-operator\">+</span> <span class=\"ruby-value\">4i</span>) <span class=\"ruby-comment\">#=&gt; (1.449461632813119+0.6858152562177092i)</span>\n</pre>\n"],["cos","CMath","CMath.html#method-c-cos","(z)","<p>Returns the cosine of <code>z</code>, where <code>z</code> is given in radians\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">CMath</span>.<span class=\"ruby-identifier\">cos</span>(<span class=\"ruby-value\">1</span> <span class=\"ruby-operator\">+</span> <span class=\"ruby-value\">1i</span>) <span class=\"ruby-comment\">#=&gt; (0.8337300251311491-0.9888977057628651i)</span>\n</pre>\n"],["cosh","CMath","CMath.html#method-c-cosh","(z)","<p>Returns the hyperbolic cosine of <code>z</code>, where <code>z</code> is given in radians\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">CMath</span>.<span class=\"ruby-identifier\">cosh</span>(<span class=\"ruby-value\">1</span> <span class=\"ruby-operator\">+</span> <span class=\"ruby-value\">1i</span>) <span class=\"ruby-comment\">#=&gt; (0.8337300251311491+0.9888977057628651i)</span>\n</pre>\n"],["exp","CMath","CMath.html#method-c-exp","(z)","<p>Math::E raised to the <code>z</code> power\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">CMath</span>.<span class=\"ruby-identifier\">exp</span>(<span class=\"ruby-value\">1</span>.<span class=\"ruby-identifier\">i</span> <span class=\"ruby-operator\">*</span> <span class=\"ruby-constant\">Math</span><span class=\"ruby-operator\">::</span><span class=\"ruby-constant\">PI</span>) <span class=\"ruby-comment\">#=&gt; (-1.0+1.2246467991473532e-16i)</span>\n</pre>\n"],["log","CMath","CMath.html#method-c-log","(z, b=::Math::E)","<p>Returns the natural logarithm of Complex. If a second argument is given, it will be the base of logarithm. …\n"],["log10","CMath","CMath.html#method-c-log10","(z)","<p>Returns the base 10 logarithm of <code>z</code>\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">CMath</span>.<span class=\"ruby-identifier\">log10</span>(<span class=\"ruby-value\">-1</span>) <span class=\"ruby-comment\">#=&gt; (0.0+1.3643763538418412i)</span>\n</pre>\n"],["log2","CMath","CMath.html#method-c-log2","(z)","<p>Returns the base 2 logarithm of <code>z</code>\n\n<pre>CMath.log2(-1) =&gt; (0.0+4.532360141827194i)</pre>\n"],["sin","CMath","CMath.html#method-c-sin","(z)","<p>Returns the sine of <code>z</code>, where <code>z</code> is given in radians\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">CMath</span>.<span class=\"ruby-identifier\">sin</span>(<span class=\"ruby-value\">1</span> <span class=\"ruby-operator\">+</span> <span class=\"ruby-value\">1i</span>) <span class=\"ruby-comment\">#=&gt; (1.2984575814159773+0.6349639147847361i)</span>\n</pre>\n"],["sinh","CMath","CMath.html#method-c-sinh","(z)","<p>Returns the hyperbolic sine of <code>z</code>, where <code>z</code> is given in radians\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">CMath</span>.<span class=\"ruby-identifier\">sinh</span>(<span class=\"ruby-value\">1</span> <span class=\"ruby-operator\">+</span> <span class=\"ruby-value\">1i</span>) <span class=\"ruby-comment\">#=&gt; (0.6349639147847361+1.2984575814159773i)</span>\n</pre>\n"],["sqrt","CMath","CMath.html#method-c-sqrt","(z)","<p>Returns the non-negative square root of Complex.\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">CMath</span>.<span class=\"ruby-identifier\">sqrt</span>(<span class=\"ruby-value\">-1</span> <span class=\"ruby-operator\">+</span> <span class=\"ruby-value\">0i</span>) <span class=\"ruby-comment\">#=&gt; 0.0+1.0i</span>\n</pre>\n"],["tan","CMath","CMath.html#method-c-tan","(z)","<p>Returns the tangent of <code>z</code>, where <code>z</code> is given in radians\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">CMath</span>.<span class=\"ruby-identifier\">tan</span>(<span class=\"ruby-value\">1</span> <span class=\"ruby-operator\">+</span> <span class=\"ruby-value\">1i</span>) <span class=\"ruby-comment\">#=&gt; (0.27175258531951174+1.0839233273386943i)</span>\n</pre>\n"],["tanh","CMath","CMath.html#method-c-tanh","(z)","<p>Returns the hyperbolic tangent of <code>z</code>, where <code>z</code> is given in radians\n\n<pre class=\"ruby\"><span class=\"ruby-constant\">CMath</span>.<span class=\"ruby-identifier\">tanh</span>(<span class=\"ruby-value\">1</span> <span class=\"ruby-operator\">+</span> <span class=\"ruby-value\">1i</span>) <span class=\"ruby-comment\">#=&gt; (1.0839233273386943+0.27175258531951174i)</span>\n</pre>\n"]]}}