var search_data = {"index":{"searchIndex":["sdbm","sdbmerror","[]()","[]=()","clear()","close()","closed?()","delete()","delete_if()","each()","each_key()","each_pair()","each_value()","empty?()","fetch()","has_key?()","has_value?()","include?()","invert()","key()","key?()","keys()","length()","member?()","new()","open()","reject()","reject!()","replace()","select()","shift()","size()","store()","to_a()","to_hash()","update()","value?()","values()","values_at()"],"longSearchIndex":["sdbm","sdbmerror","sdbm#[]()","sdbm#[]=()","sdbm#clear()","sdbm#close()","sdbm#closed?()","sdbm#delete()","sdbm#delete_if()","sdbm#each()","sdbm#each_key()","sdbm#each_pair()","sdbm#each_value()","sdbm#empty?()","sdbm#fetch()","sdbm#has_key?()","sdbm#has_value?()","sdbm#include?()","sdbm#invert()","sdbm#key()","sdbm#key?()","sdbm#keys()","sdbm#length()","sdbm#member?()","sdbm::new()","sdbm::open()","sdbm#reject()","sdbm#reject!()","sdbm#replace()","sdbm#select()","sdbm#shift()","sdbm#size()","sdbm#store()","sdbm#to_a()","sdbm#to_hash()","sdbm#update()","sdbm#value?()","sdbm#values()","sdbm#values_at()"],"info":[["SDBM","","SDBM.html","","<p>SDBM provides a simple file-based key-value store, which can only store String keys and values.\n<p>Note that …\n"],["SDBMError","","SDBMError.html","","<p>Exception class used to return errors from the sdbm library.\n"],["[]","SDBM","SDBM.html#method-i-5B-5D","(p1)","<p>Returns the <code>value</code> in the database associated with the given <code>key</code> string.\n<p>If no value is found, returns …\n"],["[]=","SDBM","SDBM.html#method-i-5B-5D-3D","(p1, p2)","<p>Stores a new <code>value</code> in the database with the given <code>key</code> as an index.\n<p>If the <code>key</code> already exists, this will …\n"],["clear","SDBM","SDBM.html#method-i-clear","()","<p>Deletes all data from the database.\n"],["close","SDBM","SDBM.html#method-i-close","()","<p>Closes the database file.\n<p>Raises SDBMError if the database is already closed.\n"],["closed?","SDBM","SDBM.html#method-i-closed-3F","()","<p>Returns <code>true</code> if the database is closed.\n"],["delete","SDBM","SDBM.html#method-i-delete","(p1)","<p>Deletes the key-value pair corresponding to the given <code>key</code>. If the <code>key</code> exists, the deleted value will …\n"],["delete_if","SDBM","SDBM.html#method-i-delete_if","()","<p>Iterates over the key-value pairs in the database, deleting those for which the block returns <code>true</code>.\n"],["each","SDBM","SDBM.html#method-i-each","()","<p>Iterates over each key-value pair in the database.\n<p>If no block is given, returns an Enumerator.\n"],["each_key","SDBM","SDBM.html#method-i-each_key","()","<p>Iterates over each <code>key</code> in the database.\n<p>If no block is given, returns an Enumerator.\n"],["each_pair","SDBM","SDBM.html#method-i-each_pair","()","<p>Iterates over each key-value pair in the database.\n<p>If no block is given, returns an Enumerator.\n"],["each_value","SDBM","SDBM.html#method-i-each_value","()","<p>Iterates over each <code>value</code> in the database.\n<p>If no block is given, returns an Enumerator.\n"],["empty?","SDBM","SDBM.html#method-i-empty-3F","()","<p>Returns <code>true</code> if the database is empty.\n"],["fetch","SDBM","SDBM.html#method-i-fetch","(p1, p2 = v2)","<p>Returns the <code>value</code> in the database associated with the given <code>key</code> string.\n<p>If a block is provided, the block …\n"],["has_key?","SDBM","SDBM.html#method-i-has_key-3F","(p1)","<p>Returns <code>true</code> if the database contains the given <code>key</code>.\n"],["has_value?","SDBM","SDBM.html#method-i-has_value-3F","(p1)","<p>Returns <code>true</code> if the database contains the given <code>value</code>.\n"],["include?","SDBM","SDBM.html#method-i-include-3F","(p1)","<p>Returns <code>true</code> if the database contains the given <code>key</code>.\n"],["invert","SDBM","SDBM.html#method-i-invert","()","<p>Returns a Hash in which the key-value pairs have been inverted.\n<p>Example:\n\n<pre class=\"ruby\"><span class=\"ruby-identifier\">require</span> <span class=\"ruby-string\">&#39;sdbm&#39;</span>\n\n<span class=\"ruby-constant\">SDBM</span>.<span class=\"ruby-identifier\">open</span> <span class=\"ruby-string\">&#39;my_database&#39;</span> <span class=\"ruby-operator\">...</span>\n</pre>\n"],["key","SDBM","SDBM.html#method-i-key","(p1)","<p>Returns the <code>key</code> associated with the given <code>value</code>. If more than one <code>key</code> corresponds to the given <code>value</code> …\n"],["key?","SDBM","SDBM.html#method-i-key-3F","(p1)","<p>Returns <code>true</code> if the database contains the given <code>key</code>.\n"],["keys","SDBM","SDBM.html#method-i-keys","()","<p>Returns a new Array containing the keys in the database.\n"],["length","SDBM","SDBM.html#method-i-length","()","<p>Returns the number of keys in the database.\n"],["member?","SDBM","SDBM.html#method-i-member-3F","(p1)","<p>Returns <code>true</code> if the database contains the given <code>key</code>.\n"],["new","SDBM","SDBM.html#method-c-new","(p1, p2 = v2)","<p>Creates a new database handle by opening the given <code>filename</code>. SDBM actually uses two physical files, with …\n"],["open","SDBM","SDBM.html#method-c-open","(*args)","<p>If called without a block, this is the same as SDBM.new.\n<p>If a block is given, the new database will be …\n"],["reject","SDBM","SDBM.html#method-i-reject","()","<p>Creates a new Hash using the key-value pairs from the database, then calls Hash#reject with the given …\n"],["reject!","SDBM","SDBM.html#method-i-reject-21","()","<p>Iterates over the key-value pairs in the database, deleting those for which the block returns <code>true</code>.\n"],["replace","SDBM","SDBM.html#method-i-replace","(p1)","<p>Empties the database, then inserts the given key-value pairs.\n<p>This method will work with any object which …\n"],["select","SDBM","SDBM.html#method-i-select","()","<p>Returns a new Array of key-value pairs for which the block returns <code>true</code>.\n<p>Example:\n\n<pre class=\"ruby\"><span class=\"ruby-identifier\">require</span> <span class=\"ruby-string\">&#39;sdbm&#39;</span>\n\n<span class=\"ruby-constant\">SDBM</span>.<span class=\"ruby-identifier\">open</span> <span class=\"ruby-operator\">...</span>\n</pre>\n"],["shift","SDBM","SDBM.html#method-i-shift","()","<p>Removes a key-value pair from the database and returns them as an Array. If the database is empty, returns …\n"],["size","SDBM","SDBM.html#method-i-size","()","<p>Returns the number of keys in the database.\n"],["store","SDBM","SDBM.html#method-i-store","(p1, p2)","<p>Stores a new <code>value</code> in the database with the given <code>key</code> as an index.\n<p>If the <code>key</code> already exists, this will …\n"],["to_a","SDBM","SDBM.html#method-i-to_a","()","<p>Returns a new Array containing each key-value pair in the database.\n<p>Example:\n\n<pre class=\"ruby\"><span class=\"ruby-identifier\">require</span> <span class=\"ruby-string\">&#39;sdbm&#39;</span>\n\n<span class=\"ruby-constant\">SDBM</span>.<span class=\"ruby-identifier\">open</span> <span class=\"ruby-operator\">...</span>\n</pre>\n"],["to_hash","SDBM","SDBM.html#method-i-to_hash","()","<p>Returns a new Hash containing each key-value pair in the database.\n"],["update","SDBM","SDBM.html#method-i-update","(p1)","<p>Insert or update key-value pairs.\n<p>This method will work with any object which implements an each_pair …\n"],["value?","SDBM","SDBM.html#method-i-value-3F","(p1)","<p>Returns <code>true</code> if the database contains the given <code>value</code>.\n"],["values","SDBM","SDBM.html#method-i-values","()","<p>Returns a new Array containing the values in the database.\n"],["values_at","SDBM","SDBM.html#method-i-values_at","(*args)","<p>Returns an Array of values corresponding to the given keys.\n"]]}}