<?php if (!defined('PmWiki')) exit();
/**
  Worse (is better): Wiki's Overdue Rather Simple Editor
  Written by (c) Petko Yotov 2017-2025    www.pmwiki.org/Petko

  This text is written for PmWiki; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published
  by the Free Software Foundation; either version 3 of the License, or
  (at your option) any later version. See pmwiki.php for full details
  and lack of warranty.
*/
$RecipeInfo['Worse']['Version'] = '20250622';

Markup("worse", '<&amp;amp;', "/\\(:worse( .*?)?:\\)\n?(.*?)\n?\\(:worseend:\\)/ims", 'WorseFmt');

# prevent double upload links
$LinkUploadCreateFmt = "<a rel='nofollow' class='createlinktext' href='\$LinkUpload'>\$LinkText</a>";
$LinkPageCreateFmt = "<a class='createlinktext' rel='nofollow' title='\$LinkAlt' href='{\$PageUrl}'>\$LinkText</a>";

# to clear cache per group+uploaddir
$UploadRedirectFunction = 'WorseRedirect';
$EditFunctions[] = 'WorseUpdatePageCache';

SDVA($HandleActions, array(
  'worseupload'=> 'HandlePostUpload',
  'worsepost'=> 'HandleWorsePost',
  'worserecache'=> 'HandleWorseReCache',
));
SDVA($HandleAuth, array(
  'worseupload' => 'upload',
  'worsepost' => 'edit',
  'worserecache' => 'edit',
));

if($action == 'worseupload') { $AbortFunction = "WorseAbort"; }

if(function_exists('pmtoken')) pmtoken();

SDVA($Worse, array(
  'FilterPageNames' => '-*.GroupAttributes,-*.GroupFooter,-*.GroupHeader',
  'FilterFileNames' => '-th*---*',
  'AttachTemplatePic'  => '<a href="{href}" data-trix-attributes="{jsoncaption}" data-trix-attachment="{json}" data-trix-content-type="{type}"><figure class="attachment attachment-preview"><img src="{url}" alt="{type}" /><figcaption class="caption caption-edited">{caption}</figcaption></figure></a>',
  'AttachTemplateFile'  => '<a href="{href}" data-trix-attachment="{json}" data-trix-content-type="{type}"><figure class="attachment attachment-file"><figcaption class="caption">{caption}</figcaption></figure></a>',
  'FlipLabel' => "<input type='checkbox' id='flipcheck' /><label id='fliplabel' for='flipcheck'><span class='ledit'>$[Edit]</span></label>",

  'EditForm' => "<form class='notoc' id='worseform'>
    <input type='hidden' name='\$TokenName' value='\$TokenValue' data-for='pmtoken' />
    <trix-editor input='worsetext' class='trix-content' placeholder=\"$[Type your text here]\"></trix-editor>
    <input type='hidden' id='worsetext' name='worsetext' value=\"{worsehtml}\" />
    <div class='pmsave'>
      <span>$[Summary]: <input type='text' name='worsecsum' id='worsecsum' size='21' placeholder=\"$[Change summary]\" /></span>
      <span>$[Author]: <input type='text' name='worseauthor' id='worseauthor' size='7' placeholder=\"$[Author]\" value=\"{author}\" /></span>
      <span>
        <input type='button' name='worsesave' id='worsesave' value=\"$[Save]\" />
        <input type='reset' name='worsecancel' id='worsecancel' value=\"$[Cancel]\" />
      </span>
    </div>
    </form>",
  'Counter' => 0,
  'CacheDir' => "$WorkDir/.worse",
  'PageTitlesFunction' => "WorsePageTitles",
  'FileDataFunction' => "WorseFileData",
  'GroupRecentChangesName' => 'RecentChanges',
  'PubDirUrl' => '$FarmPubDirUrl/worse',
));

XLSDV('en',array(
  'W_NoUploadPerm' => 'No upload permissions.',
  'W_AuthorNameReq' => 'An author name is required.',
  'W_ChangesNotSavedReplied' => 'Changes NOT saved. %s replied:',
  'W_SelectPageLink' => 'Select page link...',
  'W_CreateNewPage' => 'Create new page...',
  'W_CreateNewPageTypeTitle' => 'Create New Page, type the page title:',
  'W_InvalidPageName' => 'Invalid page name.',
  'W_AttachFiles' => 'Attach files',
  'W_Attach' => 'Attach',
  'W_DropFiles' => 'Drop files in the page to upload them.',
  'W_SelectUpFile' => 'Select uploaded file...',
  'W_UpNewFiles' => 'Upload new files...',
  'W_NotSaved' => 'Content was modified, but not saved.',
));

function WorseUpdatePageCache($pagename,$page,$new) {
  global $IsPagePosted, $UploadDir, $UploadPrefixFmt, $Worse;
  if (!$IsPagePosted) return;
  $title = @$new['title'] ? $new['title'] : $new['name'];
  list($g, $n) = explode('.', $pagename);
  $Worse['PageTitlesFunction']($g, $n, $title);
}

# Get a cached list of page titles of a group If the cached list is
# older than Group.RecentChanges, create a new list. If a new title
# is supplied, add or update the page entry then re-cache the list
function WorsePageTitles($g, $n, $newtitle=false, $recache=0) {
  global $Worse, $Now;
  $cachefile = $Worse['CacheDir']."/$g,cache";

  $grouplastmod = PageVar("$g.{$Worse['GroupRecentChangesName']}",
    '$LastModifiedTime');

  if(file_exists($cachefile) && ! $recache) {
    $data = json_decode(file_get_contents($cachefile), true);
    $pagetitles = $data['titles'];
  }
  else {
    $recache++;
    $data = array('time'=>0, 'titles'=> array());
  }

  if($data['time']<$grouplastmod) {
    $recache++;
    $pagelist = ListPages("$g.*,{$Worse['FilterPageNames']}");
    $glen = strlen("$g.");
    $pagetitles = array();
    foreach($pagelist as $k=>$v) {
      $pagetitles[substr($v, $glen)] = PageVar($v, '$Title');
    }
    asort($pagetitles);
  }

  if($newtitle) {
    $recache++;
    $pagetitles[$n] = $newtitle;
  }
  if(! PageExists("$g.$n")) {
    $recache++;
    unset($pagetitles[$n]);
  }
  if($recache) {
    $data2 = array('time'=>$Now, 'titles'=>$pagetitles);
    mkdirp($Worse['CacheDir']);
    file_put_contents($cachefile, json_encode($data2));
    fixperms($cachefile);
  }
  return $pagetitles;
}

# Get file size and other data for a single file.
function WorseOneFile($uploaddir, $fname) {
  global $UploadExts;
  $tt = '';
  if(preg_match('!\\.(\\w*)$!', $fname, $n)) {
    $tt = @$UploadExts[$n[1]];
  }
  if(!$tt) $tt = 'application/octet-stream';

  $ret = array(
    'name' => $fname,
    'size' => filesize("$uploaddir/$fname"),
    'type' => $tt,
    'encname' => rawurlencode($fname),
  );
  $dim = getimagesize("$uploaddir/$fname");
  if($dim) {
    $ret['width'] = $dim[0];
    $ret['height'] = $dim[1];
  }
  
  return json_decode(json_encode($ret), true);
}

# Get a cached list of file names and sizes from the current
# upload directory. Update the list if needed and cache it.
function WorseFileData($g, $n, $newfname=false, $recache = 0) {
  global $UploadDir, $UploadPrefixFmt, $Worse, $EnableUpload;

  if(! IsEnabled($EnableUpload, 0)) return array();

  $uploaddir = FmtPageName("$UploadDir$UploadPrefixFmt", "$g.$n");

  $cachefile = "$uploaddir/.worse,cache";

  if(file_exists($cachefile) && ! $recache) {
    $flist = json_decode(file_get_contents($cachefile), true);
    if(is_null($flist)) { 
      unlink($cachefile);
    }
    elseif($newfname) {
      $recache++;
      $flist[$newfname] =  WorseOneFile($uploaddir, $newfname);
    }
  }
  
  if($recache || !file_exists($cachefile)) {
    $recache++;
    $namelist = $fulllist = $flist = array(); # names; allfiles; filtered

    mkdirp($uploaddir);

    $dirp = @opendir($uploaddir);
    if ($dirp) {
      while (($file=readdir($dirp)) !== false) {
        # skip hidden or deleted files
        if(preg_match('!(^\\.|,(del-)?\\d+$|,cache)!', $file)) continue;

        $one = WorseOneFile($uploaddir, $file);
        if(is_null($one)) continue;
        $namelist[] = $file;
        $fulllist[$file] = $one;
      }
      $namelist = MatchNames($namelist, $Worse['FilterFileNames']);
      natcasesort($namelist);

      foreach($namelist as $fn) { # filtered, ordered list
        $flist[$fn] = $fulllist[$fn];
      }
    }
  }
  $enc = json_encode($flist);
  $dec = json_decode($enc);
  if($recache && !is_null($dec)) {
    file_put_contents($cachefile, $enc);
    fixperms($cachefile);
  }
  if(is_null($dec)) $flist = array(); # JS will fail anyway
  return $flist;
}

function WorseFmt($arg) {
  global $HTMLHeaderFmt, $UploadExtSize, $XL, $UploadPrefixFmt, $UploadUrlFmt, 
    $Worse, $Author, $WikiTitle, $EnableUpload, $EnablePostAuthorRequired, $Now;
  extract($GLOBALS["MarkupToHTML"]); # get $pagename

  if($Worse['Counter']++) $canedit = false;
  else $canedit = CondAuth($pagename, 'edit');
  $canupload = (IsEnabled($EnableUpload, 0) && CondAuth($pagename, 'upload')) ? 1: 0;

  $codes = array();
  foreach($XL['en'] as $k=>$v) {
    if(! preg_match('!^(UL|W_)!', $k)) continue;
    $codes[$k] = XL($k);
  }

  list($g, $n) = explode('.', $pagename);

  $uploadurl = FmtPageName("$UploadUrlFmt$UploadPrefixFmt/", $pagename);

  $pagetitles = $Worse['PageTitlesFunction']($g, $n);
  $flist = $Worse['FileDataFunction']($g, $n);
  $json = array();
  foreach($flist as $fn => $ar) {
    $tmp = array(
      'contentType' => $ar['type'],
      'filename' => $ar['name'],
      'filesize' => $ar['size'],
      'href' => $uploadurl . $ar['encname'],
      'url' => $uploadurl . $ar['encname'],
    );
    if(isset($ar['width'])) {
      $tmp['height'] = $ar['height'];
      $tmp['width'] = $ar['width'];
    }
    $json["Attach:$fn"] = json_encode($tmp);
  }

  $Worse['json'] = $json;
  $Worse['flist'] = $flist;
  $Worse['uploadurl'] = $uploadurl;
  $pubdirurl = $Worse['PubDirUrl'];
  
  $headfmt = "<link rel='stylesheet' href='$pubdirurl/trix.css'>
    <link rel='stylesheet' href='$pubdirurl/worse.css'>";
  if($canedit) {
    $headfmt .= '<script type="text/javascript" src="'.$pubdirurl.'/trix.js"></script>
    <script type="text/javascript">
    var PageUrl = "{$PageUrl}";
    var FullName = "{$FullName}";
    var UploadExtSize = '.json_encode($UploadExtSize).';
    var UploadUrl = "'.$uploadurl.'";
    var ListFiles = '.json_encode($flist).';
    var ListPages = '.json_encode($pagetitles).';
    var XL = '.json_encode($codes).';
    var CanUpload = '.($canupload? 1:0).';
    var WikiTitle = "'.$WikiTitle.'";
    var EnablePostAuthorRequired = '.(@$EnablePostAuthorRequired? 1:0).';
    var BaseTime = '.$Now.';
    </script>
    <script type="text/javascript" id="worsejs" src="'.$pubdirurl.'/worse.js"></script>';
  }
  SDVA($HTMLHeaderFmt, array( 'worse' => $headfmt ));

  $text = trim($arg[2], "\n"); //."\n\n";
  $html = ($text) ? WorseToHTML($pagename, $text) : '';
  $html = str_replace('&amp;nbsp;', '&nbsp;', $html);

  $flip = $form = '';
  if($canedit) {
    $value = PHSC($html, ENT_QUOTES);
    $author = PHSC($Author, ENT_QUOTES);

    $flip = FmtPageName($Worse['FlipLabel'], $pagename);

    $form = FmtPageName($Worse['EditForm'], $pagename);

    $form = str_replace(
      array('{worsehtml}', '{author}'),
      array($value, $author),
      $form
    );
  }
  $out = "$flip<div class='worse-content trix-content' id='worse_{$Worse['Counter']}'>$html</div>$form";
  return "<:block>" . Keep($out);
}

function WorseLink($m) {
  global $Worse;
  extract($GLOBALS["MarkupToHTML"]); # get $pagename

  $flist = $Worse['flist'];
  $json = $Worse['json'];
  $uploadurl = $Worse['uploadurl'];

  list(, $url, $text) = $m;
  $href = $url = trim($url);
  $text = trim(@$text);

  if(! $json[$url]) {
    $url = str_replace(
      array('(', ')', '"'),
      array('%28', '%29', '%22'), $url);
    return MakeLink($pagename, $url, $text,'');
  }

  if(!$text) $text = str_replace('Attach:', '', $url);

  $j = $json[$url];
  $fname = substr($url, 7);
  $url = $href = $uploadurl . $flist[$fname]['encname'];
  $type = $flist[$fname]['type'];
  $jsoncaption = PHSC(json_encode(array('caption'=>$text)));

  $tpl = preg_match('!\\.(jpe?g|gif|png)$!i', $url)
    ? $Worse['AttachTemplatePic']
    : $Worse['AttachTemplateFile'];

  $out = str_replace(
    array('{href}', '{url}', '{json}', '{type}', '{caption}', '{jsoncaption}'),
    array( $href,    $url,  PHSC($j),   $type,      $text,     $jsoncaption),
    $tpl
  );
  return $out;
}

function WorseToHTML($pagename, $text) {
  $lines = explode("\n", $text);
  $out = "";
  $lists = array();
  $listtypes = array('*'=>'ul', '#'=>'ol');

  for($i=0; $i<count($lines); $i++) {
    $line = $lines[$i];

    if(count($lists) && ! preg_match('!^[*#]+!', $line)) {
      while($parent = array_shift($lists)) $out .= "</li></$parent>";
    }

    if($line[0] == ' ') $line = "<pre>". substr($line, 1). "\n</pre>";

    elseif(preg_match("/^&gt;( *&gt;)*/", $line, $m)) {
      $line = trim(substr($line, strlen($m[0])));
      $level = substr_count($m[0], '&gt;');
      for($j=0; $j<$level; $j++) $line = "<blockquote>$line<br></blockquote>";
    }

    elseif(preg_match("/^!+/", $line, $m)) {
      $line = trim(substr($line, strlen($m[0])));
      $line = "<h2>$line</h2>";
    }
    elseif(preg_match("/^(\\*+|#+)/", $line, $m)) {
      $level = strlen($m[0]);
      $line = trim(substr($line, $level));
      $type = $listtypes[ $m[0][0] ];
      if($level > count($lists)) {
        array_unshift($lists, $type);
        $line = "<$type><li>$line";
      }
      elseif($level == count($lists)) {
        $line = "</li><li>$line";
      }
      else {
        $tmp = "";
        while($level < count($lists)) {
          $parent = array_shift($lists);
          $tmp .= "</li></$parent>";
        }
        $line = "$tmp</li><li>$line";
      }
    }
    else $line = "<div>$line<br></div>";

    $out .= $line;
  }

  if(!$out) return $out;
  $out2 = "";
  while($out2 != $out) {
    $out2 = $out;
    $out = preg_replace('/<\\/(pre|div)>\\s*<\\1>/', '', $out);
    $out = preg_replace('/<\\/(blockquote)>\\s*(<br>)?\\s*<\\1>/', '', $out);
  }

  $out2 = "";
  while($out2 != $out) {
    $out2 = $out;
    $out = preg_replace('/(<\\/blockquote>)\\s*<br>?\\s*\\1/', '$1$1', $out);
    $out = preg_replace("/\n+(<\\/pre>)/", '$1', $out);
  }

  $out = str_replace("&amp;#10;", '<br>', $out);
  $out = preg_replace('/<:?vspace>/', '', $out);
  $out = preg_replace('!(<div>.*?\\S.*?)<br>(</div>)!s', '$1$2', $out);

  $out = preg_replace(
    array('/\\{-(.*?)-\\}/', "/[{']\\*(.*?)\\*['}]/", "/[{']~(.*?)~['}]/"),
    array('<del>$1</del>', '<strong>$1</strong>', '<em>$1</em>'),
    $out);

  $out = preg_replace_callback("/(?>\\[\\[([^|\\]]*)\\|)(.*?)\\]\\]/", 'WorseLink', $out);
  $out = preg_replace_callback("/(?>\\[\\[([^|\\]]*))\\]\\]/", 'WorseLink', $out);

  return $out;
}

function WorseRedirect($pagename, $url) { # post upload, post ajax upload
  global $UploadDir, $UploadUrlFmt, $UploadPrefixFmt, $action, $Worse;

  list($g, $n) = explode('.', $pagename);

  if(preg_match('/&uprname=(.*?)&upresult=(.*?)(&|$)/', $url, $m)) {
    list($X, $upname, $result) = $m;
    if($result == 'success') $Worse['FileDataFunction']($g, $n, $upname);
  }

  # regular, non-ajax upload
  if($action == 'postupload') Redirect($pagename, $url);

  if(! @$m) $ret = array('upresult'=>'ULnofile');
  else {
    $encname = rawurlencode($upname);
    $url = PUE(FmtPageName("$UploadUrlFmt$UploadPrefixFmt/$encname", $pagename));
    $ext= '';
    if(preg_match('/\\.([^.]*)$/', $upname, $m)) $ext = $m[1];
    $ret = array('upname'=>$upname, 'ext'=>$ext, 'url'=>$url, 'upresult'=> "UL$result");
  }
  header('Content-Type: application/json');
  die(json_encode($ret));
}

function WorseAbort($out) { 
  $out = preg_replace_callback('!\\$\\[(.*?)\\]!', 'WorseXL', $out);
  die($msg);
}

function HandleWorsePost($pagename, $auth = 'edit') {
  global $Worse, $UploadUrlFmt, $UploadPrefixFmt, $Now, $ChangeSummary, $AbortFunction, $EnablePost, $IsPagePosted, $MessagesFmt;
  $AbortFunction = 'WorseAbort';

  $page = $new = RetrieveAuthPage($pagename, $auth, false);
  if(!$page) Abort("?No permissions to $auth $pagename.");

  $pageurl = PageVar($pagename, '$PageUrl');
  $baseurl = preg_replace('/([.\\/])[^.\\/]+$/', '$1', $pageurl);
  $uploadurl = FmtPageName("$UploadUrlFmt$UploadPrefixFmt/", $pagename);

  $text = stripmagic($_POST['worsetext']);

  $ReplArr = array(
    "/\r/" => '',
    "/(\\[)([=@])/" => '$1 $2',
    "/([=@])(\\])/" => '$1 $2',
    '/\\(:worse/' => '( :worse',
    '!<div>\\s*<br/?>\\s*</div>!' => '<div></div>',
    '!<br/?>\\s*</div>!' => '</div>',
  );
  $text = preg_replace(array_keys($ReplArr), array_values($ReplArr), $text);

  $elements = preg_split("!(</?(?:div|h2|pre|ul|ol|li|blockquote|br)[^>]*>|\n)!",
    $text, -1, PREG_SPLIT_NO_EMPTY | PREG_SPLIT_DELIM_CAPTURE);

  $stack = array();
  $out = '';
  foreach($elements as $el) {
    $el = preg_replace('!^(</?\\w+)(?: [^>]*)?(>)$!', '$1$2', $el);
    switch($el) {
      case '<div>':
        $stack = array();
        $out .= "\n";
        break;

      case '<h2>':
        $stack = array();
        $out .= "\n!! ";
        break;

      case '<pre>':
        $stack = array('pre');
        $out .= "\n";
        break;

      case "\n":
        $out .= "\n";
        break;

      case '</pre>':
      case '</div>':
      case '</h2>':
        $stack = array();
        break;

      case "<ul>":
        array_unshift($stack, 'ul');
        break;

      case "<ol>":
        array_unshift($stack, 'ol');
        break;

      case "<blockquote>":
        array_unshift($stack, 'bq');
        if(count($stack)==1) $out .= "\n";
        break;

      case "</ul>":
      case "</ol>":
      case "</blockquote>":
        array_shift($stack);
        break;

      case "<li>":
        $char = ($stack[0] == 'ul') ? '*' : '#';
        $out .= "\n". str_repeat($char, count($stack)) . " ";
        break;

      case "<br>":
      case "<br/>":
        if (count($stack) && ($stack[0] == 'ul' || $stack[0] == 'ol')) $out .= "&#10;";
        else $out .= "\n";
        break;

      case "</li>":
        break;

      default:
        if(!count($stack)) $out .= $el; # div
        elseif ($stack[0] == 'pre') $out .= " $el";
        elseif ($stack[0] == 'bq') $out .= str_repeat(">", count($stack)) . " $el";
        else $out .= $el;
    }
  }

  $InlineMarkup = array(
    '!(<(?:a|img).*?(?:href|src))="'.preg_quote($uploadurl).'(.*?)"!si' => '$1="Attach:$2"',
    '!(<(?:a).*?(?:href))="'.preg_quote($baseurl).'(.*?)"!si' => '$1="$2"',
    '! *<span[^>]*class="size"[^>]*> *!' => ' · ',
    '!</?(span|figcaption)[^>]*>!' => '',
    '! *<(/?)figure[^>]*> *!' => '<$1figure>',

    '!<a[^>]*href="([^"]*)"[^>]*><figure><img[^>]*src="([^"]*)"[^>]*>(.*?)</figure></a>!si' => "(:NL:)[[ $2 | $3 ]](:NL:)",
    '!<a[^>]*href="([^"]*)"[^>]*><figure>(.*?)</figure></a>!si' => '[[$1|$2]]', # file (caption cannot be edited)
    '!<figure><img[^>]*src="([^"]*?)"[^>]*>(.*?)</figure>!si' => "(:NL:)[[$1|$2]](:NL:)", # shouldn't happen

    '!<a[^>]*href="[^"]*?\\?action=upload&amp;upname=([^"]*?)"[^>]*?>(.*?)</a>!si' => '[[Attach:$1|$2]]',

    '!<a[^>]*href="([^"]*?)"[^>]*>(.*?)</a>!' => '[[$1|$2]]',
//     '!\\]\\]\\[\\[!si' => "]] [[",
    '!<[s]trong></strong>|<del></del>|<em></em>!' => '',
    '!</[s]trong><strong>|</del><del>|</em><em>!' => '',
    '!<strong></strong>|<del></del>|<em></em>!' => '',
    '!</strong><strong>|</del><del>|</em><em>!' => '',
    "/\\(:NL:\\)/" => '',
    "/( *&(amp;)?nbsp; *)+$/m" => ' ',

    "!^\n+|\n+$!" => '',
  )+$ReplArr;

  $out = preg_replace(array_keys($InlineMarkup), array_values($InlineMarkup), $out);

  $out = preg_replace_callback('/<(strong)>(.*?)<\\/\\1>/s', 'WorseInlineFormat', $out);
  $out = preg_replace_callback('/<(del)>(.*?)<\\/\\1>/s', 'WorseInlineFormat', $out);
  $out = preg_replace_callback('/<(em)>(.*?)<\\/\\1>/s', 'WorseInlineFormat', $out);

  $out = strip_tags($out);
  $out = htmlspecialchars_decode($out, ENT_QUOTES);
  $out = preg_replace_callback("/(\\[\\[ *Attach:[^|]*)(\\|.*?\\]\\])/", 'WorseDecodeAttachLink', $out);

  if(preg_match('/\\(:worse:\\).*?\\(:worseend:\\)/is', $page['text'], $m)) {
    $new['text'] = str_replace($m[0], "(:worse:)\n$out\n(:worseend:)", $new['text']);
  }
  else {
    $new['text'] .= "(:worse:)\n$out\n(:worseend:)\n";
  }

  if(@$_POST['worsetitle']) {
    $title = preg_replace(
      array('/\\s+/m', '/\\(:/', '/:\\)/'),
      array(' ', '( :', ': )'),
      stripmagic($_POST['worsetitle']));
    $new['text'] = preg_replace('/\\(:title\\s(.*?):\\)/i', '', $new['text'])
      . "(:title $title:)";
  }
  $new['csum'] = $new["csum:$Now"] = $ChangeSummary;
  UpdatePage($pagename, $page, $new);
  if(! $EnablePost) {
    $out = "";
    foreach($MessagesFmt as $html) $out .= preg_replace('!\\s+!', ' ', strip_tags($html))."\n";
    
    $out2 = "";
    if (strpos($out, '$[EditConflict]')!==false) {
      $out2 = "\n\n".$new['text'];
      $out = "basetime=$Now $out";
    }
    if (strpos($out, '$[EditWarning]')!==false) {
      $out = "basetime=$Now $out";
    }

    $out = preg_replace_callback('!\\$\\[(.*?)\\]!', 'WorseXL', $out);
    echo htmlspecialchars_decode($out.$out2);
  }
  else echo "basetime=$Now ok";
}

function WorseXL($m) {
  return XL($m[1]);
}

function WorseDecodeAttachLink($m) { # attachment with spaces in name
  return rawurldecode($m[1]).$m[2];
}
function WorseInlineFormat($m) { # bold/italic spanning multiple lines
  $markup = array(
    'strong' => array("{*", "*}"),
    'em' => array("{~", "~}"),
    'del' => array("{-", "-}"),
  );
  $wrap = $markup[$m[1]];
  $lines = explode("\n", $m[2]);
  foreach($lines as $k=>$line) {
    if($line && ! preg_match('!^\\[\\[ *Attach:.*?\\]\\]!', $line))
      $lines[$k] = "{$wrap[0]}$line{$wrap[1]}";
  }
  return implode("\n", $lines);
}

function HandleWorseReCache($pagename, $auth = "edit") {
  global $Worse;
  $page = $new = RetrieveAuthPage($pagename, $auth, true, READPAGE_CURRENT);
  if(!$page) Abort("?No permissions to $auth $pagename");
  list($g, $n) = explode('.', $pagename);
  WorsePageTitles($g, $n, false, true);
  $Worse['FileDataFunction']($g, $n, false, true);
  die("Data re-cached for $pagename");
}
