/**
  Worse (is better): Wiki's Overdue Rather Simple Editor
  Written by (c) Petko Yotov 2017-2025    www.pmwiki.org/petko

  This text is written for PmWiki; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published
  by the Free Software Foundation; either version 3 of the License, or
  (at your option) any later version. See pmwiki.php for full details
  and lack of warranty.
*/

(function() {
  var PageTitle, WorseText, WorseHTML, FlipCheck, WorseForm, WorseAuthor;
  function xmp(x){console.log(x);}
  if (typeof Trix == 'undefined') return;

  Trix.config.blockAttributes.heading1.tagName = "h2";
  Trix.config.textAttributes.frozen.style.backgroundColor = "inherit";

  var myself = document.getElementById("worsejs");
  if(! myself) return;

  var UploadsCount = 0;
  for (i in ListFiles) UploadsCount++;

  function AttachError(attachment) {
    if (! CanUpload) return XL.W_NoUploadPerm;
    var error = '';
    var a = attachment.name.match(/\.([^.]*)$/);
    if(a) {
      var ext = a[1].toLowerCase();
      if(! UploadExtSize.hasOwnProperty(ext) ) {
        error = XL.ULbadtype.replace(/\$upext/g, ext);
      }
      if(attachment.size > UploadExtSize[ext]) {
        error = XL.ULtoobigext.replace(/\$upext/g, ext).replace(/\$upmax/g, UploadExtSize[ext]);
      }
    }
    else {
      if(UploadExtSize.hasOwnProperty('')) {
        if (attachment.size > UploadExtSize['']) error = XL.ULtoobig;
      }
    }
    return error;
  }

  document.addEventListener("trix-file-accept", function(event) {
    var attachment = event.file;
    var error = '';
    if (attachment) error = AttachError(attachment);
    if(error) {
      alert(error);
      event.preventDefault();
    }
  });

  document.addEventListener("trix-attachment-add", function(event) {
    if(event.attachment.file)
      return upload(event.attachment);
    // only wiki uploads can appear as attachments,
    // use a "link" for other resources or upload them to the wiki
    else if(event.attachment.attachment.attributes.values.url.indexOf(UploadUrl)!==0)
      event.attachment.remove();
  });
  
  function KeySubmit(e) {
    if(e.keyCode == 13) posttext();
  }

  function posttext() {
    var author = WorseAuthor.value.replace(/^\s+|\s+$/, '');
    if(EnablePostAuthorRequired && ! author){
      alert(XL.W_AuthorNameReq);
      WorseAuthor.setAttribute('required', 'required');
      WorseAuthor.focus();
      return false;
    }
    
    WorseForm.className += " saving";
    if(PageTitle) PageTitle.className += " saving";

    var form = new FormData;
    form.append("action", 'worsepost');
    form.append("n", FullName);
    form.append('worsetext', WorseText.value);
    form.append('basetime', BaseTime);
    form.append('csum', WorseCSum.value);
    form.append('author', author);
    var tokel = document.querySelector('input[data-for="pmtoken"]');
    if(tokel) form.append(tokel.name, tokel.value);
    if(PageTitle && PageTitle.textContent != PageTitle.getAttribute('data-default'))
      form.append('worsetitle', PageTitle.textContent);

    var xhr = new XMLHttpRequest;
    xhr.open("POST", PageUrl+'?action=worsepost', true);
    xhr.onload = function() {
      var href, url;
      if (xhr.status === 200) {
        var resp = xhr.response
        xmp(resp);
        var a = resp.match(/^[\n\s]*basetime=(\d+)\s+(.*)[\n\s]*$/);
        if(a) {
          BaseTime = a[1];
          resp = a[2];
        }
        if(a && resp=='ok') {
          WorseText.setAttribute('data-default', WorseText.value);
          self.location.reload();
          return;
        }
        else {
          var msg = XL.W_ChangesNotSavedReplied.replace(/%s/, WikiTitle) + "\n";
          alert(msg + resp);
          stopsaving();
        }
      }
    };
    return xhr.send(form);
  }

  function upload(attachment) {
    var file, form, key, xhr;

    file = attachment.file;
    if(!file) {
      attachment.remove();
      return false;
    }

    form = new FormData;
    form.append("action", 'worseupload');
    form.append("n", FullName);
    form.append("Content-Type", file.type);
    form.append("uploadfile", file);
    form.append('author', WorseAuthor.value);
 
    var tokel = document.querySelector('input[data-for="pmtoken"]');
    if(tokel) form.append(tokel.name, tokel.value);
 
    xhr = new XMLHttpRequest;
    xhr.open("POST", PageUrl+'?action=worseupload', true);
    xhr.upload.onprogress = function(event) {
      var progress;
      progress = event.loaded / event.total * 100;
      return attachment.setUploadProgress(progress);
    };
    xhr.onload = function() {
      var href, url;
      if (xhr.status === 200) {
        if(xhr.response.match(/authpw/)) {
          document.querySelector("#uploadclick").style.display = 'none';
          document.querySelector("#dropfilestoupload").style.display = 'none';

          alert(XL.W_NoUploadPerm);

          attachment.remove();
          return false;
        }
        var resp = JSON.parse(xhr.response);
        if(resp.upresult != 'ULsuccess') {
          if(XL.hasOwnProperty(resp.upresult))
            alert(
              XL[resp.upresult]
                .replace(/\$upname/g, resp.upname)
                .replace(/\$upext/g, resp.ext)
                .replace(/\$upmax/g, UploadExtSize[resp.ext])
            );
          else {
            alert(XL.ULnofile);
          }
          attachment.remove();
          return false;
        }

        if(! ListFiles.hasOwnProperty(resp.upname)) {
          document.querySelector('#fileselect').options[0].insertAdjacentHTML(
            'afterend',
            '<option value="'+resp.upname+'">'+resp.upname+'</option>');
        }

        ListFiles[resp.upname] = {
          name: resp.upname,
          encname: encodeURIComponent(resp.upname),
          size: file.size,
          type: file.type
        };

        return attachment.setAttributes({
          filename: resp.upname,
          url: resp.url,
          href: resp.url
        });
      }
    };
    return xhr.send(form);
  };

  document.addEventListener('trix-initialize', function(e){
    var trix, toolBar, button, uploadButton, ifile;
    trix = e.target;
    toolBar = trix.toolbarElement;

    ifile = document.createElement("input");
    ifile.setAttribute("type", "file");
    ifile.setAttribute("multiple", "multiple");
    ifile.style.position = 'absolute';
    ifile.style.top = '-200px';
    document.getElementsByTagName('body')[0].appendChild(ifile);
    ifile.addEventListener('change', function(e){
      var i, results = [ ], files = this.files;
      for (i = 0;  i < files.length; i++) {
        results.push(trix.editor.insertFile(files[i]));
      }
    }, false);

    var prefix = PageUrl.replace(/([\/.])[^\/.]*$/, '$1');

    var linkselect = '<div>'
      +'<div class="button_group"><select id="linkselect">'
      +'<option value="">'+XL.W_SelectPageLink+'</option>';
    for(var j in ListPages) {
      linkselect += '<option value="'+j+'">'+ListPages[j]+'</option>'
    }
    linkselect += '</select> <input type="button" id="newpageclick" value="'+XL.W_CreateNewPage+'" /></div>';

    toolBar.querySelector(".link_dialog").insertAdjacentHTML("beforeend", linkselect);
    toolBar.querySelector('#linkselect').addEventListener('change', function(e){
      var val = this.options[this.selectedIndex].value;
      var text = this.options[this.selectedIndex].text;
      this.selectedIndex = 0;
      var sel = trix.editor.getSelectedRange();
      trix.focus();
      if(sel[0] == sel[1]) {
        trix.editor.insertHTML('<a href="'+prefix+val+'">'+text+'</a>');
      }
      else trix.editor.activateAttribute("href", prefix+val);
    }, false);
    toolBar.querySelector(".link_url_fields input[type=url]").setAttribute('type', 'text');

    toolBar.querySelector("#newpageclick").addEventListener('click', function(e){
      var val = prompt(XL.W_CreateNewPageTypeTitle);
      var text = val;
      if((! val) || (typeof val != 'string')) return '';
      val = val.replace(/[^-\w\x80-\xfe\s]+/gi, ' ')
        .replace(/(^| )(\S)/g, function(a){ return a.toUpperCase(); })
        .replace(/\s+/g, '');
      if(!val) {
        alert(XL.W_InvalidPageName);
        return '';
      }
      var sel = trix.editor.getSelectedRange();
      trix.focus();
      if(sel[0] == sel[1]) {
        trix.editor.insertHTML('<a href="'+prefix+val+'">'+text+'</a>');
      }
      else trix.editor.activateAttribute("href", prefix+val);
    }, false);

    if(CanUpload || UploadsCount) {
      var b = '<button type="button" class="icon attach open-dialog" data-trix-attribute="x-attach" title="'
        +XL.W_AttachFiles+'">'+XL.W_Attach+'</button>';
      toolBar.querySelector(".text_tools").insertAdjacentHTML("beforeend", b);

      var d = '<div class="dialog" data-trix-dialog="x-attach"><div class="dialog-content upload_dialog"></div></div>';
      toolBar.querySelector(".dialogs").insertAdjacentHTML("beforeend", d);

      linkselect = '<div>' + (CanUpload? '<span id="dropfilestoupload">'+XL.W_DropFiles+'</span>':'')
        +'<div class="button_group"><select id="fileselect">'
        +'<option value="">'+XL.W_SelectUpFile+'</option>';
      for(var j in ListFiles) {
        linkselect += '<option value="'+j+'">'+j+'</option>'
      }
      linkselect += '</select>';
      if(CanUpload)
        linkselect += ' <input type="button" id="uploadclick" value="'+XL.W_UpNewFiles+'" />';
      linkselect += '</div>';

      toolBar.querySelector(".upload_dialog").insertAdjacentHTML("beforeend", linkselect);

      if(CanUpload)
        toolBar.querySelector("#uploadclick").addEventListener('click', function(e){
          trix.focus();
          ifile.click();
        }, false);

      toolBar.querySelector('#fileselect').addEventListener('change', function(e){
        var val = this.options[this.selectedIndex].value;
        this.selectedIndex = 0;
        if(!val) return '';
        var out = AddFileHTML(val);
        setTimeout(function(){trix.focus(); trix.editor.insertHTML(out);}, 50);
        return '';
      }, false);
    }

    toolBar.querySelector('.link_dialog input[value=Link]').addEventListener('click', function(e){
      var input = toolBar.querySelector(".link_dialog input[name=href]");
      var url = input.value;
      if(url.match(/^(https?|ftps?|tel|mailto):.+/i)) return true;
      if(url.match(/^@.*$/)) input.value = prefix+url.substring(1);
      if(url.match(/^\+.*$/)) input.value = UploadUrl+url.substring(1);
      else if(url.match(/^[-\w.+_]+@[-\w.+_]+(\?(subject|body|b?cc)=.*$)?/i)) input.value = 'mailto:'+url;

    }, false);

    PageTitle = document.querySelector("h1.pagetitle");
    if (!PageTitle) PageTitle = document.querySelector(".pagetitle h1");
    if (PageTitle) {
      PageTitle.className += " worse-pagetitle";
      PageTitle.setAttribute('data-default', PageTitle.textContent);
      PageTitle.addEventListener('dblclick', startedit, false);

      PageTitle.addEventListener('keydown', function(e){
        if(e.keyCode == 13) e.preventDefault();
      }, false);
    }
    WorseText = document.querySelector('#worsetext');
    if(!WorseText) return;
    WorseText.setAttribute('data-default', WorseText.value);
    WorseForm = document.querySelector('#worseform');
    FlipCheck = document.querySelector("#flipcheck");
    FlipCheck.addEventListener('change', function(e){
      if(this.checked) startedit();
      else stopedit(false);
    }, false);
    WorseCSum = document.querySelector('#worsecsum');
    WorseHTML = document.querySelector('#worse_1');
    WorseAuthor = document.querySelector('#worseauthor');
    
    WorseAuthor.addEventListener('keydown', KeySubmit, false);
    WorseCSum.addEventListener('keydown', KeySubmit, false);

    document.querySelector('#worsesave').addEventListener('click', posttext, false);
    document.querySelector('#worsecancel').addEventListener('click', function(){stopedit(0);}, false);
    WorseHTML.addEventListener('dblclick', startedit, false);

    if(!WorseText.defaultValue) startedit();
  
    var action_edit = document.querySelectorAll("a[href$='action=edit']");
    for(var i=0; i<action_edit.length; i++) {
      if(action_edit[i].href.indexOf(PageUrl)===0)
        action_edit[i].addEventListener('click', function(e){
          if(this.href.indexOf(PageUrl)===0 && ! FlipCheck.checked) {
            e.preventDefault();
            startedit();
          }
        }, false);
    }
  });

  function startedit(e) {
    FlipCheck.checked = true;
    if(PageTitle)
      PageTitle.setAttribute('contenteditable', true);
  }
  function stopsaving(){
    var wf = document.querySelector('#worseform');
    if(wf) wf.className = wf.className.replace(/ *saving/, '');
    if(PageTitle) {
      PageTitle.className = PageTitle.className.replace(/ *saving/, '');
    }
  }
  function stopedit(newdefault) {
    stopsaving();
    FlipCheck.checked = false;
    if(PageTitle) {
      PageTitle.removeAttribute('contenteditable');
      if(newdefault) PageTitle.setAttribute('data-default', PageTitle.textContent);
      else PageTitle.innerHTML = PageTitle.getAttribute('data-default');
    }
  }

  function AddFileHTML(name){
    var fobject = ListFiles[name];
    var url = fobject.encname;
    var data = {
      contentType: fobject.type,
      filename: fobject.name,
      filesize: fobject.size,
      href: UploadUrl + url,
      url: UploadUrl + url,
    }
    if(fobject.hasOwnProperty('width')) {
      data.width = fobject.width;
      data.height = fobject.height;
      var fclass = "attachment-preview";
      var img = '<img src="'+data.url+'" />';
    }
    else {
      var fclass = "attachment-file";
      var img = '';
    }
    var kb = Math.round(fobject.size/10.24)/100;
    var attr = JSON.stringify(data).replace(/"/g, '&quot;');

    var out = '<a href="'+data.url+'" data-trix-attachment="'
      + attr + '" data-trix-content-type="'
      + data.contentType+'"><figure class="attachment '+fclass+'">'
      + img + '<figcaption class="caption">' + data.filename
      + ' <span class="size">' + kb + ' KB</span></figcaption></figure></a>';
    return out;
  }
  window.addEventListener('beforeunload', function(e){
    var unsaved = 0;
    WorseText = document.querySelector('#worsetext');
    if(!WorseText) return;
    if(PageTitle && PageTitle.textContent != PageTitle.getAttribute('data-default')) unsaved++;
    if(WorseText.value != WorseText.getAttribute('data-default')) unsaved++;
    if(unsaved) {
      e.returnValue = XL.W_NotSaved;
      return XL.W_NotSaved;
    }
  }, false);
  
}).call(this);
