<?php if (!defined('PmWiki')) exit();
/***********************************************************************
**  skin.php
**  Copyright Hans Bracker (www.softflow.uk)
**  built inspired by "2016" skin by Petko Yotov (www.pmwiki.org/petko)
**  
**  This file is part of PmWiki; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published
**  by the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.  See pmwiki.php for full details.
***********************************************************************/
global $RecipeInfo, $SkinName, $SkinVersion, $FmtPV, $HTMLStylesFmt, $HTMLHeaderFmt, $HTMLFooterFmt, 
				$AmberConfig, $SkinElementsPages, $DefaultSkinElements, $TableCellAlignFmt, 
				$EnableRTL, $HTMLTagAttr, $Lang, $HTMLTitle, $WikiTitle;
$RecipeInfo['Amber']['Version'] = '2024-04-24';
#StopWatch('Amber');
$SkinName = 'Amber';
$SkinVersion = $RecipeInfo['Amber']['Version'];
$FmtPV['$SkinName'] = '$GLOBALS["SkinName"]';
$FmtPV['$SkinVersion'] = '$GLOBALS["SkinVersion"]';

SDV($HTMLTitle, $WikiTitle);

# switch to RTL if we got style injection for 'rtl'
if (isset($HTMLStylesFmt['rtl'])) $EnableRTL = 1;

# check $HTMLTagAttr for dir='rtl' and for if lang is RTL language 
SDVA($RTLLanguages, array('ar','fa','he','ur'));
if (!empty($HTMLTagAttr)) {
	$htmltag = ParseArgs($HTMLTagAttr);
if (isset($htmltag['dir'])) $EnableRTL = ($htmltag['dir']=='rtl')? 1 : 0;
else if (isset($htmltag['lang'])) $EnableRTL = (in_array($htmltag['lang'], $RTLLanguages)) ? 1 : 0;
}

# for MultiLanguageView: set $HTMLTagAttr, enable RTL only if language exists in page
if (isset($Lang)) {
	if ($HTMLTagAttr) {
		$HTMLTagAttr = preg_replace('/lang=[\'\"\w]+/',"lang='$Lang'", $HTMLTagAttr);
	} else { $HTMLTagAttr = "lang='$Lang'"; }
	if (in_array($Lang, $RTLLanguages)) $EnableRTL = (MLVLangInPage($pagename, $Lang))? 1 : 0;
	else $EnableRTL = 0;
}

# default sidebar menu position: 'right' or 'left'
if (isset($EnableRTL) && $EnableRTL==1) SDV($AmberConfig['menu'], 'left'); //for rtl text direction
else SDV($AmberConfig['menu'], 'right'); //for default (ltr) text direction

# injected via skin.tmpl (v.2024-04-24)
#$HTMLHeaderFmt['ambercss'] = '<link rel="stylesheet" href="$SkinDirUrl/skin.css" type="text/css" />';

## sidebar can only be either right or left
switch ($AmberConfig['menu']) {
	case 'right':	SetTmplDisplay('PageLeftFmt', 0);
						$mopen = 'left'; $mclose = 'right';
						break;	
	case 'left':  	SetTmplDisplay('PageRightFmt', 0);
						$mopen = 'right'; $mclose = 'left';
						$HTMLHeaderFmt['AmberLeftRightCSS'] = '<link rel="stylesheet" href="$SkinDirUrl/skin-left.css" type="text/css" />';
						break;	
}

# note: for RTL we do not load skin-left.css. we load skin-rtl.css. SideBar menu always left.
if (isset($EnableRTL) && $EnableRTL==1) {
	$HTMLHeaderFmt['AmberLeftRightCSS']   = '<link rel="stylesheet" href="$SkinDirUrl/skin-rtl.css" type="text/css" />';
	$mopen = 'right'; $mclose = 'left';
}

$HTMLFooterFmt['amberjs'] = "
	<script type='text/javascript'> var mclose = '".$mclose."'; var mopen = '".$mopen."';  </script>
	<script type='text/javascript' src='$SkinDirUrl/skin.js'></script>";

# Disable inline styles injected into each header by the PmWiki core.
# These styles are included in file amber/content.css
$styles = explode(' ', 'pmwiki rtl-ltr wikistyles markup simuledit diff urlapprove vardoc PmTOC PmSortable');
foreach($styles as $style) $HTMLStylesFmt[$style] = '';

# CSS alignment for table cells (valid HTML5)
$TableCellAlignFmt = " class='%s'";

# For (:searchbox:), valid semantic HTML5
$SearchBoxInputType = "search";

# remove deprecated "name=" parameter from anchor tags
Markup('[[#','<[[','/(?>\\[\\[#([A-Za-z][-.:\\w]*))\\]\\]/',
  "AmberTidyAnchor");
function AmberTidyAnchor($m) {
	return Keep(TrackAnchors($m[1]) ? '' : "<a id='{$m[1]}'></a>", 'L');
}

# in HTML5 "clear" is a style not an attribute
Markup('[[<<]]','inline','/\\[\\[&lt;&lt;\\]\\]/',"<br style='clear:both;' />");

# Allow skin header and footer to be written 
# in a wiki page, and use defaults otherwise
SDV($SkinElementsPages, array('{$Group}.PageElements', '{$SiteGroup}.PageElements'));

SDVA($DefaultSkinElements, array(
	'topactions' => '<ul>
				<li class="browse"> <a accesskey="v" class="selflink" rel="nofollow" href="{$PageUrl}">$[View]</a></li>
				<li class="edit"><a accesskey="e" class="wikilink" rel="nofollow" href="{$PageUrl}?action=edit">$[Edit]</a></li>
				<li class="diff"><a accesskey="h" class="wikilink" rel="nofollow" href="{$PageUrl}?action=diff">$[History]</a></li>
				<li class="upload"><a accesskey="u" class="wikilink" rel="nofollow" href="{$PageUrl}?action=upload">$[Attach]</a></li>
    		</ul>',
	'header' => '
				<div class="site-title"><strong><a class="logolink" href="{$ScriptUrl}" title="{$WikiTitle}">{$WikiTitle}</a></strong></div>
				<div class="site-subtitle"><em>  </em></div>
			',
  'topsearch' => '
    <form class="wikisearch" action="{$ScriptUrl}" method="get">
      <input type="hidden" name="n" value="{$FullName}" />
      <input type="hidden" name="action" value="search" />
      <input id="header-searchquery" type="search" name="q" value="" class="inputbox searchbox" placeholder="$[Search]" />
      <input id="header-searchsubmitbtn" type="submit" class="inputbutton searchbutton" value="$[Go]" />
    </form>',
	'titlebar' => '
			<div class="crumbtrail" ><ul>
				<li><a class="wikilink" href="{$ScriptUrl}/{$DefaultGroup}/{$DefaultName}">$[Home]</a></li>
				<li><a class="wikilink" href="{$ScriptUrl}/{$Group}/">{$Group}</a></li>
				<li><a class="wikilink" href="{$PageUrl}">{$Name}</a></li>
				</ul></div>
			',
  'footactions' =>
      '<ul><li><a rel="nofollow" href="{$PageUrl}?action=edit">$[Edit]</a></li>
      <li><a rel="nofollow" href="{$PageUrl}?action=diff">$[History]</a></li>
			<li class="upload"><a accesskey="" class="wikilink" rel="nofollow" href="{$PageUrl}?action=upload">$[Attach]</a></li>
      <li><a rel="nofollow" href="{$PageUrl}?action=print" target="_blank">$[Print]</a></li>
      <li><a href="{$ScriptUrl}/$[{$Group}/RecentChanges]">$[Recent Changes]</a></li>
      <li><a href="{$ScriptUrl}/$[{$SiteGroup}/Search]?q={$Group}/ ">$[List Group]</a></li>
      <li><a href="{$ScriptUrl}/$[{$SiteGroup}/Search]">$[Search]</a></li>
    	</ul>
    	<div id="footer-lastmod" class="lastmod">$[Page last modified on {$LastModified}]</div>
    	',
   'footer' => '<span>
   			<strong>Amber Skin for PmWiki</strong> &ndash; by Hans Bracker &ndash; <em><a href="http://softflow.uk/">softflow.uk</a><em>
   			</span>',
));

# This function prints a skin element which is written 
# inside a [[#section]]...[[#hsectionend]] section in, first, a GroupName.PageElements or, second, Site.PageElements page
function SkinElement($pagename, $section) {
  global $SkinElementsPages, $DefaultSkinElements;
  foreach($SkinElementsPages as $p) { 
    $pn = FmtPageName($p, $pagename);
    $elm = RetrieveAuthSection($pn, "#$section#{$section}end");
    if(!$elm) continue;
    echo MarkupToHTML($pagename, Qualify($pn, $elm));
    return;
  }
  if(@$DefaultSkinElements[$section])
    echo FmtPageName($DefaultSkinElements[$section], $pagename);
}

## Markup (:noaction:)
Markup('noaction','directives','/\\(:noaction:\\)/', 
    "AmberNoAction");
function AmberNoAction() {
	SetTmplDisplay('PageTopActionsFmt', 0);
	SetTmplDisplay('PageFootActionsFmt', 0);
}

## Markup (:nobanner:)
Markup('nobanner','directives','/\\(:nobanner:\\)/', 
    "AmberNoBanner");
function AmberNoBanner() {
	SetTmplDisplay('PageBannerFmt', 0);
}

## Markup (:noheader:)
Markup('noheader','directives','/\\(:noheader:\\)/', 
    "AmberNoHeader");
function AmberNoHeader() {
	global $HTMLHeaderFmt, $AmberConfig;
	SetTmplDisplay('PageHeaderFmt', 0);
	SetTmplDisplay('PageTopSearchFmt', 0);
	SetTmplDisplay('PageTopActionsFmt', 0);
	if ($AmberConfig['menu'] == 'left')
		$HTMLHeaderFmt['noheader'] = "<style type='text/css'>/*Amber*/ @media screen and (max-width:54.9em){#titlebar{margin-left:45px;} .page-title{padding-left:45px;}} </style>";
}
## Markup (:notitlebar:)
Markup('notitlebar','directives','/\\(:notitlebar:\\)/', 
    "AmberNoTitleBar");
function AmberNoTitleBar() {
	SetTmplDisplay('PageTitleBarFmt', 0);
}

## Markup (:noright:)
Markup('noright','directives','/\\(:noright:\\)/', 
    "AmberNoRight");
function AmberNoRight() {
	global $HTMLHeaderFmt, $AmberConfig;
	SetTmplDisplay('PageRightFmt', 0);
	if ($AmberConfig['menu'] == 'right')
		SetTmplDisplay('PageMenuToggleFmt', 0);
	$HTMLHeaderFmt['noright'] = "<style type='text/css'>/*Amber*/ #search-toggle-label{right:10px; top:0;} </style>";
}

## Markup (:noleft:)
Markup('noleft','directives','/\\(:noleft:\\)/', 
    "AmberNoLeft");
function AmberNoLeft() {
	global $HTMLHeaderFmt, $AmberConfig;
	SetTmplDisplay('PageLeftFmt',0);
	if ($AmberConfig['menu'] == 'left')
		SetTmplDisplay('PageMenuToggleFmt',0);
	$HTMLHeaderFmt['noleft'] = "<style type='text/css'>/*Amber*/ #header{padding-left:0.5em;} #footactions{padding-left:0;} @media screen and (min-width:40em) {#header{padding-left:1.5em;}} </style>";
}

## Markup (:nofooter:)
Markup('nofooter','directives','/\\(:nofooter:\\)/', 
    "AmberNoFooter");
function AmberNoFooter() {
	SetTmplDisplay('PageFooterFmt', 0);
}

## Markup (:nosearch:)
Markup('nosearch','directives','/\\(:nosearch:\\)/', 
    "AmberNoSearch");
function AmberNoSearch() {
	SetTmplDisplay('PageTopSearchFmt', 0);
}

## Markup (:nochrome:), just show page title and content
Markup('nochrome','directives','/\\(:nochrome:\\)/', 
    "AmberNoChrome");
function AmberNoChrome() {
	AmberNoAction();
	AmberNoHeader();
	AmberNoTitleBar();
	AmberNoRight();
	AmberNoLeft();
	AmberNoFooter();
}
