<?php if (!defined('PmWiki')) exit();
/*  Copyright 2014 Hans Bracker. 
    This file is part of the fixflow skin for pmwiki 2.2.56+
    You can redistribute it and/or modify
    it under the terms of the GNU General Public License as published
    by the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This script sets the default styles and options.
    It also defines various style options.
    Color and font options are loaded via seperate css files.
        
    A user can switch styles sitewide for himself, by setting a cookie, using the following:
    setcolor=..., setfont=..., setrb=..., setlayout=...,  setsidebar=....
    A user can change a style for a page, without setting  a cookie, through:
    colors=..., fonts=..., rb=..., layout=...,  sidebar=...
    Parameters are defined below in various lists.
      
    By default, the cookies that are created will expire after
    one year.  To have cookies to expire at the end of the browser
    session, set $FontCookieExpires=0; $ColorCookieExpires=0; 
    $RightbarCookieExpires=0; $LayoutCookieExpires=0;
*/
$RecipeInfo['FixFlowSkin']['Version'] = '2023-02-24';

$SkinName = 'FixFlow';
$SkinVersion = $RecipeInfo['FixFlowSkin']['Version'];
$FmtPV['$SkinName'] = '$GLOBALS["SkinName"]';
$FmtPV['$SkinVersion'] = '$GLOBALS["SkinVersion"]';

global $FmtPV, $SkinName, $SkinVersionDate, $SkinVersionNum, $SkinVersion, $SkinRecipeName, 
       $SkinSourceURL, $RecipeInfo;
# Some Skin-specific values

$SkinName = 'fixflow';
$SkinRecipeName = "FixFlowSkin";

# for use in conditional markup  (:if enabled FixFlowSkin:)
global $FixFlowSkin; $FixFlowSkin = 1;

global $DefaultColor, $DefaultFont, $DefaultSidebar,$DefaultMenu, $DefaultRightbar, 
    $HTMLStylesFmt, $HTMLHeaderFmt, $SidebarWidth,
    $EnableRightBar, $EnableStyleOptions, $EnableColorOptions, $EnableFontOptions,
    $EnableSidebarOptions, $EnableMenuOptions, $EnableRightbarOptions,$EnableLayoutOptions,
    $EnableThemes, $EnableFontSizer,$EnableBackgroundImages,
    $EnableSidebarSearchbox, $EnableSidebarFontSizer, $EnableGroupTitle,
    $EnablePmWikiCoreCss, $EnablePopupEditForm, $BackgroundImgUrlFmt;

# A RightBar is displayed by default if created.
# $EnableRightBar = 0 disables RightBar as default, for all pages.
# RightBar can be shown on individual pages or groups (via group header) 
# by including markup (:showright:) on the page.
# It can be hidden by including markup (:noright:) on pages.
# A user can also set different widths and hide the Rightbar
# through actions ?setrb=3 (or 2, 1, 0) and ?rb=3 (or 2, 1, 0)
# if $EnableStyleOptions['rightbar'] = 1; (see below)
SDV($EnableRightBar, 1);

# Adds searchbox to top of sidebar. 
# A searchbox can also be inserted through markup (:searchbox:), 
# which could be added anywhere in the SideBar, PageTopMenu or PageFootMenu.
# In this case you may wish to set
# $EnableSidebarSearchbox = 0;  to disable searchbox in the template.
SDV($EnableSidebarSearchbox, 1);

## Adds fontsizer. To disable font sizing set in config.php: $EnableFontsizer = 0;
# Set $EnableSidebarFontSizer = 0; if the default fontsizer buttons shall not be shown,
# and alternative buttons by adding (:fontsizer:) to sidebar or other places
SDV($EnableFontSizer, 1);
SDV($EnableSidebarFontSizer, 1);

## adding  preview popup for edit window
SDV($EnablePopupEditForm, 1);

# Enables grouplink in titlebar; set to 0 for no grouplink in titlebar.
# To see a link to the Group's homepage add *[[{$Group}]] to the PageTopMenu.
# Add *[[{$Name}]] to see the current page name, which may be different than the title
# The group name can also be hidden on pages with markup (:nogroup:)
SDV($EnableGroupTitle, 1);

# Set default colors, font and layout schemes here,
# the default loads without any cookie being set.
# Different defaults can be set also in config.php 
# or a groups local/GroupName.php (for different coloured groups for instance)
# by adding lines like  $DefaultColor = 'blue';
# The keywords used her must be defined below in the various Page...Lists
SDV($DefaultColor,'silver');
SDV($DefaultFont,'verdana');
SDV($DefaultSidebar,'left');    
SDV($DefaultMenu,'fixed');
SDV($DefaultRightbar,'narrow');

# Style options for users to switch color and font schemes, rightbar width, 
# sidebar position and menu behaviour (scroll/fixed). Disable user options 
# by setting $EnableStyleOptions = 0;
SDV($EnableStyleOptions, 1);   # By default style options are enabled, 
# Inidividual option switching can be disabled by type setting any of the following to zero
# An admin may prefer to have the sidebar position not changeable
SDV($EnableColorOptions, 1);   # color scheme switching
SDV($EnableFontOptions, 1);    # font scheme switching
SDV($EnableSidebarOptions, 1); # sidebar position switching
SDV($EnableMenuOptions, 1);    # menu scroll/fixed switching
SDV($EnableRightbarOptions, 1);# rightbar width switching
SDV($EnableLayoutOptions, 0);  # not used in FixFlow

# By default markup (:theme colorname fontname:)is enabled, 
# SDV($EnableThemes, 0); #disables theme display.
SDV($EnableThemes, 1);

## background image for transparent color scheme
SDV($BackgroundImgUrlFmt, '$SkinDirUrl/images/beach.jpg');

# Quick way to disable background images:
SDV($EnableBackgroundImages, 1);

# load pmwiki-core.css instead of default styles in page head
SDV($EnablePmWikiCoreCss, 1);

# option arrays, these can be expanded with more custom files.
# comment out any options not wanted.
# The keyword (left of arrow) is used to set the default. 
# Right of the arrow is the css file which gets loaded.
global $PageColorList, $PageFontList, $PageSidebarList;
SDVA($PageColorList, array (
        'blue' => 'c-blue.css',
        'sky' => 'c-sky.css',
        'sky-blue' => 'c-sky-blue.css',
        'sand' => 'c-sand.css',
        'silver' => 'c-silver.css',
        'lavender' => 'c-lavender.css',
        'lilac' => 'c-lilac.css',       
        'pink' => 'c-pink.css',
        'red-gold' => 'c-red-gold.css',
        'green-gold' => 'c-green-gold.css',
        'parch-blue' => 'c-parch-blue.css',
        'parch-yellow' => 'c-parch-yel.css',
        'night' => 'c-night-blue.css',
        'stars' => 'c-night-stars.css',
        'trans' => 'c-transparent.css',        
        ));
SDVA($PageFontList, array (
        'sans' => 'font-sans.css',
        'verdana' => 'font-verdana.css',
        'georgia' => 'font-georgia.css',
        'times' => 'font-times.css',
        'palatino' => 'font-palatino.css',
        'monospace' => 'font-lucida.css',
        'courier' => 'font-courier.css',
        'comic' => 'font-comic.css'
        ));
$PageSidebarList = array (
        'left'  => 'left',        
        'right' => 'right'     
        );
$PageMenuList = array(
        'fixed' => 'fixed',            
        'scroll' => 'scroll'    
        );
SDVA($PageRightbarList, array (
        '0' => 'display:none',
        'off' => 'display:none',
        'on' => 'width:12em',
        '1' => 'width:12em',
        'narrow' => 'width:12em',
        '2' => 'width:16em',
        'normal' => 'width:16em',
        '3' => 'width:22em',
        'wide' => 'width:22em',
        ));

# set sidebar width default in pixels only, with variable $SidebarWidth = 'nnnpx';
SDV($SidebarWidth, '175px');
#$sbmargin = $SidebarWidth +1;
#$SidebarMargin = $sbmargin.'px'; # for IE's sake


# =========== end of configuration section of skin.php ================= #
global $BodyAttrFmt;
SDV($BodyAttrFmt, '');

# pmwiki core styles 
# disable pmwiki default core styles, load from core.css
global $PmWikiCoreCss, $PmWikiCoreStylesFmt;
if($EnablePmWikiCoreCss==1) { 
# awaiting pmwiki suport for pmwiki-core.css, $PmWikiCoreCss may need update!
  SDV($PmWikiCoreCss, "pmwiki-core.css");
  if(file_exists("$FarmD/pub/css/$PmWikiCoreCss")) SDV($PmWikiCoreStylesFmt, "
    <link href='$FarmPubDirUrl/css/$PmWikiCoreCss' rel='stylesheet' type='text/css' />");
  else
    SDV($PmWikiCoreStylesFmt, "
     <link href='$SkinDirUrl/css/pm-core.css' rel='stylesheet' type='text/css' />");
  
   $HTMLStylesFmt['pmwiki'] = '';
   $HTMLStylesFmt['diff'] = '';
   $HTMLStylesFmt['simuledit'] = '';
   $HTMLStylesFmt['markup'] = '';
   $HTMLStylesFmt['urlapprove'] = '';
   $HTMLStylesFmt['vardoc'] = '';
   $HTMLStylesFmt['wikistyles']= '';
}

# skin template adds javascript to set javascript cookie
# check for javascript cookie, set $javascript var for (:if enabled javascript:) switch  
global $javascript;
if (isset($_COOKIE['javascript'])) $javascript = $_COOKIE['javascript']; 

# add fontsizer
if($EnableFontSizer==1) { include_once("$SkinDir/fontsizer.php");
      $HTMLStylesFmt['fontsizer'] = "";}

# switch to hide FontSizer links
if ($EnableSidebarFontSizer ==0) $HTMLStylesFmt[] = " #sidebarfontsizer { display:none } \n";

# define variables
global $Now, $LayoutCss, $SidebarCss, $MenuCss, $RightbarCss, $FontCss,  
        $ColorCss, $IE6Css, $IE5Css, $SkinDir;
$sc = $DefaultColor;
$sf = $DefaultFont;     
$ss = $DefaultSidebar;
$sm = $DefaultMenu;
$sr = $DefaultRightbar;
$ColorCss = $PageColorList[$sc];
$FontCss = $PageFontList[$sf];
$SidebarCss = $PageSidebarList[$ss];
$RightbarCss = $PageRightbarList[$sr];

# add stylechange.php for cookie setting code if set.
if ($EnableStyleOptions) include_once("$SkinDir/stylechange.php");

# do not show rightbar box if RightBar is empty
$prb = FmtPageName('$FullName-RightBar',$pagename);
$grb = FmtPageName('$Group.RightBar',$pagename);
$srb = FmtPageName('$SiteGroup.RightBar',$pagename);
if (PageExists($prb)) $rpage = ReadPage($prb);
if (PageExists($grb)) $rpage .= ReadPage($grb);
if (PageExists($srb)) $rpage .= ReadPage($srb);
if(@$rpage['text']=='') {
   $HTMLStylesFmt[] = " 
     #rightbar { display:none } ";
   };

#=== fixflow switches for layout, inserted after $HTMLStylesFmt ===#
# switch from default fixed menu to scrolled menu
if($sm=='scroll') { 
  $HTMLHeaderFmt['fixflow'] = " 
  <style type='text/css'><!--
  #sidebarbox { position:absolute;  top:0; }
  --></style>";
  }
if($sm=='fixed') { 
  $HTMLHeaderFmt['fixflow'] = " 
  <style type='text/css'><!--
  #sidebarbox { position:fixed; top:0; }
  --></style>
  <!--[if lt IE 7]>
    <style type='text/css'>#sidebarbox {position:absolute; top:expression(eval(document.body.scrollTop))}</style>
  <![endif]--> ";
  }
if($ss=='left') {
  $HTMLHeaderFmt['sbpos'] = " 
  <style type='text/css'><!--
  #sidebarbox { left:0; width: $SidebarWidth }
  #main { top:0; margin:0 0 0 $SidebarWidth; }
  --></style> ";
}
if($ss=='right') {
  $HTMLHeaderFmt['sbpos'] = " 
  <style type='text/css'><!--
  #sidebarbox { right:0; width: $SidebarWidth }
  #main { top:0; margin:0 $SidebarWidth 0 0; }
  --></style> ";
}

## set scrollswitch to enable showing Menu Scrolled/Fixed links in sidebar 
global $scrollswitch;
$scrollswitch = 1;

# add {$PageLogoUrl} to page variables to use on default PageHeader page
global $FmtPV;
$FmtPV['$PageLogoUrl'] = '$GLOBALS["PageLogoUrl"]';

## add alternative searchbox markup
include_once("$SkinDir/searchbox2.php");
  
# switch to hide sidebar searchbox 
global $smallsearchbox;
if ($EnableSidebarSearchbox == 0) { 
   $HTMLStylesFmt[] = " 
   #sidebarsearch {display:none} \n";
   $smallsearchbox = 1;
   };
    
# switch to hide RightBar
if ($EnableRightBar==1) SetTmplDisplay('PageRightFmt', 1);
else SetTmplDisplay('PageRightFmt', 0);

# changes to extended markup recipe for selflink definition:
global $LinkPageSelfFmt;
$LinkPageSelfFmt = "<a class='selflink'>\$LinkText</a>";

## Set Titles
global $HTMLTitleFmt, $GroupTitleFmt, $TitleFmt, $WikiTitle;
// display or hide group-link in titlebar
if($EnableGroupTitle==0) $GroupTitleFmt = "";
else { 
  SDV($GroupTitleFmt, '<div id="pagegroup"><a href="$ScriptUrl/$Group">$Groupspaced</a></div>');
  }
// set page title
SDV($TitleFmt, '<h1><a class="titlelink" href="$PageUrl?action=browse">$Titlespaced</a></h1>');
// set HTML title
$group = PageVar($pagename,'$Group');
$title = PageVar($pagename,'$Title');
SDV($HTMLTitleFmt, "$WikiTitle -  $group - $title");

#adding switch for 'Pagename-Titlebar' subpage for fancy font titlebars
$ftb = FmtPageName('$FullName-TitleBar',$pagename);
if(PageExists($ftb))  $HTMLStylesFmt[] = " .titlelink { display:none } \n ";

## special markups =====================================
## (:nogroup:) (:noleft:) (:showright:) (:notopmenu:) (:nofootmenu:) (:noaction:) (:noheader:)  (:theme colorname fontname:)

# Markup (:nogroup:) to hide group link in titlebar 
Markup('nogroup','directives','/\\(:nogroup:\\)/', "NoPageGroup");
function NoPageGroup() { 
	$GLOBALS['GroupTitleFmt'] = ""; 
	return '';
}

## Markup (:noleft:) redefinition
Markup('noleft','directives','/\\(:noleft:\\)/', "NoLeftBar"); 
function NoLeftBar() {
     global $HTMLHeaderFmt, $PageLeftFmt;
     SetTmplDisplay('PageLeftFmt',0);
     $HTMLHeaderFmt['noleft'] = " 
     <style  type='text/css'><!-- 
     #main { margin-left:0; width:100%; padding-right:0;} #sidebar{margin-left:-500px} #outer{margin-left:0} #left {width:0} 
     --></style> ";
     return '';
}

## Markup (:showright:) (but never shows RB in edit mode)
global $action;
if ($action != 'edit') {
  Markup('showright','directives','/\\(:showright:\\)/', "ShowRightBar");
  function ShowRightBar() { 
    SetTmplDisplay('PageRightFmt', 1); 
  }
}

## Markup (:notopmenu:)
Markup('notopmenu','directives','/\\(:notopmenu:\\)/', "NoTopMenu");
function NoTopMenu() {
    global $HTMLStylesFmt, $PageTopMenuFmt;
    SetTmplDisplay('PageTopMenuFmt',0);
    $HTMLStylesFmt[] = " 
    #titlebar { margin-top:5px } \n ";
    return '';
}
 
## Markup (:nofootmenu:) 
Markup('nofootmenu','directives','/\\(:nofootmenu:\\)/', "NoFootMenu");
function NoFootMenu() { 
	SetTmplDisplay('PageFootMenuFmt', 0); 
}
  
## Markup (:noaction:) = notopmenu + nofootmenu
Markup('noaction','directives','/\\(:noaction:\\)/', "NoAction2");
function NoAction2() {
    NoTopMenu();
    SetTmplDisplay('PageFootMenuFmt', 0);
    return '';
}
  
## Markup (:noheader:)
Markup('noheader','directives','/\\(:noheader:\\)/', "NoHeader");
function NoHeader() {
    global $HTMLStylesFmt;
    SetTmplDisplay('PageHeaderFmt',0);
    $HTMLStylesFmt[] = "  #clearheader {height:1px; }
                            #header { display:none; } \n ";
    return '';
}


## Markup (:theme colorname fontname:)
if ($EnableThemes==1)
    Markup('theme', 'fulltext', '/\\(:theme\\s+(.*?)\\s*:\\)/', "SetTheme"); 
else  Markup('theme', 'fulltext', '/\\(:theme\\s+(.*?)\\s*:\\)/', "");
function SetTheme($m) {
   global $ColorCss,$PageColorList,$FontCss,$PageFontList,$BackgroundImgUrlFmt,
   			$HTMLHeaderFmt,$HTMLStylesFmt,$SkinDirUrl,$EnableThemes;
   $opt = ParseArgs($m[1]);
   $opt[''] = (array)@$opt[''];
   $sc = (isset($opt['color'])) ? $opt['color'] : array_shift($opt['']);
   $sf = (isset($opt['font']))  ? $opt['font']  : array_shift($opt['']);
   if (@$PageColorList[$sc]) { 
      $ColorCss = $PageColorList[$sc];
      $HTMLHeaderFmt['skin-color'] = "   
   <link href='$SkinDirUrl/css/$ColorCss' rel='stylesheet' type='text/css' media='screen' />";
   }
   if(isset($sf)) {
     if (@$PageFontList[$sf]) {
       $FontCss = $PageFontList[$sf];};
       $HTMLHeaderFmt['skin-font'] = "   
   <link href='$SkinDirUrl/css/$FontCss' rel='stylesheet' type='text/css' media='screen' />";
   }
   if(isset($opt['background'])) {
      $ColorCss = $PageColorList['trans'];
      $HTMLHeaderFmt['skin-color'] = "   
   <link href='$SkinDirUrl/css/$ColorCss' rel='stylesheet' type='text/css' media='screen' />";
   	$BackgroundImgUrlFmt = $opt['background'];
   	$HTMLHeaderFmt['trans-background'] = " 
			<style type='text/css'><!--
				body { background:url({$BackgroundImgUrlFmt}) fixed; } \n
			--></style>
		";
   }
};

    
## add double line horiz rule markup ====
Markup('^====','>^->','/^====+/','<:block,1><hr class="hr-double" />');
  
## removing rightbar, header, title for history and uploads windows
global $action;
if ($action=='diff' || $action=='upload') { 
            SetTmplDisplay('PageRightFmt', 0);
            SetTmplDisplay('PageHeaderFmt', 0);
            SetTmplDisplay('PageTitleFmt', 0);
    };

## alternative Diff (History) form with link in title
global $PageDiffFmt, $PageUploadFmt;
SDV($PageDiffFmt, "<h2 class='wikiaction'>
  <a href='\$PageUrl'> \$FullName</a> $[History]</h2>
  <p>\$DiffMinorFmt - \$DiffSourceFmt - <a href='\$PageUrl'> $[Cancel]</a></p>");

## alternative Uploads form with link in title 
SDVA($PageUploadFmt, array("
  <div id='wikiupload'>
  <h3 class='wikiaction'>$[Attachments for] 
  <a href='\$PageUrl'> {\$FullName}</a></h3>
  <h3>\$UploadResult</h3>
  <form enctype='multipart/form-data' action='{\$PageUrl}' method='post'>
  <input type='hidden' name='n' value='{\$FullName}' />
  <input type='hidden' name='action' value='postupload' />
    <p align='right' style='float:left'>$[File to upload:]
    <input name='uploadfile' type='file' size=50 /></p>
    <p align='right' style='float:left' />$[Name attachment as:]
    <input type='text' name='upname' value='\$UploadName' size=25 />
    <input type='submit' value=' $[Upload] ' /></p>
    </form></div><br clear=all />",
  'wiki:$[{$SiteGroup}/UploadQuickReference]'));
    
## automatic loading of skin default config pages
global $WikiLibDirs, $SkinDir;
    $where = count($WikiLibDirs);
    if ($where>1) $where--;
    array_splice($WikiLibDirs, $where, 0, 
        array(new PageStore("$SkinDir/wikilib.d/\$FullName")));
        
# set default edit form and configuration page
global $XLLangs, $PageEditForm, $SiteGroup; 
SDV($PageEditForm, $SiteGroup.'.Popup-EditForm');
#XLPage('gemini', 'Site.Gemini-Configuration' );
 #  array_splice($XLLangs, -1, 0, array_shift($XLLangs));

# popup editform load switch
global $ShowHide, $SiteGroup, $HTMLHeaderFmt, $action;
if ($action=='edit') {
  SetTmplDisplay('PageRightFmt',0);
  if($EnablePopupEditForm==1) {
    if (!$ShowHide) include_once("$SkinDir/showhide.php");
    $HTMLHeaderFmt['popupedit'] = "
      <script type='text/javascript'><!--
         document.write(\"<link href='$SkinDirUrl/css/popup2edit.css' rel='stylesheet' type='text/css' />\");
      --></script>
      <noscript>
         <link href='$SkinDirUrl/css/popup2edit-noscript.css' rel='stylesheet' type='text/css' />
      </noscript>
      ";
  }
  else $HTMLHeaderFmt['popupedit'] = "
    <link href='$SkinDirUrl/css/popup2edit-noscript.css' rel='stylesheet' type='text/css' />";
} 
   
## load skin css files
global $HTMLHeaderFmt;
$HTMLHeaderFmt['skin-layout'] = "
  <link href='$SkinDirUrl/css/layout-fixflow.css' rel='stylesheet' type='text/css' />
  <link href='$SkinDirUrl/css/layout-main.css' rel='stylesheet' type='text/css' />
  <style type='text/css' media='all'> @import '$SkinDirUrl/css/rightbar.css'; </style>
  <!--[if IE ]><link href='$SkinDirUrl/css/layout-ie.css' rel='stylesheet' type='text/css' />
  <![endif]-->
  <link rel='stylesheet' href='$SkinDirUrl/css/layout-print.css' type='text/css' media='print' />";
$HTMLHeaderFmt['skin-font'] = "  
   <link href='$SkinDirUrl/css/$FontCss' rel='stylesheet' type='text/css' media='screen' />";
$HTMLHeaderFmt['skin-color'] = "   
   <link href='$SkinDirUrl/css/$ColorCss' rel='stylesheet' type='text/css' media='screen' />";

if ($sc=='trans') {
	$HTMLHeaderFmt['trans-background'] = " 
		<style type='text/css'><!--
			body { background:url({$BackgroundImgUrlFmt}) fixed; } \n
		--></style>
	";
}

if ($EnableBackgroundImages==0)
	$HTMLHeaderFmt['background'] = "
		<style type='text/css'><!--
		body,#content,#titlebar,#sidebar,#footnav,#footer,#rightbar{background-image:none}\n
		--></style>
	"; 

## float rightbar left if sidebar right
if ($ss =='right') {
   $HTMLHeaderFmt['rightbar'] = " 
  <style type='text/css'><!--
     #rightbar { $RightbarCss; margin:-1em 1em 0.25em -1.7em; float:left;} 
  --></style>
  <!--[if lt IE 7]>
    <style type='text/css'> #rightbar {margin:-1em 1em 0.25em -0.8em; } </style>
  <![endif]-->
  ";
 }
## float rightbar right if sidebar left
if ($ss =='left') {
   $HTMLHeaderFmt['rightbar'] = " 
  <style type='text/css'><!--
     #rightbar { $RightbarCss; margin:-1em -1.7em 0.25em 1em; float:right;} 
  --></style>
  <!--[if lt IE 7]>
    <style type='text/css'> #rightbar {margin:-1em -0.8em 0.25em 1em; } </style>
  <![endif]-->
  ";
 }

## compatibility check with pmwiki version number
global $VersionNum, $CompatibilityNotice;
if($VersionNum < '2001018') 
   $CompatibilityNotice = "<p style='color:red'>Compatibility problem: Please upgrade to the latest pmwiki version</p>";

## provide backward compatibility for non-relative urls
if ($VersionNum < 2001900) 
      Markup('{*$var}', '<{$var}', '/\\{\\*\\$/', '{$'); 

global $EnablePreWrap;
SDV($EnablePreWrap, 1);
# preserve spaces and wrap lines in preformatted text
if($EnablePreWrap==1) { 
  $HTMLHeaderFmt['prewrap'] = "
  <style type='text/css'>
  pre {	white-space: pre-wrap; /* css-3 */
	white-space: -moz-pre-wrap; /* Mozilla, since 1999 */
	white-space: -pre-wrap; /* Opera 4-6 */
	white-space: -o-pre-wrap; /* Opera 7 */
	*break-word: break-all; /* Internet Explorer 7 */
	*white-space: pre;
	* html pre { white-space: normal; /* old IE */ }	
	</style>
  ";
}
