// This file is @generated by src/hir/gen_hir_effect.rb.
mod bits {
  pub const Allocator: u8 = 1u8 << 0;
  pub const Any: u8 = Allocator | Control | Memory;
  pub const Control: u8 = 1u8 << 1;
  pub const Empty: u8 = 0u8;
  pub const Frame: u8 = Locals | PC | Stack;
  pub const Locals: u8 = 1u8 << 2;
  pub const Memory: u8 = Frame | Other;
  pub const Other: u8 = 1u8 << 3;
  pub const PC: u8 = 1u8 << 4;
  pub const Stack: u8 = 1u8 << 5;
  pub const AllBitPatterns: [(&str, u8); 10] = [
    ("Any", Any),
    ("Memory", Memory),
    ("Frame", Frame),
    ("Stack", Stack),
    ("PC", PC),
    ("Other", Other),
    ("Locals", Locals),
    ("Control", Control),
    ("Allocator", Allocator),
    ("Empty", Empty),
  ];
  pub const NumEffectBits: u8 = 6;
}
pub mod effect_types {
  pub type EffectBits = u8;
}
pub mod abstract_heaps {
  use super::*;
  pub const Allocator: AbstractHeap = AbstractHeap::from_bits(bits::Allocator);
  pub const Any: AbstractHeap = AbstractHeap::from_bits(bits::Any);
  pub const Control: AbstractHeap = AbstractHeap::from_bits(bits::Control);
  pub const Empty: AbstractHeap = AbstractHeap::from_bits(bits::Empty);
  pub const Frame: AbstractHeap = AbstractHeap::from_bits(bits::Frame);
  pub const Locals: AbstractHeap = AbstractHeap::from_bits(bits::Locals);
  pub const Memory: AbstractHeap = AbstractHeap::from_bits(bits::Memory);
  pub const Other: AbstractHeap = AbstractHeap::from_bits(bits::Other);
  pub const PC: AbstractHeap = AbstractHeap::from_bits(bits::PC);
  pub const Stack: AbstractHeap = AbstractHeap::from_bits(bits::Stack);
}
pub mod effects {
  use super::*;
  pub const Allocator: Effect = Effect::promote(abstract_heaps::Allocator);
  pub const Any: Effect = Effect::promote(abstract_heaps::Any);
  pub const Control: Effect = Effect::promote(abstract_heaps::Control);
  pub const Empty: Effect = Effect::promote(abstract_heaps::Empty);
  pub const Frame: Effect = Effect::promote(abstract_heaps::Frame);
  pub const Locals: Effect = Effect::promote(abstract_heaps::Locals);
  pub const Memory: Effect = Effect::promote(abstract_heaps::Memory);
  pub const Other: Effect = Effect::promote(abstract_heaps::Other);
  pub const PC: Effect = Effect::promote(abstract_heaps::PC);
  pub const Stack: Effect = Effect::promote(abstract_heaps::Stack);
}
