module CpSt (CpSt(..), get, put, enQ, deQ, runResult, runCpSt)  where

import Data.Queue.TwoStack

newtype CpSt r s a
      = CpSt { unCpSt :: (a -> s -> r) -> s -> r }

instance Monad (CpSt r s) where
   return a  = CpSt (\k -> k a)
   m >>= f   = CpSt (\k -> unCpSt m (\a -> unCpSt (f a) k))

get     = CpSt (\k s -> k s   s   )
put s'  = CpSt (\k _ -> k ()  s'  )

--runCpSt :: CpSt a s a -> s -> (a,s)
runCpSt m s0 = unCpSt m (\a s -> (a,s)) s0

enQ e = CpSt (\k q -> k () (enque e q))

deQ   = CpSt (\k q -> case deque q of
                        (e,q') -> k e q')

runResult m = unCpSt m (\a s -> a) empty