/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OCI.IIOP;

import java.util.ArrayList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.yoko.orb.CORBA.InputStream;
import org.apache.yoko.orb.OB.IORDump;
import org.apache.yoko.orb.OB.IORUtil;
import org.apache.yoko.orb.OB.ProtocolPolicy;
import org.apache.yoko.orb.OB.ProtocolPolicyHelper;
import org.apache.yoko.orb.OCI.ConFactory;
import org.apache.yoko.orb.OCI.ConFactoryInfo;
import org.apache.yoko.orb.OCI.ConnectCB;
import org.apache.yoko.orb.OCI.Connector;
import org.apache.yoko.orb.OCI.IIOP.ConFactoryInfo_impl;
import org.apache.yoko.orb.OCI.IIOP.Connector_impl;
import org.apache.yoko.orb.OCI.IIOP.ListenerMap;
import org.apache.yoko.orb.OCI.IIOP.UnifiedConnectionHelper;
import org.apache.yoko.orb.OCI.IIOP.Util;
import org.apache.yoko.util.Assert;
import org.apache.yoko.util.Hex;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CSIIOP.TransportAddress;
import org.omg.IIOP.ProfileBody_1_0;
import org.omg.IIOP.ProfileBody_1_0Helper;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactory;
import org.omg.IOP.CodecFactoryPackage.UnknownEncoding;
import org.omg.IOP.Encoding;
import org.omg.IOP.IOR;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedComponentHelper;
import org.omg.IOP.TaggedProfile;

final class ConFactory_impl
extends LocalObject
implements ConFactory {
    static final Logger logger = Logger.getLogger(ConFactory.class.getName());
    private static final Encoding CDR_1_2_ENCODING = new Encoding(0, 1, 2);
    private final boolean keepAlive_;
    private final ORB orb_;
    private final ConFactoryInfo_impl info_;
    private final ListenerMap listenMap_;
    private final UnifiedConnectionHelper connectionHelper;
    private final Set<Integer> helperComponentTags;
    private static final Connector[] EMPTY_CONNECTORS = new Connector[0];

    @Override
    public String id() {
        return "iiop";
    }

    @Override
    public int tag() {
        return 0;
    }

    @Override
    public String describe_profile(TaggedProfile profile) {
        Assert.ensure((profile.tag == 0 ? 1 : 0) != 0);
        InputStream in = new InputStream(profile.profile_data);
        in._OB_readEndian();
        ProfileBody_1_0 body = ProfileBody_1_0Helper.read((org.omg.CORBA.portable.InputStream)in);
        StringBuilder result = new StringBuilder();
        result.append("iiop_version: " + body.iiop_version.major + '.' + body.iiop_version.minor + '\n');
        result.append("host: " + body.host + '\n');
        char port = (char)body.port;
        result.append("port: " + port + '\n');
        result.append("object_key: (" + body.object_key.length + ")\n");
        Hex.formatHexPara((byte[])body.object_key, (int)0, (int)body.object_key.length, (StringBuilder)result);
        if (body.iiop_version.major > 1 || body.iiop_version.minor >= 1) {
            int tcCount = in.read_ulong();
            for (int i = 0; i < tcCount; ++i) {
                TaggedComponent component = TaggedComponentHelper.read((org.omg.CORBA.portable.InputStream)in);
                IORUtil.describe_component(component, result);
            }
        }
        return result.toString();
    }

    @Override
    public Connector[] create_connectors(IOR ior, Policy[] policies) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Creating connection for ior: " + IORDump.PrintObjref(this.orb_, ior));
        }
        for (Policy policy : policies) {
            ProtocolPolicy protocolPolicy;
            if (policy.policy_type() != 1330577410 || (protocolPolicy = ProtocolPolicyHelper.narrow((Object)policy)).contains("iiop")) continue;
            return EMPTY_CONNECTORS;
        }
        ArrayList<Connector> iopConnectors = new ArrayList<Connector>();
        ArrayList<Connector> extConnectors = new ArrayList<Connector>();
        for (TaggedProfile profile : ior.profiles) {
            if (profile.tag != this.tag()) continue;
            InputStream in = new InputStream(profile.profile_data);
            in._OB_readEndian();
            ProfileBody_1_0 body = ProfileBody_1_0Helper.read((org.omg.CORBA.portable.InputStream)in);
            boolean recordPortZero = false;
            Codec codec = null;
            try {
                codec = ((CodecFactory)this.orb_.resolve_initial_references("CodecFactory")).create_codec(CDR_1_2_ENCODING);
            }
            catch (InvalidName e) {
                logger.fine("Could not obtain codec factory using name 'CodecFactory'");
            }
            catch (UnknownEncoding e) {
                logger.fine("Could not obtain codec using encoding " + CDR_1_2_ENCODING);
            }
            if (body.port == 0) {
                recordPortZero = true;
            } else {
                char port = (char)body.port;
                logger.fine("Creating connector to host=" + body.host + ", port=" + port);
                ConnectCB[] cbs = this.info_._OB_getConnectCBSeq();
                iopConnectors.add(this.createConnector(ior, policies, body.host, port, cbs, codec));
            }
            if (body.iiop_version.major == 1 && body.iiop_version.minor == 0) continue;
            int tcCount = in.read_ulong();
            TaggedComponent[] components = new TaggedComponent[tcCount];
            for (int c = 0; c < tcCount; ++c) {
                components[c] = TaggedComponentHelper.read((org.omg.CORBA.portable.InputStream)in);
            }
            ConnectCB[] ccbs = this.info_._OB_getConnectCBSeq();
            for (TaggedComponent tc : components) {
                Connector newConnector;
                if (tc.tag == 3) {
                    InputStream cin = new InputStream(tc.component_data);
                    cin._OB_readEndian();
                    String host = cin.read_string();
                    short s = cin.read_ushort();
                    char cport = (char)s;
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Creating alternate connector to host=" + host + ", port=" + cport);
                    }
                    newConnector = this.createConnector(ior, policies, host, cport, ccbs, codec);
                    iopConnectors.add(newConnector);
                    continue;
                }
                if (!this.helperComponentTags.contains(tc.tag)) continue;
                for (TransportAddress endpoint : this.connectionHelper.getEndpoints(tc, policies)) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Creating extended connector to host=" + endpoint.host_name + ", port=" + endpoint.port);
                    }
                    newConnector = this.createConnector(ior, policies, endpoint.host_name, endpoint.port, ccbs, codec);
                    extConnectors.add(newConnector);
                    recordPortZero = false;
                }
            }
            if (!recordPortZero) continue;
            logger.fine("Creating connector with port=0 to host=" + body.host);
            ConnectCB[] cbs = this.info_._OB_getConnectCBSeq();
            iopConnectors.add(this.createConnector(ior, policies, body.host, 0, cbs, codec));
        }
        ArrayList<Connector> connectors = extConnectors.isEmpty() ? iopConnectors : extConnectors;
        return connectors.toArray(EMPTY_CONNECTORS);
    }

    private Connector createConnector(IOR ior, Policy[] policies, String host, int port, ConnectCB[] cbs, Codec codec) {
        return new Connector_impl(ior, policies, host, port, this.keepAlive_, cbs, this.listenMap_, this.connectionHelper, codec);
    }

    @Override
    public boolean equivalent(IOR ior1, IOR ior2) {
        return Util.equivalent(ior1, ior2);
    }

    @Override
    public int hash(IOR ior, int max) {
        return Util.hash(ior, max);
    }

    @Override
    public ConFactoryInfo get_info() {
        return this.info_;
    }

    public ConFactory_impl(ORB orb, boolean keepAlive, ListenerMap lm, UnifiedConnectionHelper helper) {
        this.orb_ = orb;
        this.keepAlive_ = keepAlive;
        this.info_ = new ConFactoryInfo_impl();
        this.listenMap_ = lm;
        this.connectionHelper = helper;
        this.helperComponentTags = helper.tags();
    }
}

