/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.concurrent.internal;

import com.ibm.websphere.ras.annotation.Trivial;
import jakarta.enterprise.concurrent.LastExecution;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;

@Trivial
public class LastExecutionImpl
implements LastExecution {
    private final ZonedDateTime endTime;
    private final String identityName;
    private final Object result;
    private final ZonedDateTime scheduledStartTime;
    private final ZonedDateTime startTime;

    LastExecutionImpl(String identityName, ZonedDateTime scheduledStartTime, ZonedDateTime startTime, ZonedDateTime endTime, Object result) {
        this.identityName = identityName;
        this.scheduledStartTime = scheduledStartTime;
        this.startTime = startTime;
        this.endTime = endTime;
        this.result = result;
    }

    public final String getIdentityName() {
        return this.identityName;
    }

    public final Object getResult() {
        return this.result;
    }

    public final Date getRunEnd() {
        return Date.from(this.endTime.toInstant());
    }

    public ZonedDateTime getRunEnd(ZoneId zone) {
        return this.endTime.withZoneSameInstant(zone);
    }

    public final Date getRunStart() {
        return Date.from(this.startTime.toInstant());
    }

    public ZonedDateTime getRunStart(ZoneId zone) {
        return this.startTime.withZoneSameInstant(zone);
    }

    public final Date getScheduledStart() {
        return Date.from(this.scheduledStartTime.toInstant());
    }

    public ZonedDateTime getScheduledStart(ZoneId zone) {
        return this.scheduledStartTime.withZoneSameInstant(zone);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(100);
        sb.append(this.getClass().getSimpleName()).append(' ').append(this.identityName).append(' ').append("scheduledStart=").append(this.scheduledStartTime).append(' ').append("runStart=").append(this.startTime).append(' ').append("runEnd=").append(this.endTime).append(' ').append(this.result);
        return sb.toString();
    }
}

