/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.messaging.security.beans;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class Permission {
    private static TraceComponent tc = SibTr.register(Permission.class, (String)"MessagingSecurity", (String)"com.ibm.ws.messaging.security.CWWKMMessages");
    private static final String CLASS_NAME = "com.ibm.ws.messaging.security.beans.Permission";
    private final Map<String, Set<String>> roleToUserMap = Collections.synchronizedMap(new HashMap());
    private final Map<String, Set<String>> roleToGroupMap = Collections.synchronizedMap(new HashMap());

    public Map<String, Set<String>> getRoleToUserMap() {
        return this.roleToUserMap;
    }

    public Map<String, Set<String>> getRoleToGroupMap() {
        return this.roleToGroupMap;
    }

    protected void addUserToRole(String user, String role) {
        Set<String> usersForTheRole;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.beans.PermissionaddUserToRole", (Object)new Object[]{user, role});
        }
        if ((usersForTheRole = this.roleToUserMap.get(role)) != null) {
            usersForTheRole.add(user);
        } else {
            usersForTheRole = new HashSet<String>();
            usersForTheRole.add(user);
        }
        this.roleToUserMap.put(role, usersForTheRole);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.beans.PermissionaddUserToRole");
        }
    }

    protected void addGroupToRole(String group, String role) {
        Set<String> groupsForTheRole;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.beans.PermissionaddGroupToRole", (Object)new Object[]{group, role});
        }
        if ((groupsForTheRole = this.roleToGroupMap.get(role)) != null) {
            groupsForTheRole.add(group);
        } else {
            groupsForTheRole = new HashSet<String>();
            groupsForTheRole.add(group);
        }
        this.roleToGroupMap.put(role, groupsForTheRole);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.beans.PermissionaddGroupToRole");
        }
    }

    protected void addAllUsersToRole(Set<String> users, String role) {
        Set<String> usersForTheRole;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.beans.PermissionaddAllUsersToRole", (Object)new Object[]{users, role});
        }
        if ((usersForTheRole = this.roleToUserMap.get(role)) != null) {
            usersForTheRole.addAll(users);
        } else {
            usersForTheRole = users;
        }
        this.roleToUserMap.put(role, usersForTheRole);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.beans.PermissionaddAllUsersToRole");
        }
    }

    protected void addAllGroupsToRole(Set<String> groups, String role) {
        Set<String> groupsForTheRole;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.beans.PermissionaddAllGroupsToRole", (Object)new Object[]{groups, role});
        }
        if ((groupsForTheRole = this.roleToGroupMap.get(role)) != null) {
            groupsForTheRole.addAll(groups);
        } else {
            groupsForTheRole = groups;
        }
        this.roleToGroupMap.put(role, groupsForTheRole);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.beans.PermissionaddAllGroupsToRole");
        }
    }

    protected boolean checkActionArrayHasAllPermission(String[] actionArray) {
        for (String action : actionArray) {
            if (!action.equalsIgnoreCase("ALL")) continue;
            return true;
        }
        return false;
    }

    public abstract void addUserAndGroupsToRole(String[] var1, Set<String> var2, Set<String> var3);

    public abstract boolean validateAction(String var1);

    public abstract void addUsersAndGroupsToAllActions(Set<String> var1, Set<String> var2);
}

